/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.teamapi71;

import com.ibm.rational.connector.cq.teamapi.common.ICqLocation;
import com.ibm.rational.connector.cq.teamapi.common.ICqProvider;
import com.ibm.rational.connector.cq.teamapi.common.internal.CQUniqueIdCannonicalizer;
import com.ibm.rational.connector.cq.teamapi.common.internal.CqGatewayConstants;
import com.ibm.rational.connector.cq.teamapi71.InteropWvcmException71;
import com.ibm.rational.wvcm.stp.StpLocation;
import com.ibm.rational.wvcm.stp.StpResource;
import com.ibm.rational.wvcm.stp.cq.CqAttachment;
import com.ibm.rational.wvcm.stp.cq.CqProvider;
import com.ibm.rational.wvcm.stp.cq.CqRecord;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.wvcm.Feedback;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.WvcmException;

public class CqLocationForInterop71
implements ICqLocation {
    private String m_locationString;
    private StpLocation m_delegate = null;
    private static final PropertyRequestItem.PropertyRequest stableLocationPropertyNameList = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.STABLE_LOCATION});
    private static final PropertyRequestItem.PropertyRequest userFriendlyLocationPropertyNameList = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.USER_FRIENDLY_LOCATION});
    private static final String CQ_LOCATION_PREFIX = "CQ:";

    public void init(String locationString) throws InteropException {
        this.m_locationString = locationString;
        if (CQUniqueIdCannonicalizer.isEncodedURLString((String)this.m_locationString)) {
            this.m_locationString = this.getDecodedCqLocationString();
        }
        if (this.m_locationString.startsWith(CQ_LOCATION_PREFIX)) {
            this.m_locationString = this.m_locationString.substring(CQ_LOCATION_PREFIX.length());
        }
        this.m_locationString = CQUniqueIdCannonicalizer.convertUniqueIdForTeamAPIVersion((String)this.m_locationString);
    }

    public void init(Object object) throws InteropException {
        if (object instanceof StpLocation) {
            this.init(object.toString());
            this.m_delegate = (StpLocation)object;
        } else {
            try {
                StpLocation location = null;
                if (object instanceof CqAttachment) {
                    CqAttachment attachment = (CqAttachment)object;
                    try {
                        location = attachment.getUserFriendlyLocation();
                    }
                    catch (WvcmException wvcmException) {
                        attachment = (CqAttachment)attachment.doReadProperties((Feedback)userFriendlyLocationPropertyNameList);
                        location = attachment.getUserFriendlyLocation();
                    }
                } else if (object instanceof CqRecord) {
                    CqRecord record = (CqRecord)object;
                    try {
                        location = record.getStableLocation();
                    }
                    catch (WvcmException wvcmException) {
                        record = (CqRecord)record.doReadProperties((Feedback)stableLocationPropertyNameList);
                        location = record.getStableLocation();
                    }
                } else {
                    throw new InteropException("Don't know how to get the locator of: " + object);
                }
                this.init(location.toString());
                this.m_delegate = location;
            }
            catch (WvcmException e) {
                throw new InteropWvcmException71(e);
            }
        }
    }

    private String getDecodedCqLocationString() throws InteropException {
        try {
            this.m_locationString = this.m_locationString.replaceAll("%20", "\\+");
            return URLDecoder.decode(this.m_locationString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InteropException((Throwable)e);
        }
    }

    public String getEncodedCqLocationString() throws InteropException {
        try {
            return URLEncoder.encode(this.m_locationString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InteropException((Throwable)e);
        }
    }

    public String toString() {
        if (this.m_locationString != null) {
            return this.m_locationString;
        }
        return null;
    }

    public void generateLocator(ICqProvider provider) throws InteropException {
        CqProvider cqProvider = (CqProvider)provider.getDelegate();
        if (this.m_delegate == null) {
            if (this.m_locationString == null) {
                throw new InteropException("Cannot generate a location without a location string");
            }
            try {
                this.m_delegate = cqProvider.stpLocation(this.m_locationString);
            }
            catch (WvcmException e) {
                throw new InteropException((Throwable)e);
            }
        }
    }

    public boolean isStableSelectorScheme() throws InteropException {
        if (this.m_delegate == null) {
            throw new InteropException("No delegate");
        }
        return this.m_delegate.isObjectSelectorScheme();
    }

    public boolean isUserFriendlySelectorScheme() throws InteropException {
        if (this.m_delegate == null) {
            throw new InteropException("No delegate");
        }
        return this.m_delegate.isUserFriendlySelectorScheme();
    }

    public boolean isCqRecordLocation() throws InteropException {
        if (this.m_delegate != null && this.isUserFriendlySelectorScheme()) {
            return this.m_delegate.getNamespace().equals((Object)StpLocation.Namespace.RECORD);
        }
        return this.m_locationString.indexOf("cq-record") != -1;
    }

    public boolean isCqAttachmentLocation() {
        if (this.m_delegate != null && !this.m_delegate.getNamespace().equals((Object)StpLocation.Namespace.RECORD)) {
            return false;
        }
        return this.m_locationString.indexOf("Attachments") != -1 && this.m_locationString.split("/").length == 5;
    }

    public StpLocation getDelegate() {
        return this.m_delegate;
    }

    public ICqLocation createAttachmentLocation(String attachmentFieldName) throws InteropException {
        int locationOfAtSign = this.m_locationString.indexOf(64);
        String attachmentLocationString = String.valueOf(this.m_locationString.substring(0, locationOfAtSign)) + '/' + attachmentFieldName + "/anything" + this.m_locationString.substring(locationOfAtSign);
        return (ICqLocation)CqGatewayConstants.objectFactory.createLocator(attachmentLocationString);
    }

    public String getExternalLocationString() throws InteropException {
        String externalLocationString = CQUniqueIdCannonicalizer.convertUniqueIdForTeamAPIVersion((String)this.m_locationString, (String)"7.0.1");
        externalLocationString = CQ_LOCATION_PREFIX + externalLocationString;
        try {
            String encodedExternalLocationString = URLEncoder.encode(externalLocationString, "UTF-8");
            return encodedExternalLocationString.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new InteropException((Throwable)e);
        }
    }

    public ICqLocation child(String childName) throws InteropException {
        return (ICqLocation)CqGatewayConstants.objectFactory.createLocator((Object)this.m_delegate.child(childName));
    }
}

