/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.teamapi71;

import com.ibm.rational.connector.cq.teamapi.common.ICqDbInfo;
import com.ibm.rational.connector.cq.teamapi.common.ICqFolder;
import com.ibm.rational.connector.cq.teamapi.common.ICqFolderItem;
import com.ibm.rational.connector.cq.teamapi.common.ICqProvider;
import com.ibm.rational.connector.cq.teamapi.common.ICqRecordType;
import com.ibm.rational.connector.cq.teamapi.common.internal.CqGatewayConstants;
import com.ibm.rational.connector.cq.teamapi.common.internal.LogFactory;
import com.ibm.rational.connector.cq.teamapi71.CqFolderForInterop71;
import com.ibm.rational.connector.cq.teamapi71.InteropWvcmException71;
import com.ibm.rational.connector.cq.teamapi71.Messages;
import com.ibm.rational.wvcm.stp.StpLocation;
import com.ibm.rational.wvcm.stp.StpProvider;
import com.ibm.rational.wvcm.stp.StpResource;
import com.ibm.rational.wvcm.stp.cq.CqProvider;
import com.ibm.rational.wvcm.stp.cq.CqRecordType;
import com.ibm.rational.wvcm.stp.cq.CqUserDb;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import javax.wvcm.Feedback;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.ResourceList;
import javax.wvcm.WvcmException;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CqDbInfoForInterop71
implements ICqDbInfo {
    private static final PropertyRequestItem.PropertyRequest dbProperties = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{CqUserDb.VENDOR, CqUserDb.RECORD_TYPE_SET.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.DISPLAY_NAME})}), CqUserDb.PERSONAL_FOLDER.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.DISPLAY_NAME})}), CqUserDb.PUBLIC_FOLDER.nest(new PropertyRequestItem[]{new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.DISPLAY_NAME})})});
    protected ICqProvider m_provider;
    private CqUserDb m_delegate;
    private CqUserDb.VendorType m_vendorType;
    private HashMap<String, ICqRecordType> m_recordTypeInfo;
    private ICqFolder m_publicFolder;
    private ICqFolder m_personalFolder;
    private Log m_logDetail;
    private Log m_log = LogFactory.getLog();

    public CqDbInfoForInterop71() {
        this.m_logDetail = LogFactory.getLog((int)2);
    }

    private HashMap<String, ICqRecordType> initializeRecordTypeInfo(ResourceList recordTypes, String connectionURI, ICqProvider provider) throws InteropException, WvcmException {
        HashMap<String, ICqRecordType> result = new HashMap<String, ICqRecordType>();
        int count = 1;
        for (CqRecordType type : recordTypes) {
            result.put(type.getDisplayName(), CqGatewayConstants.objectFactory.createRecordType((Object)type, connectionURI, provider));
            if (this.m_logDetail.isDebugEnabled()) {
                this.m_logDetail.debug((Object)("Processed (" + count + ") " + type.getDisplayName()));
            }
            ++count;
        }
        return result;
    }

    public void init(ICqProvider provider) throws InteropException {
        try {
            this.m_provider = provider;
            CqProvider cqProvider = (CqProvider)provider.getDelegate();
            this.m_delegate = cqProvider.cqUserDb(cqProvider.pathLocation(StpProvider.Domain.CLEAR_QUEST, StpLocation.Namespace.USER_DB, provider.getConnectionURI()));
            this.m_delegate = (CqUserDb)this.m_delegate.doReadProperties((Feedback)dbProperties);
            this.m_vendorType = this.m_delegate.getVendor();
            ResourceList allRecordTypes = this.m_delegate.getRecordTypeSet();
            if (this.m_logDetail.isDebugEnabled()) {
                this.m_logDetail.debug((Object)("Number of record types: " + allRecordTypes.size()));
            }
            this.m_recordTypeInfo = this.initializeRecordTypeInfo(this.m_delegate.getRecordTypeSet(), provider.getConnectionURI(), provider);
        }
        catch (WvcmException e) {
            this.m_log.error((Object)MessageFormat.format(Messages.getString("CqDbInfoForInterop71.ERROR_CANNOT_GET_CQ_DB_INFO"), provider.getConnectionURI()), (Throwable)e);
            throw new InteropException((Throwable)e);
        }
        catch (InteropException e) {
            throw e;
        }
        catch (Exception e) {
            this.m_log.error((Object)MessageFormat.format(Messages.getString("CqDbInfoForInterop71.ERROR_CANNOT_GET_CQ_DB_INFO"), provider.getConnectionURI()), (Throwable)e);
            throw new InteropException((Throwable)e);
        }
    }

    public String getVendorType() {
        return this.m_vendorType.toString();
    }

    public ICqRecordType getCqRecordTypeInfo(String typeName) throws InteropException {
        return this.m_recordTypeInfo.get(typeName);
    }

    public HashMap<String, ICqRecordType> getRecordTypeInfo() {
        return this.m_recordTypeInfo;
    }

    public ICqFolder getPublicFolder() throws InteropException {
        if (this.m_publicFolder == null) {
            try {
                this.m_publicFolder = CqGatewayConstants.objectFactory.createCqFolder((Object)this.m_delegate.getPublicFolder(), null, this.m_provider);
            }
            catch (WvcmException e) {
                throw new InteropWvcmException71(e);
            }
        }
        return this.m_publicFolder;
    }

    public ICqFolder getPersonalFolder() throws InteropException {
        if (this.m_personalFolder == null) {
            try {
                this.m_personalFolder = CqGatewayConstants.objectFactory.createCqFolder((Object)this.m_delegate.getPersonalFolder(), null, this.m_provider);
            }
            catch (WvcmException e) {
                throw new InteropWvcmException71(e);
            }
        }
        return this.m_personalFolder;
    }

    private ICqFolder findFolder(ICqFolder root, String[] path, int index, int depth) throws InteropException {
        if (index > depth) {
            return null;
        }
        List children = root.getChildren();
        for (ICqFolderItem item : children) {
            if (!(item instanceof ICqFolder) || !item.getName().equals(path[index])) continue;
            if (index == depth) {
                ((CqFolderForInterop71)item).doReadProperties();
                return (ICqFolder)item;
            }
            return this.findFolder((ICqFolder)item, path, index + 1, depth);
        }
        return null;
    }

    public ICqFolder findFolder(String path) throws InteropException {
        String[] pathParts;
        if (path.startsWith("root")) {
            path = path.substring(1);
        }
        if ((pathParts = path.split("/"))[0].equals(this.getPublicFolder().getName())) {
            if (pathParts.length == 1) {
                return this.getPublicFolder();
            }
            return this.findFolder(this.getPublicFolder(), pathParts, 1, pathParts.length - 1);
        }
        if (pathParts[0].equals(this.getPersonalFolder().getName())) {
            if (pathParts.length == 1) {
                return this.getPersonalFolder();
            }
            return this.findFolder(this.getPersonalFolder(), pathParts, 1, pathParts.length - 1);
        }
        return null;
    }

    public ICqFolder createFolder(String fullPath) throws InteropException {
        String[] pathParts = fullPath.split("/");
        String currentPath = pathParts[0];
        ICqFolder parentFolder = this.findFolder(currentPath);
        ICqFolder currentFolder = null;
        int i = 1;
        while (i < pathParts.length) {
            currentFolder = this.findFolder(currentPath = String.valueOf(currentPath) + "/" + pathParts[i]);
            if (currentFolder == null) {
                currentFolder = parentFolder.createFolder(pathParts[i]);
            }
            parentFolder = currentFolder;
            ++i;
        }
        return currentFolder;
    }
}

