/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.teamapi71;

import com.ibm.rational.connector.cq.teamapi.common.ICqAction;
import com.ibm.rational.connector.cq.teamapi.common.ICqLocation;
import com.ibm.rational.connector.cq.teamapi.common.ICqProvider;
import com.ibm.rational.connector.cq.teamapi.common.ICqRecordType;
import com.ibm.rational.connector.cq.teamapi.common.IPropertyNameList;
import com.ibm.rational.connector.cq.teamapi.common.InteropLocation;
import com.ibm.rational.connector.cq.teamapi.common.impl.CqProviderForInterop;
import com.ibm.rational.connector.cq.teamapi.common.internal.CqGatewayConstants;
import com.ibm.rational.connector.cq.teamapi.common.internal.InteropConstants;
import com.ibm.rational.connector.cq.teamapi.common.internal.SuppressEventNotification;
import com.ibm.rational.connector.cq.teamapi71.CqObjectForInterop71;
import com.ibm.rational.connector.cq.teamapi71.CqProviderForInterop71;
import com.ibm.rational.connector.cq.teamapi71.InteropWvcmException71;
import com.ibm.rational.connector.cq.teamapi71.Messages;
import com.ibm.rational.connector.cq.teamapi71.PropertyNameListForInterop71;
import com.ibm.rational.wvcm.stp.StpLocation;
import com.ibm.rational.wvcm.stp.StpResource;
import com.ibm.rational.wvcm.stp.cq.CqAction;
import com.ibm.rational.wvcm.stp.cq.CqAttachment;
import com.ibm.rational.wvcm.stp.cq.CqContextResource;
import com.ibm.rational.wvcm.stp.cq.CqProvider;
import com.ibm.rational.wvcm.stp.cq.CqRecord;
import com.ibm.rational.wvcm.stp.cq.CqResource;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Feedback;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CqAttachmentForInterop71
extends CqObjectForInterop71 {
    private CqAttachment m_delegate;
    private File m_tempFile;
    private static PropertyNameList.PropertyName m_versionPropertyName = null;
    private static final PropertyRequestItem.PropertyRequest attachmentProperties = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.STABLE_LOCATION, StpResource.USER_FRIENDLY_LOCATION, CqAttachment.DESCRIPTION, CqAttachment.DISPLAY_NAME, CqAttachment.FILE_NAME, CqAttachment.FILE_SIZE, CqAttachment.FIELD});
    private static final PropertyRequestItem.PropertyRequest userFriendlyLocationPropertyNameList = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{StpResource.USER_FRIENDLY_LOCATION});
    private static final int ATTACHMENT_FILE_NAME_SIZE_LIMIT = 50;
    private static final int ATTACHMENT_DESCRIPTION_SIZE_LIMIT = 50;

    private CqAttachment createCqAttachment(InteropLocation location, ICqProvider provider) {
        this.m_provider = (CqProviderForInterop71)provider;
        CqProvider cqProvider = (CqProvider)provider.getDelegate();
        StpLocation stpLocation = (StpLocation)location.getDelegate();
        return cqProvider.cqAttachment(stpLocation);
    }

    @Override
    public void init(InteropLocation location, ICqProvider provider) throws InteropException {
        this.m_delegate = this.createCqAttachment(location, provider);
    }

    public ICqAction getDefaultModifyAction() throws InteropException {
        StpLocation loc = (StpLocation)this.m_delegate.location();
        String[] locSegments = loc.getNameSegments(1);
        ICqRecordType recordType = this.m_provider.getRecordTypeInfo(locSegments[0]);
        return recordType.getDefaultModifyAction();
    }

    public void doInitialize(List<String> requestedPropertyNames, Map<String, ?> currentState) throws InteropException {
        this.m_provider.clearCache();
        Feedback feedback = this.getFeedback(attachmentProperties);
        File tempFile = (File)currentState.get("File");
        String description = (String)currentState.get(CqAttachment.DESCRIPTION.getName());
        if (tempFile.getName().length() > 50) {
            throw new InteropException(MessageFormat.format(Messages.getString("CqAttachmentForInterop71.ERROR_FILE_NAME_TOO_LARGE"), 50, tempFile.getName()));
        }
        if (description != null && description.length() > 50) {
            throw new InteropException(MessageFormat.format(Messages.getString("CqAttachmentForInterop71.ERROR_DESCRIPTION_TOO_LARGE"), 50, description));
        }
        this.m_delegate.setAction((CqAction)this.getDefaultModifyAction().getDelegate());
        this.m_delegate = this.m_provider.doCreateAttachment(this.m_delegate, tempFile.getAbsolutePath(), feedback, CqProvider.HOLD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReadProperties(Collection<String> requestedPropertyNames) throws InteropException {
        try {
            CqProviderForInterop.CQLock cQLock = CqProviderForInterop.CQLock.getCQLock();
            synchronized (cQLock) {
                if (requestedPropertyNames.contains("File")) {
                    try {
                        this.m_tempFile = File.createTempFile("interop", "attachments", InteropConstants.interopTempDirectory);
                    }
                    catch (IOException e) {
                        throw new InteropException((Throwable)e);
                    }
                    this.m_delegate = this.m_provider.doReadContent(this.m_delegate, this.m_tempFile.getAbsolutePath(), (Feedback)allPropertyNameList);
                } else {
                    this.m_delegate = (CqAttachment)this.m_provider.doReadProperties((CqResource)this.m_delegate, (Feedback)allPropertyNameList);
                }
            }
        }
        catch (InteropException e) {
            if (this.m_tempFile != null && !this.m_tempFile.delete() && this.m_log.isInfoEnabled()) {
                this.m_log.debug((Object)("Couldn't delete temp file: " + this.m_tempFile.getAbsolutePath()));
            }
            this.m_tempFile = null;
            throw e;
        }
    }

    public void doReadContentOnly(String fileName) throws InteropException {
        File contentFile = new File(fileName);
        this.m_provider.doReadContent(this.m_delegate, contentFile.getAbsolutePath(), null);
    }

    public void doRevert() throws InteropException {
        this.m_provider.doRevert((CqContextResource)this.m_delegate);
    }

    public boolean setObjectState(Map<String, ?> newState, boolean update) throws InteropException {
        Object newDescription;
        block4: {
            try {
                String currentDescription = this.m_delegate.getDescription();
                newDescription = newState.get("description");
                if (!currentDescription.equals(newDescription)) break block4;
                return false;
            }
            catch (Exception e) {
                if (this.m_log.isDebugEnabled()) {
                    this.m_log.error((Object)"Error setting object state", (Throwable)e);
                }
                throw new InteropException((Throwable)e);
            }
        }
        this.m_delegate.setProperty(CqAttachment.DESCRIPTION, (Object)((String)newDescription));
        return true;
    }

    public Map<String, ?> createObjectState(Collection<String> wantedProperties) throws InteropException {
        try {
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            if (wantedProperties == null || wantedProperties.contains(CqAttachment.DESCRIPTION.getName())) {
                newMap.put(CqAttachment.DESCRIPTION.getName(), this.m_delegate.getDescription());
            }
            if (wantedProperties == null || wantedProperties.contains(CqAttachment.FILE_NAME.getName())) {
                newMap.put(CqAttachment.FILE_NAME.getName(), this.m_delegate.getFileName());
            }
            if (wantedProperties == null || wantedProperties.contains(CqAttachment.FILE_SIZE.getName())) {
                newMap.put(CqAttachment.FILE_SIZE.getName(), String.valueOf(this.m_delegate.getFileSize()));
            }
            if (wantedProperties != null && wantedProperties.contains("File")) {
                newMap.put("File", this.m_tempFile);
            }
            newMap.put(CqGatewayConstants.VERSION_FIELD_NAME, "1");
            newMap.put("@@uniqueId@@", this.getLocator().getExternalLocationString());
            return newMap;
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
        catch (Exception e) {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.error((Object)"Error creating object state", (Throwable)e);
            }
            throw new InteropException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWriteProperties(List<String> requestedPropertyNames, List changeContext) throws InteropException {
        try {
            Feedback request = this.getFeedback(attachmentProperties);
            CqProviderForInterop.CQLock cQLock = CqProviderForInterop.CQLock.getCQLock();
            synchronized (cQLock) {
                this.m_delegate = (CqAttachment)this.m_delegate.doWriteProperties(request, changeContext);
            }
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public void doStartAction(List<String> requestedPropertyNames, Map<String, ?> properties) throws InteropException {
    }

    @Override
    public boolean readOnly(String fieldName, CqRecord currentRecord) throws InteropException {
        return !fieldName.equals(CqAttachment.DESCRIPTION.getName());
    }

    public void doDelete() throws InteropException {
        this.m_provider.clearCache();
        this.m_provider.doDelete((CqContextResource)this.m_delegate);
    }

    private PropertyNameList.PropertyName getAttachmentVersionPropertyName() {
        if (m_versionPropertyName == null) {
            PropertyNameList propertyList = this.m_delegate.getAllProperties().getPropertyNameList();
            PropertyNameList.PropertyName[] propertyNames = propertyList.getPropertyNames();
            int i = 0;
            while (i < propertyNames.length) {
                PropertyNameList.PropertyName pname = propertyNames[i];
                if (pname.getName().equals(CqGatewayConstants.VERSION_FIELD_NAME)) {
                    m_versionPropertyName = pname;
                    break;
                }
                ++i;
            }
        }
        return m_versionPropertyName;
    }

    public void suppressEventNotification(String source, SuppressEventNotification suppressInfo) throws UnsupportedEncodingException, InteropException {
        try {
            ICqLocation location = (ICqLocation)CqGatewayConstants.objectFactory.createLocator((Object)this.m_delegate.getUserFriendlyLocation());
            String locationString = location.getExternalLocationString();
            suppressInfo.suppressEventsForThisUniqueId(locationString, source, false);
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public String getVersionNumber() throws InteropException {
        try {
            PropertyNameList.PropertyName versionPropertyName = null;
            versionPropertyName = this.getAttachmentVersionPropertyName();
            String versionNumber = this.m_delegate.getProperty(versionPropertyName).toString();
            return versionNumber;
        }
        catch (WvcmException e) {
            throw new InteropWvcmException71(e);
        }
    }

    public IPropertyNameList createPropertyNameListFromKeys(Collection<String> requestedPropertyNames) throws InteropException {
        return new PropertyNameListForInterop71(attachmentProperties);
    }

    public ICqLocation getLocator() throws InteropException {
        try {
            StpLocation location = null;
            try {
                location = this.m_delegate.getUserFriendlyLocation();
            }
            catch (WvcmException wvcmException) {
                this.m_delegate = (CqAttachment)this.m_provider.doReadProperties((CqResource)this.m_delegate, (Feedback)userFriendlyLocationPropertyNameList);
                location = this.m_delegate.getUserFriendlyLocation();
            }
            return (ICqLocation)CqGatewayConstants.objectFactory.createLocator((Object)location);
        }
        catch (WvcmException e) {
            throw new InteropException((Throwable)e);
        }
    }

    public CqAttachment getDelegate() {
        return this.m_delegate;
    }

    public ICqAction getAction() throws InteropException {
        throw new RuntimeException("Not implemented, yet");
    }

    public void setDelegate(CqContextResource delegate) {
        throw new RuntimeException("The delegate of a CqAttachmentForInterop is not directly settable");
    }

    public void setProperty(String fieldName, Object value) {
        throw new RuntimeException("Not implemented, yet");
    }

    public Object getProperty(String fieldName) throws InteropException {
        throw new RuntimeException("Not implemented, yet");
    }

    @Override
    public void rememberDelete(List<String> rememberedList, String uniqueId) {
        if (rememberedList.add(uniqueId) && this.m_logDetails.isInfoEnabled()) {
            this.m_logDetails.debug((Object)("Remember that " + uniqueId + " was deleted"));
        }
    }

    @Override
    public void forgetDelete(List<String> rememberedList, String uniqueId) {
        if (rememberedList.remove(uniqueId) && this.m_logDetails.isInfoEnabled()) {
            this.m_logDetails.debug((Object)("Forget that " + uniqueId + " was deleted"));
        }
    }
}

