/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.setup.internal;

import com.ibm.rational.connector.cq.common.cqgateway.CQGateway;
import com.ibm.rational.connector.cq.common.cqgateway.CQRepository;
import com.ibm.rational.connector.cq.setup.ICQAdminService;
import com.ibm.rational.connector.cq.setup.internal.CQWorkspaceRootFolder;
import com.ibm.rational.connector.cq.setup.internal.Messages;
import com.ibm.rational.connector.cq.teamapi.common.ICqDbInfo;
import com.ibm.rational.connector.cq.teamapi.common.ICqFolder;
import com.ibm.rational.connector.cq.teamapi.common.internal.BasicCQConnectionInfo;
import com.ibm.rational.connector.cq.teamapi.common.internal.LogFactory;
import com.ibm.team.interop.service.managers.clearquest.common.CQInteropConstants;
import com.ibm.team.interop.service.managers.clearquest.common.InteropConnectionInfo;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import com.rational.clearquest.cqjni.CQAdminSession;
import com.rational.clearquest.cqjni.CQClearQuest;
import com.rational.clearquest.cqjni.CQDatabase;
import com.rational.clearquest.cqjni.CQDatabaseDescs;
import com.rational.clearquest.cqjni.CQDatabases;
import com.rational.clearquest.cqjni.CQException;
import com.rational.clearquest.cqjni.CQGroups;
import com.rational.clearquest.cqjni.CQSession;
import com.rational.clearquest.cqjni.CQUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CQAdminService
implements ICQAdminService {
    protected Log m_log = LogFactory.getLog();
    protected String m_cqAdminUserId;
    protected String m_cqAdminPassword;
    protected String m_cqDbSetName = null;
    protected String m_cqUserDbName = null;
    protected String m_cqSchemaName = null;
    protected boolean m_loggedIn = false;
    protected CQAdminSession m_cqAdminSession = null;
    protected CQSession m_cqSession = null;

    private boolean logoffCQ() throws InteropException {
        this.m_cqAdminSession = null;
        CQClearQuest cq = new CQClearQuest();
        if (this.m_cqSession != null) {
            try {
                cq.SessionLogoff(this.m_cqSession, 0L);
            }
            catch (CQException e) {
                throw new InteropException((Throwable)e);
            }
            this.m_cqSession = null;
        }
        this.m_loggedIn = false;
        return true;
    }

    protected boolean loginToCQ() throws InteropException {
        try {
            if (this.m_cqAdminUserId == null) {
                throw new IllegalStateException("m_cqAdminUserId cannot be null");
            }
            if (this.m_cqAdminPassword == null) {
                throw new IllegalStateException("m_cqAdminPassword cannot be null");
            }
            if (this.m_cqDbSetName == null) {
                throw new IllegalStateException(Messages.getString("CQSetupService.ERROR_OPERATION_ILLEGAL_WITHOUT_DB_SET_NAME"));
            }
            if (this.m_cqUserDbName == null) {
                throw new IllegalStateException(Messages.getString("CQSetupService.ERROR_OPERATION_ILLEGAL_WITHOUT_USER_DB_NAME"));
            }
            this.logoffCQ();
            CQClearQuest cq = new CQClearQuest();
            this.m_cqAdminSession = cq.CreateAdminSession();
            this.getCQAdminSession().Logon(this.m_cqAdminUserId, this.m_cqAdminPassword, this.m_cqDbSetName);
            this.m_cqSession = cq.CreateUserSession();
            this.getCQSession().UserLogon(this.m_cqAdminUserId, this.m_cqAdminPassword, this.m_cqUserDbName, this.m_cqDbSetName);
            this.m_loggedIn = true;
            return true;
        }
        catch (CQException e) {
            throw new InteropException((Throwable)e);
        }
    }

    @Override
    public boolean loginToCQ(String cqAdminUserId, String cqAdminPassword) throws InteropException {
        if (cqAdminUserId == null) {
            throw new IllegalArgumentException("cqAdminUserId cannot be null");
        }
        if (cqAdminPassword == null) {
            throw new IllegalArgumentException("cqAdminPassword cannot be null");
        }
        this.m_cqAdminUserId = cqAdminUserId;
        this.m_cqAdminPassword = cqAdminPassword;
        return this.loginToCQ();
    }

    protected CQAdminSession getCQAdminSession() throws InteropException {
        if (this.m_cqAdminSession == null) {
            throw new InteropException(Messages.getString("CQSetupService.ERROR_NOT_LOGGED_INTO_CQ"));
        }
        return this.m_cqAdminSession;
    }

    protected CQSession getCQSession() throws InteropException {
        if (this.m_cqSession == null) {
            throw new InteropException(Messages.getString("CQSetupService.ERROR_NOT_LOGGED_INTO_CQ"));
        }
        return this.m_cqSession;
    }

    @Override
    public List<String> getDbSetNames() throws InteropException {
        try {
            CQClearQuest cq = new CQClearQuest();
            return Arrays.asList(cq.CreateUserSession().GetInstalledDbSets());
        }
        catch (CQException e) {
            throw new InteropException((Throwable)e);
        }
    }

    @Override
    public List<String> getUserDbNames() throws InteropException {
        if (this.m_cqDbSetName == null) {
            throw new IllegalStateException(Messages.getString("CQSetupService.ERROR_OPERATION_ILLEGAL_WITHOUT_DB_SET_NAME"));
        }
        try {
            ArrayList<String> userDbNames = new ArrayList<String>();
            CQClearQuest cq = new CQClearQuest();
            CQDatabaseDescs dbs = cq.CreateUserSession().GetAccessibleDatabases("MASTR", CQInteropConstants.EMPTY_STRING, this.m_cqDbSetName);
            int i = 0;
            while ((long)i < dbs.Count()) {
                userDbNames.add(dbs.Item((long)i).GetDatabaseName());
                ++i;
            }
            return userDbNames;
        }
        catch (CQException e) {
            throw new InteropException((Throwable)e);
        }
    }

    @Override
    public void setCqDbSetName(String cqDbSetName) {
        this.m_cqDbSetName = cqDbSetName;
    }

    @Override
    public void setCqUserDbName(String cqUserDbName) {
        this.m_cqUserDbName = cqUserDbName;
    }

    @Override
    public boolean createCQConnectorUser(String gatewayUserId, String gatewayPassword, String fullName, String email) throws InteropException {
        if (!this.m_loggedIn) {
            throw new IllegalStateException(Messages.getString("CQSetupService.ERROR_OPERATION_ILLEGAL_WITHOUT_LOGGED_INTO_CQ"));
        }
        try {
            CQUser gatewayUser = this.getCQAdminSession().CreateUser(gatewayUserId);
            gatewayUser.SetCQAuthentication(gatewayPassword);
            gatewayUser.SetFullName(fullName);
            gatewayUser.SetEmail(email);
            gatewayUser.SetUserPrivilege(4L, true);
            boolean result = this.addUserToDb(gatewayUser);
            return result;
        }
        catch (CQException e) {
            throw new InteropException((Throwable)e);
        }
    }

    @Override
    public Map<String, String> getCQConnectorUser(String gatewayUserId) throws InteropException {
        if (!this.m_loggedIn) {
            throw new IllegalStateException(Messages.getString("CQSetupService.ERROR_OPERATION_ILLEGAL_WITHOUT_LOGGED_INTO_CQ"));
        }
        try {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            CQUser user = this.getCQAdminSession().GetUser(gatewayUserId);
            if (user != null) {
                resultMap.put("userId", gatewayUserId);
                resultMap.put("password", user.GetPassword());
                resultMap.put("fullName", user.GetFullName());
                resultMap.put("email", user.GetEmail());
                return resultMap;
            }
            return null;
        }
        catch (CQException e) {
            throw new InteropException((Throwable)e);
        }
    }

    private CQDatabases getAllSubscribedDatabases(CQUser user) throws InteropException {
        try {
            CQDatabases dbs = user.GetSubscribedDatabases();
            CQGroups groups = user.GetGroups();
            if (groups != null) {
                int i = 0;
                while ((long)i < groups.Count()) {
                    CQDatabases groupDbs = groups.Item((long)i).GetSubscribedDatabases();
                    if (groupDbs != null) {
                        int j = 0;
                        while ((long)j < groupDbs.Count()) {
                            dbs.Add(groupDbs.Item((long)j));
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            return dbs;
        }
        catch (CQException e) {
            throw new InteropException((Throwable)e);
        }
    }

    protected boolean addUserToDb(CQUser gatewayUser) throws InteropException {
        try {
            CQDatabases dbs = this.getAllSubscribedDatabases(gatewayUser);
            if (dbs.ItemByName(this.m_cqUserDbName) == null) {
                CQDatabase userDb = this.getCQAdminSession().GetDatabase(this.m_cqUserDbName);
                gatewayUser.SubscribeDatabase(userDb);
                userDb.UpgradeMasterUserInfo();
                String[] failedDbs = gatewayUser.UpgradeInfo();
                return !Arrays.asList(failedDbs).contains(this.m_cqUserDbName);
            }
            return true;
        }
        catch (CQException e) {
            throw new InteropException((Throwable)e);
        }
    }

    protected ICqDbInfo loginToCM_API() throws InteropException {
        if (this.m_cqAdminUserId == null) {
            throw new IllegalStateException("m_cqAdminUserId cannot be null");
        }
        if (this.m_cqAdminPassword == null) {
            throw new IllegalStateException("m_cqAdminPassword cannot be null");
        }
        if (this.m_cqDbSetName == null) {
            throw new IllegalStateException(Messages.getString("CQSetupService.ERROR_OPERATION_ILLEGAL_WITHOUT_DB_SET_NAME"));
        }
        if (this.m_cqUserDbName == null) {
            throw new IllegalStateException(Messages.getString("CQSetupService.ERROR_OPERATION_ILLEGAL_WITHOUT_USER_DB_NAME"));
        }
        String dbSetDbName = String.valueOf(this.m_cqDbSetName) + '/' + this.m_cqUserDbName;
        CQGateway gateway = CQGateway.getCQGateway();
        gateway.connectToRepositoryLocal((InteropConnectionInfo)new BasicCQConnectionInfo(this.m_cqAdminUserId, this.m_cqAdminPassword, dbSetDbName));
        CQRepository repo = gateway.getRepoForURL(dbSetDbName);
        return repo.getDbInfo();
    }

    @Override
    public ICqFolder getSubTreeRootedAt(String path) throws InteropException {
        ICqDbInfo dbInfo = this.loginToCM_API();
        if (path == null || path.equals("root")) {
            return new CQWorkspaceRootFolder(dbInfo.getPublicFolder(), dbInfo.getPersonalFolder());
        }
        return dbInfo.findFolder(path);
    }

    public boolean folderExists(String path, ICqDbInfo dbInfo) throws InteropException {
        return dbInfo.findFolder(path) != null;
    }

    @Override
    public String getPersonalQueriesFolderName() throws InteropException {
        ICqDbInfo dbInfo = this.loginToCM_API();
        return dbInfo.getPersonalFolder().getName();
    }

    @Override
    public String getPublicQueriesFolderName() throws InteropException {
        ICqDbInfo dbInfo = this.loginToCM_API();
        return dbInfo.getPublicFolder().getName();
    }
}

