/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.importer.internal;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class DateParser {
    private static List<DateFormat> fgDateFormats = new ArrayList<DateFormat>();

    static {
        fgDateFormats.add(new SimpleDateFormat("dd MMM yyyy HH:mm"));
        fgDateFormats.add(new SimpleDateFormat("dd MMM yyyy h:mm a"));
        fgDateFormats.add(new SimpleDateFormat("dd-MMM-yy h:mm a"));
        fgDateFormats.add(new SimpleDateFormat("dd-MMM-yy HH:mm"));
        fgDateFormats.add(new SimpleDateFormat("M/dd/yyyy HH:mm"));
        fgDateFormats.add(new SimpleDateFormat("yyyy-M-dd HH:mm"));
        fgDateFormats.add(new SimpleDateFormat("yyyy-M-dd hh:mm a"));
        for (int dateStyle : Arrays.asList(3, 2)) {
            fgDateFormats.add(DateFormat.getDateInstance(dateStyle));
            for (int timeStyle : Arrays.asList(3)) {
                fgDateFormats.add(DateFormat.getDateTimeInstance(dateStyle, timeStyle));
            }
        }
        fgDateFormats.add(new SimpleDateFormat("MMM d, yyyy HH:mm"));
        fgDateFormats.add(new SimpleDateFormat("dd/M/yyyy HH:mm"));
        fgDateFormats.add(new SimpleDateFormat("dd/M/yyyy hh:mm a"));
        fgDateFormats.add(new SimpleDateFormat("dd.M.yyyy HH:mm"));
        fgDateFormats.add(new SimpleDateFormat("dd.M.yyyy hh:mm a"));
    }

    public static Date parseDate(String dateString, ParsePosition current) {
        ParsePosition bestPosition = new ParsePosition(current.getIndex());
        Date bestDate = null;
        for (DateFormat format : fgDateFormats) {
            ParsePosition position = new ParsePosition(0);
            Date candidateDate = format.parse(dateString, position);
            if (position.getIndex() <= bestPosition.getIndex()) continue;
            bestPosition = position;
            bestDate = candidateDate;
            if (bestPosition.getIndex() == dateString.length()) break;
        }
        current.setIndex(bestPosition.getIndex());
        current.setErrorIndex(bestPosition.getErrorIndex());
        return bestDate;
    }
}

