/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.importer.internal;

import com.ibm.rational.connector.cq.ide.ui.importer.internal.Messages;
import com.ibm.rational.connector.cq.importer.CQExporterFactory;
import com.ibm.rational.connector.cq.importer.ICQExporter;
import com.ibm.rational.connector.cq.importer.ICqRecord;
import com.ibm.rational.connector.cq.teamapi.common.ICqQuery;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IBugRetrievalStrategy;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.AttachmentData;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.AttachmentDescription;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CQRetrieval
implements IBugRetrievalStrategy,
Iterator {
    private ICQExporter fExporter;
    private String fDbSetDbName;
    private String fUserId;
    private String fPassword;
    private ICqRecord fRecord;
    private String fRecordId;

    public void connect(String dbSetDbName, String userId, String password) throws BugzillaException {
        this.fDbSetDbName = dbSetDbName;
        this.fUserId = userId;
        this.fPassword = password;
        try {
            this.fExporter = CQExporterFactory.createCQExporter();
            this.fExporter.connectToCQ(this.fDbSetDbName, this.fUserId, this.fPassword);
        }
        catch (InteropException e) {
            Status status = new Status(4, "com.ibm.rational.connector.cq.ide.ui", 4, Messages.CQImportMainPage_UNABLE_TO_LOGIN, (Throwable)e);
            throw new BugzillaException((IStatus)status);
        }
    }

    public void executeQuery(String queryPath) throws BugzillaException {
        try {
            this.fExporter.executeQuery(queryPath);
        }
        catch (InteropException e) {
            Status status = new Status(4, "com.ibm.rational.connector.cq.ide.ui", 4, Messages.CQRetrieval_ERROR_UNABLE_TO_EXECUTE_QUERY, (Throwable)e);
            throw new BugzillaException((IStatus)status);
        }
    }

    public void executeQuery(ICqQuery query) throws BugzillaException {
        try {
            this.fExporter.executeQuery(query);
        }
        catch (InteropException e) {
            Status status = new Status(4, "com.ibm.rational.connector.cq.ide.ui", 4, Messages.CQRetrieval_ERROR_UNABLE_TO_EXECUTE_QUERY, (Throwable)e);
            throw new BugzillaException((IStatus)status);
        }
    }

    public Iterator<String> getIterator() throws BugzillaException {
        return this;
    }

    public String next() {
        return this.fRecordId;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.fRecord != null) {
                this.fRecord.setAttachmentData(null);
                this.fRecord = null;
            }
            this.fRecordId = this.fExporter.getNextRecordId();
            return this.fRecordId != null;
        }
        catch (InteropException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
    }

    public String getXML(String id) throws BugzillaException {
        try {
            this.fRecord = this.fExporter.getCurrentRecordContents();
            return this.fRecord.getXml();
        }
        catch (InteropException e) {
            throw new BugzillaException(NLS.bind((String)Messages.CQRetrieval_ERROR_IMPORTING_CLEARQUEST_RECORD, (Object)id), (Throwable)e);
        }
    }

    public AttachmentData[] getAttachments(String id, List<AttachmentDescription> attachmentinfo) throws BugzillaException {
        if (this.fRecord.getAttachmentData() == null) {
            return new AttachmentData[0];
        }
        return this.fRecord.getAttachmentData();
    }

    public int getNumberOfBugs() {
        try {
            long rowCount = this.fExporter.getRowCount();
            return Long.valueOf(rowCount).intValue();
        }
        catch (InteropException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws InteropException {
        this.fExporter.releaseIterator();
        this.fExporter = null;
    }
}

