/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.importer.internal;

import com.ibm.rational.connector.cq.common.cqgateway.CQGateway;
import com.ibm.rational.connector.cq.importer.ICQExporter;
import com.ibm.rational.connector.cq.importer.ICqRecord;
import com.ibm.rational.connector.cq.importer.internal.CqRecord;
import com.ibm.rational.connector.cq.importer.internal.DateParser;
import com.ibm.rational.connector.cq.importer.internal.Messages;
import com.ibm.rational.connector.cq.teamapi.common.ICqExportAttachmentData;
import com.ibm.rational.connector.cq.teamapi.common.ICqExportData;
import com.ibm.rational.connector.cq.teamapi.common.ICqQuery;
import com.ibm.rational.connector.cq.teamapi.common.ICqRowData;
import com.ibm.rational.connector.cq.teamapi.common.InteropLocation;
import com.ibm.rational.connector.cq.teamapi.common.internal.BasicCQConnectionInfo;
import com.ibm.rational.connector.cq.teamapi.common.internal.CQNoteEntry;
import com.ibm.rational.connector.cq.teamapi.common.internal.CqExportData;
import com.ibm.rational.connector.cq.teamapi.common.internal.CqGatewayConstants;
import com.ibm.team.interop.service.managers.clearquest.common.ERException;
import com.ibm.team.interop.service.managers.clearquest.common.InteropConnectionInfo;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.AttachmentData;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CQExporter
implements ICQExporter {
    private BasicCQConnectionInfo fCqConnectionInfo = null;
    private CQGateway fCqGateway = null;
    private final String XML_TAG = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?>\n";
    private final String START_BUGZILLA_TAG = "<bugzilla version=\"3.3\" ";
    private final String END_BUGZILLA_TAG = "</bugzilla>";
    private final String START_BUG_TAG = "<bug>\n";
    private final String END_BUG_TAG = "</bug>\n";
    private final String BUG_ID = "bug_id";
    private final String LONG_DESC = "long_desc";
    private final String WHO = "who";
    private final String BUG_WHEN = "bug_when";
    private final String THE_TEXT = "thetext";
    private final String START_LEFT_BRACKET = "\t<";
    private final String RIGHT_BRACKET = ">";
    private static final String END_LEFT_BRACKET = "</";
    private static final String END_RIGHT_BRACKET = ">\n";
    private final String ATTACHMENT_TAG = "attachment";
    private final String ATTACHMENT_ID_TAG = "attachid";
    private final String ATTACHMENT_DESC_TAG = "desc";
    private final String ATTACHMENT_FILENAME_TAG = "filename";
    private final String ATTACHMENT_SIZE_TAG = "size";
    private List<ICqExportAttachmentData> fAttachmentsData = null;
    private static final String EMPTY_STRING = "";
    private Map<String, Map<String, ?>> fCachedUsers = new HashMap();
    private ICqQuery fQuery;
    private String fRecordTypeName = null;
    private int fRecordCounter = 1;
    private static final int MAX_RECORDS_IN_CACHE = 50;
    private ICqRowData fCqRowData;
    private Iterator fResultSet;

    @Override
    public void connectToCQ(String dbSetDbName, String userId, String password) throws InteropException {
        this.fCqConnectionInfo = new BasicCQConnectionInfo();
        this.fCqConnectionInfo.setConnectionURI(dbSetDbName);
        this.fCqConnectionInfo.setUserId(userId);
        this.fCqConnectionInfo.setPassword(password);
        this.fCqGateway = CQGateway.getNewCQGateway();
        this.fCqGateway.connectToRepositoryLocal((InteropConnectionInfo)this.fCqConnectionInfo);
    }

    @Override
    public void executeQuery(String queryPath) throws InteropException {
        this.fQuery = this.fCqGateway.lookupQuery(queryPath, this.fCqConnectionInfo.getConnectionURI());
        this.executeQuery(this.fQuery);
    }

    @Override
    public void executeQuery(ICqQuery query) throws InteropException {
        this.fQuery = query;
        this.fQuery.addDisplayField("id");
        ArrayList<String> fieldNamesSortOrder = new ArrayList<String>();
        fieldNamesSortOrder.add("id");
        this.fQuery.setSortOrder(fieldNamesSortOrder);
        this.fRecordTypeName = this.fQuery.getPrimaryResourceTypeName();
        this.fResultSet = this.fCqGateway.executeQuery(this.fRecordTypeName, this.fQuery, this.fCqConnectionInfo.getConnectionURI());
    }

    @Override
    public long getRowCount() throws InteropException {
        return this.fCqGateway.getRowCount(this.fResultSet, this.fCqConnectionInfo.getConnectionURI());
    }

    @Override
    public void releaseIterator() throws InteropException {
        if (this.fResultSet != null) {
            this.fCqGateway.releaseIterator(this.fResultSet, this.fCqConnectionInfo.getConnectionURI());
        }
        this.fQuery = null;
        this.fCqGateway.close();
    }

    @Override
    public void close() {
        this.fCqGateway.close();
        this.fCqGateway = null;
    }

    @Override
    public String getNextRecordId() throws InteropException {
        while (this.fResultSet.hasNext()) {
            ++this.fRecordCounter;
            if (this.fRecordCounter % 50 == 0) {
                this.fCqGateway.clearCache(this.fCqConnectionInfo.getConnectionURI());
            }
            ICqRowData cqRowData = this.fCqGateway.getNextRowData(this.fRecordTypeName, this.fResultSet, this.fCqConnectionInfo.getConnectionURI());
            if (this.fCqRowData == null) {
                this.fCqRowData = cqRowData;
                return this.fCqRowData.getRecordId();
            }
            if (cqRowData.getRecordId().equals(this.fCqRowData.getRecordId())) continue;
            this.fCqRowData = cqRowData;
            return this.fCqRowData.getRecordId();
        }
        return null;
    }

    @Override
    public ICqRecord getCurrentRecordContents() throws InteropException {
        CqRecord record = null;
        List exportData = null;
        exportData = this.fCqGateway.createExportDataFromRowData(this.fRecordTypeName, this.fCqRowData, this.fQuery, this.fCqConnectionInfo.getConnectionURI());
        record = new CqRecord();
        record.setId(this.fCqRowData.getRecordId());
        record.setXml(this.toXml(EMPTY_STRING, exportData));
        exportData = null;
        ArrayList<AttachmentData> attachmentDataList = new ArrayList<AttachmentData>();
        if (this.fAttachmentsData != null) {
            for (ICqExportAttachmentData exportAttachmentData : this.fAttachmentsData) {
                String fileName = exportAttachmentData.getFileName();
                AttachmentData attachmentData = new AttachmentData();
                attachmentData.set("0", fileName);
                attachmentData.data = this.getBytes(fileName, this.fCqRowData.getRecordId(), this.fRecordTypeName);
                attachmentDataList.add(attachmentData);
            }
            record.setAttachmentData(attachmentDataList.toArray(new AttachmentData[attachmentDataList.size()]));
            this.fAttachmentsData = null;
        }
        return record;
    }

    private String toXml(String cqUrlBase, List<ICqExportData> cqRowData) throws InteropException {
        StringBuilder xmlSb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?>\n");
        xmlSb.append("<bugzilla version=\"3.3\" ");
        xmlSb.append("urlbase=\"" + cqUrlBase + "\">\n");
        xmlSb.append("<bug>\n");
        for (ICqExportData cqColumnData : cqRowData) {
            if (cqColumnData.getType().equals((Object)CqExportData.Type.SIMPLE_STRING)) {
                xmlSb.append(this.formatStringData(cqColumnData.getName(), (String)cqColumnData.getValue()));
                continue;
            }
            if (cqColumnData.getType().equals((Object)CqExportData.Type.USER)) {
                Map<String, ?> userMap = null;
                String loginId = (String)cqColumnData.getValue();
                if (loginId.length() == 0 || loginId == null) continue;
                userMap = this.getCachedUser(loginId);
                xmlSb.append(this.formatUserData(cqColumnData.getName(), userMap));
                continue;
            }
            if (cqColumnData.getType().equals((Object)CqExportData.Type.COMMENTS)) {
                String rawNotes = (String)cqColumnData.getValue();
                if (rawNotes == null || rawNotes.length() <= 0) continue;
                ArrayList noteEntries = CQNoteEntry.parseCQContents((String)((String)cqColumnData.getValue()));
                int i = 0;
                while (i < noteEntries.size()) {
                    CQNoteEntry noteEntry = (CQNoteEntry)noteEntries.get(i);
                    xmlSb.append(this.formatNotesData(noteEntry));
                    ++i;
                }
                noteEntries = null;
                continue;
            }
            if (cqColumnData.getType().equals((Object)CqExportData.Type.TIMESTAMP)) {
                xmlSb.append(this.formatTimestampData(cqColumnData.getName(), (String)cqColumnData.getValue()));
                continue;
            }
            if (cqColumnData.getType().equals((Object)CqExportData.Type.ATTACHMENTS)) {
                xmlSb.append(this.formatAttachmentsData(cqColumnData.getName(), cqColumnData.getValue()));
                continue;
            }
            throw new InteropException(NLS.bind((String)Messages.CQExporter_ERROR_DATA_TYPE_NOT_SUPPORTED, (Object)cqColumnData.getType(), (Object[])new Object[0]));
        }
        xmlSb.append("</bug>\n");
        xmlSb.append("</bugzilla>");
        return xmlSb.toString();
    }

    private String formatStringData(String tagName, String value) {
        StringBuilder xmlSb = new StringBuilder();
        if (value == null || value.length() == 0) {
            return xmlSb.toString();
        }
        if (tagName.equals("id")) {
            this.formatXml("bug_id", value, xmlSb);
        }
        this.formatXml(tagName, value, xmlSb);
        return xmlSb.toString();
    }

    private void formatXml(String tagName, String value, StringBuilder sb) {
        sb.append("\t<" + tagName + ">");
        String escapedValue = CQExporter.escapeXmlEntity(value);
        sb.append(escapedValue);
        sb.append(END_LEFT_BRACKET + tagName + END_RIGHT_BRACKET);
    }

    private static String escapeXmlEntity(String textToEscape) {
        String escapedText = null;
        if (textToEscape == null || textToEscape.length() == 0) {
            return textToEscape;
        }
        escapedText = textToEscape.replaceAll("&", "&amp;");
        escapedText = escapedText.replaceAll("<", "&lt;");
        escapedText = escapedText.replaceAll(">", "&gt;");
        escapedText = escapedText.replaceAll("\"", "&quot;");
        escapedText = escapedText.replaceAll("'", "&apos;");
        return escapedText;
    }

    private String formatUserData(String tagName, Map<String, ?> userMap) {
        StringBuilder xmlSb = new StringBuilder();
        String userName = EMPTY_STRING;
        String emailAddress = EMPTY_STRING;
        if (userMap != null) {
            userName = userMap.get("fullname").toString();
            emailAddress = userMap.get("email").toString();
        }
        xmlSb.append("\t<" + tagName);
        xmlSb.append(" name=\"" + userName + "\">");
        xmlSb.append(CQExporter.escapeXmlEntity(emailAddress));
        xmlSb.append(END_LEFT_BRACKET + tagName + END_RIGHT_BRACKET);
        return xmlSb.toString();
    }

    private String formatTimestampData(String tagName, String timestampString) throws InteropException {
        StringBuilder xmlSb = new StringBuilder();
        if (timestampString == null || timestampString.length() == 0) {
            return xmlSb.toString();
        }
        Date cqDate = null;
        SimpleDateFormat cqDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat exportedDateFormat = new SimpleDateFormat("M/d/yy h:mm:ss a z");
        try {
            cqDate = cqDateFormat.parse(timestampString);
        }
        catch (ParseException e) {
            throw new InteropException((Throwable)e);
        }
        String formattedDateString = exportedDateFormat.format(cqDate);
        xmlSb.append("\t<" + tagName + ">");
        xmlSb.append(formattedDateString);
        xmlSb.append(END_LEFT_BRACKET + tagName + END_RIGHT_BRACKET);
        return xmlSb.toString();
    }

    private String formatNotesData(CQNoteEntry noteEntry) throws InteropException {
        StringBuilder xmlSb = new StringBuilder();
        String loginId = noteEntry.getUser();
        Map<String, ?> userMap = this.getCachedUser(loginId);
        xmlSb.append("\t<long_desc>\n\t");
        xmlSb.append(this.formatUserData("who", userMap));
        SimpleDateFormat exportedDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm Z");
        Date cqDate = DateParser.parseDate(noteEntry.getDate(), new ParsePosition(0));
        if (cqDate == null) {
            throw new InteropException(NLS.bind((String)Messages.CQExporter_ERROR_DATE_FORMAT_NOT_SUPPORTED, (Object)noteEntry.getDate(), (Object[])new Object[0]));
        }
        String formattedDateString = exportedDateFormat.format(cqDate);
        xmlSb.append("\t\t<bug_when>");
        xmlSb.append(formattedDateString);
        xmlSb.append("</bug_when>\n");
        xmlSb.append("\t\t<thetext>");
        String escapedValue = CQExporter.escapeXmlEntity(noteEntry.getText());
        xmlSb.append(escapedValue);
        xmlSb.append("</thetext>\n");
        xmlSb.append("\t</long_desc>\n");
        return xmlSb.toString();
    }

    private String formatAttachmentsData(String tagName, Object attachments) throws InteropException {
        StringBuilder xmlSb = new StringBuilder();
        this.fAttachmentsData = (List)attachments;
        for (ICqExportAttachmentData attachmentData : this.fAttachmentsData) {
            xmlSb.append("\t<attachment>\n");
            xmlSb.append("\t\t<attachid>");
            xmlSb.append(CQExporter.escapeXmlEntity(attachmentData.getFileName()));
            xmlSb.append("</attachid>\n");
            xmlSb.append("\t\t<desc>");
            xmlSb.append(CQExporter.escapeXmlEntity(attachmentData.getDescription()));
            xmlSb.append("</desc>\n");
            xmlSb.append("\t\t<filename>");
            xmlSb.append(CQExporter.escapeXmlEntity(attachmentData.getFileName()));
            xmlSb.append("</filename>\n");
            xmlSb.append("\t\t<size>");
            xmlSb.append(attachmentData.getSize());
            xmlSb.append("</size>\n");
            xmlSb.append("\t</attachment>\n");
        }
        return xmlSb.toString();
    }

    protected byte[] getBytes(String fileName, String recordId, String recordType) throws InteropException {
        InteropLocation attachmentLoc = CqGatewayConstants.objectFactory.createAttachmentLocator(fileName, recordType, recordId, this.fCqConnectionInfo.getConnectionURI());
        try {
            File attachmentFile = File.createTempFile("attach", null);
            this.fCqGateway.getContent(attachmentFile.getAbsolutePath(), attachmentLoc.getExternalLocationString(), this.fCqConnectionInfo.getConnectionURI());
            byte[] bytes = this.getBytes(attachmentFile);
            attachmentFile.delete();
            return bytes;
        }
        catch (Exception e) {
            throw new InteropException((Throwable)e);
        }
    }

    protected byte[] getBytes(File file) throws InteropException {
        try {
            int len;
            FileInputStream inputStream = new FileInputStream(file);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = ((InputStream)inputStream).read(buffer)) != -1) {
                outputStream.write(buffer, 0, len);
            }
            return outputStream.toByteArray();
        }
        catch (Exception e) {
            throw new InteropException((Throwable)e);
        }
    }

    private Map<String, ?> getCachedUser(String loginId) throws InteropException {
        Map userMap = this.fCachedUsers.get(loginId);
        if (userMap == null) {
            try {
                userMap = this.fCqGateway.retrieveUserByLoginId(loginId, this.fCqConnectionInfo.getConnectionURI());
                if (userMap == null) {
                    throw new InteropException(NLS.bind((String)Messages.CQExporter_ERROR_USER_NOT_FOUND, (Object)loginId, (Object[])new Object[0]));
                }
                this.fCachedUsers.put(loginId, userMap);
            }
            catch (ERException e) {
                throw new InteropException((Throwable)e);
            }
        }
        return userMap;
    }
}

