/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.ide.ui.importer.internal;

import com.ibm.rational.connector.cq.ide.ui.importer.CQImportIdeUIPlugin;
import com.ibm.rational.connector.cq.ide.ui.importer.internal.CQErrorPage;
import com.ibm.rational.connector.cq.ide.ui.importer.internal.CQImportMainPage;
import com.ibm.rational.connector.cq.ide.ui.importer.internal.Messages;
import com.ibm.rational.connector.cq.ide.ui.importer.internal.SettingsHelper;
import com.ibm.rational.connector.cq.importer.internal.CQRetrieval;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaConfiguration;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaImporter;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaLogStatusMonitor;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaZipFileRetrieval;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IBugRetrievalStrategy;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IBugzillaStatusMonitor;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class CQImportWizard
extends Wizard
implements IImportWizard {
    private CQImportMainPage fMainPage;
    private static boolean fCloseDialog = true;

    public CQImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.CQImportWizard_TITLE);
        this.setDefaultPageImageDescriptor(CQImportIdeUIPlugin.CQ_IMPORT_WIZARD);
    }

    public void addPages() {
        if (System.getProperty("cq.home") == null) {
            this.addPage((IWizardPage)new CQErrorPage("CQErrorPage", Messages.CQImportWizard_IMPORT_CLEARQUEST_RECORDS_ERROR, System.getProperty("CQ_ERROR_MSG"), null));
        } else {
            this.fMainPage = new CQImportMainPage("CQImportMainPage", Messages.CQImportWizard_TITLE, null);
            this.addPage((IWizardPage)this.fMainPage);
        }
    }

    public boolean performFinish() {
        return CQImportWizard.performOperation(this.getContainer(), this.fMainPage);
    }

    public static boolean performOperation(IWizardContainer container, CQImportMainPage fMainPage) {
        boolean importFromCQ = fMainPage.importFromCQ();
        String importFile = fMainPage.getImportFile();
        final String schemaRepo = fMainPage.getSchemaRepository();
        final String userName = fMainPage.getUserName();
        final String userDb = fMainPage.getUserDatabase();
        final String password = fMainPage.getPassword();
        final String query = fMainPage.getQuery();
        String saveFileName = fMainPage.getSaveFileName();
        String[] saveFileList = fMainPage.getSaveFileList();
        IProjectAreaHandle projectArea = fMainPage.getProjectArea();
        final boolean saveXML = fMainPage.isSaveAsXML();
        boolean overWrite = fMainPage.isOverWriteExisting();
        final String dataMappingFile = fMainPage.getDataMappingFile();
        String[] dataMappingFileList = fMainPage.getDataMappingFileList();
        String[] importDirList = fMainPage.getImportFileList();
        SettingsHelper.saveImportWizardSettings(saveXML, projectArea != null ? projectArea.getItemId().getUuidValue() : null, saveFileName, overWrite, saveFileList, importFile, importDirList, importFromCQ, dataMappingFile, dataMappingFileList, schemaRepo, userDb, userName, query);
        if (saveXML) {
            projectArea = null;
        }
        final BugzillaConfiguration configuration = new BugzillaConfiguration(projectArea);
        configuration.setComputeMappingFileOnly(false);
        if (!importFromCQ) {
            BugzillaZipFileRetrieval strategy;
            try {
                strategy = new BugzillaZipFileRetrieval(importFile);
            }
            catch (BugzillaException e) {
                CQImportIdeUIPlugin.getDefault().log(Messages.CQImportWizard_ERROR_IMPORTNG_CLEARQUEST_RECORDS, e);
                ErrorDialog.openError((Shell)container.getShell(), (String)Messages.CQImportWizard_ERROR_IMPORTNG_CLEARQUEST_RECORDS, null, (IStatus)e.getStatus());
                return false;
            }
            try {
                container.run(true, true, new IRunnableWithProgress((IBugRetrievalStrategy)strategy){
                    private final /* synthetic */ IBugRetrievalStrategy val$strategy;
                    {
                        this.val$strategy = iBugRetrievalStrategy;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        BugzillaLogStatusMonitor statusMonitor;
                        block6: {
                            try {
                                URL url = new File(dataMappingFile).toURL();
                                BugzillaMapping dataMapping = BugzillaMapping.readMapping((String)url.toString());
                                configuration.setMapping(dataMapping);
                            }
                            catch (MalformedURLException x) {
                                throw new InvocationTargetException(x);
                            }
                            catch (TeamRepositoryException x) {
                                throw new InvocationTargetException(x);
                            }
                            BugzillaImporter importer = new BugzillaImporter(configuration);
                            statusMonitor = new BugzillaLogStatusMonitor();
                            try {
                                importer.doImport(this.val$strategy, (IBugzillaStatusMonitor)statusMonitor, monitor);
                            }
                            catch (OperationCanceledException x) {
                                IStatus status = statusMonitor.getStatus();
                                if (!status.isOK()) break block6;
                                throw x;
                            }
                        }
                        IStatus status = statusMonitor.getStatus();
                        if (!status.isOK()) {
                            throw new InvocationTargetException((Throwable)new CoreException(status));
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                IStatus status = null;
                if (t instanceof CoreException) {
                    Throwable cause;
                    status = ((CoreException)t).getStatus();
                    Throwable details = status.getException();
                    if (details != null && (cause = details.getCause()) != null) {
                        status = new Status(4, "com.ibm.rational.connector.cq.ide.ui", 4, status.getMessage(), cause);
                    }
                } else {
                    status = new Status(4, "com.ibm.rational.connector.cq.ide.ui", 4, Messages.CQImportWizard_ERROR_IMPORTNG_CLEARQUEST_RECORDS, t);
                }
                CQImportIdeUIPlugin.getDefault().log(Messages.CQImportWizard_ERROR_IMPORTNG_CLEARQUEST_RECORDS, t);
                ErrorDialog.openError((Shell)container.getShell(), (String)Messages.CQImportWizard_ERROR_IMPORTNG_CLEARQUEST_RECORDS, null, (IStatus)status);
                return true;
            }
        }
        if (saveXML) {
            configuration.setIsSaveXML(saveXML);
            configuration.setOverWriteExisting(overWrite);
            configuration.setSaveFileName(saveFileName);
        }
        final CQRetrieval strategy = new CQRetrieval();
        try {
            container.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    BugzillaLogStatusMonitor statusMonitor;
                    block19: {
                        try {
                            String dbSetDbName = String.valueOf(schemaRepo) + "/" + userDb;
                            ((CQRetrieval)strategy).connect(dbSetDbName, userName, password);
                            ((CQRetrieval)strategy).executeQuery(query);
                        }
                        catch (BugzillaException e) {
                            fCloseDialog = false;
                            throw new InvocationTargetException(e);
                        }
                        if (!saveXML) {
                            try {
                                URL url = new File(dataMappingFile).toURL();
                                BugzillaMapping dataMapping = BugzillaMapping.readMapping((String)url.toString());
                                configuration.setMapping(dataMapping);
                            }
                            catch (MalformedURLException x) {
                                throw new InvocationTargetException(x);
                            }
                            catch (TeamRepositoryException x) {
                                throw new InvocationTargetException(x);
                            }
                        }
                        BugzillaImporter importer = new BugzillaImporter(configuration);
                        statusMonitor = new BugzillaLogStatusMonitor();
                        try {
                            try {
                                importer.doImport(strategy, (IBugzillaStatusMonitor)statusMonitor, monitor);
                            }
                            catch (OperationCanceledException x) {
                                IStatus status = statusMonitor.getStatus();
                                if (status.isOK()) {
                                    throw x;
                                }
                                try {
                                    ((CQRetrieval)strategy).close();
                                }
                                catch (InteropException e) {
                                    CQImportIdeUIPlugin.getDefault().log(e.getMessage(), e);
                                }
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                ((CQRetrieval)strategy).close();
                            }
                            catch (InteropException e) {
                                CQImportIdeUIPlugin.getDefault().log(e.getMessage(), e);
                            }
                            throw throwable;
                        }
                        try {
                            ((CQRetrieval)strategy).close();
                        }
                        catch (InteropException e) {
                            CQImportIdeUIPlugin.getDefault().log(e.getMessage(), e);
                        }
                    }
                    IStatus status = statusMonitor.getStatus();
                    if (!status.isOK()) {
                        throw new InvocationTargetException((Throwable)new CoreException(status));
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            Object status = null;
            status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "com.ibm.rational.connector.cq.ide.ui", 4, Messages.CQImportWizard_ERROR_IMPORTNG_CLEARQUEST_RECORDS, t);
            CQImportIdeUIPlugin.getDefault().log(Messages.CQImportWizard_ERROR_IMPORTNG_CLEARQUEST_RECORDS, t);
            ErrorDialog.openError((Shell)container.getShell(), (String)Messages.CQImportWizard_ERROR_IMPORTNG_CLEARQUEST_RECORDS, null, (IStatus)status);
            return fCloseDialog;
        }
        return fCloseDialog;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

