/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.ide.ui.importer.internal;

import com.ibm.rational.connector.cq.ide.ui.importer.CQImportIdeUIPlugin;
import com.ibm.rational.connector.cq.ide.ui.importer.internal.CQImportWizardHelper;
import com.ibm.rational.connector.cq.ide.ui.importer.internal.Messages;
import com.ibm.rational.connector.cq.ide.ui.importer.internal.SelectQueryDialog;
import com.ibm.rational.connector.cq.ide.ui.importer.internal.SettingsHelper;
import com.ibm.rational.connector.cq.setup.CQConnectorCQSetupFactory;
import com.ibm.rational.connector.cq.setup.ICQAdminService;
import com.ibm.rational.connector.cq.teamapi.common.ICqFolder;
import com.ibm.rational.connector.cq.teamapi.common.ICqQuery;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.ui.internal.wizards.bugzilla.WizardHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.ide.IDE;

public class CQImportMainPage
extends WizardPage {
    public static final String MEMENTO_CQ = "cqimport";
    public static final String MEMENTO_CQ_IS_CQ_IMPORT = "iscqimport";
    public static final String MEMENTO_CQ_READ_FILE = "importfile";
    public static final String MEMENTO_CQ_READ_FILE_LIST = "importfilelist";
    public static final String MEMENTO_CQ_SCHEMA_REPO = "schemarepo";
    public static final String MEMENTO_CQ_USER = "user";
    public static final String MEMENTO_CQ_USER_DB = "db";
    public static final String MEMENTO_CQ_QUERY = "query";
    public static final String MEMENTO_CQ_PROJECT_AREA = "projectarea";
    public static final String MEMENTO_CQ_SAVE_XML = "savexml";
    public static final String MEMENTO_CQ_SAVE_XML_NAME = "savexmlfile";
    public static final String MEMENTO_CQ_SAVE_XML_LIST = "savexmlfilelist";
    public static final String MEMENTO_CQ_OVERWRITE = "overwrite";
    public static final String MEMENTO_CQ_DATA_MAPPING_FILE = "datamappingfile";
    public static final String MEMENTO_CQ_DATA_MAPPING_FILE_LIST = "datamappingfilelist";
    public static final String MEMENTO_CQ_IMPORT_METHOD = "importmethod";
    public static final String CQ_IMPORT_SECTION = "cqimportsection";
    private Button fImportFromCQButton;
    private Button fImportFromZipFileButton;
    private Combo fImportFromZipCombo;
    private Button fImportFromZipBrowseButton;
    private Group fCQConnectionInfoGroup;
    private Combo fSchemaRepositoryCombo;
    private Text fUserNameText;
    private Text fPasswordText;
    private Combo fUserDatabaseCombo;
    private ICQAdminService fCqAdminService = null;
    private Group fQueryGroup;
    private Text fQueryText;
    private Button fQueryBrowseButton;
    private Group fOptionsGroup;
    private Button fImportToProjectAreaButton;
    private Label fProjectAreaLabel;
    private Combo fProjectAreaCombo;
    private IProjectAreaHandle[] fProjectAreas;
    private Button fSaveAsXMLButton;
    private Label fOptionsZipFileLabel;
    private Combo fOptionsZipFileCombo;
    private Button fOptionsZipFileBrowseButton;
    private Button fOverwriteButton;
    private Hyperlink fSaveDefaultAsHyperlink;
    private Label fXMLFileLabel;
    private Combo fXMLFileCombo;
    private Button fXMLFileBrowseButton;
    private static final String ZIP_SUFFIX = ".zip";
    private static final String XML_SUFFIX = ".xml";

    public CQImportMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = CQImportWizardHelper.createComposite(parent, 1, true);
        this.initializeDialogUnits((Control)composite);
        final Shell shell = super.getShell();
        Group locationGroup = CQImportWizardHelper.createGroup(composite, Messages.CQImportMainPage_SOURCE_LOCATION);
        Composite locationComposite = CQImportWizardHelper.createComposite((Composite)locationGroup, 3, true);
        this.fImportFromCQButton = new Button(locationComposite, 16);
        this.fImportFromCQButton.setText(Messages.CQImportMainPage_CONNECT_TO_CLEARQUEST);
        this.fImportFromCQButton.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.fImportFromCQButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CQImportMainPage.this.setCQSourceLocationEnablement(true);
                CQImportMainPage.this.updatePageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fImportFromZipFileButton = new Button(locationComposite, 16);
        this.fImportFromZipFileButton.setText(Messages.CQImportMainPage_ZIP_FILE);
        this.fImportFromZipFileButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fImportFromZipFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CQImportMainPage.this.setCQSourceLocationEnablement(false);
                CQImportMainPage.this.updatePageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fImportFromZipCombo = new Combo(locationComposite, 2052);
        this.fImportFromZipCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        String[] readFiles = SettingsHelper.restoreListSettings(MEMENTO_CQ_READ_FILE_LIST, CQ_IMPORT_SECTION, MEMENTO_CQ);
        String readFile = SettingsHelper.restoreSettings(MEMENTO_CQ_READ_FILE, CQ_IMPORT_SECTION, MEMENTO_CQ);
        this.restoreValuesForCombo(readFiles, readFile, this.fImportFromZipCombo);
        this.fImportFromZipCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CQImportMainPage.this.updatePageComplete();
            }
        });
        this.fImportFromZipBrowseButton = CQImportWizardHelper.createPushButton(locationComposite, Messages.CQImportMainPage_BROWSE);
        this.fImportFromZipBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(shell, 8192);
                String fileString = SettingsHelper.restoreSettings(CQImportMainPage.MEMENTO_CQ_READ_FILE, CQImportMainPage.CQ_IMPORT_SECTION, CQImportMainPage.MEMENTO_CQ);
                if (fileString != null) {
                    Path restorePath = new Path(fileString);
                    dialog.setFilterPath(restorePath.removeLastSegments(1).toOSString());
                    dialog.setFileName(restorePath.lastSegment());
                }
                dialog.setFilterExtensions(new String[]{"*.zip"});
                String filePathSelected = dialog.open();
                if (filePathSelected != null) {
                    Path path = new Path(dialog.getFilterPath());
                    path = path.addTrailingSeparator();
                    String fileName = dialog.getFileName();
                    if (!fileName.endsWith(CQImportMainPage.ZIP_SUFFIX)) {
                        fileName = fileName.concat(CQImportMainPage.ZIP_SUFFIX);
                    }
                    CQImportMainPage.this.fImportFromZipCombo.add(String.valueOf(path.toOSString()) + fileName);
                    int pos = CQImportMainPage.this.fImportFromZipCombo.getItems().length - 1;
                    if (pos >= 0) {
                        CQImportMainPage.this.fImportFromZipCombo.select(pos);
                    }
                    CQImportMainPage.this.updatePageComplete();
                }
            }
        });
        this.fCQConnectionInfoGroup = CQImportWizardHelper.createGroup(composite, Messages.CQImportMainPage_CLEARQUEST_CONNECTION_INFO);
        Composite cqConnectionInfoComposite = CQImportWizardHelper.createComposite((Composite)this.fCQConnectionInfoGroup, 2, true);
        CQImportWizardHelper.createLabel(cqConnectionInfoComposite, Messages.CQImportMainPage_SCHEMA_REPOSITORY);
        this.fSchemaRepositoryCombo = new Combo(cqConnectionInfoComposite, 2060);
        this.fSchemaRepositoryCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.populateSchemaRepo();
        this.fSchemaRepositoryCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CQImportMainPage.this.populateUserDbs(CQImportMainPage.this.fSchemaRepositoryCombo.getText());
                CQImportMainPage.this.setQueryEnablement();
                CQImportMainPage.this.updatePageComplete();
            }
        });
        CQImportWizardHelper.createLabel(cqConnectionInfoComposite, Messages.CQImportMainPage_USER_NAME);
        this.fUserNameText = new Text(cqConnectionInfoComposite, 2048);
        this.fUserNameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fUserNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CQImportMainPage.this.setQueryEnablement();
                CQImportMainPage.this.updatePageComplete();
            }
        });
        CQImportWizardHelper.createLabel(cqConnectionInfoComposite, Messages.CQImportMainPage_PASSWORD);
        this.fPasswordText = new Text(cqConnectionInfoComposite, 0x400800);
        this.fPasswordText.setLayoutData((Object)new GridData(4, 4, true, false));
        CQImportWizardHelper.createLabel(cqConnectionInfoComposite, Messages.CQImportMainPage_USER_DATABASE);
        this.fUserDatabaseCombo = new Combo(cqConnectionInfoComposite, 2060);
        this.fUserDatabaseCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fUserDatabaseCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CQImportMainPage.this.setQueryEnablement();
                CQImportMainPage.this.updatePageComplete();
            }
        });
        this.fQueryGroup = CQImportWizardHelper.createGroup(composite, Messages.CQImportMainPage_SELECT_QUERY);
        Composite queryComposite = CQImportWizardHelper.createComposite((Composite)this.fQueryGroup, 3, true);
        CQImportWizardHelper.createLabel(queryComposite, Messages.CQImportMainPage_QUERY);
        this.fQueryText = new Text(queryComposite, 2048);
        this.fQueryText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fQueryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CQImportMainPage.this.updatePageComplete();
            }
        });
        this.fQueryBrowseButton = CQImportWizardHelper.createPushButton(queryComposite, Messages.CQImportMainPage_BROWSE);
        this.fQueryBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CQImportMainPage.this.fCqAdminService.setCqDbSetName(CQImportMainPage.this.fSchemaRepositoryCombo.getText());
                CQImportMainPage.this.fCqAdminService.setCqUserDbName(CQImportMainPage.this.fUserDatabaseCombo.getText());
                try {
                    CQImportMainPage.this.fCqAdminService.loginToCQ(CQImportMainPage.this.fUserNameText.getText(), CQImportMainPage.this.fPasswordText.getText());
                    CQImportMainPage.this.setErrorMessage(null);
                }
                catch (InteropException e) {
                    CQImportIdeUIPlugin.getDefault().log(Messages.CQImportMainPage_UNABLE_TO_LOGIN, e);
                    CQImportMainPage.this.setErrorMessage(Messages.CQImportMainPage_UNABLE_TO_LOGIN);
                    return;
                }
                try {
                    Object objectSelected;
                    ICqFolder rootFolder = CQImportMainPage.this.fCqAdminService.getSubTreeRootedAt(null);
                    SelectQueryDialog dialog = new SelectQueryDialog(shell, rootFolder);
                    if (dialog.open() == 0 && (objectSelected = dialog.getFirstResult()) instanceof ICqQuery) {
                        ICqQuery querySelected = (ICqQuery)objectSelected;
                        String queryPath = querySelected.getPath();
                        CQImportMainPage.this.fQueryText.setText(queryPath);
                    }
                }
                catch (InteropException e) {
                    CQImportIdeUIPlugin.getDefault().log(Messages.CQImportMainPage_ERROR_RETRIEVING_QUERY_FOLDERS, e);
                    CQImportMainPage.this.setErrorMessage(Messages.CQImportMainPage_ERROR_RETRIEVING_QUERY_FOLDERS);
                }
            }
        });
        String schemaRepo = SettingsHelper.restoreSettings(MEMENTO_CQ_SCHEMA_REPO, CQ_IMPORT_SECTION, MEMENTO_CQ);
        String userDb = SettingsHelper.restoreSettings(MEMENTO_CQ_USER_DB, CQ_IMPORT_SECTION, MEMENTO_CQ);
        String userName = SettingsHelper.restoreSettings(MEMENTO_CQ_USER, CQ_IMPORT_SECTION, MEMENTO_CQ);
        String query = SettingsHelper.restoreSettings(MEMENTO_CQ_QUERY, CQ_IMPORT_SECTION, MEMENTO_CQ);
        this.restoreValuesForCombo(null, schemaRepo, this.fSchemaRepositoryCombo);
        this.restoreValuesForCombo(null, userDb, this.fUserDatabaseCombo);
        if (userName != null) {
            this.fUserNameText.setText(userName);
        }
        if (query != null) {
            this.fQueryText.setText(query);
        }
        this.fOptionsGroup = CQImportWizardHelper.createGroup(composite, Messages.CQImportMainPage_OPTIONS);
        Composite optionsComposite = CQImportWizardHelper.createComposite((Composite)this.fOptionsGroup, 3, true);
        this.fImportToProjectAreaButton = new Button(optionsComposite, 16);
        this.fImportToProjectAreaButton.setText(Messages.CQImportMainPage_IMPORT_TO_PROJECT_AREA);
        this.fImportToProjectAreaButton.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.fImportToProjectAreaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CQImportMainPage.this.setImportToProjectAreaEnablement();
                CQImportMainPage.this.updatePageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fProjectAreaLabel = new Label(optionsComposite, 16384);
        this.fProjectAreaLabel.setText(Messages.CQImportMainPage_PROJECT_AREA);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 0x1000008;
        data.horizontalIndent = 15;
        this.fProjectAreaLabel.setLayoutData((Object)data);
        this.fProjectAreas = WizardHelper.getLoggedInProjectAreas();
        String selectedProjectArea = SettingsHelper.restoreSettings(MEMENTO_CQ_PROJECT_AREA, CQ_IMPORT_SECTION, MEMENTO_CQ);
        this.fProjectAreaCombo = WizardHelper.createProjectAreaCombo((Composite)optionsComposite, (IProjectAreaHandle[])this.fProjectAreas, (String)selectedProjectArea);
        this.fProjectAreaCombo.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.fSaveAsXMLButton = new Button(optionsComposite, 16);
        this.fSaveAsXMLButton.setText(Messages.CQImportMainPage_SAVE_AS_XML_DATA);
        this.fSaveAsXMLButton.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.fOptionsZipFileLabel = new Label(optionsComposite, 16384);
        this.fOptionsZipFileLabel.setText(Messages.CQImportMainPage_ZIP_FILE);
        GridData zipFileGridData = new GridData();
        zipFileGridData.horizontalSpan = 1;
        zipFileGridData.horizontalAlignment = 1;
        zipFileGridData.horizontalIndent = 15;
        this.fOptionsZipFileLabel.setLayoutData((Object)zipFileGridData);
        this.fOptionsZipFileCombo = new Combo(optionsComposite, 2052);
        this.fOptionsZipFileCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fOptionsZipFileCombo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                String fileName = CQImportMainPage.this.fOptionsZipFileCombo.getText();
                if (fileName.length() > 0 && !fileName.endsWith(CQImportMainPage.ZIP_SUFFIX)) {
                    CQImportMainPage.this.fOptionsZipFileCombo.setText(String.valueOf(fileName) + CQImportMainPage.ZIP_SUFFIX);
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.fOptionsZipFileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CQImportMainPage.this.updatePageComplete();
            }
        });
        String[] files = SettingsHelper.restoreListSettings(MEMENTO_CQ_SAVE_XML_LIST, CQ_IMPORT_SECTION, MEMENTO_CQ);
        String file = SettingsHelper.restoreSettings(MEMENTO_CQ_SAVE_XML_NAME, CQ_IMPORT_SECTION, MEMENTO_CQ);
        this.restoreValuesForCombo(files, file, this.fOptionsZipFileCombo);
        this.fOptionsZipFileBrowseButton = CQImportWizardHelper.createPushButton(optionsComposite, Messages.CQImportMainPage_BROWSE);
        this.fOptionsZipFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(shell, 8192);
                String fileString = SettingsHelper.restoreSettings(CQImportMainPage.MEMENTO_CQ_SAVE_XML_NAME, CQImportMainPage.CQ_IMPORT_SECTION, CQImportMainPage.MEMENTO_CQ);
                if (fileString != null) {
                    Path restorePath = new Path(fileString);
                    dialog.setFilterPath(restorePath.removeLastSegments(1).toOSString());
                }
                dialog.setFilterExtensions(new String[]{"*.zip"});
                String filePathSelected = dialog.open();
                if (filePathSelected != null) {
                    Path path = new Path(dialog.getFilterPath());
                    path = path.addTrailingSeparator();
                    String fileName = dialog.getFileName();
                    if (!fileName.endsWith(CQImportMainPage.ZIP_SUFFIX)) {
                        fileName = fileName.concat(CQImportMainPage.ZIP_SUFFIX);
                    }
                    CQImportMainPage.this.fOptionsZipFileCombo.add(String.valueOf(path.toOSString()) + fileName);
                    int pos = CQImportMainPage.this.fOptionsZipFileCombo.getItems().length - 1;
                    if (pos >= 0) {
                        CQImportMainPage.this.fOptionsZipFileCombo.select(pos);
                    }
                    CQImportMainPage.this.updatePageComplete();
                }
            }
        });
        this.fOverwriteButton = new Button(optionsComposite, 32);
        this.fOverwriteButton.setText(Messages.CQImportMainPage_OVERWRITE_EXISTING_RESOURCES);
        GridData overwriteGridData = new GridData();
        overwriteGridData.horizontalSpan = 2;
        overwriteGridData.horizontalAlignment = 1;
        overwriteGridData.horizontalIndent = 15;
        this.fOverwriteButton.setLayoutData((Object)overwriteGridData);
        boolean overwrite = Boolean.valueOf(SettingsHelper.restoreSettings(MEMENTO_CQ_OVERWRITE, CQ_IMPORT_SECTION, MEMENTO_CQ));
        this.fOverwriteButton.setSelection(overwrite);
        Group dataMappingGroup = CQImportWizardHelper.createGroup(composite, Messages.CQImportMainPage_CUSTOM_DATA_MAPPING);
        Composite dataMappingComposite = CQImportWizardHelper.createComposite((Composite)dataMappingGroup, 3, true);
        this.fSaveDefaultAsHyperlink = new Hyperlink(dataMappingComposite, 0);
        this.fSaveDefaultAsHyperlink.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        this.fSaveDefaultAsHyperlink.setText(Messages.CQImportMainPage_SAVE_DEFAULT_AS);
        this.fSaveDefaultAsHyperlink.setToolTipText(Messages.CQImportMainPage_SAVE_DEFAULT_AS_TOOLTIP);
        this.fSaveDefaultAsHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FileDialog dialog = new FileDialog(shell, 8192);
                String fileString = SettingsHelper.restoreSettings(CQImportMainPage.MEMENTO_CQ_DATA_MAPPING_FILE, CQImportMainPage.CQ_IMPORT_SECTION, CQImportMainPage.MEMENTO_CQ);
                if (fileString != null) {
                    Path restorePath = new Path(fileString);
                    dialog.setFilterPath(restorePath.removeLastSegments(1).toOSString());
                    dialog.setFileName(restorePath.lastSegment());
                } else {
                    dialog.setFileName(Messages.CQImportMainPage_CQ_MAPPING_FILE);
                }
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String result = dialog.open();
                String fileName = dialog.getFileName();
                if (result != null && fileName.length() > 0) {
                    IOException x;
                    File file;
                    block31: {
                        String message;
                        MessageDialog md;
                        String filePath;
                        Path path = new Path(dialog.getFilterPath());
                        path = path.addTrailingSeparator();
                        if (!fileName.endsWith(CQImportMainPage.XML_SUFFIX)) {
                            fileName = fileName.concat(CQImportMainPage.XML_SUFFIX);
                        }
                        if ((file = new File(filePath = String.valueOf(path.toOSString()) + fileName)).exists() && (md = new MessageDialog(shell, Messages.CQImportMainPage_SAVE_DEFAULT_MAPPING_TITLE, null, message = NLS.bind((String)Messages.CQImportMainPage_OVERWRITE_EXISTING_MAPPING_FILE, (Object)fileName, (Object[])new Object[0]), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0) {
                            return;
                        }
                        x = null;
                        BufferedInputStream in = null;
                        OutputStream out = null;
                        try {
                            try {
                                in = new BufferedInputStream(CQImportMainPage.getDefaultMappingURL().openStream());
                                out = new BufferedOutputStream(new FileOutputStream(file));
                                int b = ((InputStream)in).read();
                                while (b != -1) {
                                    out.write(b);
                                    b = ((InputStream)in).read();
                                }
                            }
                            catch (IOException y) {
                                x = y;
                                if (in != null) {
                                    try {
                                        ((InputStream)in).close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                if (out != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block31;
                            }
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (in != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (x != null) {
                        CQImportIdeUIPlugin.getDefault().log(Messages.CQImportMainPage_ERROR_SAVING_FILE_TITLE, x);
                        ErrorDialog.openError((Shell)shell, (String)Messages.CQImportMainPage_ERROR_SAVING_FILE_TITLE, null, (IStatus)new Status(4, "com.ibm.rational.connector.cq.ide.ui", Messages.CQImportMainPage_ERROR_SAVING_FILE, (Throwable)x));
                    } else {
                        CQImportMainPage.this.openFile(file);
                    }
                }
            }
        });
        HyperlinkGroup hyperlinkGroup = new HyperlinkGroup(Display.getCurrent());
        hyperlinkGroup.add(this.fSaveDefaultAsHyperlink);
        this.fXMLFileLabel = CQImportWizardHelper.createLabel(dataMappingComposite, Messages.CQImportMainPage_XML_FILE);
        this.fXMLFileCombo = new Combo(dataMappingComposite, 2052);
        this.fXMLFileCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fXMLFileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CQImportMainPage.this.updatePageComplete();
            }
        });
        String[] mappingFiles = SettingsHelper.restoreListSettings(MEMENTO_CQ_DATA_MAPPING_FILE_LIST, CQ_IMPORT_SECTION, MEMENTO_CQ);
        String mappingFile = SettingsHelper.restoreSettings(MEMENTO_CQ_DATA_MAPPING_FILE, CQ_IMPORT_SECTION, MEMENTO_CQ);
        this.restoreValuesForCombo(mappingFiles, mappingFile, this.fXMLFileCombo);
        this.fXMLFileBrowseButton = CQImportWizardHelper.createPushButton(dataMappingComposite, Messages.CQImportMainPage_BROWSE);
        this.fXMLFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(shell);
                String fileString = SettingsHelper.restoreSettings(CQImportMainPage.MEMENTO_CQ_DATA_MAPPING_FILE, CQImportMainPage.CQ_IMPORT_SECTION, CQImportMainPage.MEMENTO_CQ);
                if (fileString != null) {
                    Path restorePath = new Path(fileString);
                    dialog.setFilterPath(restorePath.removeLastSegments(1).toOSString());
                    dialog.setFileName(restorePath.lastSegment());
                }
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String filePathSelected = dialog.open();
                if (filePathSelected != null) {
                    Path path = new Path(dialog.getFilterPath());
                    path = path.addTrailingSeparator();
                    String fileName = dialog.getFileName();
                    if (!fileName.endsWith(CQImportMainPage.XML_SUFFIX)) {
                        fileName = fileName.concat(CQImportMainPage.XML_SUFFIX);
                    }
                    CQImportMainPage.this.fXMLFileCombo.add(String.valueOf(path.toOSString()) + fileName);
                    int pos = CQImportMainPage.this.fXMLFileCombo.getItems().length - 1;
                    if (pos >= 0) {
                        CQImportMainPage.this.fXMLFileCombo.select(pos);
                    }
                    CQImportMainPage.this.updatePageComplete();
                }
            }
        });
        this.fImportFromCQButton.setSelection(true);
        this.setCQSourceLocationEnablement(true);
        String downloadMethod = SettingsHelper.restoreSettings(MEMENTO_CQ_IS_CQ_IMPORT, CQ_IMPORT_SECTION, MEMENTO_CQ);
        downloadMethod = downloadMethod == null ? Boolean.TRUE.toString() : downloadMethod;
        boolean isCQ = Boolean.valueOf(downloadMethod);
        this.fImportFromCQButton.setSelection(isCQ);
        this.setCQSourceLocationEnablement(isCQ);
        this.fImportFromZipFileButton.setSelection(!isCQ);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "com.ibm.rational.connector.cq.ide.ui.cqImportWizard");
        this.updatePageComplete();
    }

    private void openFile(File file) {
        if (file.exists()) {
            try {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window == null && workbench.getWorkbenchWindows().length > 0) {
                    window = workbench.getWorkbenchWindows()[0];
                }
                if (window != null) {
                    IWorkbenchPage page = window.getActivePage();
                    if (page == null && window.getPages().length > 0) {
                        page = window.getPages()[0];
                    }
                    if (page != null) {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)EFS.getLocalFileSystem().getStore((IPath)new Path(file.getAbsolutePath())));
                    }
                }
            }
            catch (PartInitException x) {
                CQImportIdeUIPlugin.getDefault().log(x.getLocalizedMessage(), x);
            }
        }
    }

    private void populateSchemaRepo() {
        try {
            this.fCqAdminService = CQConnectorCQSetupFactory.createCQAdminService();
            List dbSets = this.fCqAdminService.getDbSetNames();
            for (String dbSet : dbSets) {
                this.fSchemaRepositoryCombo.add(dbSet);
            }
        }
        catch (InteropException e) {
            CQImportIdeUIPlugin.getDefault().log(Messages.CQImportMainPage_ERROR_GETTING_SCHEMA_REPOSITORIES, e);
            this.setErrorMessage(Messages.CQImportMainPage_ERROR_GETTING_SCHEMA_REPOSITORIES);
        }
    }

    private void populateUserDbs(String schemaRepo) {
        try {
            this.fCqAdminService.setCqDbSetName(schemaRepo);
            List userDbs = this.fCqAdminService.getUserDbNames();
            this.fUserDatabaseCombo.clearSelection();
            this.fUserDatabaseCombo.removeAll();
            for (String userDb : userDbs) {
                this.fUserDatabaseCombo.add(userDb);
            }
            if (userDbs.size() == 1) {
                this.fUserDatabaseCombo.setText((String)userDbs.get(0));
            }
        }
        catch (InteropException e) {
            CQImportIdeUIPlugin.getDefault().log(Messages.CQImportMainPage_ERROR_GETTTING_USER_DATABASES, e);
            this.setErrorMessage(Messages.CQImportMainPage_ERROR_GETTTING_USER_DATABASES);
        }
    }

    private void restoreValuesForCombo(String[] files, String file, Combo combo) {
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i] != null) {
                    combo.add(files[i]);
                }
                ++i;
            }
        }
        if (file != null) {
            String[] fileItems = combo.getItems();
            int i = 0;
            while (i < fileItems.length) {
                if (fileItems[i].equals(file)) {
                    combo.select(i);
                }
                ++i;
            }
        }
    }

    private void setCQSourceLocationEnablement(boolean isCQSelected) {
        this.fImportFromZipCombo.setEnabled(!isCQSelected);
        this.fImportFromZipBrowseButton.setEnabled(!isCQSelected);
        this.setConnectionInfoEnablement(isCQSelected);
        this.setQueryEnablement();
        this.fSaveAsXMLButton.setSelection(isCQSelected);
        this.setSaveXMLEnablement(isCQSelected);
    }

    private void setConnectionInfoEnablement(boolean isCQSelected) {
        this.fSchemaRepositoryCombo.setEnabled(isCQSelected);
        this.fUserNameText.setEnabled(isCQSelected);
        this.fPasswordText.setEnabled(isCQSelected);
        this.fUserDatabaseCombo.setEnabled(isCQSelected);
    }

    private void setQueryEnablement() {
        if (this.fImportFromCQButton.getSelection() && this.fSchemaRepositoryCombo.getText().length() != 0 && this.fUserNameText.getText().length() != 0 && this.fUserDatabaseCombo.getText().length() != 0) {
            this.fQueryText.setEnabled(true);
            this.fQueryBrowseButton.setEnabled(true);
        } else {
            this.fQueryText.setEnabled(false);
            this.fQueryBrowseButton.setEnabled(false);
        }
    }

    private void setSaveXMLEnablement(boolean isCQSelected) {
        this.fImportToProjectAreaButton.setSelection(!isCQSelected);
        this.fSaveAsXMLButton.setEnabled(isCQSelected);
        this.setImportToProjectAreaEnablement();
    }

    private void setImportToProjectAreaEnablement() {
        boolean enabled = this.fImportToProjectAreaButton.getSelection();
        this.fProjectAreaLabel.setEnabled(enabled);
        this.fProjectAreaCombo.setEnabled(enabled);
        this.fOptionsZipFileLabel.setEnabled(!enabled);
        this.fOptionsZipFileCombo.setEnabled(!enabled);
        this.fOptionsZipFileBrowseButton.setEnabled(!enabled);
        this.fOverwriteButton.setEnabled(!enabled);
        this.setDataMappingEnablement();
    }

    private void setDataMappingEnablement() {
        boolean enabled = this.fImportToProjectAreaButton.getSelection();
        this.fXMLFileLabel.setEnabled(enabled);
        this.fXMLFileCombo.setEnabled(enabled);
        this.fXMLFileBrowseButton.setEnabled(enabled);
    }

    private void updatePageComplete() {
        this.updatePageComplete(true);
    }

    private void updatePageComplete(boolean showErrors) {
        if (!this.isControlCreated()) {
            return;
        }
        String error = this.validateConnectionInfo();
        if (error == null) {
            error = this.validateQuery();
        }
        if (error == null) {
            error = this.validateOptions();
        }
        if (error == null) {
            error = this.validateDataMapping();
        }
        this.setPageComplete(error == null);
        this.setErrorMessage(showErrors ? error : null);
    }

    private String validateConnectionInfo() {
        if (this.fImportFromCQButton.getSelection()) {
            if (this.fSchemaRepositoryCombo.getText().length() == 0) {
                return Messages.CQImportMainPage_SPECIFY_SCHEMA_REPOSITORY;
            }
            if (this.fUserNameText.getText().length() == 0) {
                return Messages.CQImportMainPage_SPECIFY_USER_NAME;
            }
            if (this.fUserDatabaseCombo.getText().length() == 0) {
                return Messages.CQImportMainPage_SPECIFY_DATABASE;
            }
        } else if (this.fImportFromZipCombo.getText().length() == 0) {
            return Messages.CQImportMainPage_SPECIFY_ZIP_FILE_TO_IMPORT;
        }
        return null;
    }

    private String validateQuery() {
        if (this.fImportFromCQButton.getSelection() && this.fQueryText.getText().length() == 0) {
            return Messages.CQImportMainPage_SPECIFY_QUERY;
        }
        return null;
    }

    private String validateOptions() {
        if (this.fImportToProjectAreaButton.getSelection()) {
            if (this.fProjectAreaCombo.getText().length() == 0) {
                return Messages.CQImportMainPage_SELECT_PROJECT_AREA_FOR_IMPORT;
            }
        } else if (this.fOptionsZipFileCombo.getText().length() == 0) {
            return Messages.CQImportMainPage_SPECIFY_ZIP_FILE_FOR_XML_DATA;
        }
        return null;
    }

    private String validateDataMapping() {
        if (this.fImportToProjectAreaButton.getSelection() && this.fXMLFileCombo.getText().length() == 0) {
            return Messages.CQImportMainPage_SPECIFY_DATA_MAPPING_FILE;
        }
        return null;
    }

    public boolean importFromCQ() {
        return this.fImportFromCQButton.getSelection();
    }

    public String getImportFile() {
        return this.fImportFromZipCombo.getText();
    }

    public String[] getImportFileList() {
        return this.fImportFromZipCombo.getItems();
    }

    public String getSchemaRepository() {
        return this.fSchemaRepositoryCombo.getText().trim();
    }

    public String getUserName() {
        return this.fUserNameText.getText().trim();
    }

    public String getPassword() {
        return this.fPasswordText.getText();
    }

    public String getUserDatabase() {
        return this.fUserDatabaseCombo.getText().trim();
    }

    public String getQuery() {
        return this.fQueryText.getText().trim();
    }

    public IProjectAreaHandle getProjectArea() {
        int index = this.fProjectAreaCombo.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.fProjectAreas[index];
    }

    public boolean isSaveAsXML() {
        return this.fSaveAsXMLButton.getSelection();
    }

    public String getSaveFileName() {
        return this.fOptionsZipFileCombo.getText().trim();
    }

    public String[] getSaveFileList() {
        return this.fOptionsZipFileCombo.getItems();
    }

    public boolean isOverWriteExisting() {
        return this.fOverwriteButton.getSelection();
    }

    public String getDataMappingFile() {
        return this.fXMLFileCombo.getText();
    }

    public String[] getDataMappingFileList() {
        return this.fXMLFileCombo.getItems();
    }

    private static URL getDefaultMappingURL() {
        return FileLocator.find((String)"com.ibm.rational.connector.cq.ide.ui", (IPath)new Path("resources/cq_data_mapping.xml"));
    }
}

