/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.ide.ui.importer;

import com.ibm.rational.connector.cq.ide.ui.importer.Messages;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class CQImportIdeUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.rational.connector.cq.ide.ui";
    public static final String CQ_IMPORT_WIZARD_CONTEXT_ID = "com.ibm.rational.connector.cq.ide.ui.cqImportWizard";
    private static final String TIME_ZONE = "TZ";
    private static final String CQ_HOME = "CQ_HOME";
    private static final String CQ_WEB = "cqweb";
    private static final String LIB = "lib";
    public static final String CONNECTOR_CQ_HOME = "cq.home";
    public static final String CQ_ERROR_MSG = "CQ_ERROR_MSG";
    private static final String CQ_JNI_NAME = "cqjni.jar";
    private static final String CLASSPATH = "CLASSPATH";
    private static final String CLEARQUEST_HOME = "CLEARQUEST_HOME";
    private static final String RATIONAL_HOME = "RATIONAL_HOME";
    private static final String CLEARQUEST_NAME = "ClearQuest";
    private static final String PATH_SEPARATOR = "//";
    private static String OS = null;
    public static final ImageDescriptor CQ_IMPORT_WIZARD = CQImportIdeUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.rational.connector.cq.ide.ui", (String)"icons/wizban/cq_import_wizban.gif");
    public static final ImageDescriptor FOLDER_DESCRIPTOR = CQImportIdeUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.rational.connector.cq.ide.ui", (String)"icons/obj16/closed_folder.gif");
    public static final ImageDescriptor QUERY_DESCRIPTOR = CQImportIdeUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.rational.connector.cq.ide.ui", (String)"icons/obj16/query.gif");
    private static CQImportIdeUIPlugin fgPlugin;

    public CQImportIdeUIPlugin() {
        fgPlugin = this;
    }

    public static CQImportIdeUIPlugin getDefault() {
        return fgPlugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        try {
            String cqJniDirectory = this.locateCqJniDirectory();
            if (cqJniDirectory != null) {
                File cqJniFile = new File(String.valueOf(cqJniDirectory) + PATH_SEPARATOR + CQ_JNI_NAME);
                if (cqJniFile.exists()) {
                    System.setProperty(CONNECTOR_CQ_HOME, cqJniDirectory);
                } else {
                    System.setProperty(CQ_ERROR_MSG, NLS.bind((String)Messages.getString("CQImportIdeUIPlugin.ERROR_FILE_DOES_NOT_EXIST"), (Object)cqJniFile.getPath(), (Object[])new Object[0]));
                }
            }
        }
        catch (InteropException e) {
            System.setProperty(CQ_ERROR_MSG, e.getMessage());
            this.log(e.getMessage(), e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        fgPlugin = null;
        super.stop(context);
    }

    public void log(String message, Throwable exception) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 0, message, exception));
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public static boolean isWindows() {
        if (OS == null) {
            OS = System.getProperty("os.name");
        }
        return OS.startsWith("Windows");
    }

    private String locateCqJniDirectory() throws InteropException {
        if (CQImportIdeUIPlugin.isWindows()) {
            return this.locateCqJniDirectoryOnWindows();
        }
        return this.locateCqJniDirectoryOnLinux();
    }

    private String locateCqJniDirectoryOnWindows() throws InteropException {
        String cqJniDirectory = null;
        String classPath = System.getenv(CLASSPATH);
        if (classPath != null) {
            String[] classPathEntries = classPath.split(";");
            int i = 0;
            while (i < classPathEntries.length) {
                String classPathEntry = classPathEntries[i];
                if (classPathEntry.toLowerCase().endsWith(CQ_JNI_NAME)) {
                    cqJniDirectory = classPathEntry.substring(0, classPathEntry.indexOf(CQ_JNI_NAME) - 1);
                    return cqJniDirectory;
                }
                ++i;
            }
        }
        if (cqJniDirectory == null) {
            String cqHome = System.getenv(CLEARQUEST_HOME);
            if (cqHome != null) {
                cqJniDirectory = cqHome;
            } else {
                String rationalHome = System.getenv(RATIONAL_HOME);
                if (rationalHome != null) {
                    cqJniDirectory = String.valueOf(rationalHome) + PATH_SEPARATOR + CLEARQUEST_NAME;
                } else {
                    cqHome = System.getenv(CQ_HOME);
                    if (cqHome != null) {
                        cqJniDirectory = cqHome;
                    }
                }
            }
        }
        if (cqJniDirectory == null) {
            throw new InteropException(Messages.getString("CQImportIdeUIPlugin.ERROR_SET_CQ_ENVIRONMENT_VARIABLES"));
        }
        return cqJniDirectory;
    }

    private String locateCqJniDirectoryOnLinux() throws InteropException {
        String cqJniDirectory = null;
        String timeZone = System.getenv(TIME_ZONE);
        if (timeZone == null || timeZone.length() == 0) {
            throw new InteropException(Messages.getString("CQImportIdeUIPlugin.ERROR_SET_TIMEZONE_VARIABLE"));
        }
        String cqHome = System.getenv(CQ_HOME);
        if (cqHome == null || cqHome.length() == 0) {
            throw new InteropException(Messages.getString("CQImportIdeUIPlugin.ERROR_SET_CQ_HOME_VARIABLE"));
        }
        cqJniDirectory = String.valueOf(cqHome) + PATH_SEPARATOR + CQ_WEB + PATH_SEPARATOR + LIB;
        return cqJniDirectory;
    }
}

