/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.common.cqgateway;

import com.ibm.rational.connector.cq.common.cqgateway.CQInteropEventHandler;
import com.ibm.rational.connector.cq.common.cqgateway.Messages;
import com.ibm.rational.connector.cq.teamapi.common.ICQConfigurationTable;
import com.ibm.rational.connector.cq.teamapi.common.ICQInteropEventHandler;
import com.ibm.rational.connector.cq.teamapi.common.ICqAttachmentFolder;
import com.ibm.rational.connector.cq.teamapi.common.ICqDbInfo;
import com.ibm.rational.connector.cq.teamapi.common.ICqFolder;
import com.ibm.rational.connector.cq.teamapi.common.ICqLocation;
import com.ibm.rational.connector.cq.teamapi.common.ICqObject;
import com.ibm.rational.connector.cq.teamapi.common.ICqObjectList;
import com.ibm.rational.connector.cq.teamapi.common.ICqProvider;
import com.ibm.rational.connector.cq.teamapi.common.ICqQuery;
import com.ibm.rational.connector.cq.teamapi.common.ICqQueryInfoTable;
import com.ibm.rational.connector.cq.teamapi.common.ICqRecordType;
import com.ibm.rational.connector.cq.teamapi.common.ISyncedTable;
import com.ibm.rational.connector.cq.teamapi.common.InteropLocation;
import com.ibm.rational.connector.cq.teamapi.common.InteropObjectFactory;
import com.ibm.rational.connector.cq.teamapi.common.internal.InteropProperties;
import com.ibm.rational.connector.cq.teamapi.common.internal.LogFactory;
import com.ibm.team.interop.service.managers.clearquest.common.CQInteropConstants;
import com.ibm.team.interop.service.managers.clearquest.common.InteropConnectionInfo;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import com.rational.clearquest.cqjni.CQClearQuest;
import com.rational.clearquest.cqjni.CQProductInfo;
import java.text.MessageFormat;
import java.util.Collection;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CqObjectFactory
implements InteropObjectFactory {
    private static final String CQ_LOCATION_PREFIX = "cq.repo.";
    private Log m_logDetails = LogFactory.getLog((int)2);
    private static String cqGatewayVersionInfo = null;
    private static final String DEFAULT_CM_API_VERSION = "7.1";
    private static final String VERSION_701 = "701";
    private static final String VERSION_71 = "71";

    private String determineGatewayVersion(String cqjniVersion, String cmApiVersion) throws InteropException {
        if (cqjniVersion.equals(VERSION_701) && cmApiVersion.equals(VERSION_701)) {
            return VERSION_701;
        }
        if (cqjniVersion.equals(VERSION_701) && cmApiVersion.equals(VERSION_71)) {
            return VERSION_71;
        }
        if (cqjniVersion.startsWith(VERSION_71) && cmApiVersion.equals(VERSION_71)) {
            return VERSION_71;
        }
        throw new InteropException(MessageFormat.format(Messages.getString("CqObjectFactory.ERROR_VERSION_MISMATCH"), cqjniVersion, cmApiVersion));
    }

    public String createVersionInfoForClassInstantiation(String cqVersionSpec) throws InteropException {
        String rawCqVersion = cqVersionSpec;
        String strippedDownVersion = CQInteropConstants.EMPTY_STRING;
        int indexOfDot = rawCqVersion.indexOf(".");
        if (indexOfDot == -1) {
            throw new InteropException(MessageFormat.format(Messages.getString("CqObjectFactory.ERROR_NO_MAJOR_VERSION"), cqVersionSpec));
        }
        strippedDownVersion = String.valueOf(strippedDownVersion) + rawCqVersion.substring(0, indexOfDot);
        if ((indexOfDot = (rawCqVersion = rawCqVersion.substring(indexOfDot + 1)).indexOf(".")) == -1) {
            if (rawCqVersion == null && rawCqVersion.equals(CQInteropConstants.EMPTY_STRING)) {
                throw new InteropException(MessageFormat.format(Messages.getString("CqObjectFactory.ERROR_NO_MINOR_VERSION"), cqVersionSpec));
            }
            strippedDownVersion = String.valueOf(strippedDownVersion) + rawCqVersion;
            return strippedDownVersion;
        }
        strippedDownVersion = String.valueOf(strippedDownVersion) + rawCqVersion.substring(0, indexOfDot);
        rawCqVersion = rawCqVersion.substring(indexOfDot + 1);
        indexOfDot = rawCqVersion.indexOf(".");
        String subVersionPart = CQInteropConstants.EMPTY_STRING;
        if (indexOfDot == -1) {
            if (rawCqVersion != null && !rawCqVersion.equals(CQInteropConstants.EMPTY_STRING)) {
                subVersionPart = rawCqVersion;
            }
        } else {
            subVersionPart = rawCqVersion.substring(0, indexOfDot);
        }
        if (subVersionPart.equals("0")) {
            return strippedDownVersion;
        }
        strippedDownVersion = String.valueOf(strippedDownVersion) + subVersionPart;
        return strippedDownVersion;
    }

    private String getCQVersionInfo() throws InteropException {
        try {
            if (cqGatewayVersionInfo == null) {
                String cmApiVersion;
                CQClearQuest cq = new CQClearQuest();
                CQProductInfo cqInfo = cq.CreateProductInfo();
                if (this.m_logDetails.isInfoEnabled()) {
                    this.m_logDetails.debug((Object)("Stage label of CQ: " + cqInfo.GetStageLabel()));
                }
                String cqjniVersion = this.createVersionInfoForClassInstantiation(cqInfo.GetFullProductVersion());
                if (this.m_logDetails.isInfoEnabled()) {
                    this.m_logDetails.debug((Object)("CQ Provider (JNI) Version is: " + cqjniVersion));
                }
                if ((cmApiVersion = (String)InteropProperties.getCurrentInteropProperties().getConfigValue("cm.api.version")) == null) {
                    cmApiVersion = DEFAULT_CM_API_VERSION;
                }
                cmApiVersion = this.createVersionInfoForClassInstantiation(cmApiVersion);
                if (this.m_logDetails.isInfoEnabled()) {
                    this.m_logDetails.debug((Object)("CM API Version is: " + cmApiVersion));
                }
                cqGatewayVersionInfo = this.determineGatewayVersion(cqjniVersion, cmApiVersion);
                if (this.m_logDetails.isInfoEnabled()) {
                    this.m_logDetails.debug((Object)("CQ Version Info is: " + cqGatewayVersionInfo));
                }
            }
            return cqGatewayVersionInfo;
        }
        catch (InteropException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InteropException("Couldn't get CQ version", (Throwable)e);
        }
    }

    private Object getImplementation(String baseClassName) throws InteropException {
        try {
            Object newInstance;
            String teamApiVersionInfo = this.getCQVersionInfo();
            String className = "com.ibm.rational.connector.cq.teamapi" + teamApiVersionInfo + '.' + baseClassName + "ForInterop" + teamApiVersionInfo;
            Class<?> clazz = Class.forName(className);
            try {
                newInstance = clazz.newInstance();
            }
            catch (Exception exception) {
                throw new InteropException("Can't create class with name: " + clazz.getName());
            }
            return newInstance;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InteropException("No class found for: " + baseClassName);
        }
    }

    public InteropLocation createLocator(String locationString) throws InteropException {
        ICqLocation cqLocation = (ICqLocation)this.getImplementation("CqLocation");
        cqLocation.init(locationString);
        return cqLocation;
    }

    public InteropLocation createLocator(Object location) throws InteropException {
        ICqLocation cqLocation = (ICqLocation)this.getImplementation("CqLocation");
        cqLocation.init(location);
        return cqLocation;
    }

    public InteropLocation createLocator(String dbid, String recordTypeName, String dbSetDatabaseName) throws InteropException {
        String locationString = null;
        if (!recordTypeName.equals("attachments")) {
            locationString = this.createLocatorString(dbid, recordTypeName, dbSetDatabaseName);
        }
        return this.createLocator(locationString);
    }

    public String createLocatorString(String dbid, String recordTypeName, String dbSetDatabaseName) throws InteropException {
        return "cq.repo.cq-record:" + recordTypeName + '/' + dbid + '@' + dbSetDatabaseName;
    }

    private String genAttachmentLocationString(String fileName, String recordTypeName, String id, String dbSetDatabaseName) throws InteropException {
        int indexOfLastBackSlash;
        String justName = null;
        int indexOfLastSlash = fileName.lastIndexOf("/");
        justName = indexOfLastSlash != -1 ? fileName.substring(indexOfLastSlash + 1) : ((indexOfLastBackSlash = fileName.lastIndexOf("\\")) != -1 ? fileName.substring(indexOfLastBackSlash + 1) : fileName);
        return "cq.record:" + recordTypeName + '/' + id + '/' + "Attachments" + '/' + justName + '@' + dbSetDatabaseName;
    }

    public InteropLocation createAttachmentLocator(String fileName, String recordTypeName, String id, String dbSetDatabaseName) throws InteropException {
        return this.createLocator(this.genAttachmentLocationString(fileName, recordTypeName, id, dbSetDatabaseName));
    }

    public ICqLocation createNewUserFriendlyLocation(ICqRecordType cqType, String value) throws InteropException {
        return cqType.getUserFriendlyLocation().child(value);
    }

    public ICQConfigurationTable createConfigurationTable() throws InteropException {
        return (ICQConfigurationTable)this.getImplementation("CQConfigurationTable");
    }

    public ISyncedTable createSyncedTable() throws InteropException {
        return (ISyncedTable)this.getImplementation("SyncedTable");
    }

    public ICqQueryInfoTable createQueryInfoTable() throws InteropException {
        return (ICqQueryInfoTable)this.getImplementation("CqQueryInfoTable");
    }

    public ICqObject createCqAttachment(InteropLocation location, ICqProvider provider) throws InteropException {
        ICqObject attachment = (ICqObject)this.getImplementation("CqAttachment");
        attachment.init(location, provider);
        return attachment;
    }

    public ICqAttachmentFolder createCqAttachmentFolder() throws InteropException {
        ICqAttachmentFolder attachmentFolder = (ICqAttachmentFolder)this.getImplementation("CqAttachmentFolder");
        return attachmentFolder;
    }

    public ICqAttachmentFolder createCqAttachmentFolder(Object folder, ICqProvider provider) throws InteropException {
        ICqAttachmentFolder attachmentFolder = (ICqAttachmentFolder)this.getImplementation("CqAttachmentFolder");
        attachmentFolder.init(folder, provider);
        return attachmentFolder;
    }

    public ICqFolder createCqFolder(Object cqFolder, ICqFolder parent, ICqProvider provider) throws InteropException {
        ICqFolder folder = (ICqFolder)this.getImplementation("CqFolder");
        folder.init(cqFolder, provider);
        if (parent != null) {
            folder.setParent(parent);
        } else {
            folder.doReadProperties();
        }
        return folder;
    }

    public ICqQuery createCqQuery(Object cqQuery, ICqFolder parent, ICqProvider provider) throws InteropException {
        ICqQuery query = (ICqQuery)this.getImplementation("CqQuery");
        query.init(cqQuery, provider);
        if (parent != null) {
            query.setParent(parent);
        } else {
            query.doReadProperties();
        }
        return query;
    }

    public ICqObject createCqRecord(InteropLocation location, String typeName, ICqProvider provider) throws InteropException {
        ICqObject record = (ICqObject)this.getImplementation("CqRecord");
        record.init(location, typeName, provider);
        return record;
    }

    public ICqObject createCqRecord(Object cqRecord, String typeName, ICqProvider provider) throws InteropException {
        ICqObject record = (ICqObject)this.getImplementation("CqRecord");
        record.init(cqRecord, typeName, provider);
        return record;
    }

    public ICqObjectList createRecordList(Object delegates, String typeName, ICqProvider provider) throws InteropException {
        ICqObjectList cqObjectList = (ICqObjectList)this.getImplementation("CqObjectList");
        cqObjectList.init(delegates, typeName, provider);
        return cqObjectList;
    }

    public ICqProvider createCqProvider(InteropConnectionInfo info, ICQInteropEventHandler handler, boolean hasAdminSession) throws InteropException {
        ICqProvider provider = (ICqProvider)this.getImplementation("CqProvider");
        provider.init(info, handler, hasAdminSession, ((CQInteropEventHandler)handler).getThreadInfo());
        return provider;
    }

    public ICqDbInfo createCqDbInfo(ICqProvider provider) throws InteropException {
        ICqDbInfo cqDbInfo = (ICqDbInfo)this.getImplementation("CqDbInfo");
        cqDbInfo.init(provider);
        return cqDbInfo;
    }

    public ICqRecordType createRecordType(Object type, String connectionURI, ICqProvider provider) throws InteropException {
        ICqRecordType cqRecordType = (ICqRecordType)this.getImplementation("CqRecordType");
        cqRecordType.init(type, connectionURI, provider);
        return cqRecordType;
    }

    public ICqQuery createCqQuery(String typeName, String queryPath, String connectionURI, ICqProvider provider) throws InteropException {
        ICqQuery cqQuery = (ICqQuery)this.getImplementation("CqQuery");
        cqQuery.init(typeName, queryPath, connectionURI, false, provider);
        return cqQuery;
    }

    public ICqQuery lookupCqQuery(String queryPath, String connectionURI, ICqProvider provider) throws InteropException {
        ICqQuery cqQuery = (ICqQuery)this.getImplementation("CqQuery");
        cqQuery.init(null, queryPath, connectionURI, true, provider);
        return cqQuery;
    }

    public ICqObject createNewCQObject(InteropLocation location, String typeName, ICqProvider provider) throws InteropException {
        if (typeName.equals("attachments")) {
            ICqLocation attachmentLocation = ((ICqLocation)location).createAttachmentLocation("Attachments");
            attachmentLocation.generateLocator(provider);
            return this.createCqAttachment((InteropLocation)attachmentLocation, provider);
        }
        ICqLocation cqLocation = (ICqLocation)location;
        cqLocation.generateLocator(provider);
        return this.createCqRecord((InteropLocation)cqLocation, typeName, provider);
    }

    public ICqObject createCQObject(InteropLocation location, String typeName, ICqProvider provider) throws InteropException {
        ICqLocation cqLocation = (ICqLocation)location;
        cqLocation.generateLocator(provider);
        if (cqLocation.isCqAttachmentLocation()) {
            return this.createCqAttachment((InteropLocation)cqLocation, provider);
        }
        if (cqLocation.isCqRecordLocation()) {
            return this.createCqRecord((InteropLocation)cqLocation, typeName, provider);
        }
        throw new InteropException("Can't create CQ proxy for " + location);
    }

    public ICqObject lookup(InteropLocation uniqueId, Collection<String> keySet, String typeName, ICqProvider provider) throws InteropException {
        ICqObject currentRecord = this.createCQObject(uniqueId, typeName, provider);
        currentRecord.doReadProperties(keySet);
        return currentRecord;
    }

    public String createUniqueTypeName(String recordTypeName) throws InteropException {
        return "com.ibm.rational.clearquest." + recordTypeName;
    }
}

