/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CQStateResolution {
    private String fResolution = null;
    private String fState;
    public static final String STATE_FIELD = "State";
    public static final String RESOLUTION_FIELD = "Resolution";
    public static final String STATE_RESOLUTION_PROPERTY = "StateResolution";

    public CQStateResolution(String encodedStateResolution) {
        int separatorPos = encodedStateResolution.indexOf(47);
        if (separatorPos == -1) {
            this.fState = encodedStateResolution;
        } else {
            this.fState = encodedStateResolution.substring(0, separatorPos);
            this.fResolution = encodedStateResolution.substring(separatorPos + 1);
        }
    }

    public String getState() {
        return this.fState;
    }

    public String getResolution() {
        return this.fResolution;
    }

    private static String getStateResolution(Map<String, ?> cqState) {
        String state = (String)cqState.get(STATE_FIELD);
        String resolution = (String)cqState.get(RESOLUTION_FIELD);
        if (state == null) {
            return null;
        }
        if (resolution == null || resolution.length() == 0) {
            return state;
        }
        return String.valueOf(state) + '/' + resolution;
    }

    public static void addStateResolution(Map<String, Object> cqState) {
        String stateRes = CQStateResolution.getStateResolution(cqState);
        if (stateRes != null) {
            cqState.put(STATE_RESOLUTION_PROPERTY, stateRes);
        }
    }

    public static void replaceWithStateResolution(Map<String, Object> cqState) {
        String stateRes = CQStateResolution.getStateResolution(cqState);
        if (stateRes != null) {
            cqState.put(STATE_RESOLUTION_PROPERTY, stateRes);
            cqState.remove(STATE_FIELD);
            cqState.remove(RESOLUTION_FIELD);
        }
    }

    public static List<String> getActualPropertyNames() {
        ArrayList<String> propNames = new ArrayList<String>();
        propNames.add(STATE_FIELD);
        propNames.add(RESOLUTION_FIELD);
        return propNames;
    }
}

