//Create a global object so I can send variables between different functions that shouldn't necessarily be able to talk to each other
window.$my = {};

dojo.require("dojo._base.fx");
dojo.require("dojo.fx");
dojo.require("dojo.NodeList-fx");
dojo.require("dijit.Tooltip");
dojo.require("dijit.form.Button");


dojo.addOnLoad(function() {

/*
 * THIS REQUIRES YOUR INPUT, PART 1
 * 
 * If you need to disable certain buttons when an option gets selected look no further
 * 
 * 
 * In the buttons array below, define objects with 4 elements as below. Use CSS notation (ie, for an id, use #id, for classes, use .class) to identify the elements 
 *
 * (1) buttonToClick : The button that you click that needs to disable something
 * (2) buttonToDisable : The button that gets disabled when you click (1)
 * (3) buttonReplacesDisabled : (OPTIONAL) If choosing (1) means another button should be chosen to replace (2), what is it? Use ONLY one id here.
 * (4) buttonFixesDisabled : What buttons can the user click to re-enabled (2)?
 *
 * You can add as many objects as you need to the "buttons" array. I have three below.
 *
 *
 */

	var buttons = [
			{
				buttonToClick: "#os_windows, #os_aix, #os_linux, #os_zlinux, #os_solaris, #os_ibmi, #os_plinux",
				buttonToDisable: "#smpe",
				buttonReplacesDisabled: "",
				buttonFixesDisabled: "#os_zos"
			},
			{
				buttonToClick: "#os_windows, #os_aix, #os_linux, #os_zlinux, #os_solaris, #os_zos",
				buttonToDisable: "#im_no",
				buttonReplacesDisabled: "#im_yes",
				buttonFixesDisabled: "#os_ibmi, #os_plinux"
			},
			{
				buttonToClick: "#os_ibmi",
				buttonToDisable: "#dbserver_derby",
				buttonReplacesDisabled: "",
				buttonFixesDisabled: "#os_windows, #os_aix, #os_linux, #os_solaris, #os_zos, #os_zlinux, #os_plinux"
			},
			{
				buttonToClick: "#os_ibmi",
				buttonToDisable: "#dbserver_oracle",
				buttonReplacesDisabled: "#dbserver_db2",
				buttonFixesDisabled: "#os_windows, #os_aix, #os_linux, #os_solaris, #os_zlinux, #os_plinux"
			},
			{
				buttonToClick: "#os_ibmi",
				buttonToDisable: "#dbserver_mssql",
				buttonReplacesDisabled: "#dbserver_db2",
				buttonFixesDisabled: "#os_windows, #os_aix, #os_linux, #os_solaris"
			},
			{
				buttonToClick: "#os_ibmi",
				buttonToDisable: "#server_tomcat",
				buttonReplacesDisabled: "#server_was",
				buttonFixesDisabled: "#os_windows, #os_aix, #os_linux, #os_solaris, #os_zos, #os_zlinux, #os_plinux"
			},
			{
				buttonToClick: "#os_ibmi, #os_plinux",
				buttonToDisable: "#im_yes",
				buttonReplacesDisabled: "#im_no",
				buttonFixesDisabled: "#os_windows, #os_aix, #os_linux, #os_solaris, #os_zlinux"
			},
			{
				buttonToClick: "#os_ibmi",
				buttonToDisable: "#smpe",
				buttonReplacesDisabled: "",
				buttonFixesDisabled: "#os_zos"
			},
			{
				buttonToClick: "#os_zlinux",
				buttonToDisable: "#dbserver_mssql",
				buttonReplacesDisabled: "",
				buttonFixesDisabled: "#os_windows, #os_aix, #os_linux, #os_solaris"
			},
			{
				buttonToClick: "#os_zlinux",
				buttonToDisable: "#smpe",
				buttonReplacesDisabled: "",
				buttonFixesDisabled: "#os_zos"
			},
			{
				buttonToClick: "#os_plinux",
				buttonToDisable: "#dbserver_mssql",
				buttonReplacesDisabled: "",
				buttonFixesDisabled: "#os_windows, #os_aix, #os_linux, #os_solaris"
			},
			{
				buttonToClick: "#os_plinux",
				buttonToDisable: "#smpe",
				buttonReplacesDisabled: "",
				buttonFixesDisabled: "#os_zos"
			},
			{
				buttonToClick: "#os_zos",
				buttonToDisable: "#dbserver_mssql",
				buttonReplacesDisabled: "",
				buttonFixesDisabled: "#os_windows, #os_aix, #os_solaris, #os_linux"
			},
			{
				buttonToClick: "#os_zos",
				buttonToDisable: "#dbserver_oracle",
				buttonReplacesDisabled: "",
				buttonFixesDisabled: "#os_windows, #os_aix, #os_solaris, #os_linux, #os_zlinux, #os_plinux"
			},
			{
				buttonToClick: "#os_zos",
				buttonToDisable: "#im_yes",
				buttonReplacesDisabled: "#smpe",
				buttonFixesDisabled: "#os_windows, #os_aix, #os_linux, #os_solaris, #os_zlinux,"
			},
			{
				buttonToClick: "#os_zos",
				buttonToDisable: "#im_no",
				buttonReplacesDisabled: "#smpe",
				buttonFixesDisabled: "#os_ibmi, #os_plinux"
			}
		];
	
	dojo.forEach(buttons, function(b, i) {
	//cache the queries for the buttons
	
		var click = dojo.query(b.buttonToClick);
		var kill = dojo.query(b.buttonToDisable);
		var toReplace = b.buttonReplacesDisabled.replace('#','');
			if (toReplace) {
				var replace = dojo.byId(toReplace);
			}
		var fixers = dojo.query(b.buttonFixesDisabled);

	//add to the object a reusable function to remove the disabled attribute
	//we're doing this for two reasons: adding it to the objects lets me have unique functions, and I will use them later
	//for the reset() function
		b.fixIt = function() {
			kill.attr('disabled',false);
		};
		
	//add to the object a reusable function to disable and do whatever else has to be done
		b.killIt = function() {
			
		// if there's something to replace it with, do that;
		// BUG BUG BUG: If there's a lot going on with conflicting replacement and fixer elements, 
		// I can't guarantee that it'll work the second or subsequent times
			if (toReplace) {
				replace.click();
			}

		//disable the buttons we don't want and uncheck them
		//this is a partial response to the bug above: at the very least, they won't be stuck with a disabled and checked button
			kill.attr({
				'disabled': 'disabled',
				'checked': false
				});
				
		//and finally, add an event handler to re-enable it if those other buttons get clicked
			fixers.onclick(function() {
				b.fixIt();
			});
		};

	//Certain browser fix: On load/reload, if something is still disabled, fix it. This might get overwritten in a second
		if (kill.attr('disabled')[0]) {
			b.fixIt();
		}
		
	//Certain browser fix: If on load/reload the Click button is checked, run the disable function
		if (click.attr('checked')[0]) {
			b.killIt();
		}

	//The main event listener
		click.onclick(function() {
			b.killIt();
		});
			
	});

//Need to simulate my own RESET function
	dojo.query('#form_reset')
		.onclick(function(e) {
		//reset the form
			dojo.byId('theForm').reset();
		//While we're at it, re-enabled any items that might have been disabled
			dojo.forEach(buttons, function(b, i){
				b.fixIt();
			});

		//Look for any highlighted form elements and remove the highlight class	
			dojo.query('td.option_selected','theForm').removeClass('option_selected');
		//And prevent the default behavior for the link
			dojo.stopEvent(e);
		});

//AND, finally, time to submit the thing.

	dojo.query('#theForm')
		.onsubmit(function(e) {
		//Remove any error messages
			dojo.query('p.error').orphan();
		
		//Validation time! Verify that they've selected all 5 options
			var hasSelected = true;
			dojo.query('div.needsSelected')
				.forEach(function(node) {
				//Check for a checked input
					var isOneSelected = dojo.query('input:checked',node).length;
					
				//If there isn't one
					if (!isOneSelected) {
					//Create an error message and cache it
						var theError = dojo.query(dojo.create('p',{ 
							innerHTML: errorMsg,
							'class': 'error' 
							}));
					//Find the table here and drop the error message in front of it
						theError.place(dojo.query('ul',node), 'before');

					//Add a handler to any of the inputs here, and remove the error message when they click one
						dojo.query('input', node)
							.onclick(function() {
								theError.orphan();
							});
							
					//If any of this happens, stop the presses
						hasSelected = false;
					}
				});

		// If you're good on each input, let's move on
			if (hasSelected) {

			// DEBUGGING: Uncomment this to get a list of what was submitted in Firebug's Console log. Very useful.
			//
			//	var q = dojo.formToJson(this, true);
			//	console.log(q);
				

			/*
			* THIS REQUIRES YOUR INPUT, PART 2
			*
			* In the dojo.query line below, with CSS notation (#id, .class), list any elements or steps that will ALWAYS be shown.
			* For example, if someone must always hit the Power button or whatever, regardless of other options, list it here.
			*
			*/
				dojo.query('#sysReq, #getInstallMedia, #editionsLicenses, #installation, #runWizard, #itsOver, #doEclipse').addClass('seen');


			//turn the values of the form into an object, with name: value
				var o = dojo.formToObject(this);
			
			/*
			* THIS REQUIRES YOUR INPUT, PART 3
			*
			* OK, the formToObject function above turned your form input into a javascript object.
			* Now, you have to turn each value into a variable. You'll be using these values to create an object, so you'll thank me later.
			*
			* You can name the variables whatever you want, but the values are o.NAME, where NAME is the value of the NAME="something" attribute of that form input
			*
			* This isn't strictly necessary, but it gives you something to copy-paste and it improves performance a little bit.
			* 
			*/
				var formCP = o.cp;
				var formCCM = o.cp_ccm;
				var formRDM = o.cp_rdm;
				var formRQM = o.cp_rqm;
				var formOS = o.os;
				var formAS = o.appserver;
				var formDB = o.dbserver;
				var formIM = o.im;
				
			/*
			* THIS REQUIRES YOUR INPUT, PART 4
			*
			* OK, with the values above, you'll be making an array of objects out of the possible values for the form.
			* 
			* Each object goes like this:
			* toCheck: One of the form variables from directly above.
			* possibleValue: One of the values (the VALUE="something" attribute from the form) that could be selected for that named input. 
			* classToShow: A list of classes, in CSS selector syntax (e.g, '.forWebSphere') to show IF the toCheck value is equal to the possibleValue value.
			*
			* The logic will go like this: IF the toCheck value IS possibleValue, THEN show the blocks with the class classToShow
			*
			* For example, "If for the 'Application Server' field, the user selected 'websphere7', then show the elements with the class 'forWebsphere7'" 
			*
			*/
			
			//Here's the array of values to check, and the classes (in CSS3 selector syntax) to display if someone has selected those options
				var a = [

						{toCheck: formCP, possibleValue: 'clm', classToShow: '.forCLM'},
						{toCheck: formCCM, possibleValue: 'ccm', classToShow: '.forCCM'},
						{toCheck: formRDM, possibleValue: 'rdm', classToShow: '.forRDM'},
						{toCheck: formRQM, possibleValue: 'rqm', classToShow: '.forRQM'},
						{toCheck: formOS, possibleValue: 'windows', classToShow: '.forWindows'},
						{toCheck: formOS, possibleValue: 'aix', classToShow: '.forAIX'},
						{toCheck: formOS, possibleValue: 'linux', classToShow: '.forLinux'},
						{toCheck: formOS, possibleValue: 'zlinux', classToShow: '.forZLinux'},
						{toCheck: formOS, possibleValue: 'plinux', classToShow: '.forPLinux'},
						{toCheck: formOS, possibleValue: 'solaris', classToShow: '.forSolaris'},
						{toCheck: formOS, possibleValue: 'ibmi', classToShow: '.forIBMi'},
						{toCheck: formOS, possibleValue: 'zos', classToShow: '.forZOS'},
						
						{toCheck: formAS, possibleValue: 'was', classToShow: '.forWAS'},
						{toCheck: formAS, possibleValue: 'tomcat', classToShow: '.forTomcat'},
						
						{toCheck: formDB, possibleValue: 'derby', classToShow: '.forDerby, .forNotServerSetupDB2'},
						{toCheck: formDB, possibleValue: 'db2', classToShow: '.forDB2, .forServerSetupDB2'},
						{toCheck: formDB, possibleValue: 'oracle', classToShow: '.forOracle'},
						{toCheck: formDB, possibleValue: 'mssql', classToShow: '.forMsSQL'},
						
						{toCheck: formIM, possibleValue: 'imYes', classToShow: '.forImYes'},
						{toCheck: formIM, possibleValue: 'imNo', classToShow: '.forImNo'}
					];


			//Cycle through the array
				dojo.forEach(a, function(field) {
				//If the field matches one of the possible values
					if (field.toCheck === field.possibleValue) {
					//then show those classes
						dojo.query(field.classToShow).addClass('seen');
					}
				});
				
			//Hide the form
				/*
				dojo.query('#qa')
					.wipeOut({duration: 500})
					.play();
				*/
				dojo.style('qa','display','none');
					
			//OK, now show the container with the results
				/*
				dojo.query('#results')
					.style({'display':'block','height':0,'overflow':'hidden'})
					.wipeIn({duration: 1000})
					.play();
				*/
				dojo.style('results','display','block');

			//Function for numbering the steps and adding a table of contents: For each H3 that is now visible (aka, it has a calculated height > 0), stick a number in front of it.
				var i = 0;
				
				dojo.create(
					'div',
					{
					'id':'tableOfContents',
					innerHTML: '<h2>' + tocTitle + '<\/h2><ol id="tocSteps"><\/ol>'
					},
					"results",
					"first");
				
				dojo.query('#results h3')
					.forEach(function(item) {
						if (dojo.style(item, "height")) {
						i = i+1;
						
						var stepNumber = '<span class="countNumber">' + i +'<\/span>',
							backToTop = ' <a class="backToTop" href="#tableOfContents">' + backToTopString + '<\/a>';
						
						//Add an ID to the H3 (for linking)
						dojo.attr(item,'id','step' + i);
						
						//Add an <li> to the tocSteps list, with a link
						dojo.create(
						'li',
						{
						innerHTML: '<a href="#step' + i + '">' + item.innerHTML + '<\/a>'
						},
						"tocSteps",
						"last");
						
						//Prepend the step number to the contents of the header
						item.innerHTML = stepNumber + item.innerHTML + backToTop;
												
						}
					});
					
			//Check for visible links and count them
			//This has to happen before you click the PRINT ALL button
			//Links are inline, not block, so you need a different way to figure out height
				$my.internalLinks.forEach(function(item){
					if (dojo.style(item.parentNode, "height")) {
						$my.visibleLinksCount++;

					}
				});

			//Loading Image
				var loadingImg = dojo.create('span', {
									innerHTML: '<img alt="' + loadingString + '" src="../common/loader_orange.gif"> ' + loadingString + '...',
									'class': 'loader'
									});
									
				dojo.place(loadingImg, "results", "before");

			//Fade in the loading graphic
				/*
				dojo.animateProperty({
					node: loadingImg,
					duration: 125,
					properties: {
						opacity: 1
					}
				}).play();
				*/
					
				var progress = 0; //Create variable to track progress of loaded links
				
			//Go through all links (that are internal) and pull in the content
				$my.internalLinks.forEach(function(link, i){
					//Check that the link is actually visible before you do anything fancy
					//To do this, you need to check that the PARENT node has height, b/c anchors are inline elements that don't have height
					//THIS is why you can't put links in a SPAN anywhere. The link has to be in a DIV, PI, LI, H1...
					if (dojo.style(link.parentNode, "height")) {
						
						//Cache some variables
						var	href = link.href, // The href of the link
							linktext = link.innerHTML, //the text of the link
							parent = link.parentNode, // The parent node of the link (likely a P or LI)			
							ajaxDiv = dojo.create('div',{  // A loading sign and wrapper for the AJAX-loaded content
								innerHTML: 'Loading...',
								'class': 'ajax loading' 
								});
					
						dojo.place(ajaxDiv, parent, "after"); //Drop the loading div after the node that holds the link
						
						dojo.xhrGet({
							url: href,
							load: function(response) {
								//Create an empty DIV element to give us a scoped place to search from
								var tempDiv = dojo.create('div');
								//Place the response (the full HTML document) in the div
								tempDiv.innerHTML = response;
								//Grab only the body, scoped from that temporary div
								var filteredResponse = dojo.query('div.body', tempDiv);
								
								//Drop the results in that div ... the innerHTML of the BODY is all of the topic's content
								ajaxDiv.innerHTML = filteredResponse[0].innerHTML;
								
								//Remove the 'loading' class from the loading div
								dojo.removeClass(ajaxDiv,'loading');
								
								//Captain subtlety: Animate in and out a highlight color to emphasize change
								/*
								dojo.style(ajaxDiv,"backgroundColor","#FCFFBF");
								dojo.animateProperty({
									node: ajaxDiv,
									duration: 650,
									properties: {
										"backgroundColor": "transparent"
									}
								}).play();
								*/
								
								//Add a class as a bit of data to show that you completed loading this link
								dojo.addClass(link, completedClass);
								
								//Add some text to the linktext to say that its content is just below
								link.innerHTML = linktext + '<em class="loadedLinkText"> (' + loadedLinkText + ')</em>';
								
								progress++; //increment the bar progress
//								console.log('Success! ' + progress + ' out of ' + $my.visibleLinksCount);
								
								if (progress == $my.visibleLinksCount) {
									dojo.destroy(loadingImg);

									dojo.addClass('results','showIt');
									
								}

								},
							error: function(response) {
								ajaxDiv.innerHTML = '<a href="' + href + '">' + loadErrorText + '</a>';
								dojo.addClass(link, attemptedClass);
								
								//Remove the 'loading' class from the loading div
								dojo.removeClass(ajaxDiv,'loading');

								progress++; //increment the bar progress
//								console.log('Error! ' + progress + ' out of ' + $my.visibleLinksCount);
								
								if (progress == $my.visibleLinksCount) {
									dojo.destroy(loadingImg);
									
									dojo.addClass('results','showIt');
								}

								} //End Error function
						}); //End XHR

					} //End IF HEIGHT
				
				}); //End internalLinks.forEach()
								
			//Start Over button
				dojo.query(
					dojo.create('button', {
						'id': 'startOver',
						'type': 'button',
						'title': backToFormTitle,
						innerHTML: backToFormLabel
						})
					)
					.place(loadingImg, "after")
					.onclick(function(e) {
						//Hide #results
						dojo.style('results','display','none');
						dojo.removeClass('results','showIt');
						
						//Bring back form
						/*
						dojo.query('#qa')
							.wipeIn({duration: 500})
							.play();
						*/
						dojo.style('qa','display','block')
							
						//Remove count numbers in headers
						dojo.query('span.countNumber')
							.orphan();
							
						//Remove back-to-top links
						dojo.query('a.backToTop')
							.orphan();
						
						//Remove SEEN class from all objects that might have it
						dojo.query('#results .seen')
							.removeClass('seen');
						
						//Reset visible Links Count to 0
						$my.visibleLinksCount = 0;
												
						//Destroy all possibly loaded content
						dojo.query('div.ajax')
							.orphan();
							
						//Destroy all the text that was added to links
						dojo.query('em.loadedLinkText')
							.orphan();
						
						//Destroy the existing loader image
						dojo.destroy(loadingImg);
						
						//Destroy the table of contents
						dojo.destroy('tableOfContents');
						
						//Finally, destroy this button itself
						dojo.destroy(e.target);
						
						dojo.stopEvent(e);
					}); // END START OVER BUTTON
			
			} //End conditional checking if the appropriate buttons are selected
			
		//This is very important: Prevent the form from actually submitting Data anywhere
			dojo.stopEvent(e);
		
		});
	
	//AJAX FUNCTIONS
		var completedClass = 'completed',
			attemptedClass = 'attempted';
			
		$my.visibleLinksCount = 0;

		//Query all links that are NOT external to the information center (marked by the REL attribute or they just begin with http:// things)
		$my.internalLinks = dojo.query('#results a:not([rel=external]):not([href^="http://"])');
		
		//Handler for clicking a single external anchor
/*
		$my.internalLinks.onclick(function(evt) {
				var anchor = this;
				
				//Check if you haven't done this yet
				if (!dojo.hasClass(anchor, completedClass)) {
					var	href = this.href,
						parent = this.parentNode,					
						ajaxDiv = dojo.create('div',{ 
								innerHTML: 'Loading...',
								'class': 'ajax loading' 
								});
						
					dojo.place(ajaxDiv, parent, "after");
										
					dojo.xhrGet({
						url: href,
						load: function(response) {
							//Create an empty DIV element to give us a scoped place to search from
							var tempDiv = dojo.create('div');
							//Place the response (the full HTML document) in the div
							tempDiv.innerHTML = response;
							//Grab only the body, scoped from that temporary div
							var filteredResponse = dojo.query('div.body', tempDiv);
							
							//Drop the results in that div
							ajaxDiv.innerHTML = filteredResponse[0].innerHTML;
							
							//Remove the 'loading' class from the loading div
							dojo.removeClass(ajaxDiv,'loading');
							
							//Captain subtlety: Animate in and out a highlight color to emphasize change
							dojo.style(ajaxDiv,"backgroundColor","#FCFFBF");
							dojo.animateProperty({
								node: ajaxDiv,
								duration: 650,
								properties: {
									"backgroundColor": "transparent"
								}
							}).play();
							
							//Add a class as a bit of data to show that you completed loading this link
							dojo.addClass(anchor, completedClass);
							
						},
						error: function(response) {
							ajaxDiv.innerHTML = 'Something went wrong. Sorry \'bout that! To go directly to the topic, click <a href="' + href + '">here</a>.';
							dojo.addClass(anchor, attemptedClass);
						}
					});
				
				}

				
				//As always, prevent the default action
				dojo.stopEvent(evt);
			});
*/	
});