/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. 
 *******************************************************************************
 
/***************************************************** 
* Example of calling the collapse() function:
* 
* <div class="collapseheadlearnmore"><a href="javascript:void(0)" class="collapsehead" onclick="collapse(this)">Learn more about something</a></div><div class="collapsecontent">This section should be collapsed and hidden.</div>
* 
* The collapse effect works standalone, but can take advantage of styles for better appearance.
* For example, you could define styles for div.collapsehead, div.collapsecontent, and a.collapsehead
* for nice results.
*
* IMPORTANT: For this to work, there must be no spaces or linebreaks 
* between the collapsehead div and the collapsecontent div.
* 
* Also, in the runtime output, provide a <noscript>, like this:
* 
* <noscript>
* <style type="text/css"><!--
* div.collapsecontent{display:block;}
* //--></style>
* </noscript>
*
*******************************************************/

function collapse(loc){
	
	//Navigate to the content division using DOM, then change its style
	var foc=loc.parentNode.parentNode.childNodes[1];
	foc.style.display=foc.style.display=='block'?'none':'block';
	
	//Find the header anchor by navigating the DOM tree, then change its class attribute to use a different style
	var headA = loc.parentNode.firstChild;
	headA.className=headA.className=='collapsehead'?'collapseheadopen':'collapsehead';

}  