/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.welcome.internal.brochures.loader;

import com.ibm.ccl.welcome.internal.brochures.loader.BrochureManager;
import com.ibm.ccl.welcome.internal.brochures.loader.BrochureXMLParser;
import com.ibm.ccl.welcome.internal.util.BundleUtil;
import com.ibm.ccl.welcome.internal.util.ModelUtil;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class ExtensionPointManager {
    private static ExtensionPointManager inst = new ExtensionPointManager();
    protected static final String BROCHURE = "com.ibm.ccl.welcome.bits.brochure";
    protected static final String ATT_BROCHURE_FILE = "file";
    protected IExtensionRegistry registry = Platform.getExtensionRegistry();

    private ExtensionPointManager() {
        IConfigurationElement[] brochureElements = this.getBrochureExtensions();
        int i = 0;
        while (i < brochureElements.length) {
            Bundle bundle = this.getBundle(brochureElements[i]);
            Document dom = this.loadDOM(brochureElements[i]);
            BrochureManager.brochureManager.addBrochure(dom, bundle);
            ++i;
        }
        BrochureManager.brochureManager.resolveReplacements();
    }

    private Bundle getBundle(IConfigurationElement element) {
        Bundle bundle = BundleUtil.getBundleFromConfigurationElement(element);
        return bundle;
    }

    public static ExtensionPointManager getInst() {
        return inst;
    }

    protected IConfigurationElement[] getBrochureExtensions() {
        return this.registry.getConfigurationElementsFor(BROCHURE);
    }

    protected Document loadDOM(IConfigurationElement cfgElement) {
        String content = cfgElement.getAttribute(ATT_BROCHURE_FILE);
        Bundle domBundle = this.getBundle(cfgElement);
        ModelUtil.extractParentFolder(domBundle, content);
        content = BundleUtil.getResourceLocation(content, cfgElement);
        Document document = new BrochureXMLParser(content).getDocument();
        return document;
    }

    protected IConfigurationElement[] getIntroConfig(String attributeName, String attributeValue) {
        IConfigurationElement[] configExtensionElements = this.registry.getConfigurationElementsFor(BROCHURE);
        IConfigurationElement[] configExtensions = this.getConfigurationsFromAttribute(configExtensionElements, attributeName, attributeValue);
        return configExtensions;
    }

    protected IConfigurationElement[] getConfigurationsFromAttribute(IConfigurationElement[] configElements, String attributeName, String attributeValue) {
        Vector<IConfigurationElement> elements = new Vector<IConfigurationElement>();
        int i = 0;
        while (i < configElements.length) {
            String currentAttributeValue = configElements[i].getAttribute(attributeName);
            if (currentAttributeValue != null && currentAttributeValue.equals(attributeValue)) {
                elements.add(configElements[i]);
            }
            ++i;
        }
        Object[] filteredConfigElements = new IConfigurationElement[elements.size()];
        elements.copyInto(filteredConfigElements);
        return filteredConfigElements;
    }
}

