/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.welcome.internal.brochures.loader;

import com.ibm.ccl.welcome.internal.brochures.loader.Page;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Brochure {
    private String id;
    private String title;
    private Vector pages;
    private boolean complete;

    public Brochure(String id, String title) {
        this.id = id;
        this.title = title;
        this.pages = new Vector();
    }

    public void addPage(String pageId, String pageIcon, String pageTitle) {
        Page page;
        try {
            Page prev = (Page)this.pages.lastElement();
            page = new Page(pageId, pageIcon, pageTitle, prev, null);
            prev.setNext(page);
        }
        catch (NoSuchElementException noSuchElementException) {
            page = new Page(pageId, pageIcon, pageTitle, null, null);
        }
        this.pages.add(page);
    }

    public Page getPage(String id) {
        int i = 0;
        while (i < this.pages.size()) {
            Page pg = (Page)this.pages.get(i);
            if (pg.getId().equalsIgnoreCase(id)) {
                return pg;
            }
            ++i;
        }
        return null;
    }

    public boolean containsPage(String id) {
        return this.getPage(id) != null;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        String s = this.id;
        s = String.valueOf(s) + "\n";
        int i = 0;
        while (i < this.pages.size()) {
            s = String.valueOf(s) + ((Page)this.pages.get(i)).getId() + " - ";
            ++i;
        }
        return s;
    }

    public int numberOfPages() {
        return this.pages.size();
    }

    public Page page(int i) {
        try {
            return (Page)this.pages.get(i);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public int getPageNumber(Page page) {
        return this.pages.indexOf(page);
    }

    public String getTitle() {
        return this.title;
    }

    public void addPage(Page page) {
        this.pages.add(page);
    }

    public boolean equals(Object o) {
        return this.id.equalsIgnoreCase(((Brochure)o).getId());
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void replacePage(int position, Page replacement) {
        Page page = (Page)this.pages.get(position);
        page.setIcon(replacement.getIcon());
        page.setTitle(replacement.getTitle());
        this.pages.set(position, page);
    }
}

