/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.welcome.bits.contentproviders;

import com.ibm.ccl.welcome.bits.contentproviders.BrochureNav;
import com.ibm.ccl.welcome.internal.brochures.loader.Brochure;
import com.ibm.ccl.welcome.internal.brochures.loader.Page;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IIntroXHTMLContentProvider;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BrochureTopicList
extends BrochureNav
implements IIntroXHTMLContentProvider {
    private FormText formText;
    private Image bulletImage;
    private static final String HREF_BULLET = "bullet";
    private Composite parent;
    private FormToolkit toolkit;
    private String id;
    private static final String UL = "ul";
    private static final String LI = "li";

    public void createContent(String id, Element parent) {
        Document dom = parent.getOwnerDocument();
        Brochure brochure = this.getBrochure(id);
        int i = 0;
        while (i < brochure.numberOfPages()) {
            Page page = brochure.page(i);
            Element li = dom.createElement(LI);
            Element pageLink = dom.createElement("a");
            pageLink.setAttribute("class", "topicList");
            pageLink.setAttribute("href", "http://org.eclipse.ui.intro/showPage?id=" + page.getId());
            pageLink.appendChild(dom.createTextNode(brochure.page(i).getTitle()));
            li.appendChild(pageLink);
            parent.appendChild(li);
            ++i;
        }
    }

    public void createContent(String id, PrintWriter out) {
        try {
            DocumentBuilder loader = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = loader.newDocument();
            Element parent = document.createElement(UL);
            parent.setAttribute("ID", "topics");
            this.createContent(id, parent);
            out.write(this.getStringRepresentation(parent));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void createContent(String id, Composite parent, FormToolkit toolkit) {
        if (this.formText == null) {
            this.formText = toolkit.createFormText(parent, true);
            this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    BrochureTopicList.this.doNavigate((String)e.getHref());
                }
            });
            this.bulletImage = this.createImage((IPath)new Path("css/graphics/arrow.gif"));
            if (this.bulletImage != null) {
                this.formText.setImage(HREF_BULLET, this.bulletImage);
            }
            this.parent = parent;
            this.toolkit = toolkit;
            this.id = id;
        }
        Brochure brochure = this.getBrochure(id);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<form>");
        int i = 0;
        while (i < brochure.numberOfPages()) {
            Page page = brochure.page(i);
            buffer.append("<li style=\"image\" value=\"");
            buffer.append(HREF_BULLET);
            buffer.append("\">");
            buffer.append("<a href=\"");
            buffer.append("http://org.eclipse.ui.intro/showPage?id=" + page.getId());
            buffer.append("\">");
            buffer.append(brochure.page(i).getTitle());
            buffer.append("</a>");
            buffer.append("</li>");
            ++i;
        }
        buffer.append("</form>");
        this.formText.setText(buffer.toString(), true, false);
    }

    public void dispose() {
    }

    public void init(IIntroContentProviderSite site) {
    }

    private void doNavigate(final String url) {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IIntroURL introUrl = IntroURLFactory.createIntroURL((String)url);
                if (introUrl != null) {
                    introUrl.execute();
                    return;
                }
                BrochureTopicList.this.openBrowser(url);
            }
        });
    }

    private void openBrowser(String href) {
        try {
            URL url = new URL(href);
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            support.getExternalBrowser().openURL(url);
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private Image createImage(IPath path) {
        Bundle bundle = Platform.getBundle((String)"com.ibm.ccl.welcome.bits");
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        try {
            url = FileLocator.toFileURL((URL)url);
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            return desc.createImage();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

