/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.welcome.bits.contentproviders;

import com.ibm.ccl.welcome.bits.contentproviders.BrochureNavIdException;
import com.ibm.ccl.welcome.internal.brochures.loader.Brochure;
import com.ibm.ccl.welcome.internal.brochures.loader.BrochureManager;
import com.ibm.ccl.welcome.internal.brochures.loader.Page;
import com.ibm.ccl.welcome.internal.util.BundleUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.util.BundleUtility;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BrochureNav {
    final String DIV = "div";
    final String IMG = "img";
    final String A = "a";
    final String TABLE = "table";
    final String TR = "tr";
    final String TD = "td";
    final String P = "p";
    final String ID = "id";
    final String CLASS = "class";
    final String HREF = "href";
    final String SRC = "src";
    final String ALT = "alt";
    final String WIDTH = "width";
    final String ALIGN = "align";
    final String MOUSEOVER = "onmouseover";
    final String URL = "http://org.eclipse.ui.intro/showPage?id=";
    final String PREVIOUS_IMAGE = "/css/graphics/previous.gif";
    final String NEXT_IMAGE = "/css/graphics/next.gif";
    protected Document dom;
    protected Page currentPage;
    protected Brochure currentBrochure;

    protected boolean setUp(String id, Element parent) throws BrochureNavIdException {
        this.dom = parent.getOwnerDocument();
        return this.setUp(id);
    }

    protected boolean setUp(String id) throws BrochureNavIdException {
        String[] strings = id.split("-");
        if (strings.length < 2) {
            throw new BrochureNavIdException("Error parsing id: " + id);
        }
        String brochureId = id.substring(id.indexOf("-") + 1);
        String pageId = IntroPlugin.getDefault().getIntroModelRoot().getCurrentPageId();
        this.currentBrochure = this.getBrochure(brochureId);
        if (this.currentBrochure == null) {
            throw new BrochureNavIdException("Could not find brochure with id: " + brochureId);
        }
        this.currentPage = this.currentBrochure.getPage(pageId);
        if (this.currentPage == null) {
            throw new BrochureNavIdException("Brochure with id " + brochureId + " does not contain a page with id " + pageId);
        }
        return true;
    }

    protected Brochure getBrochure(String brochureId) {
        return BrochureManager.brochureManager.findBrochure(brochureId);
    }

    protected void addPrevious(Element e, Node n) {
        if (this.currentPage.hasPrevious()) {
            Element prevLink = this.dom.createElement("a");
            prevLink.setAttribute("href", "http://org.eclipse.ui.intro/showPage?id=" + this.currentPage.getPrevious().getId());
            prevLink.appendChild(n);
            e.appendChild(prevLink);
        } else {
            e.appendChild(this.dom.createComment("Div needs contents to space correctly"));
        }
    }

    protected void addNext(Element e, Node n) {
        if (this.currentPage.hasNext()) {
            Element nextLink = this.dom.createElement("a");
            nextLink.setAttribute("href", "http://org.eclipse.ui.intro/showPage?id=" + this.currentPage.getNext().getId());
            nextLink.appendChild(n);
            e.appendChild(nextLink);
        } else {
            e.appendChild(this.dom.createComment("Div needs contents to space correctly"));
        }
    }

    protected String getStringRepresentation(Element parent) {
        String html = "";
        NodeList list = parent.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            short type = list.item(i).getNodeType();
            switch (type) {
                case 3: {
                    html = String.valueOf(html) + this.handleTextNode(list.item(i));
                    break;
                }
                case 8: {
                    html = String.valueOf(html) + this.handleCommentNode(list.item(i));
                    break;
                }
                case 1: {
                    html = String.valueOf(html) + this.handleElementNode(list.item(i));
                }
            }
            ++i;
        }
        return html;
    }

    private String handleElementNode(Node node) {
        String html = "<" + node.getNodeName();
        if (node.hasAttributes()) {
            html = String.valueOf(html) + this.getAttributesString(node.getAttributes());
        }
        if (node.hasChildNodes()) {
            html = String.valueOf(html) + ">\n";
            html = String.valueOf(html) + this.getStringRepresentation((Element)node);
            html = String.valueOf(html) + "</" + node.getNodeName() + ">\n";
        } else {
            html = String.valueOf(html) + "/>";
        }
        return html;
    }

    private String handleCommentNode(Node node) {
        return "<!-- " + node.getNodeValue() + " -->";
    }

    private String handleTextNode(Node node) {
        return node.getNodeValue();
    }

    private String getAttributesString(NamedNodeMap attributes) {
        String s = "";
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            s = String.valueOf(s) + " " + attribute.getNodeName() + "=\"" + attribute.getNodeValue() + "\"";
            ++i;
        }
        return s;
    }

    protected String getPath(String imageFilePath) {
        Bundle bundle = Platform.getBundle((String)"com.ibm.ccl.welcome.bits");
        if (!BundleUtility.isReady((Bundle)bundle)) {
            return null;
        }
        return BundleUtil.getResolvedResourceLocation(imageFilePath, bundle);
    }
}

