/**
 * <copyright>
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2006, 2008. All Rights Reserved. 
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 * </copyright>
 *
 * $Id$
 */
package com.ibm.team.foundation.rcp.core.internal.favorites.impl;

import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.foundation.rcp.core.internal.favorites.Favorite;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFactory;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage;
import com.ibm.team.foundation.rcp.core.internal.favorites.ModelAccessor;
import com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite;
import com.ibm.team.repository.common.model.RepositoryPackage;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 *
 * @since 0.5
 * <!-- end-user-doc -->
 * @generated
 */
public class FavoritesPackageImpl extends EPackageImpl implements
		FavoritesPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass favoritesNodeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass uriFavoriteEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass favoritesFolderEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass favoriteEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass modelAccessorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass modelAccessorFacadeEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private FavoritesPackageImpl() {
		super(eNS_URI, FavoritesFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static FavoritesPackage init() {
		if (isInited)
			return (FavoritesPackage) EPackage.Registry.INSTANCE
					.getEPackage(FavoritesPackage.eNS_URI);

		// Obtain or create and register package
		FavoritesPackageImpl theFavoritesPackage = (FavoritesPackageImpl) (EPackage.Registry.INSTANCE
				.getEPackage(eNS_URI) instanceof FavoritesPackageImpl ? EPackage.Registry.INSTANCE
				.getEPackage(eNS_URI)
				: new FavoritesPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		RepositoryPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theFavoritesPackage.createPackageContents();

		// Initialize created meta-data
		theFavoritesPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theFavoritesPackage.freeze();

		return theFavoritesPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFavoritesNode() {
		return favoritesNodeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFavoritesNode_Parent() {
		return (EReference) favoritesNodeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getFavoritesNode_Text() {
		return (EAttribute) favoritesNodeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getFavoritesNode_SortOrder() {
		return (EAttribute) favoritesNodeEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getURIFavorite() {
		return uriFavoriteEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getURIFavorite_Details() {
		return (EAttribute) uriFavoriteEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getURIFavorite_FavoriteType() {
		return (EAttribute) uriFavoriteEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getURIFavorite_Uri() {
		return (EAttribute) uriFavoriteEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFavoritesFolder() {
		return favoritesFolderEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFavoritesFolder_Children() {
		return (EReference) favoritesFolderEClass.getEStructuralFeatures().get(
				0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFavorite() {
		return favoriteEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFavorite_Item() {
		return (EReference) favoriteEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getFavorite_RepositoryUrl() {
		return (EAttribute) favoriteEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getModelAccessor() {
		return modelAccessorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getModelAccessorFacade() {
		return modelAccessorFacadeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FavoritesFactory getFavoritesFactory() {
		return (FavoritesFactory) getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated)
			return;
		isCreated = true;

		// Create classes and their features
		favoritesNodeEClass = createEClass(FAVORITES_NODE);
		createEReference(favoritesNodeEClass, FAVORITES_NODE__PARENT);
		createEAttribute(favoritesNodeEClass, FAVORITES_NODE__TEXT);
		createEAttribute(favoritesNodeEClass, FAVORITES_NODE__SORT_ORDER);

		uriFavoriteEClass = createEClass(URI_FAVORITE);
		createEAttribute(uriFavoriteEClass, URI_FAVORITE__DETAILS);
		createEAttribute(uriFavoriteEClass, URI_FAVORITE__FAVORITE_TYPE);
		createEAttribute(uriFavoriteEClass, URI_FAVORITE__URI);

		favoritesFolderEClass = createEClass(FAVORITES_FOLDER);
		createEReference(favoritesFolderEClass, FAVORITES_FOLDER__CHILDREN);

		favoriteEClass = createEClass(FAVORITE);
		createEReference(favoriteEClass, FAVORITE__ITEM);
		createEAttribute(favoriteEClass, FAVORITE__REPOSITORY_URL);

		modelAccessorEClass = createEClass(MODEL_ACCESSOR);

		modelAccessorFacadeEClass = createEClass(MODEL_ACCESSOR_FACADE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized)
			return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		RepositoryPackage theRepositoryPackage = (RepositoryPackage) EPackage.Registry.INSTANCE
				.getEPackage(RepositoryPackage.eNS_URI);

		// Add supertypes to classes
		uriFavoriteEClass.getESuperTypes().add(this.getFavoritesNode());
		uriFavoriteEClass.getESuperTypes().add(this.getModelAccessor());
		favoritesFolderEClass.getESuperTypes().add(this.getFavoritesNode());
		favoriteEClass.getESuperTypes().add(this.getFavoritesNode());
		favoriteEClass.getESuperTypes().add(this.getModelAccessor());

		// Initialize classes and features; add operations and parameters
		initEClass(
				favoritesNodeEClass,
				FavoritesNode.class,
				"FavoritesNode", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
		initEReference(
				getFavoritesNode_Parent(),
				this.getFavoritesFolder(),
				null,
				"parent", null, 0, 1, FavoritesNode.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
		initEAttribute(
				getFavoritesNode_Text(),
				ecorePackage.getEString(),
				"text", null, 0, 1, FavoritesNode.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
		initEAttribute(
				getFavoritesNode_SortOrder(),
				ecorePackage.getEDouble(),
				"sortOrder", null, 0, 1, FavoritesNode.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

		initEClass(
				uriFavoriteEClass,
				URIFavorite.class,
				"URIFavorite", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
		initEAttribute(
				getURIFavorite_Details(),
				ecorePackage.getEString(),
				"details", null, 0, 1, URIFavorite.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
		initEAttribute(
				getURIFavorite_FavoriteType(),
				ecorePackage.getEString(),
				"favoriteType", null, 0, 1, URIFavorite.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
		initEAttribute(
				getURIFavorite_Uri(),
				ecorePackage.getEString(),
				"uri", "", 0, 1, URIFavorite.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$ //$NON-NLS-2$

		initEClass(
				favoritesFolderEClass,
				FavoritesFolder.class,
				"FavoritesFolder", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
		initEReference(
				getFavoritesFolder_Children(),
				this.getFavoritesNode(),
				null,
				"children", null, 0, -1, FavoritesFolder.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

		initEClass(
				favoriteEClass,
				Favorite.class,
				"Favorite", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
		initEReference(
				getFavorite_Item(),
				theRepositoryPackage.getItemHandleFacade(),
				null,
				"item", null, 0, 1, Favorite.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$
		initEAttribute(
				getFavorite_RepositoryUrl(),
				ecorePackage.getEString(),
				"repositoryUrl", null, 0, 1, Favorite.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED); //$NON-NLS-1$

		initEClass(
				modelAccessorEClass,
				ModelAccessor.class,
				"ModelAccessor", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$

		initEClass(
				modelAccessorFacadeEClass,
				IModelAccessor.class,
				"ModelAccessorFacade", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// teamModel
		createTeamModelAnnotations();
		// teamPackage
		createTeamPackageAnnotations();
		// teamClass
		createTeamClassAnnotations();
	}

	/**
	 * Initializes the annotations for <b>teamModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createTeamModelAnnotations() {
		String source = "teamModel"; //$NON-NLS-1$		
		addAnnotation(this, source, new String[] {
				"clientProject", "com.ibm.team.foundation.rcp.core", //$NON-NLS-1$ //$NON-NLS-2$
				"clientSrcFolder", "model/src" //$NON-NLS-1$ //$NON-NLS-2$
		});
	}

	/**
	 * Initializes the annotations for <b>teamPackage</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createTeamPackageAnnotations() {
		String source = "teamPackage"; //$NON-NLS-1$			
		addAnnotation(
				this,
				source,
				new String[] {
						"clientBasePackage", "com.ibm.team.foundation.rcp.core.internal", //$NON-NLS-1$ //$NON-NLS-2$
						"clientPackageSuffix", "", //$NON-NLS-1$ //$NON-NLS-2$
						"version", "0.1" //$NON-NLS-1$ //$NON-NLS-2$
				});
	}

	/**
	 * Initializes the annotations for <b>teamClass</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createTeamClassAnnotations() {
		String source = "teamClass"; //$NON-NLS-1$				
		addAnnotation(favoritesNodeEClass, source, new String[] {
				"dbPersistable", "false" //$NON-NLS-1$ //$NON-NLS-2$
		});
		addAnnotation(uriFavoriteEClass, source, new String[] {
				"dbPersistable", "false" //$NON-NLS-1$ //$NON-NLS-2$
		});
		addAnnotation(favoritesFolderEClass, source, new String[] {
				"dbPersistable", "false" //$NON-NLS-1$ //$NON-NLS-2$
		});
		addAnnotation(favoriteEClass, source, new String[] {
				"dbPersistable", "false" //$NON-NLS-1$ //$NON-NLS-2$
		});
		addAnnotation(modelAccessorEClass, source, new String[] {
				"dbPersistable", "false" //$NON-NLS-1$ //$NON-NLS-2$
		});
		addAnnotation(modelAccessorFacadeEClass, source, new String[] {
				"facadeForClass", "ModelAccessor" //$NON-NLS-1$ //$NON-NLS-2$
		});
	}

} //FavoritesPackageImpl
