/**
 * <copyright>
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2006, 2008. All Rights Reserved. 
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 * </copyright>
 *
 * $Id$
 */
package com.ibm.team.foundation.rcp.core.internal.favorites.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Node</b></em>'.
 *
 * @since 0.5
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesNodeImpl#getParent <em>Parent</em>}</li>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesNodeImpl#getText <em>Text</em>}</li>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.impl.FavoritesNodeImpl#getSortOrder <em>Sort Order</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class FavoritesNodeImpl extends EObjectImpl implements FavoritesNode {
	/**
	 * A set of bit flags representing the values of boolean attributes and whether unsettable features have been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected int ALL_FLAGS = 0;

	/**
	 * The cached value of the '{@link #getParent() <em>Parent</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParent()
	 * @generated
	 * @ordered
	 */
	protected FavoritesFolder parent;

	/**
	 * The flag representing whether the Parent reference has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected static final int PARENT_ESETFLAG = 1 << 0;

	/**
	 * The default value of the '{@link #getText() <em>Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getText()
	 * @generated
	 * @ordered
	 */
	protected static final String TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getText() <em>Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getText()
	 * @generated
	 * @ordered
	 */
	protected String text = TEXT_EDEFAULT;

	/**
	 * The flag representing whether the Text attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected static final int TEXT_ESETFLAG = 1 << 1;

	/**
	 * The default value of the '{@link #getSortOrder() <em>Sort Order</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSortOrder()
	 * @generated
	 * @ordered
	 */
	protected static final double SORT_ORDER_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getSortOrder() <em>Sort Order</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSortOrder()
	 * @generated
	 * @ordered
	 */
	protected double sortOrder = SORT_ORDER_EDEFAULT;

	/**
	 * The flag representing whether the Sort Order attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected static final int SORT_ORDER_ESETFLAG = 1 << 2;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FavoritesNodeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return FavoritesPackage.Literals.FAVORITES_NODE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FavoritesFolder getParent() {
		if (parent != null && ((EObject) parent).eIsProxy()) {
			InternalEObject oldParent = (InternalEObject) parent;
			parent = (FavoritesFolder) eResolveProxy(oldParent);
			if (parent != oldParent) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE,
							FavoritesPackage.FAVORITES_NODE__PARENT, oldParent,
							parent));
			}
		}
		return parent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FavoritesFolder basicGetParent() {
		return parent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParent(FavoritesFolder newParent) {
		FavoritesFolder oldParent = parent;
		parent = newParent;
		boolean oldParentESet = (ALL_FLAGS & PARENT_ESETFLAG) != 0;
		ALL_FLAGS |= PARENT_ESETFLAG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					FavoritesPackage.FAVORITES_NODE__PARENT, oldParent, parent,
					!oldParentESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetParent() {
		FavoritesFolder oldParent = parent;
		boolean oldParentESet = (ALL_FLAGS & PARENT_ESETFLAG) != 0;
		parent = null;
		ALL_FLAGS &= ~PARENT_ESETFLAG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					FavoritesPackage.FAVORITES_NODE__PARENT, oldParent, null,
					oldParentESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetParent() {
		return (ALL_FLAGS & PARENT_ESETFLAG) != 0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText() {
		return text;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setText(String newText) {
		String oldText = text;
		text = newText;
		boolean oldTextESet = (ALL_FLAGS & TEXT_ESETFLAG) != 0;
		ALL_FLAGS |= TEXT_ESETFLAG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					FavoritesPackage.FAVORITES_NODE__TEXT, oldText, text,
					!oldTextESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetText() {
		String oldText = text;
		boolean oldTextESet = (ALL_FLAGS & TEXT_ESETFLAG) != 0;
		text = TEXT_EDEFAULT;
		ALL_FLAGS &= ~TEXT_ESETFLAG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					FavoritesPackage.FAVORITES_NODE__TEXT, oldText,
					TEXT_EDEFAULT, oldTextESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetText() {
		return (ALL_FLAGS & TEXT_ESETFLAG) != 0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getSortOrder() {
		return sortOrder;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSortOrder(double newSortOrder) {
		double oldSortOrder = sortOrder;
		sortOrder = newSortOrder;
		boolean oldSortOrderESet = (ALL_FLAGS & SORT_ORDER_ESETFLAG) != 0;
		ALL_FLAGS |= SORT_ORDER_ESETFLAG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					FavoritesPackage.FAVORITES_NODE__SORT_ORDER, oldSortOrder,
					sortOrder, !oldSortOrderESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetSortOrder() {
		double oldSortOrder = sortOrder;
		boolean oldSortOrderESet = (ALL_FLAGS & SORT_ORDER_ESETFLAG) != 0;
		sortOrder = SORT_ORDER_EDEFAULT;
		ALL_FLAGS &= ~SORT_ORDER_ESETFLAG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					FavoritesPackage.FAVORITES_NODE__SORT_ORDER, oldSortOrder,
					SORT_ORDER_EDEFAULT, oldSortOrderESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetSortOrder() {
		return (ALL_FLAGS & SORT_ORDER_ESETFLAG) != 0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case FavoritesPackage.FAVORITES_NODE__PARENT:
			if (resolve)
				return getParent();
			return basicGetParent();
		case FavoritesPackage.FAVORITES_NODE__TEXT:
			return getText();
		case FavoritesPackage.FAVORITES_NODE__SORT_ORDER:
			return new Double(getSortOrder());
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case FavoritesPackage.FAVORITES_NODE__PARENT:
			setParent((FavoritesFolder) newValue);
			return;
		case FavoritesPackage.FAVORITES_NODE__TEXT:
			setText((String) newValue);
			return;
		case FavoritesPackage.FAVORITES_NODE__SORT_ORDER:
			setSortOrder(((Double) newValue).doubleValue());
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
		case FavoritesPackage.FAVORITES_NODE__PARENT:
			unsetParent();
			return;
		case FavoritesPackage.FAVORITES_NODE__TEXT:
			unsetText();
			return;
		case FavoritesPackage.FAVORITES_NODE__SORT_ORDER:
			unsetSortOrder();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case FavoritesPackage.FAVORITES_NODE__PARENT:
			return isSetParent();
		case FavoritesPackage.FAVORITES_NODE__TEXT:
			return isSetText();
		case FavoritesPackage.FAVORITES_NODE__SORT_ORDER:
			return isSetSortOrder();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (text: "); //$NON-NLS-1$
		if ((ALL_FLAGS & TEXT_ESETFLAG) != 0)
			result.append(text);
		else
			result.append("<unset>"); //$NON-NLS-1$
		result.append(", sortOrder: "); //$NON-NLS-1$
		if ((ALL_FLAGS & SORT_ORDER_ESETFLAG) != 0)
			result.append(sortOrder);
		else
			result.append("<unset>"); //$NON-NLS-1$
		result.append(')');
		return result.toString();
	}

} //FavoritesNodeImpl