/**
 * <copyright>
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2006, 2008. All Rights Reserved. 
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 * </copyright>
 *
 * $Id$
 */
package com.ibm.team.foundation.rcp.core.internal.favorites.impl;

import com.ibm.team.foundation.rcp.core.internal.favorites.*;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import com.ibm.team.foundation.rcp.core.internal.favorites.Favorite;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFactory;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 *
 * @since 0.5
 * <!-- end-user-doc -->
 * @generated
 */
public class FavoritesFactoryImpl extends EFactoryImpl implements
		FavoritesFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static FavoritesFactory init() {
		try {
			FavoritesFactory theFavoritesFactory = (FavoritesFactory) EPackage.Registry.INSTANCE
					.getEFactory("http:///com/ibm/team/favoritesmodel.ecore"); //$NON-NLS-1$ 
			if (theFavoritesFactory != null) {
				return theFavoritesFactory;
			}
		} catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new FavoritesFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FavoritesFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
		case FavoritesPackage.FAVORITES_NODE:
			return (EObject) createFavoritesNode();
		case FavoritesPackage.URI_FAVORITE:
			return (EObject) createURIFavorite();
		case FavoritesPackage.FAVORITES_FOLDER:
			return (EObject) createFavoritesFolder();
		case FavoritesPackage.FAVORITE:
			return (EObject) createFavorite();
		default:
			throw new IllegalArgumentException(
					"The class '" + eClass.getName() + "' is not a valid classifier"); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FavoritesNode createFavoritesNode() {
		FavoritesNodeImpl favoritesNode = new FavoritesNodeImpl();
		return favoritesNode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public URIFavorite createURIFavorite() {
		URIFavoriteImpl uriFavorite = new URIFavoriteImpl();
		return uriFavorite;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FavoritesFolder createFavoritesFolder() {
		FavoritesFolderImpl favoritesFolder = new FavoritesFolderImpl();
		return favoritesFolder;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Favorite createFavorite() {
		FavoriteImpl favorite = new FavoriteImpl();
		return favorite;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FavoritesPackage getFavoritesPackage() {
		return (FavoritesPackage) getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static FavoritesPackage getPackage() {
		return FavoritesPackage.eINSTANCE;
	}

} //FavoritesFactoryImpl
