/**
 * <copyright>
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2006-2007. All Rights Reserved. 
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 * </copyright>
 *
 * $Id$
 */
package com.ibm.team.foundation.rcp.core.internal.favorites;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Node</b></em>'.
 *
 * @since 0.5
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getParent <em>Parent</em>}</li>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getText <em>Text</em>}</li>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getSortOrder <em>Sort Order</em>}</li>
 * </ul>
 * </p>
 *
 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage#getFavoritesNode()
 * @model annotation="teamClass dbPersistable='false'"
 * @generated
 */
public interface FavoritesNode {
	/**
	 * Returns the value of the '<em><b>Parent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parent</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Parent</em>' reference.
	 * @see #isSetParent()
	 * @see #unsetParent()
	 * @see #setParent(FavoritesFolder)
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage#getFavoritesNode_Parent()
	 * @model unsettable="true"
	 * @generated
	 */
	FavoritesFolder getParent();

	/**
	 * Sets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getParent <em>Parent</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Parent</em>' reference.
	 * @see #isSetParent()
	 * @see #unsetParent()
	 * @see #getParent()
	 * @generated
	 */
	void setParent(FavoritesFolder value);

	/**
	 * Unsets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getParent <em>Parent</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetParent()
	 * @see #getParent()
	 * @see #setParent(FavoritesFolder)
	 * @generated
	 */
	void unsetParent();

	/**
	 * Returns whether the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getParent <em>Parent</em>}' reference is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Parent</em>' reference is set.
	 * @see #unsetParent()
	 * @see #getParent()
	 * @see #setParent(FavoritesFolder)
	 * @generated
	 */
	boolean isSetParent();

	/**
	 * Returns the value of the '<em><b>Text</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Text</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Text</em>' attribute.
	 * @see #isSetText()
	 * @see #unsetText()
	 * @see #setText(String)
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage#getFavoritesNode_Text()
	 * @model unsettable="true"
	 * @generated
	 */
	String getText();

	/**
	 * Sets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getText <em>Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Text</em>' attribute.
	 * @see #isSetText()
	 * @see #unsetText()
	 * @see #getText()
	 * @generated
	 */
	void setText(String value);

	/**
	 * Unsets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getText <em>Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetText()
	 * @see #getText()
	 * @see #setText(String)
	 * @generated
	 */
	void unsetText();

	/**
	 * Returns whether the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getText <em>Text</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Text</em>' attribute is set.
	 * @see #unsetText()
	 * @see #getText()
	 * @see #setText(String)
	 * @generated
	 */
	boolean isSetText();

	/**
	 * Returns the value of the '<em><b>Sort Order</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sort Order</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sort Order</em>' attribute.
	 * @see #isSetSortOrder()
	 * @see #unsetSortOrder()
	 * @see #setSortOrder(double)
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage#getFavoritesNode_SortOrder()
	 * @model unsettable="true"
	 * @generated
	 */
	double getSortOrder();

	/**
	 * Sets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getSortOrder <em>Sort Order</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Sort Order</em>' attribute.
	 * @see #isSetSortOrder()
	 * @see #unsetSortOrder()
	 * @see #getSortOrder()
	 * @generated
	 */
	void setSortOrder(double value);

	/**
	 * Unsets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getSortOrder <em>Sort Order</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetSortOrder()
	 * @see #getSortOrder()
	 * @see #setSortOrder(double)
	 * @generated
	 */
	void unsetSortOrder();

	/**
	 * Returns whether the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode#getSortOrder <em>Sort Order</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Sort Order</em>' attribute is set.
	 * @see #unsetSortOrder()
	 * @see #getSortOrder()
	 * @see #setSortOrder(double)
	 * @generated
	 */
	boolean isSetSortOrder();

} // FavoritesNode