/**
 * <copyright>
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2006-2007. All Rights Reserved. 
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 * </copyright>
 *
 * $Id$
 */
package com.ibm.team.foundation.rcp.core.internal.favorites;

import com.ibm.team.repository.common.IItemHandle;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Favorite</b></em>'.
 *
 * @since 0.5
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.Favorite#getItem <em>Item</em>}</li>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.Favorite#getRepositoryUrl <em>Repository Url</em>}</li>
 * </ul>
 * </p>
 *
 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage#getFavorite()
 * @model annotation="teamClass dbPersistable='false'"
 * @generated
 */
public interface Favorite extends FavoritesNode, ModelAccessor {
	/**
	 * Returns the value of the '<em><b>Item</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Item</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Item</em>' containment reference.
	 * @see #isSetItem()
	 * @see #unsetItem()
	 * @see #setItem(IItemHandle)
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage#getFavorite_Item()
	 * @model type="com.ibm.team.repository.common.model.ItemHandleFacade" containment="true" unsettable="true"
	 * @generated
	 */
	IItemHandle getItem();

	/**
	 * Sets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.Favorite#getItem <em>Item</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Item</em>' containment reference.
	 * @see #isSetItem()
	 * @see #unsetItem()
	 * @see #getItem()
	 * @generated
	 */
	void setItem(IItemHandle value);

	/**
	 * Unsets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.Favorite#getItem <em>Item</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetItem()
	 * @see #getItem()
	 * @see #setItem(IItemHandle)
	 * @generated
	 */
	void unsetItem();

	/**
	 * Returns whether the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.Favorite#getItem <em>Item</em>}' containment reference is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Item</em>' containment reference is set.
	 * @see #unsetItem()
	 * @see #getItem()
	 * @see #setItem(IItemHandle)
	 * @generated
	 */
	boolean isSetItem();

	/**
	 * Returns the value of the '<em><b>Repository Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Repository Url</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Repository Url</em>' attribute.
	 * @see #isSetRepositoryUrl()
	 * @see #unsetRepositoryUrl()
	 * @see #setRepositoryUrl(String)
	 * @see com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage#getFavorite_RepositoryUrl()
	 * @model unsettable="true"
	 * @generated
	 */
	String getRepositoryUrl();

	/**
	 * Sets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.Favorite#getRepositoryUrl <em>Repository Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Repository Url</em>' attribute.
	 * @see #isSetRepositoryUrl()
	 * @see #unsetRepositoryUrl()
	 * @see #getRepositoryUrl()
	 * @generated
	 */
	void setRepositoryUrl(String value);

	/**
	 * Unsets the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.Favorite#getRepositoryUrl <em>Repository Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetRepositoryUrl()
	 * @see #getRepositoryUrl()
	 * @see #setRepositoryUrl(String)
	 * @generated
	 */
	void unsetRepositoryUrl();

	/**
	 * Returns whether the value of the '{@link com.ibm.team.foundation.rcp.core.internal.favorites.Favorite#getRepositoryUrl <em>Repository Url</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Repository Url</em>' attribute is set.
	 * @see #unsetRepositoryUrl()
	 * @see #getRepositoryUrl()
	 * @see #setRepositoryUrl(String)
	 * @generated
	 */
	boolean isSetRepositoryUrl();

} // Favorite