/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.srvc;

import com.ibm.rational.wvcm.ri.impl.ActivityImpl;
import com.ibm.rational.wvcm.ri.impl.BaselineImpl;
import com.ibm.rational.wvcm.ri.impl.ComponentImpl;
import com.ibm.rational.wvcm.ri.impl.ConfigurationImpl;
import com.ibm.rational.wvcm.ri.impl.ControllableFolderImpl;
import com.ibm.rational.wvcm.ri.impl.ControllableResourceImpl;
import com.ibm.rational.wvcm.ri.impl.ControllableSymbolicLinkImpl;
import com.ibm.rational.wvcm.ri.impl.FolderImpl;
import com.ibm.rational.wvcm.ri.impl.FolderVersionImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.ResourceImpl;
import com.ibm.rational.wvcm.ri.impl.ResourceListImpl;
import com.ibm.rational.wvcm.ri.impl.StreamImpl;
import com.ibm.rational.wvcm.ri.impl.SymbolicLinkVersionImpl;
import com.ibm.rational.wvcm.ri.impl.TaskImpl;
import com.ibm.rational.wvcm.ri.impl.VersionHistoryImpl;
import com.ibm.rational.wvcm.ri.impl.VersionImpl;
import com.ibm.rational.wvcm.ri.impl.WorkspaceImpl;
import com.ibm.rational.wvcm.ri.srvc.Messages;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcLocation;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.wvcm.Activity;
import javax.wvcm.Baseline;
import javax.wvcm.Component;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.ControllableSymbolicLink;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.FolderVersion;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Provider;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.SymbolicLinkVersion;
import javax.wvcm.Task;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.Workspace;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SrvcProvider
implements WorkspaceProvider {
    private static final String EMPTY = "";
    private static final String DOT = ".";
    public static final String RATIONAL_WVCM_NAMESPACE = "com.ibm.rational.wvcm";
    public static final String IA_DISPLAYNAME = "com.ibm.rational.wvcm.DISPLAYNAME";
    public static final String IA_CR_HAS_ONE_PARENT = "com.ibm.rational.wvcm.CR_HAS_ONE_PARENT";
    public static final String IA_STREAM_FORGETS_UNBOUND_VERSIONS = "com.ibm.rational.wvcm.STREAM_FORGETS_UNBOUND_VERSIONS";
    public static final String IA_VERSION_KNOWS_PARENT = "com.ibm.rational.wvcm.VERSION_KNOWS_PARENT";
    public static final String IA_WVCM_LOG_MINIMUM_DURATION = "com.ibm.rational.wvcm.LOG_MINIMUM_DURATION";
    protected ProviderFactory.Callback _callback;
    protected Map<String, String> _initArgs;
    private String _displayName = this.getClass().getSimpleName();
    private static ILogger _logger;
    private static Map<String, callInfo> _stats;
    private static boolean _loggingActive;
    private Stack<String> _methodNames = new Stack();
    private PropertyRequestItem.PropertyRequest _lastPropertyRequest = null;
    private Map<PropertyNameList.PropertyName<?>, PropValue> _lastUpdates = null;
    private long _startTime = 0L;
    private long _writeDuration;
    private long _readDuration;
    private static Map<String, Integer> _propStats;

    static {
        _stats = new HashMap<String, callInfo>();
        _loggingActive = false;
        _propStats = new HashMap<String, Integer>();
    }

    protected SrvcProvider() {
    }

    public void initialize(Map<String, String> initArgs, ProviderFactory.Callback callback) throws WvcmException {
        if (initArgs != null) {
            if (this._initArgs == null) {
                this._initArgs = initArgs;
            } else {
                this._initArgs.putAll(initArgs);
            }
        }
        if (this._initArgs == null) {
            this._initArgs = new Hashtable<String, String>();
        }
        this._callback = callback;
    }

    protected SrvcProvider(ProviderFactory.Callback callback) {
        if (callback != null) {
            this._callback = callback;
            this._initArgs = new Hashtable<String, String>();
        }
    }

    protected SrvcProvider(ProviderFactory.Callback callback, Map<String, String> args) {
        this._callback = callback;
        this._initArgs = args;
    }

    public String displayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public static void setLogger(ILogger logger) {
        _logger = logger;
    }

    public static Map<String, callInfo> getStatistics() {
        return _stats;
    }

    public static boolean activateLogging(boolean activate) {
        boolean oldState = _loggingActive;
        _loggingActive = activate;
        return oldState;
    }

    private static boolean durationLoggingEnabled() {
        return _stats != null && _loggingActive;
    }

    private void logWritePropertiesCompletion(long durationMillis) {
        if (SrvcProvider.durationLoggingEnabled()) {
            this._writeDuration += durationMillis;
        }
    }

    private void logReadPropertiesCompletion(long durationMillis) {
        if (SrvcProvider.durationLoggingEnabled()) {
            this._readDuration += durationMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logStart(String methodName, PropertyRequestItem.PropertyRequest pr, Map<PropertyNameList.PropertyName<?>, PropValue> updates) {
        SrvcProvider srvcProvider = this;
        synchronized (srvcProvider) {
            if (methodName == null) {
                throw new IllegalArgumentException("methodName must not be null");
            }
            if (this._methodNames.empty()) {
                this._lastPropertyRequest = pr;
                this._lastUpdates = updates;
                this._startTime = System.currentTimeMillis();
                this._writeDuration = 0L;
                this._readDuration = 0L;
                if (_logger != null) {
                    _logger.starting(this.displayName(), methodName, updates, pr);
                }
            }
            this._methodNames.push(methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logCompletion(ResourceImpl resource, SrvcFeedback feedback) {
        SrvcProvider srvcProvider = this;
        synchronized (srvcProvider) {
            String methodName = this._methodNames.pop();
            if (this._methodNames.empty()) {
                long minDuration;
                String providerName = this.displayName();
                long duration = System.currentTimeMillis() - this._startTime;
                String minDurationVal = this._initArgs.get(IA_WVCM_LOG_MINIMUM_DURATION);
                if (minDurationVal != null && duration >= (minDuration = (long)Integer.parseInt(minDurationVal))) {
                    String msg = String.valueOf(providerName) + DOT + methodName + ": " + duration;
                    try {
                        feedback.notifyNestedActive(msg);
                    }
                    catch (WvcmException wvcmException) {}
                }
                if (SrvcProvider.durationLoggingEnabled()) {
                    String key;
                    callInfo current;
                    String updatesString = EMPTY;
                    if (this._lastUpdates != null && this._lastUpdates.size() > 0) {
                        updatesString = this._lastUpdates.keySet().toString();
                    }
                    String prString = EMPTY;
                    if (this._lastPropertyRequest != null) {
                        prString = " return:" + this._lastPropertyRequest.toString();
                    }
                    if ((current = _stats.get(key = String.valueOf(providerName) + DOT + resource.getClass().getSimpleName() + DOT + methodName + updatesString + prString)) == null) {
                        current = new callInfo();
                        _stats.put(key, current);
                    }
                    current.addCall(duration, this._writeDuration, this._readDuration);
                }
                if (_logger != null) {
                    _logger.completed(duration);
                }
            }
        }
    }

    public static Map<String, Integer> getPropStats() {
        return _propStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logProperty(String className, String propName) {
        if (SrvcProvider.durationLoggingEnabled()) {
            SrvcProvider srvcProvider = this;
            synchronized (srvcProvider) {
                String key = String.valueOf(this.displayName()) + DOT + className + DOT + propName;
                Integer current = _propStats.get(key);
                if (current == null) {
                    current = 0;
                }
                _propStats.put(key, current + 1);
            }
        }
    }

    public SrvcLocation internalLocation(String string) {
        try {
            return this.location(string);
        }
        catch (WvcmException e) {
            throw new RuntimeException("bad location", e);
        }
    }

    protected void writeUpdates(SrvcResource srvcResource, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback sfb) throws WvcmException {
        long durationMillis;
        boolean logThis;
        if (updates.size() == 0) {
            return;
        }
        boolean bl = logThis = _logger != null && updates.size() > 0;
        if (logThis) {
            _logger.starting(EMPTY, "writeProperties", updates, null);
        }
        long writeStartTime = SrvcProvider.durationLoggingEnabled() ? System.currentTimeMillis() : 0L;
        try {
            srvcResource.doWriteProperties(updates, updated, sfb);
        }
        catch (Throwable throwable) {
            long durationMillis2;
            long l = durationMillis2 = SrvcProvider.durationLoggingEnabled() ? System.currentTimeMillis() - writeStartTime : 0L;
            if (logThis) {
                _logger.completed(durationMillis2);
            }
            this.logWritePropertiesCompletion(durationMillis2);
            throw throwable;
        }
        long l = durationMillis = SrvcProvider.durationLoggingEnabled() ? System.currentTimeMillis() - writeStartTime : 0L;
        if (logThis) {
            _logger.completed(durationMillis);
        }
        this.logWritePropertiesCompletion(durationMillis);
    }

    public Resource createContextProxy(SrvcResource srvcResource, Location location, SrvcResource context, SrvcFeedback sfb) throws WvcmException {
        boolean logThis;
        Resource result = sfb.lookupResourceCache(location);
        if (result != null) {
            return result;
        }
        PropertyRequestItem.PropertyRequest propertyRequest = sfb.getPropertyRequestForResult();
        boolean bl = logThis = _logger != null && propertyRequest != null;
        if (logThis) {
            _logger.starting(EMPTY, "readProperties", null, propertyRequest);
        }
        long readStartTime = SrvcProvider.durationLoggingEnabled() ? System.currentTimeMillis() : 0L;
        try {
            result = srvcResource.buildProxy(location, propertyRequest, context, sfb);
        }
        catch (Throwable throwable) {
            long durationMillis = SrvcProvider.durationLoggingEnabled() ? System.currentTimeMillis() - readStartTime : 0L;
            this.logReadPropertiesCompletion(durationMillis);
            if (logThis) {
                _logger.completed(durationMillis);
            }
            throw throwable;
        }
        long durationMillis = SrvcProvider.durationLoggingEnabled() ? System.currentTimeMillis() - readStartTime : 0L;
        this.logReadPropertiesCompletion(durationMillis);
        if (logThis) {
            _logger.completed(durationMillis);
        }
        ResourceImpl.validateProxy(result, propertyRequest);
        return result;
    }

    public Resource createProxy(SrvcResource srvcResource, Location location, SrvcFeedback sfb) throws WvcmException {
        boolean logThis;
        Resource result = sfb.lookupResourceCache(location);
        if (result != null) {
            return result;
        }
        PropertyRequestItem.PropertyRequest propertyRequest = sfb.getPropertyRequestForResult();
        boolean bl = logThis = _logger != null && propertyRequest != null;
        if (logThis) {
            _logger.starting(EMPTY, "readProperties", null, propertyRequest);
        }
        long readStartTime = SrvcProvider.durationLoggingEnabled() ? System.currentTimeMillis() : 0L;
        try {
            result = srvcResource.buildProxy(location, propertyRequest, srvcResource, sfb);
        }
        catch (Throwable throwable) {
            long durationMillis = SrvcProvider.durationLoggingEnabled() ? System.currentTimeMillis() - readStartTime : 0L;
            this.logReadPropertiesCompletion(durationMillis);
            if (logThis) {
                _logger.completed(durationMillis);
            }
            throw throwable;
        }
        long durationMillis = SrvcProvider.durationLoggingEnabled() ? System.currentTimeMillis() - readStartTime : 0L;
        this.logReadPropertiesCompletion(durationMillis);
        if (logThis) {
            _logger.completed(durationMillis);
        }
        ResourceImpl.validateProxy(result, propertyRequest);
        return result;
    }

    public <T extends Resource> T buildProxy(Class<T> type, Location loc) throws WvcmException {
        if (Workspace.class.isAssignableFrom(type)) {
            return (T)new WorkspaceImpl(loc, (Provider)this);
        }
        if (ControllableSymbolicLink.class.isAssignableFrom(type)) {
            return (T)new ControllableSymbolicLinkImpl(loc, (Provider)this);
        }
        if (ControllableFolder.class.isAssignableFrom(type)) {
            return (T)new ControllableFolderImpl(loc, (Provider)this);
        }
        if (Configuration.class.isAssignableFrom(type)) {
            return (T)new ConfigurationImpl(loc, (Provider)this);
        }
        if (ControllableResource.class.isAssignableFrom(type)) {
            return (T)new ControllableResourceImpl(loc, (Provider)this);
        }
        if (Component.class.isAssignableFrom(type)) {
            return (T)new ComponentImpl(loc, (Provider)this);
        }
        if (VersionHistory.class.isAssignableFrom(type)) {
            return (T)new VersionHistoryImpl(loc, (Provider)this);
        }
        if (Folder.class.isAssignableFrom(type)) {
            return (T)new FolderImpl(loc, (Provider)this);
        }
        if (Stream.class.isAssignableFrom(type)) {
            return (T)new StreamImpl(loc, (Provider)this);
        }
        if (Activity.class.isAssignableFrom(type)) {
            return (T)new ActivityImpl(loc, (Provider)this);
        }
        if (Task.class.isAssignableFrom(type)) {
            return (T)new TaskImpl(loc, (Provider)this);
        }
        if (Baseline.class.isAssignableFrom(type)) {
            return (T)new BaselineImpl(loc, (Provider)this);
        }
        if (SymbolicLinkVersion.class.isAssignableFrom(type)) {
            return (T)new SymbolicLinkVersionImpl(loc, (Provider)this);
        }
        if (FolderVersion.class.isAssignableFrom(type)) {
            return (T)new FolderVersionImpl(loc, (Provider)this);
        }
        if (Version.class.isAssignableFrom(type)) {
            return (T)new VersionImpl(loc, (Provider)this);
        }
        return (T)new ResourceImpl(loc, (Provider)this);
    }

    public Resource buildProxy(Location location, PropertyRequestItem.PropertyRequest propertyRequest, SrvcFeedback feedback) throws WvcmException {
        SrvcResource resource = this.lookup(location, feedback);
        if (resource == null) {
            String msg = feedback.format(Messages.getString("SrvcProvider.ERR_NO_RESOURCE_FOUND"), location);
            throw new WvcmException(msg, WvcmException.ReasonCode.NOT_FOUND);
        }
        ResourceImpl proxy = resource.buildProxy(location);
        resource.readProperties(proxy, resource, propertyRequest, feedback);
        return proxy;
    }

    public Component component(Location loc) {
        ComponentImpl proxy = new ComponentImpl(loc, (Provider)this);
        return proxy;
    }

    public Stream stream(Location loc) {
        StreamImpl proxy = new StreamImpl(loc, (Provider)this);
        return proxy;
    }

    public Task task(Location loc) {
        TaskImpl proxy = new TaskImpl(loc, (Provider)this);
        return proxy;
    }

    public Activity activity(Location loc) {
        ActivityImpl proxy = new ActivityImpl(loc, (Provider)this);
        return proxy;
    }

    public Baseline baseline(Location loc) {
        BaselineImpl proxy = new BaselineImpl(loc, (Provider)this);
        return proxy;
    }

    public Configuration configuration(Location loc) {
        ConfigurationImpl proxy = new ConfigurationImpl(loc, (Provider)this);
        return proxy;
    }

    public ControllableFolder controllableFolder(Location loc) {
        ControllableFolderImpl proxy = new ControllableFolderImpl(loc, (Provider)this);
        return proxy;
    }

    public ControllableResource controllableResource(Location loc) {
        ControllableResourceImpl proxy = new ControllableResourceImpl(loc, (Provider)this);
        return proxy;
    }

    public ControllableSymbolicLink controllableSymbolicLink(Location loc) {
        ControllableSymbolicLinkImpl proxy = new ControllableSymbolicLinkImpl(loc, (Provider)this);
        return proxy;
    }

    public Folder folder(Location loc) {
        FolderImpl proxy = new FolderImpl(loc, (Provider)this);
        return proxy;
    }

    public FolderVersion folderVersion(Location loc) {
        FolderVersionImpl proxy = new FolderVersionImpl(loc, (Provider)this);
        return proxy;
    }

    public Resource resource(Location loc) {
        ResourceImpl proxy = new ResourceImpl(loc, (Provider)this);
        return proxy;
    }

    public Version version(Location loc) {
        VersionImpl proxy = new VersionImpl(loc, (Provider)this);
        return proxy;
    }

    public VersionHistory versionHistory(Location loc) {
        VersionHistoryImpl proxy = new VersionHistoryImpl(loc, (Provider)this);
        return proxy;
    }

    public Workspace workspace(Location loc) {
        WorkspaceImpl proxy = new WorkspaceImpl(loc, (Provider)this);
        return proxy;
    }

    public <T extends Resource> ResourceList<T> resourceList(T ... initialContent) {
        ResourceListImpl result = new ResourceListImpl(this);
        T[] TArray = initialContent;
        int n = initialContent.length;
        int n2 = 0;
        while (n2 < n) {
            T resource = TArray[n2];
            result.add(resource);
            ++n2;
        }
        return result;
    }

    public ProviderFactory.Callback callback() {
        return this._callback;
    }

    public Map<String, String> initArgs() {
        return this._initArgs;
    }

    public SrvcResource getSrvcRes(Location loc, SrvcFeedback feedback) throws WvcmException {
        SrvcResource resource = this.lookup(loc, feedback);
        if (resource == null) {
            throw new WvcmException(String.valueOf(Messages.getString("SrvcProvider.ERR_DOES_NOT_EXIST")) + loc.string(), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return resource;
    }

    public List<Object> doFind(ResourceList<?> queries, SrvcFeedback feedback) throws WvcmException {
        int size = queries.size();
        int count = 0;
        ArrayList<Object> results = new ArrayList<Object>(queries.size());
        for (Resource query : queries) {
            ++count;
            try {
                SrvcResource srvcResource = this.doFind(query, feedback.nest(100 * count / size));
                results.add(srvcResource);
            }
            catch (WvcmException e) {
                results.add((Object)e);
            }
        }
        return results;
    }

    public SrvcFeedback srvcFeedback(Feedback fb) throws WvcmException {
        if (fb != null && fb.isAbortRequested()) {
            fb.abortRequested(false);
            throw new WvcmException("Aborted", WvcmException.ReasonCode.ABORTED);
        }
        return new SrvcFeedback(fb);
    }

    public void validate(Feedback feedback) throws WvcmException {
        this.validate(this.srvcFeedback(feedback));
    }

    public void validate(SrvcFeedback feedback) throws WvcmException {
        feedback.notifyPercentComplete(100);
        feedback.notifyActive(Messages.getString("INFO_NO_VALIDATIONS"));
    }

    public List<Object> doUpdateContextProperties(List<Location> locations, Location contextLocation, List<Map<PropertyNameList.PropertyName<?>, PropValue>> updatesList, List<List<PropertyNameList.PropertyName<?>>> updatedList, SrvcFeedback feedback) throws WvcmException {
        int size = locations.size();
        ArrayList<Object> results = new ArrayList<Object>(locations.size());
        int i = 0;
        while (i < locations.size()) {
            block6: {
                Location location = locations.get(i);
                Map<PropertyNameList.PropertyName<?>, PropValue> updates = updatesList.get(i);
                ArrayList updated = new ArrayList();
                try {
                    try {
                        SrvcResource srvcResource = this.getSrvcRes(location, feedback.nest(20 * (i + 1) / size));
                        this.writeUpdates(srvcResource, updates, updated, feedback.nest(40 * (i + 1) / size));
                        results.add(srvcResource);
                    }
                    catch (WvcmException e) {
                        results.add((Object)e);
                        updatedList.add(updated);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    updatedList.add(updated);
                    throw throwable;
                }
                updatedList.add(updated);
            }
            ++i;
        }
        return results;
    }

    public SrvcResource doWriteContent(Location location, InputStream content, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource result = this.doWriteContent(location, content, contentIdentifier, feedback);
        this.writeUpdates(result, updates, updated, feedback);
        return result;
    }

    public SrvcResource doCreateControllableResource(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource result = this.doCreateControllableResource(location, feedback);
        this.writeUpdates(result, updates, updated, feedback);
        return result;
    }

    public SrvcResource doCreateVersionControlledResource(Location location, Location versionLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource result = this.doCreateVersionControlledResource(location, versionLoc, feedback);
        this.writeUpdates(result, updates, updated, feedback);
        return result;
    }

    public SrvcResource doCreateControllableSymbolicLink(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource result = this.doCreateControllableSymbolicLink(location, feedback);
        this.writeUpdates(result, updates, updated, feedback);
        return result;
    }

    public SrvcResource doCreateControllableFolder(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource result = this.doCreateControllableFolder(location, feedback);
        this.writeUpdates(result, updates, updated, feedback);
        return result;
    }

    public SrvcResource doCreateWorkspace(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource result = this.doCreateWorkspace(location, feedback);
        this.writeUpdates(result, updates, updated, feedback);
        return result;
    }

    public SrvcResource doCreateGeneratedWorkspace(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource result = this.doCreateGeneratedWorkspace(location, feedback);
        this.writeUpdates(result, updates, updated, feedback);
        return result;
    }

    public SrvcResource doCreateActivity(Location location, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource result = this.doCreateActivity(location, isStream, feedback);
        this.writeUpdates(result, updates, updated, feedback);
        return result;
    }

    public SrvcResource doCreateGeneratedActivity(Location location, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource result = this.doCreateGeneratedActivity(location, isStream, feedback);
        this.writeUpdates(result, updates, updated, feedback);
        return result;
    }

    public SrvcResource doCreateGeneratedTask(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource result = this.doCreateGeneratedTask(location, feedback);
        this.writeUpdates(result, updates, updated, feedback);
        return result;
    }

    public SrvcResource doBaselineControl(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource result = this.doBaselineControl(location, feedback);
        this.writeUpdates(result, updates, updated, feedback);
        return result;
    }

    public SrvcResource doCreateBaselineControlledFolder(Location location, Location baselineLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource result = this.doCreateBaselineControlledFolder(location, baselineLoc, feedback);
        this.writeUpdates(result, updates, updated, feedback);
        return result;
    }

    public SrvcResource doWriteContent(Location location, InputStream content, String contentIdentifier, SrvcFeedback sfb) throws WvcmException {
        throw new WvcmException("doWriteContent", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateControllableResource(Location location, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateControllableResource not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateVersionControlledResource(Location location, Location versionLoc, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateVersionControlledResource not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateControllableSymbolicLink(Location location, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateControllableSymbolicLink not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateControllableFolder(Location location, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateControllableFolder not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateWorkspace(Location location, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateWorkspace not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateGeneratedWorkspace(Location location, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateGeneratedWorkspace not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateActivity(Location location, boolean isStream, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateActivity not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateGeneratedActivity(Location location, boolean isStream, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateGeneratedActivity not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateGeneratedTask(Location location, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateGeneratedTask not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doBaselineControl(Location location, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doBaselineControl not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateBaselineControlledFolder(Location location, Location baselineLoc, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateBaselineControlledFolder not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doFind(Resource query, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doFind not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public List<SrvcResource> doFindAll(Resource query, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doFindAll not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public abstract SrvcResource lookup(Location var1, SrvcFeedback var2) throws WvcmException;

    public abstract SrvcLocation rootLocation();

    public abstract SrvcLocation relativeRootLocation();

    public abstract SrvcLocation location(String var1) throws WvcmException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ILogger {
        public void starting(String var1, String var2, Map<PropertyNameList.PropertyName<?>, PropValue> var3, PropertyRequestItem.PropertyRequest var4);

        public void completed(long var1);
    }

    public class callInfo {
        private long _totalCalls = 0L;
        private long _totalDuration = 0L;
        private long _writePropertiesDuration = 0L;
        private long _readPropertiesDuration = 0L;

        public void addCall(long totalDuration, long writeDuration, long readDuration) {
            ++this._totalCalls;
            this._totalDuration += totalDuration;
            this._writePropertiesDuration += writeDuration;
            this._readPropertiesDuration += readDuration;
        }

        public long getTotalDuration() {
            return this._totalDuration;
        }

        public long getTotalCalls() {
            return this._totalCalls;
        }

        public long getWritePropsDuration() {
            return this._writePropertiesDuration;
        }

        public long getReadPropsDuration() {
            return this._readPropertiesDuration;
        }
    }
}

