/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.repo;

import com.ibm.rational.wvcm.ri.impl.ControllableResourceImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.VersionImpl;
import com.ibm.rational.wvcm.ri.impl.WorkspaceImpl;
import com.ibm.rational.wvcm.ri.repo.RiRepo;
import com.ibm.rational.wvcm.ri.repo.RiRepoActivity;
import com.ibm.rational.wvcm.ri.repo.RiRepoBaseline;
import com.ibm.rational.wvcm.ri.repo.RiRepoComponent;
import com.ibm.rational.wvcm.ri.repo.RiRepoConfiguration;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoIFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoStream;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersionHistory;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wvcm.Activity;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Version;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiRepoWorkspace
extends RiRepoControllableFolder {
    public Map<RiRepoVersionHistory, RiRepoVersion> deleted = new HashMap<RiRepoVersionHistory, RiRepoVersion>();

    @Override
    public Class<?> get_proxyClass() {
        return WorkspaceImpl.class;
    }

    protected RiRepoWorkspace(RiRepoResource parent, String bindingName, SrvcProvider provider, RiRepo repo) {
        super(parent, bindingName, provider, repo);
        this.initialize();
    }

    private void initialize() {
        this.createProperty(Workspace.ACTIVITY_FOLDER_LIST, this.get_repo().getActivityFolderList());
        this.createProperty(Workspace.BASELINE_CONTROLLED_FOLDER_LIST, null);
        this.createProperty(Workspace.CURRENT_ACTIVITY, null);
        this.createProperty(Workspace.CONFIGURATION_ROOT_FOLDER_HOME, null);
        this.createProperty(Workspace.CONTROLLABLE_RESOURCE_HOME, null);
        this.createProperty(Workspace.VERSION_HISTORY_FOLDER_LIST, this._repo.getVersionHistoryFolderList());
        this.createProperty(Workspace.WORKSPACE_CHECKOUT_LIST, new ArrayList());
        this.createProperty(Workspace.STREAM, null);
        this.createProperty(Workspace.TARGET, null);
        this.createProperty(Workspace.ISOLATED_TARGET, null);
        this.createProperty(Workspace.SOURCE_LIST, new ArrayList());
    }

    @Override
    protected void destroy() {
        this.setPropertyEx(Workspace.CURRENT_ACTIVITY, null);
        super.destroy();
    }

    @Override
    protected void checkWhetherPropertyCanBeSet(PropertyNameList.PropertyName<?> propertyName, Object value) throws WvcmException {
        super.checkWhetherPropertyCanBeSet(propertyName, value);
        if (propertyName.getNamespace() == null && (propertyName.equals((Object)Workspace.TARGET) || propertyName.equals((Object)Workspace.TARGET)) && !this.is_creationInProgress()) {
            throw new WvcmException("TARGET and ISOLATED_TARGET can only be set before the workspace is created.", WvcmException.ReasonCode.CONFLICT);
        }
    }

    @Override
    protected void postSetPropertyEx(PropertyNameList.PropertyName<?> propertyName, Object oldValue, Object value) {
        super.postSetPropertyEx(propertyName, oldValue, value);
        if (propertyName.equals((Object)Workspace.CURRENT_ACTIVITY)) {
            RiRepoActivity oldActivity = (RiRepoActivity)oldValue;
            RiRepoActivity newActivity = (RiRepoActivity)value;
            if (oldActivity != null) {
                oldActivity.setProperty_RemoveFromList(Activity.CURRENT_WORKSPACE_LIST, this);
            }
            if (newActivity != null) {
                newActivity.setProperty_AppendUniqueToList(Activity.CURRENT_WORKSPACE_LIST, this);
            }
        }
    }

    public RiRepoControllableResource locateByHistoryReport(RiRepoVersionHistory vh) throws WvcmException {
        RiRepoControllableResource result = null;
        result = vh instanceof RiRepoComponent ? this.locateConfigurationByHistoryReport(vh) : this.recursivelyLocateByHistoryReport(vh);
        return result;
    }

    private RiRepoConfiguration locateConfigurationByHistoryReport(RiRepoVersionHistory versionHistory) {
        List<RiRepoControllableFolder> blControlledFolderList = this.getBaselineControlledFolderList();
        int i = 0;
        while (i < blControlledFolderList.size()) {
            RiRepoControllableFolder cf = blControlledFolderList.get(i);
            RiRepoConfiguration config = cf.getRootFolderOf();
            RiRepoVersionHistory vh = config.getVersionHistory();
            if (vh == versionHistory) {
                return config;
            }
            ++i;
        }
        return null;
    }

    protected List<RiRepoControllableFolder> calculateBaselineControlledFolderList() {
        ArrayList<RiRepoControllableFolder> list = new ArrayList<RiRepoControllableFolder>();
        this.recursivelyCalculateBaselineControlledFolderList(list);
        return list;
    }

    private List<RiRepoVersion> identifySourceVersionsForMerge(List<?> sourceList, boolean checkinActivity, boolean forkOK, boolean checkinIdentical) throws WvcmException {
        ArrayList<RiRepoVersion> sourceVersions = new ArrayList<RiRepoVersion>();
        int i = 0;
        while (i < sourceList.size()) {
            RiRepoControllableResource cr;
            RiRepoResource origSource = (RiRepoResource)sourceList.get(i);
            if (origSource instanceof RiRepoVersion) {
                sourceVersions.add((RiRepoVersion)origSource);
            } else if (origSource instanceof RiRepoStream) {
                RiRepoStream stream = (RiRepoStream)origSource;
                List<RiRepoVersion> versionList = stream.getVersionList();
                sourceVersions.addAll(versionList);
            } else if (origSource instanceof RiRepoActivity) {
                RiRepoActivity sourceActivity = (RiRepoActivity)origSource;
                List<RiRepoVersion> activityVersionList = sourceActivity.getActivityVersionList();
                sourceVersions.addAll(activityVersionList);
            } else if (origSource instanceof RiRepoControllableFolder) {
                cr = (RiRepoControllableResource)origSource;
                cr.checkCannotMergeCheckedOutResource();
                cr.addAllCheckedInVersions(sourceVersions);
            } else if (origSource instanceof RiRepoControllableResource) {
                cr = (RiRepoControllableResource)origSource;
                cr.checkCannotMergeCheckedOutResource();
                RiRepoVersion checkedInVersion = (RiRepoVersion)cr.getProperty(ControllableResource.CHECKED_IN);
                if (checkedInVersion != null) {
                    sourceVersions.add(checkedInVersion);
                }
            } else {
                throw new WvcmException("Bad source argument to doMerge", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            ++i;
        }
        return sourceVersions;
    }

    @Override
    protected boolean handleCalculatedProperties(PropertyNameList.PropertyName<?> propertyName, Object[] calculatedValue) {
        if (propertyName.equals((Object)Workspace.BASELINE_CONTROLLED_FOLDER_LIST)) {
            calculatedValue[0] = this.calculateBaselineControlledFolderList();
            return true;
        }
        if (propertyName.equals((Object)Workspace.CONFIGURATION_ROOT_FOLDER_HOME)) {
            calculatedValue[0] = this;
            return true;
        }
        if (propertyName.equals((Object)Workspace.CONTROLLABLE_RESOURCE_HOME)) {
            List<RiRepoControllableFolder> bcf = this.getBaselineControlledFolderList();
            calculatedValue[0] = bcf.size() > 0 ? bcf.get(0) : this;
            return true;
        }
        return super.handleCalculatedProperties(propertyName, calculatedValue);
    }

    protected static List<RiRepoVersion> identifySourceVersions(List<?> sourceList, boolean forStream) throws WvcmException {
        ArrayList<RiRepoVersion> sourceVersions = new ArrayList<RiRepoVersion>();
        int i = 0;
        while (i < sourceList.size()) {
            RiRepoControllableResource cr;
            RiRepoResource origSource = (RiRepoResource)sourceList.get(i);
            if (origSource instanceof RiRepoVersion) {
                sourceVersions.add((RiRepoVersion)origSource);
            } else if (origSource instanceof RiRepoStream) {
                RiRepoStream stream = (RiRepoStream)origSource;
                sourceVersions.addAll(stream.getVersionList());
            } else if (origSource instanceof RiRepoActivity) {
                RiRepoActivity sourceActivity = (RiRepoActivity)origSource;
                sourceVersions.addAll(sourceActivity.getActivityVersionList());
            } else if (origSource instanceof RiRepoControllableFolder) {
                cr = (RiRepoControllableResource)origSource;
                cr.checkCannotMergeCheckedOutResource();
                cr.addAllCheckedInVersions(sourceVersions);
            } else if (origSource instanceof RiRepoControllableResource) {
                cr = (RiRepoControllableResource)origSource;
                RiRepoVersion checkedInVersion = (RiRepoVersion)cr.getProperty(ControllableResource.CHECKED_IN);
                if (checkedInVersion != null) {
                    sourceVersions.add(checkedInVersion);
                }
            } else {
                throw new WvcmException("BAD_ARGUMENT_TYPE", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            ++i;
        }
        return sourceVersions;
    }

    public void mergePreviewReport(RiRepoVersion sourceVersion, PropertyRequestItem.PropertyRequest propertyRequest, List<Object> results, SrvcFeedback feedback) throws WvcmException {
        RiRepoVersionHistory sourceVH = sourceVersion.getVersionHistory();
        RiRepoControllableResource target = this.locateByHistoryReport(sourceVH);
        if (target == null) {
            return;
        }
        RiRepoVersion targetVersion = target.getCheckedIn();
        if (targetVersion == null) {
            targetVersion = target.getCheckedOut();
        }
        if (sourceVersion != targetVersion && !sourceVersion.isAncestorOf(targetVersion) && !targetVersion.isAncestorOf(sourceVersion)) {
            RiRepoBaseline bl;
            ArrayList<RiRepoVersion> versions = new ArrayList<RiRepoVersion>();
            versions.add(sourceVersion);
            List<RiRepoVersion> toBeMerged = target.getMergeList();
            versions.addAll(toBeMerged);
            toBeMerged = target.getAutoMergeList();
            versions.addAll(toBeMerged);
            RiRepoVersion ancestor = target.getCommonAncestor(versions, targetVersion);
            ControllableResourceImpl riTarget = (ControllableResourceImpl)target.buildProxy(propertyRequest, feedback);
            VersionImpl riAncestor = (VersionImpl)ancestor.buildProxy(propertyRequest, feedback);
            ResourceList riVersions = this.provider().resourceList((Resource[])new Version[0]);
            int i = 0;
            while (i < versions.size()) {
                RiRepoVersion repoVersion = (RiRepoVersion)versions.get(i);
                riVersions.add((Object)((Version)repoVersion.buildProxy(propertyRequest, feedback)));
                ++i;
            }
            WorkspaceImpl.MergePreviewReportImpl result = new WorkspaceImpl.MergePreviewReportImpl(riTarget, riAncestor, (ResourceList<Version>)riVersions);
            results.add(result);
            if (sourceVersion instanceof RiRepoBaseline && !(bl = (RiRepoBaseline)targetVersion).isAncestorOf(sourceVersion) && !sourceVersion.isAncestorOf(bl)) {
                Iterator<RiRepoVersion> blVersions = bl.getVersionList().iterator();
                while (blVersions.hasNext()) {
                    this.mergePreviewReport(blVersions.next(), propertyRequest, results, feedback);
                }
            }
        }
    }

    public static RiRepoControllableResource doCreateResource(SrvcProvider provider, Location loc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        RiRepo repo = RiRepo.get_Repo(loc, provider);
        RiRepoWorkspace.performCreationPreconditionChecks(loc, provider);
        RiRepoResource parent = RiRepoWorkspace.getParentResource(provider, loc);
        if (parent != repo.getWorkspaceFolder()) {
            throw new WvcmException("Workspaces can only be created in the workspace folders: " + loc, WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
        }
        RiRepoWorkspace workspace = (RiRepoWorkspace)RiRepoWorkspace.createVersionControlledResource(provider, loc, repo.getWorkspaceInitialVersion(), false, updates, updated, feedback);
        if (updates != null) {
            workspace.set_creationInProgress(true);
            workspace.doWriteProperties(updates, updated, feedback);
            workspace.set_creationInProgress(false);
        }
        return workspace;
    }

    public static RiRepoWorkspace doCreateGeneratedWorkspace(SrvcProvider provider, Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        RiRepo repo = RiRepo.get_Repo(location, provider);
        RiRepoControllableFolder parent = repo.getWorkspaceFolder();
        Location workspaceLoc = location;
        String bindingName = workspaceLoc.lastSegment();
        if (bindingName == null) {
            bindingName = "ws";
        }
        workspaceLoc = repo.getWorkspaceFolderLocation().child(bindingName);
        RiRepoWorkspace existingWorkspace = (RiRepoWorkspace)parent.lookupBoundMember(bindingName);
        if (existingWorkspace != null) {
            workspaceLoc = repo.createUniqueGeneratedLocation(provider, workspaceLoc);
        }
        RiRepoWorkspace newWorkspace = (RiRepoWorkspace)RiRepoWorkspace.createVersionControlledResource(provider, workspaceLoc, repo.getWorkspaceInitialVersion(), false, updates, updated, feedback);
        return newWorkspace;
    }

    @Override
    public <T extends SrvcResource> void doCheckin(List<T> resourceList, String comment, ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        ArrayList<WvcmException> exceptions = new ArrayList<WvcmException>();
        int i = 0;
        while (i < resourceList.size()) {
            RiRepoResource repoResource = (RiRepoResource)resourceList.get(i);
            if (repoResource instanceof RiRepoActivity) {
                RiRepoActivity act = (RiRepoActivity)repoResource;
                List<RiRepoControllableResource> activityCheckoutList = act.getActivityCheckoutList();
                int j = 0;
                while (j < activityCheckoutList.size()) {
                    String oldComment;
                    RiRepoControllableResource cr = activityCheckoutList.get(j);
                    if (comment != null && (oldComment = (String)cr.getProperty(Resource.COMMENT)) == null) {
                        cr.setProperty(Resource.COMMENT, comment);
                    }
                    try {
                        cr.doCheckin(flags, feedback);
                    }
                    catch (WvcmException ex) {
                        exceptions.add(ex);
                    }
                    ++j;
                }
            } else {
                String oldComment;
                RiRepoControllableResource cr = (RiRepoControllableResource)resourceList.get(i);
                if (comment != null && (oldComment = (String)cr.getProperty(Resource.COMMENT)) == null) {
                    cr.setProperty(Resource.COMMENT, comment);
                }
                try {
                    cr.doCheckin(flags, feedback);
                }
                catch (WvcmException ex) {
                    exceptions.add(ex);
                }
            }
            ++i;
        }
        if (exceptions.size() > 0) {
            throw new WvcmException("Some checkouts failed.", null, WvcmException.ReasonCode.MULTI_STATUS, (Throwable)exceptions.get(0), (Throwable[])RiRepoWorkspace.convertListToExceptionArray(exceptions));
        }
    }

    @Override
    public void doCheckinAll(String comment, ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        ArrayList<WvcmException> exceptions = new ArrayList<WvcmException>();
        List<RiRepoControllableResource> checkoutList = this.getWorkspaceCheckoutList();
        ArrayList<RiRepoControllableResource> rl = new ArrayList<RiRepoControllableResource>(checkoutList.size());
        rl.addAll(checkoutList);
        int i = 0;
        while (i < rl.size()) {
            try {
                RiRepoControllableResource cr = (RiRepoControllableResource)rl.get(i);
                cr.doCheckin(flags, feedback);
            }
            catch (WvcmException e) {
                exceptions.add(e);
            }
            ++i;
        }
        if (exceptions.size() > 0) {
            throw new WvcmException("Some checkins failed.", null, WvcmException.ReasonCode.MULTI_STATUS, (Throwable)exceptions.get(0), (Throwable[])RiRepoWorkspace.convertListToExceptionArray(exceptions));
        }
    }

    @Override
    public <T extends SrvcResource> List<Object> doMergePreviewReport(List<T> sourceList, PropertyRequestItem.PropertyRequest propertyRequest, SrvcFeedback feedback) throws WvcmException {
        ArrayList<Object> results = new ArrayList<Object>();
        List<RiRepoVersion> sourceVersions = RiRepoWorkspace.identifySourceVersions(sourceList, false);
        int i = 0;
        while (i < sourceVersions.size()) {
            RiRepoVersion sourceVersion = sourceVersions.get(i);
            this.mergePreviewReport(sourceVersion, propertyRequest, results, feedback);
            ++i;
        }
        return results;
    }

    @Override
    public <T extends SrvcResource> void doMerge(List<T> sourceList, Workspace.MergeFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        boolean checkinActivity = false;
        boolean noAutoMerge = false;
        boolean noCheckout = false;
        boolean forkOK = false;
        boolean reserved = false;
        boolean checkinIdentical = false;
        boolean updateStream = false;
        if (flags != null) {
            int i = 0;
            while (i < flags.length) {
                if (flags[i] == Workspace.MergeFlag.NO_AUTO_MERGE) {
                    noAutoMerge = true;
                } else if (flags[i] == Workspace.MergeFlag.NO_CHECKOUT) {
                    noCheckout = true;
                } else if (flags[i] == Workspace.MergeFlag.FORK_OK) {
                    forkOK = true;
                } else if (flags[i] == Workspace.MergeFlag.RESERVED) {
                    reserved = true;
                } else if (flags[i] == Workspace.MergeFlag.CHECKIN_IDENTICAL) {
                    checkinIdentical = true;
                } else if (flags[i] == Workspace.MergeFlag.UPDATE_STREAM) {
                    updateStream = true;
                }
                ++i;
            }
        }
        if (this.versionKnowsParent()) {
            for (SrvcResource source : sourceList) {
                if (!(source instanceof RiRepoStream)) continue;
                RiRepoStream s = (RiRepoStream)source;
                for (RiRepoVersionHistory vh : s.deleted.keySet()) {
                    RiRepoVersion deletedV;
                    RiRepoControllableResource r = this.locateByHistoryReport(vh);
                    if (r == null) continue;
                    RiRepoVersion v = r.getCheckedIn();
                    if (v == (deletedV = s.deleted.get(vh)) || v.isAncestorOf(deletedV)) {
                        r.doUnbindAll(feedback);
                        continue;
                    }
                    deletedV.isAncestorOf(v);
                }
            }
        }
        List<RiRepoVersion> sourceVersions = this.identifySourceVersionsForMerge(sourceList, checkinActivity, forkOK, checkinIdentical);
        if (noCheckout) {
            int i = 0;
            while (i < sourceVersions.size()) {
                RiRepoVersion sourceVersion = sourceVersions.get(i);
                RiRepoControllableResource target = this.locateByHistoryReport(sourceVersion.getVersionHistory());
                if (target != null && !target.isNoCheckoutMerge(sourceVersion, noAutoMerge)) {
                    throw new WvcmException("Merge not allowed to checkout (workspace state unchanged)", WvcmException.ReasonCode.CANNOT_MERGE_CHECKOUT_NOT_ALLOWED);
                }
                ++i;
            }
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            ArrayList<RiRepoVersion> newSourceVersions = new ArrayList<RiRepoVersion>();
            int i = 0;
            while (i < sourceVersions.size()) {
                RiRepoVersion sourceVersion = sourceVersions.get(i);
                RiRepoControllableResource target = this.locateByHistoryReport(sourceVersion.getVersionHistory());
                if (target == null) {
                    this.processNullTarget(sourceVersion, newSourceVersions, feedback);
                } else {
                    changed = true;
                    target.doMergeWork(this, sourceVersion, noAutoMerge, noCheckout, forkOK, reserved, checkinIdentical, flags, feedback);
                }
                ++i;
            }
            sourceVersions = newSourceVersions;
        }
        for (SrvcResource r : sourceList) {
            if (!(r instanceof RiRepoStream)) continue;
            RiRepoStream stream = (RiRepoStream)r;
            List<RiRepoVersion> baselines = stream.getLatestVersionList();
            HashMap<RiRepoVersionHistory, RiRepoVersion> latestMap = new HashMap<RiRepoVersionHistory, RiRepoVersion>();
            for (RiRepoVersion v : baselines) {
                latestMap.put(v.getVersionHistory(), v);
            }
            List<RiRepoControllableFolder> bcfList = this.getBaselineControlledFolderList();
            for (RiRepoControllableFolder bcf : bcfList) {
                RiRepoVersion currentV;
                RiRepoConfiguration conf = bcf.getRootFolderOf();
                RiRepoVersion v = (RiRepoVersion)latestMap.get(conf.getVersionHistory());
                if (v == null || !(currentV = conf.getCheckedIn()).isAncestorOf(v)) continue;
                conf.setPropertyEx(ControllableResource.CHECKED_IN, v);
            }
        }
        if (updateStream) {
            ArrayList<RiRepoWorkspace> updateList = new ArrayList<RiRepoWorkspace>(1);
            updateList.add(this);
            for (SrvcResource source : sourceList) {
                if (!(source instanceof RiRepoStream)) continue;
                RiRepoStream stream = (RiRepoStream)source;
                stream.doUpdate(updateList, feedback);
            }
        }
    }

    @Override
    public <T extends SrvcResource> void doUpdate(List<T> sourceList, SrvcFeedback feedback) throws WvcmException {
        if (this.versionKnowsParent()) {
            for (SrvcResource source : sourceList) {
                if (!(source instanceof RiRepoStream)) continue;
                RiRepoStream streamSource = (RiRepoStream)source;
                ArrayList<RiRepoControllableResource> checkouts = new ArrayList<RiRepoControllableResource>();
                checkouts.addAll(this.getWorkspaceCheckoutList());
                for (RiRepoControllableResource cr : checkouts) {
                    cr.doUncheckout(feedback);
                }
                this.deleted.clear();
                this.deleted.putAll(streamSource.deleted);
                Map<String, RiRepoIFolder.RepoBinding> childBindings = this.getChildBindingsMap();
                for (RiRepoIFolder.RepoBinding binding : childBindings.values()) {
                    binding.unbind();
                }
            }
        }
        List<RiRepoVersion> sourceVersions = RiRepoWorkspace.identifySourceVersions(sourceList, false);
        boolean changed = true;
        while (changed) {
            changed = false;
            ArrayList<RiRepoVersion> newSourceVersions = new ArrayList<RiRepoVersion>();
            int i = 0;
            while (i < sourceVersions.size()) {
                RiRepoVersion sourceVersion = sourceVersions.get(i);
                RiRepoVersionHistory vh = sourceVersion.getVersionHistory();
                RiRepoControllableResource target = this.locateByHistoryReport(vh);
                if (target == null) {
                    this.processNullTarget(sourceVersion, newSourceVersions, feedback);
                } else {
                    target.update(sourceVersion, feedback);
                    changed = true;
                }
                ++i;
            }
            sourceVersions = newSourceVersions;
        }
    }

    private void processNullTarget(RiRepoVersion sourceVersion, List<RiRepoVersion> newSourceVersions, SrvcFeedback feedback) throws WvcmException {
        if (this.versionKnowsParent()) {
            RiRepoVersionHistory parentVH;
            RiRepoControllableFolder parent;
            RiRepoVersion deletedVersion = this.deleted.get(sourceVersion.getVersionHistory());
            if (deletedVersion != null && (deletedVersion == sourceVersion || sourceVersion.isAncestorOf(deletedVersion))) {
                return;
            }
            RiRepoVersion version = sourceVersion;
            if (version instanceof RiRepoBaseline) {
                RiRepoComponent comp = (RiRepoComponent)version.getVersionHistory();
                version = comp.getRootVersion();
            }
            if ((parent = (RiRepoControllableFolder)this.locateByHistoryReport(parentVH = version.getParentVersionHistory(feedback))) != null) {
                String bindingName = version.getBindingName(feedback);
                Map<String, RiRepoResource> childMap = parent.getChildMap();
                if (childMap.get(bindingName) != null) {
                    parent.doUnbindChild(bindingName, feedback);
                }
                RiRepoVersionHistory vh = version.getVersionHistory();
                if (version instanceof RiRepoBaseline) {
                    RiRepoBaseline baseline = (RiRepoBaseline)version;
                    RiRepoWorkspace.createBaselineControlledFolder(parent, bindingName, baseline, feedback);
                } else {
                    parent.updateAdded(parent.getWorkspace(), vh, version, bindingName, feedback);
                }
                return;
            }
        }
        newSourceVersions.add(sourceVersion);
    }

    public RiRepoActivity getCurrentActivity() {
        return (RiRepoActivity)this.getProperty(Workspace.CURRENT_ACTIVITY);
    }

    public List<RiRepoControllableResource> getWorkspaceCheckoutList() {
        return this.getListProperty(Workspace.WORKSPACE_CHECKOUT_LIST);
    }

    public List<RiRepoControllableFolder> getBaselineControlledFolderList() {
        return this.getListProperty(Workspace.BASELINE_CONTROLLED_FOLDER_LIST);
    }

    public RiRepoStream getStream() {
        return (RiRepoStream)this.getProperty(Workspace.STREAM);
    }
}

