/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.repo;

import com.ibm.rational.wvcm.ri.impl.VersionImpl;
import com.ibm.rational.wvcm.ri.repo.RiRepo;
import com.ibm.rational.wvcm.ri.repo.RiRepoActivity;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersionHistory;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.List;
import javax.wvcm.Activity;
import javax.wvcm.ControllableResource;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiRepoVersion
extends RiRepoResource {
    static final PropertyNameList.PropertyName<RiRepoVersionHistory> PARENT_VERSION_HISTORY = new PropertyNameList.PropertyName("com.ibm.team.interop", "PARENT_VERSION_HISTORY");
    static final PropertyNameList.PropertyName<String> BINDING_NAME = new PropertyNameList.PropertyName("com.ibm.team.interop", "BINDING_NAME");

    @Override
    public Class<?> get_proxyClass() {
        return VersionImpl.class;
    }

    protected RiRepoVersion(RiRepoResource parent, String bindingName, SrvcProvider provider, RiRepo repo) {
        super(parent, bindingName, provider, repo);
        this.initialize(bindingName);
    }

    private void initialize(String bindingName) {
        this.createProperty(Version.ACTIVITY, null);
        this.createProperty(Version.CHECKIN_FORK, Version.Fork.OK);
        this.createProperty(Version.CHECKOUT_FORK, Version.Fork.OK);
        this.createProperty(Version.CHECKOUT_LIST, new ArrayList());
        this.createProperty(Version.LABEL_NAME_LIST, new ArrayList());
        RiRepoVersionHistory versionHistory = (RiRepoVersionHistory)this.getParentResource();
        this.createProperty(Version.VERSION_HISTORY, versionHistory);
        this.createProperty(Version.VERSION_NAME, bindingName);
        RiRepoVersion rootVersion = versionHistory.getRootVersion();
        if (rootVersion == null) {
            versionHistory.setProperty(VersionHistory.ROOT_VERSION, this);
            rootVersion = this;
        }
        this.createProperty(Version.PREDECESSOR_LIST, new ArrayList());
        this.createProperty(Version.SUCCESSOR_LIST, new ArrayList());
        this.createProperty(Version.IN_WORKSPACE_LIST, new ArrayList());
        this.createProperty(Version.IN_BASELINE_LIST, new ArrayList());
        if (this.versionKnowsParent()) {
            this.createProperty(PARENT_VERSION_HISTORY, null);
            this.createProperty(BINDING_NAME, null);
        }
    }

    @Override
    protected void checkWhetherPropertyCanBeSet(PropertyNameList.PropertyName<?> name, Object value) throws WvcmException {
        super.checkWhetherPropertyCanBeSet(name, value);
        String ns = name.getNamespace();
        if (!(name.equals((Object)Version.CHECKIN_FORK) || name.equals((Object)Version.CHECKOUT_FORK) || name.equals((Object)Version.ACTIVITY))) {
            throw new WvcmException("Cannot set this property on version: " + name, WvcmException.ReasonCode.CANNOT_MODIFY_VERSION);
        }
        if (ns != null) {
            throw new WvcmException("Cannot set custom properties on a Version; versions are immutable.", WvcmException.ReasonCode.CANNOT_MODIFY_VERSION);
        }
        if (name.equals((Object)Version.ACTIVITY)) {
            this.checkWhetherActivityCanBeSet((RiRepoActivity)value);
        }
    }

    private void checkWhetherActivityCanBeSet(RiRepoActivity activity) throws WvcmException {
        if (activity == null) {
            return;
        }
        RiRepoVersionHistory thisVH = (RiRepoVersionHistory)this.getProperty(Version.VERSION_HISTORY);
        List<RiRepoVersion> versions = activity.getActivityVersionList();
        this.checkWhetherActivityCanBeSet2(versions, this, thisVH);
        List<RiRepoControllableResource> activityCheckoutList = activity.getActivityCheckoutList();
        int j = 0;
        while (j < activityCheckoutList.size()) {
            RiRepoControllableResource cr = activityCheckoutList.get(j);
            if (!cr.getReserved() && cr.getVersionHistory() == thisVH) {
                RiRepoVersion checkedOutVersion = cr.getCheckedOut();
                this.checkWhetherActivityCanBeSet2(versions, checkedOutVersion, thisVH);
            }
            ++j;
        }
    }

    private void checkWhetherActivityCanBeSet2(List<RiRepoVersion> versions, RiRepoVersion thisVersion, RiRepoVersionHistory thisVH) throws WvcmException {
        int i = 0;
        while (i < versions.size()) {
            RiRepoVersionHistory otherVH;
            RiRepoVersion version = versions.get(i);
            if (version != thisVersion && (otherVH = (RiRepoVersionHistory)version.getProperty(Version.VERSION_HISTORY)) == thisVH && !version.isAncestorOf(this)) {
                throw new WvcmException("ACTIVITY value invalid", WvcmException.ReasonCode.CONFLICT);
            }
            ++i;
        }
    }

    @Override
    protected void postSetPropertyEx(PropertyNameList.PropertyName<?> propertyName, Object oldValue, Object value) {
        super.postSetPropertyEx(propertyName, oldValue, value);
        if (propertyName.equals((Object)Version.ACTIVITY)) {
            if (value != null) {
                RiRepoActivity act = (RiRepoActivity)value;
                act.setProperty_AppendUniqueToList(Activity.ACTIVITY_VERSION_LIST, this);
            }
        } else if (propertyName.equals((Object)Version.PREDECESSOR_LIST)) {
            RiRepoVersion predecessor = (RiRepoVersion)value;
            predecessor.setProperty_AppendUniqueToList(Version.SUCCESSOR_LIST, this);
        }
    }

    @Override
    protected boolean handleCalculatedProperties(PropertyNameList.PropertyName<?> propertyName, Object[] calculatedValue) {
        if (propertyName.equals((Object)Version.LABEL_NAME_LIST)) {
            ArrayList<String> list = new ArrayList<String>();
            RiRepoVersionHistory vh = (RiRepoVersionHistory)this.getProperty(Version.VERSION_HISTORY);
            for (String label : vh.labelMap.keySet()) {
                if (!vh.labelMap.get(label).equals(this)) continue;
                list.add(label);
            }
            calculatedValue[0] = list;
            return true;
        }
        return super.handleCalculatedProperties(propertyName, calculatedValue);
    }

    boolean isAncestorOf(RiRepoVersion descendantVersion) {
        List<RiRepoVersion> descendantPredList = descendantVersion.getPredecessorList();
        int i = 0;
        while (i < descendantPredList.size()) {
            RiRepoVersion predVersion = descendantPredList.get(i);
            if (this == predVersion) {
                return true;
            }
            if (this.isAncestorOf(predVersion)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasContent() {
        return true;
    }

    @Override
    public boolean hasSameContent(SrvcResource otherVersion, SrvcFeedback feedback) {
        RiRepoVersion otherV = (RiRepoVersion)otherVersion;
        if (this._content == null) {
            return otherV._content == null;
        }
        return this._content.equals(otherV._content);
    }

    @Override
    public void doRemoveLabel(String label, SrvcFeedback feedback) throws WvcmException {
        RiRepoVersionHistory vh = (RiRepoVersionHistory)this.getProperty(Version.VERSION_HISTORY);
        RiRepoVersion version = vh.labelMap.get(label);
        if (version != this) {
            throw new WvcmException("Label does not exist on this version", WvcmException.ReasonCode.CANNOT_REMOVE_LABEL_DOES_NOT_EXIST);
        }
        vh.labelMap.remove(label);
    }

    @Override
    public void doSetLabel(String label, boolean overwrite, SrvcFeedback feedback) throws WvcmException {
        RiRepoVersionHistory vh = (RiRepoVersionHistory)this.getProperty(ControllableResource.VERSION_HISTORY);
        if (!overwrite && vh.labelMap.containsKey(label)) {
            throw new WvcmException("Label already in use", WvcmException.ReasonCode.ADD_MUST_BE_NEW_LABEL);
        }
        vh.labelMap.put(label, this);
    }

    public RiRepoVersionHistory getVersionHistory() {
        return (RiRepoVersionHistory)this.getProperty(Version.VERSION_HISTORY);
    }

    public RiRepoActivity getActivity() {
        return (RiRepoActivity)this.getProperty(Version.ACTIVITY);
    }

    public List<RiRepoVersion> getPredecessorList() {
        return this.getListProperty(Version.PREDECESSOR_LIST);
    }

    public List<RiRepoVersion> getSuccessorList() {
        return this.getListProperty(Version.SUCCESSOR_LIST);
    }

    public List<RiRepoControllableResource> getCheckoutList() {
        return this.getListProperty(Version.CHECKOUT_LIST);
    }

    @Override
    public RiRepoVersionHistory getParentVersionHistory(SrvcFeedback feedback) {
        if (!this.versionKnowsParent()) {
            throw new IllegalStateException("Versions have no parent");
        }
        return (RiRepoVersionHistory)this.getProperty(PARENT_VERSION_HISTORY);
    }

    @Override
    public String getBindingName(SrvcFeedback feedback) {
        if (!this.versionKnowsParent()) {
            throw new IllegalStateException("Versions have no binding name");
        }
        return (String)this.getProperty(BINDING_NAME);
    }
}

