/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.repo;

import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.StreamImpl;
import com.ibm.rational.wvcm.ri.repo.RiRepo;
import com.ibm.rational.wvcm.ri.repo.RiRepoActivity;
import com.ibm.rational.wvcm.ri.repo.RiRepoBaseline;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoFolderVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersionHistory;
import com.ibm.rational.wvcm.ri.repo.RiRepoWorkspace;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Stream;
import javax.wvcm.Version;
import javax.wvcm.VersionSet;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiRepoStream
extends RiRepoActivity {
    public Map<RiRepoVersionHistory, RiRepoVersion> deleted = new HashMap<RiRepoVersionHistory, RiRepoVersion>();

    @Override
    public Class<?> get_proxyClass() {
        return StreamImpl.class;
    }

    public RiRepoStream(RiRepoResource parent, String bindingName, SrvcProvider provider, RiRepo repo) {
        super(parent, bindingName, provider, repo);
        this.initialize();
    }

    private void initialize() {
        this.createProperty(Stream.SOURCE_LIST, new ArrayList());
        this.createProperty(Stream.TARGET, null);
        this.createProperty(Stream.VERSION_LIST, new ArrayList());
        this.setPropertyEx_AppendToList(Stream.VERSION_LIST, this.get_repo().getWorkspaceInitialVersion());
        try {
            SrvcProvider p = this.provider();
            Location wsLoc = p.rootLocation().child("streamWs");
            HashMap updates = new HashMap();
            updates.put(Stream.TARGET, new PropValue(Stream.TARGET, this));
            ArrayList updated = new ArrayList();
            RiRepoWorkspace ws = RiRepoWorkspace.doCreateGeneratedWorkspace(p, wsLoc, updates, updated, null);
            this.createProperty(Stream.WORKSPACE, ws);
        }
        catch (WvcmException wvcmException) {
            throw new RuntimeException("Could not create stream workspace");
        }
    }

    @Override
    protected void postSetPropertyEx(PropertyNameList.PropertyName<?> propertyName, Object oldValue, Object value) {
        super.postSetPropertyEx(propertyName, oldValue, value);
        if (propertyName.equals((Object)Stream.TARGET)) {
            RiRepoStream stream = (RiRepoStream)oldValue;
            if (stream != null) {
                stream.setProperty_RemoveFromList(Stream.SOURCE_LIST, this);
            }
            if ((stream = (RiRepoStream)value) != null) {
                stream.setProperty_AppendUniqueToList(Stream.SOURCE_LIST, this);
            }
        }
    }

    @Override
    protected void checkWhetherPropertyCanBeSet(PropertyNameList.PropertyName<?> propertyName, Object value) throws WvcmException {
        super.checkWhetherPropertyCanBeSet(propertyName, value);
        String ns = propertyName.getNamespace();
        if (ns == null && propertyName.equals((Object)Stream.TARGET) && !this.is_creationInProgress()) {
            throw new WvcmException("TARGET cannot be set after Stream has been created", WvcmException.ReasonCode.CONFLICT);
        }
    }

    @Override
    public Map<RiRepoVersionHistory, RiRepoVersion> getVersionMap() {
        List<RiRepoVersion> versions = this.getVersionList();
        HashMap<RiRepoVersionHistory, RiRepoVersion> map = new HashMap<RiRepoVersionHistory, RiRepoVersion>();
        int i = 0;
        while (i < versions.size()) {
            RiRepoVersion version = versions.get(i);
            map.put(version.getVersionHistory(), version);
            ++i;
        }
        return map;
    }

    public RiRepoVersion getVersion(RiRepoVersionHistory versionHistory) {
        List<RiRepoVersion> versions = this.getVersionList();
        int i = 0;
        while (i < versions.size()) {
            RiRepoVersion version = versions.get(i);
            if (version.getVersionHistory() == versionHistory) {
                return version;
            }
            ++i;
        }
        return null;
    }

    private static void findUpwardVVH(Set<RiRepoVersionHistory> visibleVHs, RiRepoVersionHistory vh, RiRepoVersionHistory rootVH, Map<RiRepoVersionHistory, RiRepoVersion> oldVersions, SrvcFeedback feedback) {
        if (visibleVHs.contains(vh)) {
            return;
        }
        RiRepoVersion v = oldVersions.get(vh);
        if (v != null) {
            RiRepoVersionHistory parentVH = v.getParentVersionHistory(feedback);
            RiRepoStream.findUpwardVVH(visibleVHs, parentVH, rootVH, oldVersions, feedback);
            if (visibleVHs.contains(parentVH)) {
                visibleVHs.add(vh);
            }
        }
    }

    private void findDownwardVVH(Set<RiRepoVersionHistory> visibleVHs, RiRepoVersionHistory vh, Map<RiRepoVersionHistory, RiRepoVersion> oldVersions, SrvcFeedback feedback) {
        RiRepoVersion v = oldVersions.get(vh);
        if (v != null) {
            visibleVHs.add(vh);
            if (v instanceof RiRepoFolderVersion) {
                RiRepoFolderVersion fv = (RiRepoFolderVersion)v;
                Iterator<RiRepoVersionHistory> children = fv.getChildList().iterator();
                while (children.hasNext()) {
                    this.findVisibleVersionHistorys(visibleVHs, children.next(), oldVersions, feedback);
                }
            }
        }
    }

    private void findVisibleVersionHistorys(Set<RiRepoVersionHistory> visibleVHs, RiRepoVersionHistory rootVH, Map<RiRepoVersionHistory, RiRepoVersion> oldVersions, SrvcFeedback feedback) {
        if (this.versionKnowsParent()) {
            visibleVHs.add(rootVH);
            for (RiRepoVersionHistory vh : oldVersions.keySet()) {
                RiRepoStream.findUpwardVVH(visibleVHs, vh, rootVH, oldVersions, feedback);
            }
        } else {
            this.findDownwardVVH(visibleVHs, rootVH, oldVersions, feedback);
        }
    }

    private RiRepoVersion findTargetForStreamUpdate(RiRepoVersion sourceVersion) {
        RiRepoVersionHistory vh = (RiRepoVersionHistory)sourceVersion.getProperty(Version.VERSION_HISTORY);
        List<RiRepoVersion> versionList = this.getVersionList();
        int i = 0;
        while (i < versionList.size()) {
            RiRepoVersion version = versionList.get(i);
            RiRepoVersionHistory vh2 = (RiRepoVersionHistory)version.getProperty(Version.VERSION_HISTORY);
            if (vh == vh2) {
                return version;
            }
            ++i;
        }
        return null;
    }

    private static boolean isDeletedFrom(RiRepoVersion v, Map<RiRepoVersionHistory, RiRepoControllableFolder> sourceCFMap, SrvcFeedback feedback) {
        RiRepoVersionHistory parentVH = v.getParentVersionHistory(feedback);
        if (parentVH == null) {
            return false;
        }
        RiRepoControllableFolder f = sourceCFMap.get(parentVH);
        if (f == null) {
            return false;
        }
        RiRepoVersionHistory vh = v.getVersionHistory();
        for (RiRepoControllableResource r : f.getChildList()) {
            if (vh != r.getVersionHistory()) continue;
            return false;
        }
        return true;
    }

    private static void addSourceCF(Map<RiRepoVersionHistory, RiRepoControllableFolder> sourceCFMap, RiRepoResource o) {
        if (!(o instanceof RiRepoControllableFolder)) {
            return;
        }
        RiRepoControllableFolder f = (RiRepoControllableFolder)o;
        sourceCFMap.put(f.getVersionHistory(), f);
        for (RiRepoControllableResource r : f.getChildList()) {
            RiRepoStream.addSourceCF(sourceCFMap, r);
        }
    }

    @Override
    protected RiRepoVersion locateByHistory(SrvcResource versionHistory, SrvcFeedback feedback) throws WvcmException {
        if (!(versionHistory instanceof RiRepoVersionHistory)) {
            throw new WvcmException("Argument must be a version history", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
        }
        return this.getVersionMap().get(versionHistory);
    }

    @Override
    public Map<String, SrvcResource> getFolderVersionChildMap(SrvcResource folderVersion, SrvcFeedback feedback) throws WvcmException {
        if (!this.versionKnowsParent()) {
            throw new IllegalStateException("No need to compute folder versions children");
        }
        if (!(folderVersion instanceof RiRepoVersion)) {
            throw new RuntimeException("getChildMap expects a folder version history argument");
        }
        RiRepoFolderVersion parentVersion = (RiRepoFolderVersion)folderVersion;
        RiRepoVersionHistory parentVH = parentVersion.getVersionHistory();
        HashMap<String, SrvcResource> result = new HashMap<String, SrvcResource>();
        for (RiRepoVersion v : this.getVersionList()) {
            if (v.getParentVersionHistory(feedback) != parentVH) continue;
            result.put(v.getBindingName(feedback), v.getVersionHistory());
        }
        return result;
    }

    @Override
    public List<SrvcResource> getFolderVersionChildList(SrvcResource folderVersion, SrvcFeedback feedback) throws WvcmException {
        if (!this.versionKnowsParent()) {
            throw new IllegalStateException("No need to compute folder versions children");
        }
        if (!(folderVersion instanceof RiRepoVersion)) {
            throw new RuntimeException("getChildMap expects a folder version history argument");
        }
        RiRepoFolderVersion parentVersion = (RiRepoFolderVersion)folderVersion;
        RiRepoVersionHistory parentVH = parentVersion.getVersionHistory();
        ArrayList<SrvcResource> result = new ArrayList<SrvcResource>();
        for (RiRepoVersion v : this.getVersionList()) {
            if (v.getParentVersionHistory(feedback) != parentVH) continue;
            result.add(v.getVersionHistory());
        }
        return result;
    }

    @Override
    public List<SrvcResource.SrvcCompareReport> doCompareReport(SrvcResource newResource, VersionSet.CompareFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        RiRepoResource resource = (RiRepoResource)newResource;
        if (resource == null) {
            throw new WvcmException("Argument must be non-null", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
        }
        if (!(resource instanceof RiRepoBaseline) && !(resource instanceof RiRepoStream)) {
            throw new WvcmException("Argument must be a baseline or a stream", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
        }
        boolean isActivityCompare = false;
        boolean newOnly = false;
        if (flags != null) {
            int i = 0;
            while (i < flags.length) {
                if (flags[i] == VersionSet.CompareFlag.ACTIVITIES) {
                    isActivityCompare = true;
                } else if (flags[i] == VersionSet.CompareFlag.NEW_ONLY) {
                    newOnly = true;
                } else {
                    throw new WvcmException("Compare flag not supported: " + flags[i].toString(), WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
                }
                ++i;
            }
        }
        return RiRepoBaseline.compareVersions(this.provider(), this.getVersionMap(), resource.getVersionMap(), isActivityCompare, newOnly);
    }

    @Override
    public <T extends SrvcResource> void doUpdate(List<T> sourceList, SrvcFeedback feedback) throws WvcmException {
        if (this.versionKnowsParent()) {
            Map<RiRepoVersionHistory, RiRepoVersion> verMap = this.getVersionMap();
            for (T o : sourceList) {
                if (!(o instanceof RiRepoWorkspace)) continue;
                RiRepoWorkspace w = (RiRepoWorkspace)o;
                for (RiRepoVersionHistory deletedVH : w.deleted.keySet()) {
                    this.deleted.put(deletedVH, w.deleted.get(deletedVH));
                    RiRepoVersion v = verMap.get(deletedVH);
                    if (v == null) continue;
                    this.setPropertyEx_RemoveFromList(Stream.VERSION_LIST, v);
                }
            }
        }
        List<RiRepoVersion> sourceVersions = RiRepoWorkspace.identifySourceVersions(sourceList, true);
        SrvcProvider p = this.provider();
        int i = 0;
        while (i < sourceVersions.size()) {
            RiRepoVersion sourceVersion = sourceVersions.get(i);
            RiRepoVersion target = this.findTargetForStreamUpdate(sourceVersion);
            if (target == null) {
                this.setPropertyEx_AppendToList(Stream.VERSION_LIST, sourceVersion);
            } else {
                this.setPropertyEx_RemoveFromList(Stream.VERSION_LIST, target);
                this.setPropertyEx_AppendToList(Stream.VERSION_LIST, sourceVersion);
            }
            ++i;
        }
        if (p.initArgs().get("com.ibm.rational.wvcm.STREAM_FORGETS_UNBOUND_VERSIONS") != null) {
            Map<RiRepoVersionHistory, RiRepoVersion> oldVersions = this.getVersionMap();
            HashSet<RiRepoVersionHistory> visibleVHs = new HashSet<RiRepoVersionHistory>(oldVersions.size());
            this.findVisibleVersionHistorys(visibleVHs, this.get_repo().getWorkspaceVersionHistory(), oldVersions, feedback);
            for (RiRepoVersionHistory oldVH : oldVersions.keySet()) {
                if (visibleVHs.contains(oldVH)) continue;
                this.setPropertyEx_RemoveFromList(Stream.VERSION_LIST, oldVersions.get(oldVH));
            }
        }
        if (this.versionKnowsParent()) {
            HashMap<RiRepoVersionHistory, RiRepoControllableFolder> sourceCFMap = new HashMap<RiRepoVersionHistory, RiRepoControllableFolder>();
            for (T o : sourceList) {
                RiRepoStream.addSourceCF(sourceCFMap, (RiRepoResource)o);
            }
            ArrayList<RiRepoVersion> removedVList = new ArrayList<RiRepoVersion>();
            for (RiRepoVersion v : this.getVersionList()) {
                if (!RiRepoStream.isDeletedFrom(v, sourceCFMap, feedback)) continue;
                removedVList.add(v);
            }
            for (RiRepoVersion v : removedVList) {
                this.setPropertyEx_RemoveFromList(Stream.VERSION_LIST, v);
                this.deleted.put(v.getVersionHistory(), v);
            }
            for (RiRepoVersion v : this.getVersionList()) {
                if (this.deleted.get(v.getVersionHistory()) == null) continue;
                this.deleted.remove(v.getVersionHistory());
            }
        }
    }

    public List<RiRepoVersion> getVersionList() {
        return this.getListProperty(Stream.VERSION_LIST);
    }
}

