/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.repo;

import com.ibm.rational.wvcm.ri.impl.ControllableSymbolicLinkImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.repo.RiRepo;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersion;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableSymbolicLink;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiRepoControllableSymbolicLink
extends RiRepoControllableResource {
    @Override
    public Class<?> get_proxyClass() {
        return ControllableSymbolicLinkImpl.class;
    }

    protected RiRepoControllableSymbolicLink(RiRepoResource parent, String bindingName, SrvcProvider provider, RiRepo repo) {
        super(parent, bindingName, provider, repo);
        this.initialize();
    }

    private void initialize() {
        this.createProperty(ControllableSymbolicLink.LINK_TARGET, this.provider().relativeRootLocation());
    }

    @Override
    protected boolean isControlledStateDifferent(RiRepoVersion version, SrvcFeedback feedback) {
        if (super.isControlledStateDifferent(version, feedback)) {
            return true;
        }
        if (this.versionKnowsParent()) {
            return false;
        }
        return !this.getLinkTarget().equals(version.getProperty(ControllableSymbolicLink.LINK_TARGET));
    }

    private boolean isRelativeLocation(Location loc) {
        if (loc == null) {
            return false;
        }
        if (loc.equals(this.provider().relativeRootLocation())) {
            return true;
        }
        return this.isRelativeLocation(loc.parent());
    }

    private Location applyRelativeLocation(Location baseLoc, Location relativeLoc) throws WvcmException {
        if (relativeLoc.equals(this.provider().relativeRootLocation())) {
            return baseLoc;
        }
        return this.applyRelativeLocation(baseLoc.child(relativeLoc.lastSegment()), relativeLoc.parent());
    }

    public static RiRepoControllableResource doCreateResource(SrvcProvider provider, Location loc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        RiRepo repo = RiRepo.get_Repo(loc, provider);
        RiRepoControllableSymbolicLink.performCreationPreconditionChecks(loc, provider);
        RiRepoResource parent = RiRepoControllableSymbolicLink.getParentResource(provider, loc);
        if (!(parent instanceof RiRepoControllableFolder)) {
            throw new WvcmException("Parent folder for a ControllableFolder must be a ControllableFolder or Workspace: " + loc, WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
        }
        String bindingName = loc.lastSegment();
        RiRepoControllableSymbolicLink symLink = new RiRepoControllableSymbolicLink(parent, bindingName, provider, repo);
        if (updates != null) {
            symLink.set_creationInProgress(true);
            symLink.doWriteProperties(updates, updated, feedback);
            symLink.set_creationInProgress(false);
        }
        return symLink;
    }

    @Override
    public void doReadContent(OutputStream content, Resource accept, SrvcFeedback feedback) throws WvcmException {
        SrvcResource target;
        Location targetLoc = this.getLinkTarget();
        if (this.isRelativeLocation(targetLoc)) {
            targetLoc = this.applyRelativeLocation(this.calculatePathLocation().parent(), targetLoc);
        }
        if ((target = this.provider().lookup(targetLoc, null)) == null) {
            throw new WvcmException("Link target not found: " + targetLoc, WvcmException.ReasonCode.NOT_FOUND);
        }
        target.doReadContent(content, accept, feedback);
    }

    @Override
    public void doWriteContent(InputStream content, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource target;
        Location targetLoc = this.getLinkTarget();
        if (this.isRelativeLocation(targetLoc)) {
            targetLoc = this.applyRelativeLocation(this.calculatePathLocation().parent(), targetLoc);
        }
        if ((target = this.provider().lookup(targetLoc, null)) == null) {
            throw new WvcmException("Link target not found: " + targetLoc, WvcmException.ReasonCode.NOT_FOUND);
        }
        this.provider().doWriteContent(target.location(), content, contentIdentifier, updates, updated, feedback);
    }

    public Location getLinkTarget() {
        return (Location)this.getProperty(ControllableSymbolicLink.LINK_TARGET);
    }
}

