/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.repo;

import com.ibm.rational.wvcm.ri.impl.ControllableFolderImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.repo.RiRepo;
import com.ibm.rational.wvcm.ri.repo.RiRepoBaseline;
import com.ibm.rational.wvcm.ri.repo.RiRepoComponent;
import com.ibm.rational.wvcm.ri.repo.RiRepoConfiguration;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableSymbolicLink;
import com.ibm.rational.wvcm.ri.repo.RiRepoFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoFolderVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoIFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoStream;
import com.ibm.rational.wvcm.ri.repo.RiRepoSymbolicLinkVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersionHistory;
import com.ibm.rational.wvcm.ri.repo.RiRepoWorkspace;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcLocation;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wvcm.Baseline;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.VersionHistory;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiRepoControllableFolder
extends RiRepoControllableResource
implements RiRepoIFolder {
    @Override
    public Class<?> get_proxyClass() {
        return ControllableFolderImpl.class;
    }

    protected RiRepoControllableFolder(RiRepoResource parent, String bindingName, SrvcProvider provider, RiRepo repo) {
        super(parent, bindingName, provider, repo);
        this.initialize();
    }

    private void initialize() {
        this.createProperty(ControllableFolder.IS_BASELINE_CONTROLLABLE, Boolean.FALSE);
        this.createProperty(ControllableFolder.ROOT_FOLDER_OF, null);
        this.createProperty(ControllableFolder.IS_BASELINE_CONTROLLED, null);
        this.createProperty(RiRepoIFolder.CHILD_BINDING_LIST, new ArrayList());
        this.createProperty(Folder.CHILD_LIST, null);
        this.createProperty(Folder.CHILD_MAP, null);
    }

    @Override
    protected void destroy() {
        RiRepoConfiguration config = this.getRootFolderOf();
        if (config != null) {
            ArrayList<RiRepoIFolder.RepoBinding> parentBindings = new ArrayList<RiRepoIFolder.RepoBinding>();
            parentBindings.addAll(config.getParentBindingList());
            for (RiRepoIFolder.RepoBinding binding : parentBindings) {
                binding.unbind();
            }
        }
        super.destroy();
    }

    @Override
    protected void createBaselineVersionList(List<RiRepoVersion> versions) {
        if (!this.getIsVersionControlled()) {
            return;
        }
        RiRepoVersion v = this.getCheckedIn();
        if (v == null) {
            throw new RuntimeException("Baseline members must not be checked-out.");
        }
        versions.add(v);
        for (RiRepoControllableResource child : this.getChildList()) {
            child.createBaselineVersionList(versions);
        }
    }

    void restoreBoundMembersToFolderVersion(RiRepoFolderVersion folderVersion) throws WvcmException {
        SrvcFeedback feedback = null;
        List<RiRepoIFolder.RepoBinding> folderBoundMembers = this.getChildBindingList();
        int i = 0;
        while (i < folderBoundMembers.size()) {
            RiRepoIFolder.RepoBinding crBinding = folderBoundMembers.get(i);
            String crBindingName = crBinding.get_bindingName();
            RiRepoControllableResource cr = (RiRepoControllableResource)crBinding.get_bindingMember();
            if (!cr.getVersionHistory().equals(folderVersion.getChildMap().get(crBindingName)) && cr.isControlled()) {
                crBinding.unbind();
                --i;
            }
            ++i;
        }
        List<RiRepoIFolder.RepoBinding> folderVersionBoundMembers = folderVersion.getChildBindingList();
        int i2 = 0;
        while (i2 < folderVersionBoundMembers.size()) {
            String vhBindingName;
            RiRepoIFolder.RepoBinding vhBinding = folderVersionBoundMembers.get(i2);
            RiRepoVersionHistory versionHistory = (RiRepoVersionHistory)vhBinding.get_bindingMember();
            if (!this.versionHistoryIsInBML(versionHistory, vhBindingName = vhBinding.get_bindingName())) {
                RiRepoVersion rootVersion = (RiRepoVersion)versionHistory.getProperty(VersionHistory.ROOT_VERSION);
                Location resLocation = this.location().child(vhBindingName);
                RiRepoControllableResource cr = (RiRepoControllableResource)this.provider().lookup(resLocation, feedback);
                if (cr == null) {
                    RiRepoControllableFolder.createVersionControlledResource(this.provider(), resLocation, rootVersion, false, null, null, feedback);
                }
            }
            ++i2;
        }
    }

    boolean versionHistoryIsInBML(RiRepoVersionHistory versionHistory, String vhBindingName) {
        boolean exists = false;
        List<RiRepoIFolder.RepoBinding> resourceMembers = this.getChildBindingList();
        int i = 0;
        while (i < resourceMembers.size() && versionHistory != null) {
            RiRepoIFolder.RepoBinding crBinding = resourceMembers.get(i);
            RiRepoControllableResource cr = (RiRepoControllableResource)crBinding.get_bindingMember();
            String crBindingName = crBinding.get_bindingName();
            RiRepoVersionHistory vh = (RiRepoVersionHistory)cr.getProperty(ControllableResource.VERSION_HISTORY);
            if (vh == versionHistory && vhBindingName.equals(crBindingName)) {
                exists = true;
                break;
            }
            ++i;
        }
        return exists;
    }

    protected void recursivelyCalculateBaselineControlledFolderList(List<RiRepoControllableFolder> list) {
        RiRepoConfiguration config = this.getRootFolderOf();
        if (config != null) {
            list.add(this);
        }
        List<RiRepoIFolder.RepoBinding> bindings = this.getChildBindingList();
        int i = 0;
        while (i < bindings.size()) {
            RiRepoIFolder.RepoBinding binding = bindings.get(i);
            RiRepoResource member = binding.get_bindingMember();
            if (member instanceof RiRepoControllableFolder) {
                ((RiRepoControllableFolder)member).recursivelyCalculateBaselineControlledFolderList(list);
            }
            ++i;
        }
    }

    protected RiRepoControllableResource updateAdded(RiRepoWorkspace workspace, RiRepoVersionHistory versionHistory, RiRepoVersion version, String bindingName, SrvcFeedback feedback) throws WvcmException {
        RiRepoControllableResource cr = workspace.locateByHistoryReport(versionHistory);
        if (cr != null) {
            this.setupBinding(bindingName, cr);
            return null;
        }
        return this.updateCreated(workspace, versionHistory, version, bindingName, feedback);
    }

    protected RiRepoControllableResource updateCreated(RiRepoWorkspace workspace, RiRepoVersionHistory versionHistory, RiRepoVersion aVersion, String bindingName, SrvcFeedback feedback) throws WvcmException {
        RiRepoControllableResource newVCR;
        RiRepoControllableFolder parent = this;
        RiRepo repo = versionHistory.get_repo();
        RiRepoWorkspace ws = workspace;
        RiRepoBaseline baseline = null;
        RiRepoVersion version = aVersion;
        if (aVersion instanceof RiRepoBaseline) {
            baseline = (RiRepoBaseline)aVersion;
            version = baseline.getVersion(versionHistory);
        }
        if (version == null) {
            RiRepoStream stream = workspace.getStream();
            if (stream != null) {
                version = stream.getVersion(versionHistory);
            }
            if (version == null) {
                version = versionHistory.getRootVersion();
            }
        }
        if (ws == null) {
            ws = new RiRepoWorkspace(this, bindingName, this.provider(), repo);
            newVCR = ws;
        } else {
            newVCR = version instanceof RiRepoSymbolicLinkVersion ? new RiRepoControllableSymbolicLink(parent, bindingName, this.provider(), repo) : (version instanceof RiRepoFolderVersion ? new RiRepoControllableFolder(parent, bindingName, this.provider(), repo) : new RiRepoControllableResource(parent, bindingName, this.provider(), repo));
        }
        newVCR.setPropertyEx(ControllableResource.CHECKED_IN, version);
        newVCR.setProperty(ControllableResource.VERSION_HISTORY, versionHistory);
        RiRepoControllableResource.copyVersionToVCR(version, newVCR);
        if (newVCR instanceof RiRepoControllableFolder) {
            ((RiRepoControllableFolder)newVCR).makeIsBaselineControllable();
        }
        if (this.versionKnowsParent()) {
            if (!(newVCR instanceof RiRepoWorkspace || bindingName.equals(version.getBindingName(feedback)) && parent.getVersionHistory() == version.getParentVersionHistory(feedback))) {
                newVCR.doCheckout(null, null);
            }
            if (ws.deleted.containsKey(versionHistory)) {
                ws.deleted.remove(versionHistory);
            }
        } else if (newVCR instanceof RiRepoControllableFolder) {
            RiRepoControllableFolder newVCF = (RiRepoControllableFolder)newVCR;
            List<RiRepoIFolder.RepoBinding> blfBindings = ((RiRepoFolderVersion)version).getChildBindingList();
            int i = 0;
            while (i < blfBindings.size()) {
                RiRepoIFolder.RepoBinding blfBinding = blfBindings.get(i);
                RiRepoVersionHistory vh = (RiRepoVersionHistory)blfBinding.get_bindingMember();
                newVCF.updateAdded(workspace, vh, baseline, blfBinding.get_bindingName(), feedback);
                ++i;
            }
        }
        return newVCR;
    }

    @Override
    public boolean canAutoMerge(RiRepoVersion srcVersion) throws WvcmException {
        Map<String, RiRepoResource> crCMap = this.getChildMap();
        Map<String, RiRepoVersionHistory> verCMap = ((RiRepoFolderVersion)srcVersion).getChildMap();
        Iterator<String> keys = verCMap.keySet().iterator();
        while (keys.hasNext()) {
            if (!crCMap.containsKey(keys.next())) continue;
            return false;
        }
        return true;
    }

    public void autoMergeFolder(RiRepoFolderVersion otherVersion, SrvcFeedback feedback) throws WvcmException {
        if (this.versionKnowsParent()) {
            this.setProperty_AppendToList(ControllableResource.MERGE_LIST, otherVersion);
            return;
        }
        Map<String, RiRepoResource> crCMap = this.getChildMap();
        Map<String, RiRepoVersionHistory> verCMap = otherVersion.getChildMap();
        Iterator<String> keys = verCMap.keySet().iterator();
        while (keys.hasNext()) {
            if (!crCMap.containsKey(keys.next())) continue;
            this.setProperty_AppendToList(ControllableResource.MERGE_LIST, otherVersion);
            return;
        }
        for (String key : verCMap.keySet()) {
            this.updateAdded(this.getWorkspace(), verCMap.get(key), null, key, feedback);
        }
        this.setProperty_AppendToList(ControllableResource.AUTO_MERGE_LIST, otherVersion);
    }

    protected void updateVersionControlledFolderMembers(RiRepoFolderVersion oldFolderVersion, RiRepoFolderVersion newFolderVersion, RiRepoBaseline bl, SrvcFeedback feedback) throws WvcmException {
        boolean found;
        RiRepoControllableFolder cf = this;
        List<RiRepoIFolder.RepoBinding> oldChildBindings = oldFolderVersion.getChildBindingList();
        List<RiRepoIFolder.RepoBinding> newChildBindings = newFolderVersion.getChildBindingList();
        int i = 0;
        while (i < oldChildBindings.size()) {
            RiRepoIFolder.RepoBinding oldChildBinding = oldChildBindings.get(i);
            RiRepoVersionHistory oldVH = (RiRepoVersionHistory)oldChildBinding.get_bindingMember();
            found = false;
            String newBindingName = null;
            int j = 0;
            while (j < newChildBindings.size()) {
                RiRepoIFolder.RepoBinding newChildBinding = newChildBindings.get(j);
                RiRepoVersionHistory newVH = (RiRepoVersionHistory)newChildBinding.get_bindingMember();
                if (oldVH == newVH) {
                    found = true;
                    String oldBindingName = oldChildBinding.get_bindingName();
                    if (!oldBindingName.equals(newBindingName = newChildBinding.get_bindingName())) break;
                    newBindingName = null;
                    break;
                }
                ++j;
            }
            RiRepoIFolder.RepoBinding childCRBinding = null;
            if (!found || newBindingName != null) {
                List<RiRepoIFolder.RepoBinding> crBindings = cf.getChildBindingList();
                int j2 = 0;
                while (j2 < crBindings.size()) {
                    RiRepoIFolder.RepoBinding crBinding = crBindings.get(j2);
                    RiRepoControllableResource cr = (RiRepoControllableResource)crBinding.get_bindingMember();
                    RiRepoVersionHistory crVH = cr.getVersionHistory();
                    if (oldVH == crVH) {
                        childCRBinding = crBinding;
                        break;
                    }
                    ++j2;
                }
            }
            if (!found) {
                childCRBinding.unbind();
            } else if (newBindingName != null) {
                childCRBinding.renameBinding(newBindingName);
            }
            ++i;
        }
        i = 0;
        while (i < newChildBindings.size()) {
            RiRepoIFolder.RepoBinding newChildBinding = newChildBindings.get(i);
            RiRepoVersionHistory newVH = (RiRepoVersionHistory)newChildBinding.get_bindingMember();
            found = false;
            int j = 0;
            while (j < oldChildBindings.size()) {
                RiRepoIFolder.RepoBinding oldChildBinding = oldChildBindings.get(j);
                RiRepoVersionHistory oldVH = (RiRepoVersionHistory)oldChildBinding.get_bindingMember();
                if (oldVH == newVH) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                String bindingName = newChildBinding.get_bindingName();
                RiRepoControllableResource cr = cf.updateAdded(cf.getWorkspace(), newVH, bl, bindingName, feedback);
                if (cr != null && feedback != null) {
                    feedback.notifyIsModified(cr);
                }
            }
            ++i;
        }
    }

    @Override
    protected boolean isControlledStateDifferent(RiRepoVersion folderVersion, SrvcFeedback feedback) {
        if (super.isControlledStateDifferent(folderVersion, feedback)) {
            return true;
        }
        if (this.versionKnowsParent()) {
            return false;
        }
        Map<String, RiRepoResource> map1 = this.getChildMap();
        Map<String, RiRepoVersionHistory> map2 = ((RiRepoFolderVersion)folderVersion).getChildMap();
        for (String key : map2.keySet()) {
            RiRepoControllableResource cr = (RiRepoControllableResource)map1.get(key);
            if (cr != null && cr.getVersionHistory().equals(map2.get(key))) continue;
            return true;
        }
        for (String key : map1.keySet()) {
            if (map2.get(key) != null) continue;
            return true;
        }
        return false;
    }

    public Map<String, RiRepoIFolder.RepoBinding> getChildBindingsMap() {
        HashMap<String, RiRepoIFolder.RepoBinding> ret = new HashMap<String, RiRepoIFolder.RepoBinding>();
        List<RiRepoIFolder.RepoBinding> bindings = this.getChildBindingList();
        int i = 0;
        while (i < bindings.size()) {
            RiRepoIFolder.RepoBinding binding = bindings.get(i);
            ret.put(binding.get_bindingName(), binding);
            ++i;
        }
        return ret;
    }

    @Override
    protected boolean handleCalculatedProperties(PropertyNameList.PropertyName<?> propertyName, Object[] calculatedValue) {
        if (propertyName.equals((Object)ControllableFolder.IS_BASELINE_CONTROLLED)) {
            RiRepoConfiguration config = (RiRepoConfiguration)this.getProperty(ControllableFolder.ROOT_FOLDER_OF);
            calculatedValue[0] = config == null ? Boolean.FALSE : Boolean.TRUE;
            return true;
        }
        if (RiRepoFolder.handleCalculatedPropertiesHelper(this, propertyName, calculatedValue)) {
            return true;
        }
        return super.handleCalculatedProperties(propertyName, calculatedValue);
    }

    protected void checkNoCheckedOutBaselineControlledFolderMembers() throws WvcmException {
        RiRepoWorkspace workspace = this.getWorkspace();
        List<RiRepoControllableResource> workspaceCheckouts = workspace.getWorkspaceCheckoutList();
        int i = 0;
        while (i < workspaceCheckouts.size()) {
            RiRepoControllableResource checkout = workspaceCheckouts.get(i);
            if (!(checkout instanceof RiRepoConfiguration) && checkout.isMemberOf(this)) {
                throw new WvcmException("A baseline controlled folder member is checked out: " + checkout.calculatePath(), WvcmException.ReasonCode.NO_CHECKED_OUT_BASELINE_CONTROLLED_FOLDER_MEMBERS);
            }
            ++i;
        }
    }

    public void putUnderBaselineControl(RiRepoBaseline baseline) throws WvcmException {
        RiRepo repo = this.get_repo();
        String configurationName = repo.createUniqueConfigurationLocation();
        RiRepoConfiguration configuration = new RiRepoConfiguration(repo.getConfigurationFolder(), configurationName, this.provider(), repo);
        configuration.setPropertyEx(Configuration.ROOT_FOLDER, this);
        configuration.setPropertyEx(ControllableResource.WORKSPACE, this.getWorkspace());
        this.setProperty(ControllableFolder.ROOT_FOLDER_OF, configuration);
        configuration.setPropertyEx(ControllableResource.CHECKED_IN, baseline);
        configuration.setPropertyEx(ControllableResource.VERSION_HISTORY, baseline.getVersionHistory());
    }

    public void makeIsBaselineControllable() throws WvcmException {
        this.setProperty(ControllableFolder.IS_BASELINE_CONTROLLABLE, Boolean.TRUE);
        RiRepoComponent component = this.getVersionHistory().getComponentRootOf();
        if (component != null) {
            RiRepoBaseline baseline = null;
            RiRepoStream stream = this.getWorkspace().getStream();
            if (stream != null) {
                baseline = (RiRepoBaseline)component.getLatestActivityVersionReport(stream);
            }
            if (baseline == null) {
                baseline = (RiRepoBaseline)component.getRootVersion();
            }
            this.putUnderBaselineControl(baseline);
        }
    }

    public static RiRepoControllableResource doCreateResource(SrvcProvider provider, Location loc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        RiRepo repo = RiRepo.get_Repo(loc, provider);
        RiRepoControllableFolder.performCreationPreconditionChecks(loc, provider);
        RiRepoResource parent = RiRepoControllableFolder.getParentResource(provider, loc);
        if (!(parent instanceof RiRepoControllableFolder)) {
            throw new WvcmException("Parent folder for a ControllableFolder must be a ControllableFolder or Workspace: " + loc, WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
        }
        String bindingName = loc.lastSegment();
        RiRepoControllableFolder sFolder = new RiRepoControllableFolder(parent, bindingName, provider, repo);
        if (updates != null) {
            sFolder.set_creationInProgress(true);
            sFolder.doWriteProperties(updates, updated, feedback);
            sFolder.set_creationInProgress(false);
        }
        return sFolder;
    }

    @Override
    public void doBindChild(String bindingName, Location childLocation, Folder.BindFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        RiRepoWorkspace destinationWorkspace;
        RiRepoResource destinationResource;
        boolean destinationExists;
        RiRepoControllableResource child;
        if (RiRepo.TraceLevel > 10) {
            System.out.println("binding location: " + childLocation.string() + "to: " + bindingName);
        }
        RiRepoControllableFolder parent = this;
        SrvcProvider provider = this.provider();
        Location destination = parent.location().child(bindingName);
        boolean overwrite = false;
        if (flags != null) {
            int i = 0;
            while (i < flags.length) {
                if (flags[i] == Folder.BindFlag.OVERWRITE) {
                    overwrite = true;
                }
                ++i;
            }
        }
        if ((child = (RiRepoControllableResource)provider.lookup(childLocation, feedback)) == null) {
            throw new WvcmException("Repository resource does not exist: " + childLocation, null, WvcmException.ReasonCode.NOT_FOUND);
        }
        if (provider.initArgs().get("com.ibm.rational.wvcm.CR_HAS_ONE_PARENT") != null) {
            SrvcLocation childPathLoc = provider.location(child.calculatePath());
            Folder.RebindFlag[] rFlags = null;
            if (overwrite) {
                rFlags = new Folder.RebindFlag[]{Folder.RebindFlag.OVERWRITE};
            }
            this.doRebindChild(bindingName, childPathLoc.parent(), childPathLoc.lastSegment(), rFlags, feedback);
            return;
        }
        if (this.versionKnowsParent()) {
            throw new WvcmException("Only one parent supported", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        if (child.isControlled() && !parent.getIsCheckedOut()) {
            parent.doCheckout(null, null);
        }
        boolean bl = destinationExists = (destinationResource = (RiRepoResource)this.provider().lookup(destination, feedback)) != null;
        if (destinationExists && !overwrite) {
            throw new WvcmException("There already is a resource at the destination, and overwrite is false", WvcmException.ReasonCode.CANNOT_OVERWRITE);
        }
        if (child instanceof RiRepoControllableFolder && parent.isMemberOf((RiRepoControllableFolder)child)) {
            throw new WvcmException("CYCLE_NOT_ALLOWED", WvcmException.ReasonCode.CYCLE_NOT_ALLOWED);
        }
        RiRepoWorkspace sourceWorkspace = child.getWorkspace();
        if (sourceWorkspace != (destinationWorkspace = parent.getWorkspace()) || destinationWorkspace == null) {
            throw new WvcmException("Source and destination for a doBind of a ControllableResource must be within the same Workspace", WvcmException.ReasonCode.CANNOT_OVERWRITE);
        }
        if (destinationExists) {
            this.doUnbindChild(bindingName, feedback);
        }
        parent.setupBinding(bindingName, child);
    }

    @Override
    public void doRebindChild(String bindingName, Location sourceFolderLocation, String sourceBindingName, Folder.RebindFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        RiRepoIFolder.RepoBinding binding;
        RiRepoControllableFolder srcParent;
        boolean destinationExists;
        if (RiRepo.TraceLevel > 10) {
            System.out.println("renaming from: " + sourceBindingName + " to: " + bindingName);
        }
        RiRepoControllableFolder destParent = this;
        Location destination = destParent.location().child(bindingName);
        boolean overwrite = false;
        if (flags != null) {
            int i = 0;
            while (i < flags.length) {
                if (flags[i] == Folder.RebindFlag.OVERWRITE) {
                    overwrite = true;
                }
                ++i;
            }
        }
        Location sourceLoc = sourceFolderLocation.child(sourceBindingName);
        RiRepoControllableResource child = (RiRepoControllableResource)this.provider().lookup(sourceLoc, feedback);
        if (child == null) {
            throw new WvcmException("Repository resource does not exist: " + sourceLoc, WvcmException.ReasonCode.NOT_FOUND);
        }
        RiRepoResource destinationResource = (RiRepoResource)child.provider().lookup(destination, feedback);
        boolean bl = destinationExists = destinationResource != null;
        if (destinationExists && !overwrite) {
            throw new WvcmException("There already is a resource at the destination, and overwrite is false", WvcmException.ReasonCode.CANNOT_OVERWRITE);
        }
        if (this.versionKnowsParent()) {
            if (child.isControlled() && !child.getIsCheckedOut()) {
                child.doCheckout(null, null);
            }
        } else if (!(child instanceof RiRepoWorkspace) && child.isControlled() && !(srcParent = (RiRepoControllableFolder)this.provider().lookup(sourceFolderLocation, feedback)).getIsCheckedOut()) {
            srcParent.doCheckout(null, null);
        }
        RiRepoControllableFolder destinationParent = destParent;
        boolean destinationIsWorkspaceLocation = false;
        if (child instanceof RiRepoWorkspace) {
            if (destinationParent != child.get_repo().getWorkspaceFolder()) {
                throw new WvcmException("Invalid destination location", WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
            }
            destinationIsWorkspaceLocation = true;
        }
        if (!this.versionKnowsParent() && !destinationIsWorkspaceLocation && child.isControlled() && !destParent.getIsCheckedOut()) {
            destParent.doCheckout(null, null);
        }
        if (destinationExists) {
            this.doUnbindChild(bindingName, feedback);
        }
        if ((binding = child.getParentBinding(sourceLoc)) == null) {
            throw new IllegalStateException("doUnbind: Parent binding not found");
        }
        destinationParent.setupBinding(bindingName, child);
        binding.unbind();
        if (!(child instanceof RiRepoWorkspace)) {
            child.setProperty(ControllableResource.WORKSPACE, destParent.getWorkspace());
        }
    }

    @Override
    public void doUnbindChild(String bindingName, SrvcFeedback feedback) throws WvcmException {
        Map<String, RiRepoIFolder.RepoBinding> childBindings = this.getChildBindingsMap();
        RiRepoIFolder.RepoBinding binding = childBindings.get(bindingName);
        if (binding == null) {
            throw new WvcmException("Repository resource does not exist: " + this.calculatePath() + "/" + bindingName, WvcmException.ReasonCode.NOT_FOUND);
        }
        RiRepoControllableResource child = (RiRepoControllableResource)binding.get_bindingMember();
        if (child.isControlled() && !(child instanceof RiRepoWorkspace)) {
            if (this.versionKnowsParent()) {
                RiRepoVersion childV = child.getCheckedIn();
                if (childV == null) {
                    childV = child.getCheckedOut();
                }
                child.getWorkspace().deleted.put(childV.getVersionHistory(), child.getCheckedIn());
            } else if (!this.getIsCheckedOut()) {
                this.doCheckout(null, null);
            }
        }
        binding.unbind();
    }

    public static RiRepoControllableFolder doBaselineControl(SrvcProvider provider, Location rootFolderLocation, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        RiRepo repo = RiRepo.get_Repo(rootFolderLocation, provider);
        SrvcResource root = provider.lookup(rootFolderLocation, feedback);
        RiRepoControllableFolder rootFolder = null;
        if (root == null) {
            rootFolder = (RiRepoControllableFolder)RiRepoControllableFolder.doCreateResource(provider, rootFolderLocation, updates, updated, feedback);
        } else {
            if (!(root instanceof RiRepoControllableFolder)) {
                throw new WvcmException("Can only baseline control a controllable folder", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
            }
            rootFolder = (RiRepoControllableFolder)root;
            if (updates != null) {
                rootFolder.set_creationInProgress(true);
                rootFolder.doWriteProperties(updates, updated, feedback);
                rootFolder.set_creationInProgress(false);
            }
        }
        RiRepoWorkspace workspace = rootFolder.getWorkspace();
        List<RiRepoControllableFolder> workspaceControlledFolders = workspace.getBaselineControlledFolderList();
        if (workspaceControlledFolders.contains(rootFolder)) {
            throw new WvcmException("Folder is already associated with a Configuration", WvcmException.ReasonCode.CONTROLLED_CONFIGURATION_ALREADY_EXISTS);
        }
        if (!rootFolder.isControlled()) {
            rootFolder.doVersionControl(feedback);
        }
        rootFolder.checkNoCheckedOutBaselineControlledFolderMembers();
        String baselineHistoryName = repo.createUniqueComponentLocation(rootFolderLocation.lastSegment());
        RiRepoComponent component = new RiRepoComponent(repo.getBaselineHistoryFolder(), baselineHistoryName, provider, repo);
        RiRepoVersionHistory rootVersionHistory = rootFolder.getVersionHistory();
        rootVersionHistory._componentRootOf = component;
        component._componentRoot = rootVersionHistory;
        String baselineName = component.createUniqueBaselineLocation();
        RiRepoBaseline baseline = new RiRepoBaseline(component, baselineName, provider, repo);
        ArrayList<RiRepoVersion> baselineVersions = new ArrayList<RiRepoVersion>();
        rootFolder.createBaselineVersionList(baselineVersions);
        baseline.setPropertyEx(Baseline.VERSION_LIST, baselineVersions);
        baseline.setPropertyEx(Baseline.ACTIVITY, workspace.getProperty(Workspace.STREAM));
        rootFolder.putUnderBaselineControl(baseline);
        return rootFolder;
    }

    public static RiRepoControllableFolder doCreateBaselineControlledFolder(SrvcProvider provider, Location rootFolderLocation, Location baselineLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource res;
        SrvcResource baselineArg = provider.getSrvcRes(baselineLoc, feedback);
        if (!(baselineArg instanceof RiRepoBaseline)) {
            throw new WvcmException("Must be a baseline", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
        }
        RiRepoBaseline baseline = (RiRepoBaseline)baselineArg;
        if (provider.lookup(rootFolderLocation, feedback) != null) {
            throw new WvcmException("Not a valid location for a controllable folder", WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
        }
        RiRepoControllableFolder parent = null;
        Location parentLoc = rootFolderLocation.parent();
        if (parentLoc != null && (res = provider.lookup(parentLoc, feedback)) != null && res instanceof RiRepoControllableFolder) {
            parent = (RiRepoControllableFolder)res;
        }
        if (parent == null) {
            throw new WvcmException("Not a valid location for a controllable folder: " + rootFolderLocation, WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
        }
        RiRepoControllableFolder rootFolder = RiRepoControllableFolder.createBaselineControlledFolder(parent, rootFolderLocation.lastSegment(), baseline, feedback);
        if (updates != null) {
            rootFolder.set_creationInProgress(true);
            rootFolder.doWriteProperties(updates, updated, feedback);
            rootFolder.set_creationInProgress(false);
        }
        return rootFolder;
    }

    public static RiRepoControllableFolder createBaselineControlledFolder(RiRepoControllableFolder parent, String bindingName, RiRepoBaseline baseline, SrvcFeedback feedback) throws WvcmException {
        RiRepoWorkspace workspace = parent.getWorkspace();
        RiRepoVersionHistory baselineHistory = baseline.getVersionHistory();
        List<RiRepoControllableFolder> otherBaselineControlledFolders = workspace.getBaselineControlledFolderList();
        int i = 0;
        while (i < otherBaselineControlledFolders.size()) {
            RiRepoControllableFolder otherFolder = otherBaselineControlledFolders.get(i);
            RiRepoConfiguration otherFolderConfiguration = otherFolder.getRootFolderOf();
            RiRepoVersionHistory otherConfigurationBaselineHistory = otherFolderConfiguration.getVersionHistory();
            if (baselineHistory == otherConfigurationBaselineHistory) {
                throw new WvcmException("There MUST NOT be another folder in the workspace of this ControllableFolder whose Configuration property identifies a configuration for the baseline history of that baseline.", WvcmException.ReasonCode.CANNOT_HAVE_MULTIPLE_BASELINE_CONTROLLED_FOLDERS);
            }
            ++i;
        }
        RiRepoFolderVersion root = baseline.getRootVersion();
        RiRepoVersionHistory vh = root.getVersionHistory();
        RiRepoControllableFolder rootFolder = (RiRepoControllableFolder)parent.updateAdded(workspace, vh, root, bindingName, feedback);
        baseline.setBaselineControlledFolderMembers(rootFolder, feedback);
        rootFolder.putUnderBaselineControl(baseline);
        return rootFolder;
    }

    public Map<String, RiRepoResource> getChildMap() {
        return this.getMapProperty(Folder.CHILD_MAP);
    }

    public List<RiRepoControllableResource> getChildList() {
        return this.getListProperty(Folder.CHILD_LIST);
    }

    public List<RiRepoIFolder.RepoBinding> getChildBindingList() {
        return this.getListProperty(RiRepoIFolder.CHILD_BINDING_LIST);
    }

    public boolean getIsBaselineControlled() {
        return this.getPropertyAsBoolean(ControllableFolder.IS_BASELINE_CONTROLLED);
    }

    public RiRepoConfiguration getRootFolderOf() {
        return (RiRepoConfiguration)this.getProperty(ControllableFolder.ROOT_FOLDER_OF);
    }
}

