/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.repo;

import com.ibm.rational.wvcm.ri.impl.ActivityImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.repo.RiRepo;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoStream;
import com.ibm.rational.wvcm.ri.repo.RiRepoTask;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersionHistory;
import com.ibm.rational.wvcm.ri.repo.RiRepoWorkspace;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wvcm.Activity;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Task;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiRepoActivity
extends RiRepoResource {
    @Override
    public Class<?> get_proxyClass() {
        return ActivityImpl.class;
    }

    protected RiRepoActivity(RiRepoResource parent, String bindingName, SrvcProvider provider, RiRepo repo) {
        super(parent, bindingName, provider, repo);
        this.initialize();
    }

    private void initialize() {
        this.createProperty(Activity.ACTIVITY_CHECKOUT_LIST, new ArrayList());
        this.createProperty(Activity.ACTIVITY_VERSION_LIST, new ArrayList());
        this.createProperty(Activity.IS_COMPLETE, Boolean.FALSE);
        this.createProperty(Activity.CURRENT_WORKSPACE_LIST, new ArrayList());
        this.createProperty(Activity.TASK_LIST, new ArrayList());
        this.createProperty(Activity.ORIGIN_WORKSPACE, null);
        this.createProperty(Activity.LATEST_VERSION_LIST, null);
    }

    @Override
    protected boolean handleCalculatedProperties(PropertyNameList.PropertyName<?> propertyName, Object[] calculatedValue) {
        if (propertyName.equals((Object)Activity.LATEST_VERSION_LIST)) {
            ArrayList<RiRepoVersion> list = new ArrayList<RiRepoVersion>();
            List<RiRepoVersion> actVersionList = this.getActivityVersionList();
            int i = 0;
            while (i < actVersionList.size()) {
                RiRepoVersion version = actVersionList.get(i);
                RiRepoVersionHistory vh = version.getVersionHistory();
                try {
                    RiRepoVersion latestVersion = vh.getLatestActivityVersionReport(this);
                    if (!list.contains(latestVersion)) {
                        list.add(latestVersion);
                    }
                }
                catch (WvcmException ex) {
                    ex.printStackTrace();
                }
                ++i;
            }
            calculatedValue[0] = list;
            return true;
        }
        if (RiRepoFolder.handleCalculatedPropertiesHelper(this, propertyName, calculatedValue)) {
            return true;
        }
        return super.handleCalculatedProperties(propertyName, calculatedValue);
    }

    @Override
    protected void postSetPropertyEx(PropertyNameList.PropertyName<?> propertyName, Object oldValue, Object value) {
        super.postSetPropertyEx(propertyName, oldValue, value);
        if (propertyName.equals((Object)Activity.TASK_LIST)) {
            RiRepoTask task = (RiRepoTask)oldValue;
            if (task != null) {
                task.setProperty_RemoveFromList(Task.ACTIVITY_LIST, this);
            }
            if ((task = (RiRepoTask)value) != null) {
                task.setProperty_AppendUniqueToList(Task.ACTIVITY_LIST, this);
            }
        }
    }

    public void verifyIsNotComplete() throws WvcmException {
        if (this.getIsComplete()) {
            throw new WvcmException("Cannot modify checkout-list or activity-version-list when activity is complete", WvcmException.ReasonCode.CONFLICT);
        }
    }

    public static RiRepoActivity doCreateActivity(SrvcProvider provider, Location loc, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        RiRepo repo = RiRepo.get_Repo(loc, provider);
        RiRepoResource parent = RiRepoActivity.getParentResource(provider, loc);
        if (parent != parent.get_repo().getActivityFolder()) {
            throw new WvcmException("Activity location is invalid: " + loc, WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
        }
        RiRepoActivity sActivity = (RiRepoActivity)provider.lookup(loc, feedback);
        if (sActivity != null) {
            throw new WvcmException("Activity already exists: " + loc, WvcmException.ReasonCode.RESOURCE_ALREADY_EXISTS_AT_LOCATION);
        }
        String bindingName = loc.lastSegment();
        sActivity = isStream ? new RiRepoStream(parent, bindingName, provider, repo) : new RiRepoActivity(parent, bindingName, provider, repo);
        sActivity.set_creationInProgress(true);
        sActivity.doWriteProperties(updates, updated, feedback);
        sActivity.set_creationInProgress(false);
        return sActivity;
    }

    public static RiRepoActivity doCreateGeneratedActivity(SrvcProvider provider, Location loc, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        RiRepo repo = RiRepo.get_Repo(loc, provider);
        Location activityLoc = loc;
        RiRepoFolder parent = repo.getActivityFolder();
        String bindingName = activityLoc.lastSegment();
        if (bindingName == null) {
            bindingName = isStream ? "stream" : "act";
        }
        activityLoc = repo.getActivityFolderLocation().child(bindingName);
        RiRepoActivity existingActivity = (RiRepoActivity)parent.lookupBoundMember(bindingName);
        if (existingActivity != null) {
            activityLoc = repo.createUniqueGeneratedLocation(provider, activityLoc);
        }
        bindingName = activityLoc.lastSegment();
        RiRepoActivity newActivity = null;
        newActivity = isStream ? new RiRepoStream(parent, bindingName, provider, repo) : new RiRepoActivity(parent, bindingName, provider, repo);
        if (updates != null) {
            newActivity.set_creationInProgress(true);
            newActivity.doWriteProperties(updates, updated, feedback);
            newActivity.set_creationInProgress(false);
        }
        return newActivity;
    }

    public List<RiRepoVersion> getActivityVersionList() {
        return this.getListProperty(Activity.ACTIVITY_VERSION_LIST);
    }

    public List<RiRepoControllableResource> getActivityCheckoutList() {
        return this.getListProperty(Activity.ACTIVITY_CHECKOUT_LIST);
    }

    public boolean getIsComplete() {
        return this.getPropertyAsBoolean(Activity.IS_COMPLETE);
    }

    public List<RiRepoWorkspace> getCurrentWorkspaceList() {
        return this.getListProperty(Activity.CURRENT_WORKSPACE_LIST);
    }

    public List<RiRepoVersion> getLatestVersionList() {
        return this.getListProperty(Activity.LATEST_VERSION_LIST);
    }
}

