/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.repo;

import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.repo.RiLocation;
import com.ibm.rational.wvcm.ri.repo.RiRepo;
import com.ibm.rational.wvcm.ri.repo.RiRepoActivity;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableSymbolicLink;
import com.ibm.rational.wvcm.ri.repo.RiRepoResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoTask;
import com.ibm.rational.wvcm.ri.repo.RiRepoWorkspace;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiProvider
extends SrvcProvider {
    public static String IA_REPO_NAME = "com.ibm.rational.wvcm.ri.repo.REPO_NAME";
    protected String _userName;

    public String repoName() {
        return this.initArgs().get(IA_REPO_NAME);
    }

    public boolean crHasOneParent() {
        return this.initArgs().get("com.ibm.rational.wvcm.CR_HAS_ONE_PARENT") != null;
    }

    public boolean streamForgetsUnboundVersions() {
        return this.initArgs().get("com.ibm.rational.wvcm.STREAM_FORGETS_UNBOUND_VERSIONS") != null;
    }

    public String get_userName() {
        return this._userName;
    }

    public RiProvider() {
    }

    @Override
    public void initialize(Map<String, String> initArgs, ProviderFactory.Callback callback) throws WvcmException {
        super.initialize(initArgs, callback);
        this.login(callback);
    }

    public RiProvider(ProviderFactory.Callback callback) {
        super(callback);
        this.login(callback);
    }

    public RiProvider(ProviderFactory.Callback callback, Map<String, String> args) {
        super(callback, args);
        this.login(callback);
    }

    protected void login(ProviderFactory.Callback callback) {
        try {
            ProviderFactory.Callback.Authentication auth;
            ProviderFactory.Callback.Authentication authentication = auth = callback == null ? null : callback.getAuthentication("realm", 0);
            if (auth == null) {
                this._userName = "anonymous";
            } else {
                this._userName = auth.loginName();
                String password = auth.password();
                if (password.equals("bad")) {
                    throw new RuntimeException("bad password");
                }
            }
        }
        catch (WvcmException wvcmException) {
            this._userName = "";
        }
    }

    @Override
    public RiLocation rootLocation() {
        String repoName = this.initArgs().get(IA_REPO_NAME);
        if (repoName != null) {
            return RiRepo.get_Repo((String)repoName, (SrvcProvider)this).rootFolderLocation;
        }
        return RiRepo.get_Repo((SrvcProvider)this).rootFolderLocation;
    }

    @Override
    public RiLocation relativeRootLocation() {
        String repoName = this.initArgs().get(IA_REPO_NAME);
        if (repoName != null) {
            return RiRepo.get_Repo((String)repoName, (SrvcProvider)this).relativeRootLocation;
        }
        return RiRepo.get_Repo((SrvcProvider)this).relativeRootLocation;
    }

    @Override
    public RiLocation location(String string) throws WvcmException {
        return new RiLocation(string);
    }

    @Override
    public SrvcResource lookup(Location location, SrvcFeedback feedback) throws WvcmException {
        String path = location.string();
        String[] segments = path.split("/");
        if (segments.length < 2) {
            return null;
        }
        if (segments[0].length() != 0) {
            return null;
        }
        RiRepo repo = RiRepo._repoMap.get(segments[1]);
        if (repo == null) {
            return null;
        }
        RiRepoResource res = repo.rootFolder;
        if (segments[2].equals("uuid") && (res = repo.getResourceFromId(segments[3])) == null) {
            return null;
        }
        int i = 4;
        while (i < segments.length) {
            if ((res = res.lookupBoundMember(segments[i])) == null) {
                return res;
            }
            ++i;
        }
        res.set_provider(this);
        return res;
    }

    @Override
    public SrvcResource doWriteContent(Location location, InputStream content, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource srvcResource = this.lookup(location, feedback);
        if (srvcResource == null) {
            srvcResource = this.doCreateControllableResource(location, updates, updated, feedback.nest(50));
            updates.clear();
        }
        ((RiRepoResource)srvcResource).doWriteContent(content, contentIdentifier, updates, updated, feedback);
        return srvcResource;
    }

    @Override
    public SrvcResource doCreateControllableResource(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return RiRepoControllableResource.doCreateControllableResource(this, location, updates, updated, feedback);
    }

    @Override
    public SrvcResource doCreateVersionControlledResource(Location location, Location versionLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return RiRepoControllableResource.doCreateVersionControlledResource(this, location, versionLoc, false, updates, updated, feedback);
    }

    @Override
    public SrvcResource doCreateControllableSymbolicLink(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return RiRepoControllableSymbolicLink.doCreateResource(this, location, updates, updated, feedback);
    }

    @Override
    public SrvcResource doCreateControllableFolder(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return RiRepoControllableFolder.doCreateResource(this, location, updates, updated, feedback);
    }

    @Override
    public SrvcResource doCreateWorkspace(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return RiRepoWorkspace.doCreateResource(this, location, updates, updated, feedback);
    }

    @Override
    public SrvcResource doCreateGeneratedWorkspace(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return RiRepoWorkspace.doCreateGeneratedWorkspace(this, location, updates, updated, feedback);
    }

    @Override
    public SrvcResource doCreateActivity(Location location, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return RiRepoActivity.doCreateActivity(this, location, isStream, updates, updated, feedback);
    }

    @Override
    public SrvcResource doCreateGeneratedActivity(Location location, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return RiRepoActivity.doCreateGeneratedActivity(this, location, isStream, updates, updated, feedback);
    }

    @Override
    public SrvcResource doCreateGeneratedTask(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return RiRepoTask.doCreateGeneratedTask(this, location, updates, updated, feedback);
    }

    @Override
    public SrvcResource doBaselineControl(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return RiRepoControllableFolder.doBaselineControl(this, location, updates, updated, feedback);
    }

    @Override
    public SrvcResource doCreateBaselineControlledFolder(Location location, Location baselineLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return RiRepoControllableFolder.doCreateBaselineControlledFolder(this, location, baselineLoc, updates, updated, feedback);
    }

    @Override
    public SrvcResource doFind(Resource query, SrvcFeedback feedback) throws WvcmException {
        List<SrvcResource> objects = RiRepoResource.doFind(query, false, feedback);
        if (objects.isEmpty()) {
            return null;
        }
        return objects.get(0);
    }

    @Override
    public List<SrvcResource> doFindAll(Resource query, SrvcFeedback feedback) throws WvcmException {
        return RiRepoResource.doFind(query, true, feedback);
    }
}

