/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.internal.util.LocationUtil;
import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.ClientHttpUtil;
import com.ibm.team.repository.transport.client.IOAuthHandler;
import com.ibm.team.repository.transport.client.RemoteTeamServer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.eclipse.core.runtime.IStatus;

public class OAuthUtil {
    public static final String BLANK_PAGE_URI = "web/com.ibm.team.repository.web/ui/internal/oauth/OAuthRedirectPopup.html";
    private static final String X_OAUTH_AUTHORIZATION_URL = "X-jazz-web-oauth-url";
    private static final String OAUTH_CALLBACK = "oauth_callback";
    public static final String AUTHORIZED_REQUEST_TOKEN_PARAM_NAME = "oauth_token";
    public static final String REQUEST_TOKEN_SECRET_PARAM_NAME = "request_token_secret";
    public static final String OAUTH_PROVIDER = "oauth_provider";
    static Pattern _queryPattern = Pattern.compile("^(.*?)([?][^#]*)?(#.*)?$");

    public static int handleOAuthChallenge(int status, RemoteTeamServer remoteTeamServer, HttpMethod httpMethod, IOAuthHandler oauthHandler, String redirectUrl) throws MalformedURLException, URIException, TeamServiceException, UnsupportedEncodingException, URISyntaxException {
        AuthenticationException authEx;
        block19: {
            Header oauthUriHeader;
            IOAuthHandler.IResponse oauthAuthResponse = null;
            String authorizeUri = null;
            String[] oauthTokens = null;
            if (status == 401 && (oauthUriHeader = httpMethod.getResponseHeader(X_OAUTH_AUTHORIZATION_URL)) != null && oauthHandler != null) {
                String oauthUri = oauthUriHeader.getValue();
                if (oauthUri == null || oauthUri.length() == 0) {
                    throw new IllegalArgumentException(String.format("Missing value for %s header", X_OAUTH_AUTHORIZATION_URL));
                }
                oauthTokens = OAuthUtil.parseOAuthTokens(oauthUri);
                authorizeUri = OAuthUtil.buildOAuthRedirectUrl(new URI(oauthUri), oauthTokens, redirectUrl);
                oauthAuthResponse = oauthHandler.authorize(authorizeUri);
            }
            if (oauthAuthResponse == null || oauthAuthResponse.getCallbackURL() == null) {
                return status;
            }
            if (oauthAuthResponse.getStatus() != null && !oauthAuthResponse.getStatus().isOK()) {
                IStatus errorStatus = oauthAuthResponse.getStatus();
                throw new TeamServiceException(errorStatus.getMessage(), errorStatus.getException());
            }
            String tokenQuery = String.format("%s=%s", AUTHORIZED_REQUEST_TOKEN_PARAM_NAME, LocationUtil.encode((String)oauthTokens[0]));
            String secretQuery = String.format("%s=%s", REQUEST_TOKEN_SECRET_PARAM_NAME, LocationUtil.encode((String)oauthTokens[1]));
            String providerQuery = null;
            if (oauthTokens[2] != null) {
                providerQuery = String.format("%s=%s", OAUTH_PROVIDER, oauthTokens[2]);
            }
            String originalUri = httpMethod.getURI().getEscapedURI();
            String newUri = OAuthUtil.stripOAuthParms(originalUri);
            Matcher matches = _queryPattern.matcher(newUri);
            matches.matches();
            String prefix = matches.group(1);
            String query = matches.group(2);
            String fragment = matches.group(3);
            if (fragment == null) {
                fragment = "";
            }
            StringBuffer queryBuf = new StringBuffer();
            if (query != null) {
                queryBuf.append(query);
                queryBuf.append('&');
            } else {
                queryBuf.append('?');
            }
            queryBuf.append(tokenQuery);
            queryBuf.append('&');
            queryBuf.append(secretQuery);
            if (providerQuery != null) {
                queryBuf.append('&');
                queryBuf.append(providerQuery);
            }
            newUri = String.valueOf(prefix) + queryBuf.toString() + fragment;
            httpMethod.releaseConnection();
            httpMethod.setRequestHeader("Connection", "Close");
            httpMethod.setPath(newUri);
            TeamServiceCallContextImpl.setUpCall((HttpMethod)httpMethod);
            authEx = null;
            try {
                status = ClientHttpUtil.executeHttpMethod(remoteTeamServer, null, httpMethod, false, true);
            }
            catch (AuthenticationException e) {
                status = 401;
                try {
                    status = OAuthUtil.handleOAuthChallenge(status, remoteTeamServer, httpMethod, oauthHandler, redirectUrl);
                    if (status == 401) {
                        authEx = e;
                    }
                }
                catch (Exception ex) {
                    throw new TeamServiceException(ex.getMessage(), (Throwable)ex);
                }
                httpMethod.setPath(originalUri);
                TeamServiceCallContextImpl.tearDownCall();
                break block19;
            }
            catch (IOException e) {
                try {
                    throw new TeamServiceException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    httpMethod.setPath(originalUri);
                    TeamServiceCallContextImpl.tearDownCall();
                    throw throwable;
                }
            }
            httpMethod.setPath(originalUri);
            TeamServiceCallContextImpl.tearDownCall();
        }
        if (status == 401 && authEx != null) {
            throw authEx;
        }
        return status;
    }

    private static String[] parseOAuthTokens(String uri) throws URISyntaxException, UnsupportedEncodingException {
        String name;
        StringTokenizer parmTokenizer;
        String oauthCallbackUri = null;
        String oauthSecret = null;
        String oauthToken = null;
        String oauthProviderUri = null;
        String[] tokens = new String[3];
        String queryString = new URI(uri).getRawQuery();
        StringTokenizer queryTokenizer = new StringTokenizer(queryString, "&");
        while (queryTokenizer.hasMoreTokens()) {
            parmTokenizer = new StringTokenizer(queryTokenizer.nextToken(), "=");
            if (parmTokenizer.countTokens() == 0) continue;
            name = parmTokenizer.nextToken();
            if (name.toLowerCase().equals(OAUTH_CALLBACK)) {
                oauthCallbackUri = LocationUtil.decode((String)parmTokenizer.nextToken());
                continue;
            }
            if (!name.toLowerCase().equals(AUTHORIZED_REQUEST_TOKEN_PARAM_NAME)) continue;
            oauthToken = LocationUtil.decode((String)parmTokenizer.nextToken());
        }
        if (oauthCallbackUri == null) {
            throw new IllegalArgumentException(String.format("Absence of oauth callback in \"%s\" during OAuth parsing and redirection handling", uri));
        }
        if (oauthToken == null) {
            throw new IllegalArgumentException(String.format("Absence of oauth token in \"%s\" during OAuth parsing and redirection handling", uri));
        }
        queryString = new URI(oauthCallbackUri).getRawQuery();
        if (queryString == null || queryString.length() == 0) {
            throw new IllegalArgumentException(String.format("Absence of oauth token in \"%s\" during OAuth parsing and redirection handling", uri));
        }
        queryTokenizer = new StringTokenizer(queryString, "&");
        while (queryTokenizer.hasMoreTokens()) {
            parmTokenizer = new StringTokenizer(queryTokenizer.nextToken(), "=");
            if (parmTokenizer.countTokens() == 0) continue;
            name = parmTokenizer.nextToken();
            if (name.toLowerCase().equals(REQUEST_TOKEN_SECRET_PARAM_NAME)) {
                oauthSecret = LocationUtil.decode((String)parmTokenizer.nextToken());
                continue;
            }
            if (!name.toLowerCase().equals(OAUTH_PROVIDER)) continue;
            oauthProviderUri = parmTokenizer.nextToken();
        }
        if (oauthSecret == null) {
            throw new IllegalArgumentException(String.format("Absence of oauth token in \"%s\" during OAuth parsing and redirection handling", uri));
        }
        tokens[0] = oauthToken;
        tokens[1] = oauthSecret;
        tokens[2] = oauthProviderUri;
        return tokens;
    }

    private static String stripOAuthParms(String uri) throws URISyntaxException, MalformedURLException, UnsupportedEncodingException {
        Matcher matches = _queryPattern.matcher(uri);
        matches.matches();
        String prefix = matches.group(1);
        String query = matches.group(2);
        String fragment = matches.group(3);
        if (fragment == null) {
            fragment = "";
        }
        if (query != null) {
            query = query.length() > 1 ? query.substring(1) : null;
        }
        Map queryParms = LocationUtil.parseQueryParameters((String)query);
        String queryString = LocationUtil.queryString((Map)queryParms, (String[])new String[]{OAUTH_PROVIDER, AUTHORIZED_REQUEST_TOKEN_PARAM_NAME, REQUEST_TOKEN_SECRET_PARAM_NAME});
        StringBuffer buf = new StringBuffer(prefix);
        if (queryString.length() != 0) {
            buf.append('?');
            buf.append(queryString);
        }
        buf.append(fragment);
        return buf.toString();
    }

    private static String buildOAuthRedirectUrl(URI oauthRedirectUri, String[] oauthTokens, String callbackUri) throws URISyntaxException, UnsupportedEncodingException {
        String callbackQueryParm = String.format("%s?%s=%s", callbackUri, REQUEST_TOKEN_SECRET_PARAM_NAME, oauthTokens[1]);
        String redirectBase = OAuthUtil.extractBase(oauthRedirectUri);
        String blankRedirectPage = String.format("%s?%s=%s&%s=%s", redirectBase, OAUTH_CALLBACK, LocationUtil.encode((String)callbackQueryParm), AUTHORIZED_REQUEST_TOKEN_PARAM_NAME, LocationUtil.encode((String)oauthTokens[0]));
        return blankRedirectPage;
    }

    private static String extractBase(URI uri) {
        String redirectBase = uri.toString();
        int ndx = redirectBase.indexOf(63);
        if (ndx == -1) {
            throw new IllegalArgumentException(String.format("URI \"%s\" is missing expected query parameters", redirectBase));
        }
        redirectBase = redirectBase.substring(0, ndx);
        return redirectBase;
    }
}

