/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import com.ibm.team.repository.transport.client.InterruptableSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class InterruptableSocketFactory
implements ProtocolSocketFactory {
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SocketChannel channel = SocketChannel.open();
        return this.doConnect(channel.socket(), channel, host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        SocketChannel channel = SocketChannel.open();
        Socket socket = channel.socket();
        if (localAddress != null || localPort != 0) {
            socket.bind(new InetSocketAddress(localAddress, localPort));
        }
        return this.doConnect(socket, channel, host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        SocketChannel channel = SocketChannel.open();
        Socket socket = channel.socket();
        if (params.isParameterSet("http.tcp.nodelay")) {
            socket.setTcpNoDelay(params.getTcpNoDelay());
        }
        if (params.isParameterSet("http.socket.sendbuffer")) {
            socket.setSendBufferSize(params.getSendBufferSize());
        }
        if (params.isParameterSet("http.socket.receivebuffer")) {
            socket.setReceiveBufferSize(params.getReceiveBufferSize());
        }
        if (params.isParameterSet("http.socket.timeout")) {
            socket.setSoTimeout(params.getSoTimeout());
        }
        if (localAddress != null || localPort != 0) {
            socket.bind(new InetSocketAddress(localAddress, localPort));
        }
        return this.doConnect(socket, channel, host, port, params);
    }

    protected Socket doConnect(Socket socket, SocketChannel channel, String remoteHost, int remotePort) throws IOException {
        return this.doConnect(socket, channel, remoteHost, remotePort, null);
    }

    protected Socket doConnect(Socket socket, SocketChannel channel, String remoteHost, int remotePort, HttpConnectionParams params) throws IOException {
        channel.configureBlocking(true);
        Thread currentThread = Thread.currentThread();
        TeamServiceCallContextImpl.registerConnectingSocket((SocketChannel)channel, (Thread)currentThread);
        try {
            InetSocketAddress remoteSocketAddress = new InetSocketAddress(remoteHost, remotePort);
            channel.connect(remoteSocketAddress);
            Socket socket2 = InterruptableSocket.newInterruptableSocket(socket, channel, params);
            return socket2;
        }
        finally {
            TeamServiceCallContextImpl.unregisterConnectingSocket((Thread)currentThread);
        }
    }
}

