/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy;

import com.ibm.team.filesystem.client.internal.daemon.Messages;
import com.ibm.team.filesystem.client.internal.http.constants.ResponseCode;
import com.ibm.team.filesystem.client.internal.marshalling.EObjectJSONDeserializer;
import com.ibm.team.filesystem.client.internal.marshalling.IDeserializer;
import com.ibm.team.filesystem.client.internal.marshalling.ISerializer;
import com.ibm.team.filesystem.client.internal.marshalling.ParameterWrapperSerializer;
import com.ibm.team.filesystem.client.restproxy.HttpClientWrapper;
import com.ibm.team.filesystem.client.restproxy.RestInvocationParticipant;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestAuthenticationException;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestHttpException;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestMarshallingException;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestTransportException;
import com.ibm.team.filesystem.client.restproxy.notification.ClientNotificationChannel;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestInvocationHandler
implements InvocationHandler {
    public static final boolean DEBUG_HIDE_MARSHALLING = System.getProperty("debug.rest.hide_marshalling") != null;
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_POST = "post";
    private final Class<?> wrapped;
    private final String uri;
    private final HttpClientWrapper client;
    private final ISerializer serializer;
    private final IDeserializer deserializer;
    private final LinkedList<RestInvocationParticipant> participants = new LinkedList();
    private ClientNotificationChannel channel;

    public RestInvocationHandler(Class<?> proxying, String baseUri, HttpClientWrapper client, ISerializer serializer, IDeserializer deserializer) {
        this.wrapped = proxying;
        this.uri = baseUri.endsWith("/") ? baseUri : String.valueOf(baseUri) + '/';
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.client = client;
    }

    public RestInvocationHandler(Class<?> proxying, String baseUri, HttpClientWrapper client) {
        this(proxying, baseUri, client, new ParameterWrapperSerializer(), new EObjectJSONDeserializer());
    }

    private HttpMethod generateRequest(RestInvocationParticipant.CallKey key, Method method) {
        GetMethod request;
        String methodName = method.getName();
        if (methodName.startsWith(PREFIX_GET)) {
            request = new GetMethod();
        } else if (methodName.startsWith(PREFIX_POST)) {
            request = new PostMethod();
        } else {
            throw new IllegalArgumentException("only know how to handle get* and post*");
        }
        request.getParams().setParameter("http.method.retry-handler", (Object)new HttpMethodRetryHandler(){

            public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
                return false;
            }
        });
        return request;
    }

    public String getBaseUri() {
        return this.uri;
    }

    public static String generateURI(Class<?> type, String baseUri, Method method) {
        String lastRemoteSegment = null;
        String methodName = method.getName();
        if (methodName.startsWith(PREFIX_GET)) {
            lastRemoteSegment = methodName.substring(PREFIX_GET.length());
        } else if (methodName.startsWith(PREFIX_POST)) {
            lastRemoteSegment = methodName.substring(PREFIX_POST.length());
        } else {
            throw new IllegalArgumentException("Only know how to handle get*/post*. Method \"" + methodName + "\" is invalid.");
        }
        return String.valueOf(baseUri) + "service" + '/' + type.getCanonicalName() + "/" + lastRemoteSegment;
    }

    private void generateParameters(Object proxy, Method method, String encoding, Object[] args, HttpMethod request) {
        if (args != null && args[0] instanceof IParameterWrapper) {
            Class<?> parameterType = method.getParameterTypes()[0];
            String queryString = this.serializer.serialize(parameterType, args[0], request);
            if (request instanceof GetMethod) {
                request.setQueryString(queryString);
            } else if (request instanceof PostMethod) {
                this.generatePostParameters(proxy, method, encoding, queryString, (PostMethod)request);
            } else {
                throw new IllegalArgumentException("Don't know how to handle request type " + request.getName());
            }
        }
    }

    private void generatePostParameters(Object proxy, Method method, String encoding, String queryString, PostMethod request) {
        ByteArrayRequestEntity requestEntity;
        try {
            requestEntity = new ByteArrayRequestEntity(queryString.getBytes(encoding), HttpUtil.MediaType.FORM_URLENCODED.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RestMarshallingException(e);
        }
        request.setRequestEntity((RequestEntity)requestEntity);
    }

    protected Object executeAndReturnResult(RestInvocationParticipant.CallKey key, HttpMethod request, Method method, Object[] args) throws Throwable {
        this.executeRequest(key, request, method, args);
        return this.deserializer.deserialize(this.wrapped.getClassLoader(), request.getResponseBodyAsStream(), method.getReturnType());
    }

    /*
     * Unable to fully structure code
     */
    protected void executeRequest(RestInvocationParticipant.CallKey key, HttpMethod request, Method method, Object[] args) throws Throwable {
        for (RestInvocationParticipant part : this.participants) {
            part.preRequest(key, request);
        }
        code = -1;
        t = null;
        try {
            try {
                code = this.client.client.executeMethod(request);
            }
            catch (IllegalStateException e) {
                t = e;
                throw new RestHttpException(request, (Exception)e);
            }
            catch (HttpException e) {
                t = e;
                throw new RestHttpException(request, (Exception)e);
            }
            catch (IOException e) {
                t = e;
                throw new RestTransportException("Failure when connecting to: " + request.getURI(), e);
            }
        }
        finally {
            ** for (part : this.participants)
        }
lbl-1000:
        // 1 sources

        {
            part.postRequest(key, request, t);
            continue;
        }
lbl23:
        // 1 sources

        if (code == ResponseCode.OK.getCode()) {
            return;
        }
        if (code == ResponseCode.FORBIDDEN.getCode()) {
            throw new RestAuthenticationException(null);
        }
        if (this.requestContainsStackTrace(request)) {
            throw this.deserializer.deserializeError(request, this.wrapped.getClassLoader(), String.valueOf(request.getName()) + " " + request.getURI());
        }
        if (code == ResponseCode.INTERNAL_SERVER_ERROR.getCode()) {
            throw new RestTransportException("Internal server error without stack trace: " + request.getStatusText());
        }
        if (code == ResponseCode.BAD_REQUEST.getCode()) {
            throw new RestTransportException("Bad request without stack trace: " + request.getStatusText());
        }
        throw new RestHttpException("Unexpected status: " + code, request, null);
    }

    private boolean requestContainsStackTrace(HttpMethod request) {
        Header header = request.getResponseHeader("Content-Type");
        if (header == null) {
            return false;
        }
        HeaderElement[] elements = header.getElements();
        if (elements.length > 0) {
            return "application/vnd.ibm.jazz-json-stacktrace-1.0".equals(elements[0].getName());
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        key = new RestInvocationParticipant.CallKey();
        for (RestInvocationParticipant part : this.participants) {
            part.preInvoke(key, proxy, method, args);
        }
        result = null;
        thrown = null;
        try {
            try {
                result = this.invokeInternal(key, proxy, method, args);
            }
            catch (Throwable t) {
                thrown = t;
                throw t;
            }
        }
        finally {
            ** for (part : this.participants)
        }
lbl-1000:
        // 1 sources

        {
            part.postInvoke(key, proxy, method, args, result, thrown);
            continue;
        }
lbl18:
        // 1 sources

        return result;
    }

    private Object invokeInternal(RestInvocationParticipant.CallKey key, Object proxy, Method method, Object[] args) throws Throwable {
        assert (args == null || args.length == 1 && (args[0] == null || args[0] instanceof IParameterWrapper || args[0] instanceof IProgressMonitor) || args.length == 2 && (args[0] == null || args[0] instanceof IParameterWrapper) && (args[1] == null || args[1] instanceof IProgressMonitor));
        HttpMethod request = this.generateRequest(key, method);
        request.setURI(new URI(RestInvocationHandler.generateURI(this.wrapped, this.uri, method), true));
        this.generateParameters(proxy, method, "UTF-8", args, request);
        final LinkedList<Runnable> toRun = new LinkedList<Runnable>();
        RestInvocationParticipant.ISynchronousCallback cb = new RestInvocationParticipant.ISynchronousCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call(Runnable runnable) {
                LinkedList linkedList = toRun;
                synchronized (linkedList) {
                    toRun.add(runnable);
                    toRun.notifyAll();
                }
            }
        };
        boolean needsSynchronousParticipation = false;
        for (RestInvocationParticipant part : this.participants) {
            needsSynchronousParticipation |= part.setSynchronousCallback(key, request, proxy, method, args, cb);
        }
        this.client.beginRequest();
        try {
            if (needsSynchronousParticipation) {
                RequestExecutor re = new RequestExecutor(key, request, method, args, toRun);
                Object object = re.execute();
                return object;
            }
            Object object = this.executeAndReturnResult(key, request, method, args);
            return object;
        }
        finally {
            try {
                request.releaseConnection();
            }
            finally {
                this.client.endRequest();
            }
        }
    }

    protected void rethrow(Throwable ex) throws Throwable {
        StackTraceElement[] original = ex.getStackTrace();
        StackTraceElement[] current = Thread.currentThread().getStackTrace();
        StackTraceElement[] combined = new StackTraceElement[original.length + current.length];
        int i = original.length - 1;
        while (i >= 0) {
            combined[i] = original[i];
            --i;
        }
        int j = combined.length - 1;
        int i2 = current.length - 1;
        while (i2 >= 0) {
            combined[j] = current[i2];
            --j;
            --i2;
        }
        ex.setStackTrace(combined);
        throw ex;
    }

    public void addParticipant(RestInvocationParticipant part) {
        this.participants.add(part);
    }

    public void setNotificationChannel(ClientNotificationChannel channel) {
        this.channel = channel;
    }

    public ClientNotificationChannel getNotificationChannel() {
        return this.channel;
    }

    static /* synthetic */ LinkedList access$0(RestInvocationHandler restInvocationHandler) {
        return restInvocationHandler.participants;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RequestExecutor
    extends Job {
        public final RestInvocationParticipant.CallKey key;
        public Throwable ex;
        public Object result;
        public HttpMethod request;
        public Method method;
        public Object[] args;
        public LinkedList<Runnable> toRun;
        public boolean finished;

        public RequestExecutor(RestInvocationParticipant.CallKey key, HttpMethod request, Method method, Object[] args, LinkedList<Runnable> notifier) {
            super(Messages.getString("RestInvocationHandler.0"));
            this.key = key;
            this.request = request;
            this.method = method;
            this.args = args;
            this.toRun = notifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public Object execute() throws Throwable {
            this.schedule();
            do {
                var1_1 = this.toRun;
                synchronized (var1_1) {
                    this.toRun.wait(100L);
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 6] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                    if (true) ** GOTO lbl21
                }
                do {
                    completed = false;
                    try {
                        nextRunnable.run();
                        completed = true;
                    }
                    finally {
                        if (!completed) {
                            this.request.abort();
                        }
                    }
lbl21:
                    // 2 sources

                } while ((nextRunnable = this.nextRunnable()) != null);
                for (RestInvocationParticipant part : RestInvocationHandler.access$0(RestInvocationHandler.this)) {
                    part.duringInvoke(this.key, this.request);
                }
            } while (this.isAlive());
            if (this.ex != null) {
                RestInvocationHandler.this.rethrow(this.ex);
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Runnable nextRunnable() {
            LinkedList<Runnable> linkedList = this.toRun;
            synchronized (linkedList) {
                block4: {
                    if (!this.toRun.isEmpty()) break block4;
                    return null;
                }
                return this.toRun.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            LinkedList<Runnable> linkedList;
            IStatus iStatus;
            try {
                try {
                    this.result = RestInvocationHandler.this.executeAndReturnResult(this.key, this.request, this.method, this.args);
                }
                catch (Throwable e) {
                    this.ex = e;
                }
                iStatus = Status.OK_STATUS;
                linkedList = this.toRun;
            }
            catch (Throwable throwable) {
                LinkedList<Runnable> linkedList2 = this.toRun;
                synchronized (linkedList2) {
                    this.finished = true;
                    this.toRun.notifyAll();
                }
                throw throwable;
            }
            synchronized (linkedList) {
                this.finished = true;
                this.toRun.notifyAll();
            }
            return iStatus;
        }

        public boolean isAlive() {
            return this.getState() != 0 && !this.finished;
        }
    }
}

