/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy;

import com.ibm.team.filesystem.client.internal.utils.IDaemonRegistry;
import com.ibm.team.filesystem.client.restproxy.DaemonRegistry;
import java.io.File;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryEntry
implements IDaemonRegistry.IRegistryEntry {
    private final DaemonRegistry registry;
    private final String key;
    private final int port;
    private final String description;
    private final Collection<String> sandboxes;
    private final Map<String, String> properties;

    public RegistryEntry(DaemonRegistry registry, String key, int port, String description, Collection<String> sandboxes, Map<String, String> properties) {
        this.registry = registry;
        this.key = key;
        this.port = port;
        this.description = description;
        this.sandboxes = sandboxes;
        this.properties = properties;
    }

    public String getKey() {
        return this.key;
    }

    public int getPort() {
        return this.port;
    }

    public IDaemonRegistry.IDaemonSandbox[] getRegisteredSandboxes() {
        IDaemonRegistry.IDaemonSandbox[] toReturn = new IDaemonRegistry.IDaemonSandbox[this.sandboxes.size()];
        int i = 0;
        for (String path : this.sandboxes) {
            final File sandboxFile = new File(path);
            toReturn[i++] = new IDaemonRegistry.IDaemonSandbox(){

                public File getSandboxRoot() {
                    return sandboxFile;
                }
            };
        }
        return toReturn;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof IDaemonRegistry.IRegistryEntry) {
            IDaemonRegistry.IRegistryEntry other = (IDaemonRegistry.IRegistryEntry)o;
            return this.getKey().equals(other.getKey()) && this.getPort() == other.getPort();
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode() ^ this.getPort();
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public IDaemonRegistry getRegistry() {
        return this.registry;
    }
}

