/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy;

import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import com.ibm.team.filesystem.client.internal.utils.IDaemonRegistry;
import com.ibm.team.filesystem.client.internal.utils.IPermissionUtil;
import com.ibm.team.filesystem.client.restproxy.DaemonRegistry;
import com.ibm.team.filesystem.client.restproxy.HttpClientWrapper;
import com.ibm.team.filesystem.client.restproxy.IClientNotificationChannel;
import com.ibm.team.filesystem.client.restproxy.IDaemonHandle;
import com.ibm.team.filesystem.client.restproxy.ProgressRestParticipant;
import com.ibm.team.filesystem.client.restproxy.RestInvocationHandler;
import com.ibm.team.filesystem.client.restproxy.RestInvocationParticipant;
import com.ibm.team.filesystem.client.restproxy.StatisticsRestParticipant;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestDiscoveryException;
import com.ibm.team.filesystem.client.restproxy.notification.ClientNotificationChannel;
import com.ibm.team.filesystem.client.restproxy.notification.ProgressNotificationParm;
import com.ibm.team.repository.client.IStatistics;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Discovery2 {
    private static final String DEBUG_TIMING_PROPERTY = "com.ibm.team.filesystem.client/debug/timing";
    public static final boolean DEBUG_TIMING = "true".equalsIgnoreCase(System.getProperty("com.ibm.team.filesystem.client/debug/timing"));
    public static final Discovery2 RESOLVER = new Discovery2();
    private final Map<DaemonData, FSDProxies> proxies = new HashMap<DaemonData, FSDProxies>();
    private final Map<FSDaemon, Thread> threads = new ConcurrentHashMap<FSDaemon, Thread>();

    private Discovery2() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T resolve(DiscoveryParams params, IProgressMonitor progress) {
        params.verify();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)5);
        IDaemonRegistry.IRegistryEntry entry = this.findEntryFor(params, monitor.newChild(1));
        Map<DaemonData, FSDProxies> map = this.proxies;
        synchronized (map) {
            DaemonData daemonInfo;
            if (entry == null) {
                daemonInfo = this.createDaemon(params, monitor.newChild(1));
                if (daemonInfo == null) {
                    return null;
                }
            } else {
                daemonInfo = new DaemonData((DaemonRegistry)entry.getRegistry(), entry.getPort(), entry.getKey());
            }
            monitor.setWorkRemaining(3);
            return this.connectToDaemon(params, daemonInfo, monitor.newChild(2));
        }
    }

    private IDaemonRegistry findRegistryFor(DiscoveryParams params) {
        DaemonRegistry registry = params.getDaemonRegistry();
        if (registry == null) {
            registry = DaemonRegistry.getInstance();
        }
        return registry;
    }

    private IDaemonRegistry.IRegistryEntry findEntryFor(DiscoveryParams params, SubMonitor monitor) {
        IDaemonRegistry registry = this.findRegistryFor(params);
        Collection entries = registry.listDaemons((IProgressMonitor)monitor);
        if (params.getPort() != -1) {
            for (IDaemonRegistry.IRegistryEntry entry : entries) {
                if (params.getPort() != entry.getPort()) continue;
                return entry;
            }
        }
        if (params.getPathToRoot() != null) {
            File path = params.getPathToRoot();
            for (IDaemonRegistry.IRegistryEntry entry : entries) {
                IDaemonRegistry.IDaemonSandbox[] iDaemonSandboxArray = entry.getRegisteredSandboxes();
                int n = iDaemonSandboxArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IDaemonRegistry.IDaemonSandbox sandbox = iDaemonSandboxArray[n2];
                    if (path.equals(sandbox.getSandboxRoot())) {
                        return entry;
                    }
                    ++n2;
                }
            }
        }
        if (params.acceptAny && entries.size() > 0) {
            return (IDaemonRegistry.IRegistryEntry)entries.iterator().next();
        }
        return null;
    }

    private DaemonData createDaemon(DiscoveryParams params, SubMonitor monitor) {
        Thread inProcessThread = null;
        DaemonData daemonData = null;
        if (params.isAllowStart()) {
            if (params.isRunInProcess()) {
                FSDaemon daemon = null;
                daemon = this.startInProcess(params);
                inProcessThread = this.threads.get(daemon);
                if (inProcessThread == null) {
                    throw new IllegalStateException("in-process FSDaemon failed too quickly");
                }
                daemonData = new DaemonData(daemon.getDaemonRegistry(), inProcessThread, daemon);
            } else {
                FSDaemon.ILockFile lockFile;
                try {
                    lockFile = this.startOutOfProcess(params);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
                daemonData = new DaemonData((DaemonRegistry)this.findRegistryFor(params), lockFile.getPort(), lockFile.getKey());
            }
        }
        return daemonData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSDaemon startInProcess(DiscoveryParams params) throws RestDiscoveryException {
        final FSDaemon fsd = new FSDaemon();
        if (params.getDaemonRegistry() == null) {
            fsd.setDaemonRegistry((DaemonRegistry)DaemonRegistry.getInstance());
        } else {
            fsd.setDaemonRegistry(params.getDaemonRegistry());
        }
        this.secure(params, fsd.getDaemonRegistry());
        if (params.getLogFile() != null) {
            fsd.enableRequestTracing(params.getLogFile());
        }
        final SnitchingLifecycleListener listener = new SnitchingLifecycleListener();
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    fsd.addListener(listener);
                    fsd.start();
                }
                finally {
                    Discovery2.this.deregisterClientAfterShutdown(fsd.getPort());
                    Discovery2.this.threads.remove(fsd);
                }
            }
        });
        SnitchingLifecycleListener snitchingLifecycleListener = listener;
        synchronized (snitchingLifecycleListener) {
            try {
                t.start();
                long WAIT_TIME = params.getStartTimeout();
                if (!listener.waitForStart(WAIT_TIME)) {
                    throw new IllegalStateException("Waited for " + WAIT_TIME + "ms, but FSDaemon failed to come up");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unexpected interruption", e);
            }
        }
        this.threads.put(fsd, t);
        return fsd;
    }

    private void secure(DiscoveryParams params, DaemonRegistry daemonRegistry) throws RegistrySecurityException {
        String targetPath;
        if (params.permUtils == null) {
            return;
        }
        try {
            targetPath = daemonRegistry.getRegistryLocation().getCanonicalPath();
        }
        catch (IOException e) {
            throw new CanonicalizationRegistrySecurityException(e);
        }
        try {
            params.permUtils.mkRoot(targetPath);
        }
        catch (IPermissionUtil.PermissionUtilsException e) {
            throw new PermissionUtilsRegistrySecurityException(e);
        }
        catch (InterruptedException e) {
            throw new SecureInterruptedRegistrySecurityException(e);
        }
    }

    private FSDaemon.ILockFile startOutOfProcess(DiscoveryParams params) throws InterruptedException {
        ArrayList<String> argsToRun = new ArrayList<String>(4);
        argsToRun.add(params.getDaemonExecutable());
        DaemonRegistry daemonRegistry = params.getDaemonRegistry();
        if (daemonRegistry != null) {
            argsToRun.add("--config");
            argsToRun.add(daemonRegistry.getRegistryLocation().getAbsolutePath());
        }
        argsToRun.add("daemon");
        argsToRun.add("start");
        File pathToRoot = params.getPathToRoot();
        if (pathToRoot != null) {
            argsToRun.add(pathToRoot.getAbsolutePath());
        }
        argsToRun.addAll(Arrays.asList(params.getExtraArguments()));
        HashMap<String, Pattern> patterns = new HashMap<String, Pattern>();
        patterns.put("port", Pattern.compile("Port: (\\d+)", 8));
        patterns.put("key", Pattern.compile("Key: ([0-9A-F]+)", 8));
        ProcessBuilder pb = new ProcessBuilder(argsToRun);
        Process process = null;
        try {
            process = pb.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to start client", e);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ExpectReader reader = new ExpectReader(process.getInputStream(), out, patterns);
        reader.join(params.getStartTimeout());
        String portString = reader.getValue("port");
        final String key = reader.getValue("key");
        if (portString == null || key == null) {
            throw new IllegalStateException("Daemon output did not include coordinates");
        }
        final int port = Integer.parseInt(portString);
        return new FSDaemon.ILockFile(){

            public int getPort() {
                return port;
            }

            public String getKey() {
                return key;
            }
        };
    }

    private <T> T connectToDaemon(DiscoveryParams params, final DaemonData daemonInfo, SubMonitor monitor) {
        FSDProxies proxyGroup = this.proxies.get(daemonInfo);
        if (proxyGroup == null) {
            StatisticsRestParticipant srp = null;
            if (DEBUG_TIMING || params.isEnableStats()) {
                srp = new StatisticsRestParticipant();
            }
            proxyGroup = new FSDProxies(daemonInfo, srp);
            this.proxies.put(daemonInfo, proxyGroup);
        }
        assert (proxyGroup.isAcceptingConnections());
        RestInvocationHandler handler = new RestInvocationHandler(params.getType(), proxyGroup.getUrl(), proxyGroup.getHttpClient());
        handler.addParticipant(new RestInvocationParticipant(){

            public void preRequest(RestInvocationParticipant.CallKey key, HttpMethod request) {
                request.addRequestHeader("X-Secret-Key", daemonInfo.key);
            }
        });
        handler.addParticipant(new ProgressRestParticipant());
        StatisticsRestParticipant srp = proxyGroup.srp;
        if (srp != null) {
            handler.addParticipant(srp);
        }
        handler.setNotificationChannel(proxyGroup.channel);
        Object wrapped = Proxy.newProxyInstance(params.getType().getClassLoader(), new Class[]{params.getType()}, (InvocationHandler)handler);
        proxyGroup.addProxy(wrapped);
        return (T)wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterClientAfterShutdown(int port) {
        Map<DaemonData, FSDProxies> map = this.proxies;
        synchronized (map) {
            DaemonData data = this.findDaemonAt(port);
            if (data == null) {
                return;
            }
            FSDProxies proxyObjects = this.proxies.get(data);
            proxyObjects.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DaemonData findDaemonAt(int port) {
        Map<DaemonData, FSDProxies> map = this.proxies;
        synchronized (map) {
            for (DaemonData data : this.proxies.keySet()) {
                if (data.port != port) continue;
                return data;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDaemonHandle find(Object proxy) {
        Map<DaemonData, FSDProxies> map = this.proxies;
        synchronized (map) {
            for (FSDProxies group : this.proxies.values()) {
                if (!group.isAcceptingConnections() || !group.hasProxy(proxy)) continue;
                return group;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatistics findStatistics(Object proxy) {
        Map<DaemonData, FSDProxies> map = this.proxies;
        synchronized (map) {
            FSDProxies group;
            Iterator<FSDProxies> iterator = this.proxies.values().iterator();
            do {
                if (iterator.hasNext()) continue;
                return null;
            } while (!(group = iterator.next()).hasProxy(proxy));
            if (group == null) return null;
            if (group.srp != null) return group.srp.getStatistics();
            return null;
        }
    }

    public void joinInProcess(Object o) throws InterruptedException {
        IDaemonHandle handle = this.find(o);
        if (handle == null) {
            throw new IllegalArgumentException("Could not find daemon.");
        }
        handle.join();
    }

    public Collection<FSDaemon> getInProcessDaemons() {
        HashSet<FSDaemon> daemons = new HashSet<FSDaemon>();
        daemons.addAll(this.threads.keySet());
        return daemons;
    }

    public static class CanonicalizationRegistrySecurityException
    extends RegistrySecurityException {
        protected CanonicalizationRegistrySecurityException(IOException e) {
            super(e);
        }
    }

    private static class DaemonData {
        private final Thread inProcessThread;
        private final DaemonRegistry registry;
        private final FSDaemon daemon;
        private final int port;
        private final String key;

        public DaemonData(DaemonRegistry registry, Thread inProcessThread, FSDaemon daemon) {
            this.inProcessThread = inProcessThread;
            this.registry = registry;
            this.daemon = daemon;
            this.port = daemon.getPort();
            this.key = daemon.getKey();
        }

        public DaemonData(DaemonRegistry registry, int port, String key) {
            this.registry = registry;
            this.inProcessThread = null;
            this.daemon = null;
            this.port = port;
            this.key = key;
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.port;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof DaemonData) {
                DaemonData other = (DaemonData)o;
                return this.key.equals(other.key) && this.port == other.port;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DiscoveryParams {
        public static final String DEFAULT_EXECUTABLE = "scm";
        public static final int UNKNOWN_PORT = -1;
        Class<?> type = null;
        File pathToRoot = null;
        boolean runInProcess = true;
        boolean allowStart = false;
        boolean enableStats = false;
        String daemonExecutable = "scm";
        Method[] terminationMethods = new Method[0];
        private String[] extraArgs = new String[0];
        int port = -1;
        boolean acceptAny = false;
        DaemonRegistry registry = null;
        File log = null;
        IPermissionUtil permUtils;
        long startTimeout = 40000L;

        public DiscoveryParams() {
        }

        public DiscoveryParams(DaemonRegistry reg, IDaemonRegistry.IRegistryEntry entry) {
            this.setPort(entry.getPort());
            this.setAllowStart(false);
            this.setDaemonRegistry(reg);
        }

        public Class<?> getInterface() {
            return this.type;
        }

        public DiscoveryParams setInterface(Class<?> newClass) {
            this.type = newClass;
            return this;
        }

        public File getPathToRoot() {
            return this.pathToRoot;
        }

        public DiscoveryParams setPathToRoot(File newPathToRoot) {
            this.pathToRoot = newPathToRoot;
            return this;
        }

        public boolean isRunInProcess() {
            return this.runInProcess;
        }

        public DiscoveryParams setRunInProcess(boolean newRunInProcess) {
            this.runInProcess = newRunInProcess;
            return this;
        }

        public boolean isAllowStart() {
            return this.allowStart;
        }

        public DiscoveryParams setAllowStart(boolean newAllowStart) {
            this.allowStart = newAllowStart;
            return this;
        }

        public boolean isEnableStats() {
            return this.enableStats;
        }

        public DiscoveryParams setEnableStats(boolean newEnableStats) {
            this.enableStats = newEnableStats;
            return this;
        }

        public String getDaemonExecutable() {
            return this.daemonExecutable;
        }

        public DiscoveryParams setDaemonExecutable(String newDaemonExecutable) {
            this.daemonExecutable = newDaemonExecutable;
            return this;
        }

        public Class<?> getType() {
            return this.type;
        }

        public DiscoveryParams setExtraArguments(String ... args) {
            this.extraArgs = args;
            return this;
        }

        public String[] getExtraArguments() {
            return this.extraArgs;
        }

        public DiscoveryParams setPort(int p) {
            this.port = p;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public DiscoveryParams setAcceptAny(boolean b) {
            this.acceptAny = b;
            return this;
        }

        public boolean getAcceptAny() {
            return this.acceptAny;
        }

        public DiscoveryParams setDaemonRegistry(DaemonRegistry registry) {
            this.registry = registry;
            return this;
        }

        public DaemonRegistry getDaemonRegistry() {
            return this.registry;
        }

        public DiscoveryParams setLogFile(File f) {
            this.log = f;
            return this;
        }

        public File getLogFile() {
            return this.log;
        }

        public long getStartTimeout() {
            return this.startTimeout;
        }

        public DiscoveryParams setStartTimeout(long startTimeout) {
            this.startTimeout = startTimeout;
            return this;
        }

        public DiscoveryParams setPermissionUtils(IPermissionUtil utils) {
            this.permUtils = utils;
            return this;
        }

        protected void verify() {
            if (this.type == null) {
                throw new IllegalArgumentException("Cannot create a new proxy without a type");
            }
            if (this.pathToRoot == null && this.port == -1 && !this.allowStart) {
                throw new IllegalArgumentException("One of the following must be set: pathToRoot, port, allowStart");
            }
            if (this.runInProcess && (this.extraArgs == null || this.extraArgs.length != 0)) {
                throw new IllegalArgumentException("May only specify extra arguments when running out of process");
            }
            if (this.runInProcess && !DEFAULT_EXECUTABLE.equals(this.daemonExecutable)) {
                throw new IllegalArgumentException("May not specify external executable when running in process");
            }
            if (this.getLogFile() != null && !this.runInProcess) {
                throw new IllegalArgumentException("A log can only be opened on in-process daemons");
            }
            if (!this.runInProcess && this.permUtils != null) {
                throw new IllegalArgumentException("Protect command may only be specified for in-process daemons");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExpectReader
    implements Runnable {
        final InputStream in;
        final ByteArrayOutputStream out;
        final Map<String, Pattern> expected;
        final Map<String, String> values = new HashMap<String, String>();
        final List<String> unmatchedKeys;
        IOException error;

        public ExpectReader(InputStream in, ByteArrayOutputStream out, Map<String, Pattern> expected) {
            this.in = in;
            this.out = out;
            this.expected = expected;
            this.unmatchedKeys = new ArrayList<String>(expected.size());
            this.unmatchedKeys.addAll(expected.keySet());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
            while ((line = this.readLine(reader)) != null) {
                ExpectReader expectReader = this;
                synchronized (expectReader) {
                    Iterator<String> i = this.unmatchedKeys.iterator();
                    while (i.hasNext()) {
                        String key = i.next();
                        Matcher m = this.expected.get(key).matcher(line);
                        if (!m.find()) continue;
                        this.values.put(key, m.group(1));
                        i.remove();
                    }
                    if (this.unmatchedKeys.size() == 0) {
                        this.notifyAll();
                        return;
                    }
                }
            }
        }

        private String readLine(BufferedReader reader) {
            try {
                return reader.readLine();
            }
            catch (IOException e) {
                this.error = e;
                return null;
            }
        }

        public IOException getError() {
            return this.error;
        }

        public String getValue(String key) {
            return this.values.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void join(long timeout) throws InterruptedException {
            Thread t = new Thread(this);
            ExpectReader expectReader = this;
            synchronized (expectReader) {
                t.start();
                if (this.unmatchedKeys.size() == 0) {
                    return;
                }
                this.wait(timeout);
            }
        }
    }

    private static class FSDProxies
    implements IDaemonHandle {
        private final DaemonData daemonInfo;
        private final HttpClientWrapper connectionPool;
        private final ClientNotificationChannel channel;
        private final StatisticsRestParticipant srp;
        private volatile boolean isAcceptingConnections = true;
        private final LinkedList<Object> proxyObjects = new LinkedList();

        public FSDProxies(DaemonData daemonInfo, StatisticsRestParticipant srp) {
            this.daemonInfo = daemonInfo;
            this.connectionPool = new HttpClientWrapper(this.createHttpClient());
            this.srp = srp;
            this.channel = new ClientNotificationChannel(this.getUrl(), daemonInfo.key, this.connectionPool);
            this.channel.addType(ProgressNotificationParm.TYPE, ProgressNotificationParm.class);
        }

        public HttpClientWrapper getHttpClient() {
            return this.connectionPool;
        }

        private HttpClient createHttpClient() {
            MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
            HttpConnectionManagerParams parms = new HttpConnectionManagerParams();
            parms.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, Integer.MAX_VALUE);
            parms.setMaxTotalConnections(Integer.MAX_VALUE);
            manager.setParams(parms);
            return new HttpClient((HttpConnectionManager)manager);
        }

        private void addProxy(Object wrapped) {
            this.proxyObjects.add(wrapped);
        }

        private void cleanup() {
            this.connectionPool.shutdown = true;
            this.connectionPool.lock.writeLock().lock();
            try {
                ((MultiThreadedHttpConnectionManager)this.connectionPool.client.getHttpConnectionManager()).shutdown();
            }
            finally {
                this.connectionPool.lock.writeLock().unlock();
            }
        }

        private boolean hasProxy(Object proxy) {
            for (Object e : this.proxyObjects) {
                if (e != proxy) continue;
                return true;
            }
            return false;
        }

        public void join() throws InterruptedException {
            if (this.daemonInfo.inProcessThread == null) {
                throw new IllegalStateException("Daemon must be in-memory to join");
            }
            this.daemonInfo.inProcessThread.join();
        }

        public FSDaemon getInProcessServer() {
            return this.daemonInfo.daemon;
        }

        public String getKey() {
            return this.daemonInfo.key;
        }

        public int getPort() {
            return this.daemonInfo.port;
        }

        public IClientNotificationChannel getNotificationChannel() {
            return this.channel;
        }

        public String getUrl() {
            try {
                return new URI("http", null, InetAddress.getByName(null).getHostAddress(), this.getPort(), "/", null, null).toASCIIString();
            }
            catch (UnknownHostException e) {
                throw new RestDiscoveryException(e);
            }
            catch (URISyntaxException e) {
                throw new RestDiscoveryException(e);
            }
        }

        public void shutdown() throws InterruptedException {
            FSDaemon daemon = this.getInProcessServer();
            if (daemon == null) {
                return;
            }
            daemon.stop();
            try {
                this.join();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }

        public IDaemonRegistry getRegistry() {
            return this.daemonInfo.registry;
        }

        public boolean isAcceptingConnections() {
            return this.isAcceptingConnections;
        }

        private void noLongerAcceptingConnections() {
            this.isAcceptingConnections = false;
        }
    }

    public static class PermissionUtilsRegistrySecurityException
    extends RegistrySecurityException {
        public PermissionUtilsRegistrySecurityException(IPermissionUtil.PermissionUtilsException e) {
            super((Exception)e);
        }
    }

    public static abstract class RegistrySecurityException
    extends RestDiscoveryException {
        public RegistrySecurityException(Exception e) {
            super(e);
        }
    }

    public static class SecureInterruptedRegistrySecurityException
    extends RegistrySecurityException {
        public SecureInterruptedRegistrySecurityException(InterruptedException e) {
            super(e);
        }
    }

    private class SnitchingLifecycleListener
    implements FSDaemon.ILifecycleListener {
        public int port = -1;
        public String secret;
        private boolean hasStarted = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initialized(FSDaemon fsd) {
            this.port = fsd.getPort();
            this.secret = fsd.getKey();
            SnitchingLifecycleListener snitchingLifecycleListener = this;
            synchronized (snitchingLifecycleListener) {
                this.hasStarted = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown(FSDaemon fsd) {
            DaemonData data = Discovery2.this.findDaemonAt(fsd.getPort());
            FSDProxies proxyObjects = (FSDProxies)Discovery2.this.proxies.get(data);
            if (proxyObjects != null) {
                proxyObjects.noLongerAcceptingConnections();
            }
            SnitchingLifecycleListener snitchingLifecycleListener = this;
            synchronized (snitchingLifecycleListener) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean waitForStart(long timeout) throws InterruptedException {
            SnitchingLifecycleListener snitchingLifecycleListener = this;
            synchronized (snitchingLifecycleListener) {
                long stoppingTime = System.currentTimeMillis() + timeout;
                if (this.hasStarted) {
                    return true;
                }
                do {
                    this.wait(timeout);
                    if (!this.hasStarted) continue;
                    return true;
                } while (timeout == 0L || (timeout = stoppingTime - System.currentTimeMillis()) > 0L);
                return false;
            }
        }

        public void handleEvent(FSDaemon.ILifecycleEvent event) {
            if (event instanceof FSDaemon.IInitializedEvent) {
                this.initialized(event.getDaemon());
            } else if (event instanceof FSDaemon.IShutdownEvent) {
                this.shutdown(event.getDaemon());
            }
        }
    }
}

