/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.marshalling;

import com.ibm.team.filesystem.client.internal.marshalling.ParameterWrapperHandlerWithFallback;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestMarshallingException;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestReflectionException;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.json.DeserializationException;
import com.ibm.team.repository.common.json.IJSONSerializable;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.transport.ParameterConverter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONConverter
extends ParameterConverter {
    public static String CLASS_ANNOTATION = "-type";
    private final ClassLoader classloader;
    final ParameterWrapperHandlerWithFallback wrapper;

    public JSONConverter(ClassLoader loader, ParameterWrapperHandlerWithFallback wrapperHandlerWithFallback) {
        this.classloader = loader;
        this.wrapper = wrapperHandlerWithFallback;
    }

    public Object convertToObject(Class<?> type, String param) {
        InputStreamReader r = new InputStreamReader(new ByteArrayInputStream(param.getBytes()));
        try {
            return this.convertFromJSON(type, JSONObject.parseAny((Reader)r));
        }
        catch (DeserializationException e) {
            throw new RestMarshallingException("Could not parse parameter", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new RestMarshallingException("Unexpected exception when reading from memory", e);
        }
    }

    public <T> Object convertFromJSON(Class<T> type, Object possiblyJSON) {
        return this.convertFromJSON(this.classloader, type, possiblyJSON);
    }

    public <T> Object convertFromJSON(ClassLoader loader, Class<?> type, Object possiblyJSON) throws RestMarshallingException {
        if (possiblyJSON == null) {
            return null;
        }
        if (!(possiblyJSON instanceof IJSONSerializable)) {
            if (this.isAllowedPrimitive(type)) {
                return this.convertToTargetType(type, possiblyJSON);
            }
            throw new RestMarshallingException("Don't know how to deserialize field of type " + possiblyJSON.getClass().getSimpleName());
        }
        if (type.isArray()) {
            return this.convertFromJSONArray(type.getComponentType(), possiblyJSON);
        }
        return this.convertFromJSONObject(loader, type, possiblyJSON);
    }

    private Object convertToTargetType(Class<?> type, Object possiblyJSON) {
        if (type.equals(possiblyJSON.getClass())) {
            return possiblyJSON;
        }
        if ((type.equals(Boolean.class) || type.equals(Boolean.TYPE)) && (Boolean.class.equals(possiblyJSON.getClass()) || Boolean.TYPE.equals(possiblyJSON.getClass()))) {
            return possiblyJSON;
        }
        if (Number.class.isAssignableFrom(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Double.TYPE.equals(type) || Float.TYPE.equals(type) || Short.TYPE.equals(type) || Byte.TYPE.equals(type)) {
            if (!(possiblyJSON instanceof Number)) {
                throw new RestMarshallingException("Expecting a subclass of Number: " + possiblyJSON.getClass());
            }
            Number n = (Number)possiblyJSON;
            if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
                return n.intValue();
            }
            if (Long.class.equals(type) || Long.TYPE.equals(type)) {
                return n.longValue();
            }
            if (Double.class.equals(type) || Double.TYPE.equals(type)) {
                return n.doubleValue();
            }
            if (Float.class.equals(type) || Float.TYPE.equals(type)) {
                return Float.valueOf(n.floatValue());
            }
            if (Short.class.equals(type) || Short.TYPE.equals(type)) {
                return n.shortValue();
            }
            if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
                return n.byteValue();
            }
            throw new RestMarshallingException("Unknown Number subclass " + possiblyJSON.getClass().getCanonicalName());
        }
        throw new RestMarshallingException("Can't narrow " + possiblyJSON.getClass() + " to assign to  " + type);
    }

    private <T> Object convertFromJSONArray(Class<T> type, Object possiblyJSON) {
        JSONArray thing = (JSONArray)possiblyJSON;
        Object array = Array.newInstance(type, thing.size());
        int i = 0;
        for (Object each : thing) {
            Object newValue = this.convertFromJSON(type, each);
            Array.set(array, i++, newValue);
        }
        return array;
    }

    private <T> Object convertFromJSONObject(ClassLoader loader, Class<T> baseType, Object possiblyJSON) {
        T thing;
        JSONObject json = (JSONObject)possiblyJSON;
        Class<Object> targetType = baseType;
        Object typeName = json.get((Object)CLASS_ANNOTATION);
        if (typeName != null && typeName instanceof String) {
            try {
                targetType = loader.loadClass((String)typeName);
            }
            catch (ClassNotFoundException e) {
                LogFactory.getLog((String)JSONConverter.class.getName()).error((Object)e.getMessage(), (Throwable)e);
            }
        }
        try {
            thing = targetType.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RestReflectionException("Unable to instantiate " + targetType.getName(), e);
        }
        catch (InstantiationException e) {
            throw new RestReflectionException("Unable to instantiate " + targetType.getName(), e);
        }
        for (Field field : this.accessibleFieldsIn(targetType)) {
            Object newValue = this.convertFromJSON(field.getType(), json.get((Object)field.getName()));
            try {
                field.set(thing, newValue);
            }
            catch (IllegalArgumentException e) {
                throw new RestReflectionException("Unable to set " + targetType.getName() + "." + field.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new RestReflectionException("Unable to set " + targetType.getName() + "." + field.getName(), e);
            }
        }
        return thing;
    }

    public String convertToString(Class<?> baseType, Object param) {
        Class<?> type = param.getClass();
        if (!IParameterWrapper.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Passed class is not IParameterWrapper: " + type.getName());
        }
        if (type.isArray()) {
            throw new IllegalArgumentException("Don't know how to handle arrays");
        }
        IJSONSerializable toSerialize = this.jsonify(baseType, param);
        return toSerialize.toString(false);
    }

    private IJSONSerializable jsonify(Class<?> baseType, Object param) {
        if (param == null) {
            return null;
        }
        JSONObject obj = new JSONObject();
        for (Field field : this.accessibleFieldsIn(param.getClass())) {
            Object value = this.getValue(param, field);
            Class<?> fieldType = field.getType();
            if (fieldType.isArray()) {
                value = this.jsonifyArray(field, value);
            } else if (IParameterWrapper.class.isAssignableFrom(fieldType)) {
                value = this.jsonify(field.getType(), value);
            } else assert (this.isAllowedPrimitive(fieldType));
            obj.put((Object)field.getName(), value);
        }
        if (!baseType.equals(param.getClass())) {
            obj.put((Object)CLASS_ANNOTATION, (Object)param.getClass().getName());
        }
        return obj;
    }

    private Object jsonifyArray(Field field, Object value) {
        if (value == null) {
            return null;
        }
        int length = Array.getLength(value);
        JSONArray result = new JSONArray(length);
        Class<?> baseType = field.getType().getComponentType();
        int i = 0;
        while (i < length) {
            Object thing = Array.get(value, i);
            result.add(this.jsonifyArrayElement(baseType, thing));
            ++i;
        }
        return result;
    }

    private Object jsonifyArrayElement(Class<?> baseType, Object thing) {
        if (this.isAllowedPrimitive(baseType)) {
            return thing;
        }
        return this.jsonify(baseType, thing);
    }

    private boolean isAllowedPrimitive(Class<?> type) {
        return type.isAssignableFrom(Long.class) || type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Double.class) || type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Float.class) || type.isAssignableFrom(Float.TYPE) || type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE) || String.class.isAssignableFrom(type);
    }

    private Object getValue(Object param, Field field) {
        try {
            return field.get(param);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not query field: " + field.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not query field: " + field.getName(), e);
        }
    }

    boolean isConvertable(Field f) {
        ParameterConverter conv;
        Class<?> type = f.getType();
        if (type.isArray()) {
            type = type.getComponentType();
        }
        if ((conv = this.wrapper.findParameterConverterForClass(type)) == this) {
            return IParameterWrapper.class.isAssignableFrom(type);
        }
        return true;
    }

    protected Iterable<Field> accessibleFieldsIn(Class<?> type) {
        Field[] fields = type.getDeclaredFields();
        ArrayList<Field> list = new ArrayList<Field>(fields.length);
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers)) {
                if (!Modifier.isPublic(modifiers) || Modifier.isTransient(modifiers)) {
                    throw new RestReflectionException("Inaccessible field " + type.getName() + "." + field.getName());
                }
                if (!this.isConvertable(field)) {
                    throw new RestReflectionException("Unconvertible field " + type.getName() + "." + field.getName());
                }
                list.add(field);
            }
            ++n2;
        }
        return list;
    }
}

