/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.http;

import com.ibm.team.filesystem.client.internal.http.HttpHandler;
import com.ibm.team.filesystem.client.internal.http.HttpRequest;
import com.ibm.team.filesystem.client.internal.http.HttpResponse;
import com.ibm.team.filesystem.client.internal.http.IExternalManager;
import com.ibm.team.filesystem.client.internal.http.constants.ResponseCode;
import java.io.IOException;

public abstract class ProtocolSwitchingHttpHandler
extends HttpHandler
implements IExternalManager {
    protected abstract String getProtocol();

    public final void handle(HttpRequest request, HttpResponse response) throws IOException {
        response.setExternallyManaged(this);
        String protocol = this.getProtocol();
        try {
            String upgrade = request.getFirstHeader("Upgrade");
            if (upgrade == null || !upgrade.contains(protocol)) {
                response.setCode(ResponseCode.UPGRADE_REQUIRED);
                response.writeHeader("Upgrade", protocol);
                return;
            }
            response.setCode(ResponseCode.SWITCHING_PROTOCOLS);
            response.writeHeader("Upgrade", protocol);
            response.getResponseStream().flush();
            this.handleRequest(request, response);
        }
        finally {
            response.close();
        }
    }

    protected abstract void handleRequest(HttpRequest var1, HttpResponse var2) throws IOException;
}

