/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.daemon;

import com.ibm.team.filesystem.client.daemon.events.ConnectionEvent;
import com.ibm.team.filesystem.client.daemon.events.IConnectedHttpServerEvent;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEvent;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEventListener;
import com.ibm.team.filesystem.client.daemon.events.RequestEvent;
import com.ibm.team.filesystem.client.daemon.events.ResponseEvent;
import com.ibm.team.filesystem.client.internal.http.HttpRequest;
import com.ibm.team.filesystem.client.internal.http.HttpResponse;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationDiscardedEvent;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationDroppedEvent;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationEvent;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationQueuedEvent;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationSentEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonTracer
implements ILightweightEventListener<ILightweightEvent> {
    private static final String NEWLINE = System.getProperty("line.separator");
    private final File outputFile;

    public DaemonTracer(File outputFile) {
        this.outputFile = outputFile;
        this.write(outputFile, "# Time - Type - Port - Description" + NEWLINE);
    }

    @Override
    public void handleEvent(ILightweightEvent event) {
        if (event instanceof ConnectionEvent) {
            this.write((ConnectionEvent)event);
        } else if (event instanceof RequestEvent) {
            this.write((RequestEvent)event);
        } else if (event instanceof ResponseEvent) {
            this.write((ResponseEvent)event);
        } else if (event instanceof NotificationQueuedEvent) {
            this.write("NOTIFICATION QUEUED", (NotificationQueuedEvent)event);
        } else if (event instanceof NotificationSentEvent) {
            NotificationSentEvent sentEvent = (NotificationSentEvent)event;
            this.write("NOTIFICATION SENT", sentEvent.getPeerPort(), sentEvent);
        } else if (event instanceof NotificationDiscardedEvent) {
            this.write("NOTIFICATION DISCARDED", (NotificationDiscardedEvent)event);
        } else if (event instanceof NotificationDroppedEvent) {
            NotificationDroppedEvent droppedEvent = (NotificationDroppedEvent)event;
            this.write("NOTIFICATION DROPPED", droppedEvent.getPeerPort(), droppedEvent);
        }
    }

    private void write(String eventType, NotificationEvent event) {
        this.write(this.outputFile, eventType, -1, "Type: " + event.getType());
    }

    private void write(String eventType, int port, NotificationEvent event) {
        this.write(this.outputFile, eventType, port, "Type: " + event.getType());
    }

    private void write(ResponseEvent event) {
        HttpResponse resp = event.getResponse();
        this.write(this.outputFile, event, "RESPONSE", Integer.toString(resp.getLastCode()));
    }

    private void write(RequestEvent event) {
        HttpRequest req = event.getRequest();
        this.write(this.outputFile, event, "REQUEST", String.valueOf(req.getMethod().toString()) + " " + req.getRequestURI());
    }

    private void write(ConnectionEvent event) {
        if (event.getType() == ConnectionEvent.Type.OPENED) {
            this.write(this.outputFile, event, "CONNECT", "Client connected");
        } else if (event.getType() == ConnectionEvent.Type.CLOSED) {
            this.write(this.outputFile, event, "DISCONNECT", "Client disconnected");
        }
    }

    private void write(File file, IConnectedHttpServerEvent event, String eventType, String eventDescription) {
        this.write(file, eventType, event.getPeerPort(), eventDescription);
    }

    private void write(File file, String eventType, int port, String eventDescription) {
        StringBuffer buf = new StringBuffer();
        DaemonTracer.writeTimeIntoBuffer(buf);
        buf.append(" - ");
        buf.append(eventType);
        buf.append(" - ");
        buf.append(port);
        buf.append(" - ");
        buf.append(eventDescription);
        buf.append(NEWLINE);
        this.write(file, buf);
    }

    private synchronized void write(File file, CharSequence seq) {
        block12: {
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(file, true);
                    out.write(seq.toString().getBytes());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (out == null) break block12;
                    try {
                        out.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    private static void writeTimeIntoBuffer(StringBuffer buf) {
        buf.append(System.currentTimeMillis());
    }
}

