/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.parser;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.descriptor.BodyDescriptor;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeTokenStream;

public class MimeStreamParser {
    private ContentHandler handler = null;
    private boolean contentDecoding = false;
    private final MimeTokenStream mimeTokenStream = new MimeTokenStream();

    public boolean isContentDecoding() {
        return this.contentDecoding;
    }

    public void setContentDecoding(boolean b) {
        this.contentDecoding = b;
    }

    public void parse(InputStream is) throws MimeException, IOException {
        this.mimeTokenStream.parse(is);
        block16: while (true) {
            int state = this.mimeTokenStream.getState();
            switch (state) {
                case 12: {
                    BodyDescriptor desc = this.mimeTokenStream.getBodyDescriptor();
                    InputStream bodyContent = this.contentDecoding ? this.mimeTokenStream.getDecodedInputStream() : this.mimeTokenStream.getInputStream();
                    this.handler.body(desc, bodyContent);
                    break;
                }
                case 11: {
                    this.handler.endBodyPart();
                    break;
                }
                case 5: {
                    this.handler.endHeader();
                    break;
                }
                case 1: {
                    this.handler.endMessage();
                    break;
                }
                case 7: {
                    this.handler.endMultipart();
                    break;
                }
                case -1: {
                    break block16;
                }
                case 9: {
                    this.handler.epilogue(this.mimeTokenStream.getInputStream());
                    break;
                }
                case 4: {
                    this.handler.field(this.mimeTokenStream.getField());
                    break;
                }
                case 8: {
                    this.handler.preamble(this.mimeTokenStream.getInputStream());
                    break;
                }
                case 2: {
                    this.handler.raw(this.mimeTokenStream.getInputStream());
                    break;
                }
                case 10: {
                    this.handler.startBodyPart();
                    break;
                }
                case 3: {
                    this.handler.startHeader();
                    break;
                }
                case 0: {
                    this.handler.startMessage();
                    break;
                }
                case 6: {
                    this.handler.startMultipart(this.mimeTokenStream.getBodyDescriptor());
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid state: " + state);
                }
            }
            int n = this.mimeTokenStream.next();
        }
    }

    public boolean isRaw() {
        return this.mimeTokenStream.isRaw();
    }

    public void setRaw(boolean raw) {
        this.mimeTokenStream.setRecursionMode(2);
    }

    public void stop() {
        this.mimeTokenStream.stop();
    }

    public void setContentHandler(ContentHandler h) {
        this.handler = h;
    }
}

