/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.field.ContentTypeField;
import org.apache.james.mime4j.message.Body;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.Entity;
import org.apache.james.mime4j.util.CharsetUtil;
import org.apache.james.mime4j.util.MessageUtils;

public class Multipart
implements Body {
    private String preamble = "";
    private String epilogue = "";
    private List bodyParts = new LinkedList();
    private Entity parent = null;
    private String subType;

    public Multipart(String subType) {
        this.subType = subType;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public Entity getParent() {
        return this.parent;
    }

    public void setParent(Entity parent) {
        this.parent = parent;
        Iterator it = this.bodyParts.iterator();
        while (it.hasNext()) {
            ((BodyPart)it.next()).setParent(parent);
        }
    }

    public String getEpilogue() {
        return this.epilogue;
    }

    public void setEpilogue(String epilogue) {
        this.epilogue = epilogue;
    }

    public List getBodyParts() {
        return Collections.unmodifiableList(this.bodyParts);
    }

    public void setBodyParts(List bodyParts) {
        this.bodyParts = bodyParts;
        Iterator it = bodyParts.iterator();
        while (it.hasNext()) {
            ((BodyPart)it.next()).setParent(this.parent);
        }
    }

    public void addBodyPart(BodyPart bodyPart) {
        this.bodyParts.add(bodyPart);
        bodyPart.setParent(this.parent);
    }

    public String getPreamble() {
        return this.preamble;
    }

    public void setPreamble(String preamble) {
        this.preamble = preamble;
    }

    public void writeTo(OutputStream out, int mode) throws IOException, MimeException {
        Entity e = this.getParent();
        ContentTypeField cField = (ContentTypeField)e.getHeader().getField("Content-Type");
        if (cField == null || cField.getBoundary() == null) {
            throw new MimeException("Multipart boundary not specified");
        }
        String boundary = cField.getBoundary();
        Charset charset = null;
        charset = mode == 3 ? (cField != null && cField.getCharset() != null ? CharsetUtil.getCharset(cField.getCharset()) : MessageUtils.ISO_8859_1) : MessageUtils.DEFAULT_CHARSET;
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, charset), 8192);
        List bodyParts = this.getBodyParts();
        writer.write(this.getPreamble());
        writer.write("\r\n");
        for (int i = 0; i < bodyParts.size(); ++i) {
            writer.write("--");
            writer.write(boundary);
            writer.write("\r\n");
            writer.flush();
            BodyPart bodyPart = (BodyPart)bodyParts.get(i);
            bodyPart.writeTo(out, mode);
            writer.write("\r\n");
        }
        writer.write("--");
        writer.write(boundary);
        writer.write("--");
        writer.write("\r\n");
        String epilogue = this.getEpilogue();
        writer.write(epilogue);
        writer.flush();
    }
}

