/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.PluginParser$$Cold;
import org.eclipse.update.internal.configurator.PluginParser$ParseCompleteException;
import org.eclipse.update.internal.configurator.Utils;
import org.eclipse.update.internal.configurator.VersionedIdentifier;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PluginParser
extends DefaultHandler
implements IConfigurationConstants {
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private SAXParser parser;
    private PluginEntry pluginEntry;
    private String location;

    public PluginParser() {
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            System.out.println(sAXException);
        }
    }

    public synchronized PluginEntry parse(File file) throws SAXException, IOException {
        return PluginParser$$Cold.parse(this, file);
    }

    public synchronized PluginEntry parse(InputStream inputStream, String string) throws SAXException, IOException {
        try {
            this.location = string;
            this.pluginEntry = new PluginEntry();
            this.pluginEntry.setURL(string);
            this.parser.parse(new InputSource(inputStream), (DefaultHandler)this);
        }
        catch (PluginParser$ParseCompleteException pluginParser$ParseCompleteException) {}
        return this.pluginEntry;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2.trim();
        if (string4.equalsIgnoreCase("plugin")) {
            this.pluginEntry.isFragment(false);
            this.processPlugin(attributes);
            return;
        }
        if (string4.equalsIgnoreCase("fragment")) {
            this.pluginEntry.isFragment(true);
            this.processPlugin(attributes);
            return;
        }
    }

    private void processPlugin(Attributes attributes) throws PluginParser$ParseCompleteException {
        String string = attributes.getValue("id");
        String string2 = attributes.getValue("version");
        if (string == null || string.trim().length() == 0) {
            string = "_no_id_";
            Utils.log(NLS.bind((String)Messages.PluginParser_plugin_no_id, (Object[])new String[]{this.location}));
        }
        if (string2 == null || string2.trim().length() == 0) {
            string2 = "0.0.0";
            Utils.log(NLS.bind((String)Messages.PluginParser_plugin_no_version, (Object[])new String[]{this.location}));
        }
        this.pluginEntry.setVersionedIdentifier(new VersionedIdentifier(string, string2));
        throw (Throwable)new PluginParser$ParseCompleteException(this, "");
    }
}

