/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FeatureParser
extends DefaultHandler {
    private SAXParser parser;
    private FeatureEntry feature;
    private URL url;
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    public FeatureParser() {
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            System.out.println(sAXException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FeatureEntry parse(URL uRL) {
        this.feature = null;
        InputStream inputStream = null;
        try {
            try {
                this.url = uRL;
                inputStream = uRL.openStream();
                this.parser.parse(new InputSource(inputStream), (DefaultHandler)this);
                return this.feature;
            }
            catch (SAXException sAXException) {
                if (inputStream == null) return this.feature;
                try {
                    inputStream.close();
                    return this.feature;
                }
                catch (IOException iOException) {
                    Utils.log(iOException.getLocalizedMessage());
                }
                return this.feature;
            }
            catch (IOException iOException) {
                if (inputStream == null) return this.feature;
                try {
                    inputStream.close();
                    return this.feature;
                }
                catch (IOException iOException2) {
                    Utils.log(iOException2.getLocalizedMessage());
                }
                return this.feature;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Utils.log(iOException.getLocalizedMessage());
                }
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Utils.debug("Start Element: uri:" + string + " local Name:" + string2 + " qName:" + string3);
        if ("feature".equals(string2)) {
            this.processFeature(attributes);
            throw (Throwable)new SAXException("");
        }
    }

    private void processFeature(Attributes attributes) {
        String string = attributes.getValue("id");
        String string2 = attributes.getValue("version");
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("")) {
            System.out.println(NLS.bind((String)Messages.FeatureParser_IdOrVersionInvalid, (Object[])new String[]{string, string2}));
        } else {
            String string3 = attributes.getValue("os");
            String string4 = attributes.getValue("ws");
            String string5 = attributes.getValue("nl");
            String string6 = attributes.getValue("arch");
            if (!Utils.isValidEnvironment(string3, string4, string6, string5)) {
                return;
            }
            String string7 = attributes.getValue("primary");
            boolean bl = "true".equals(string7);
            String string8 = attributes.getValue("application");
            String string9 = attributes.getValue("plugin");
            this.feature = new FeatureEntry(string, string2, string9, "", bl, string8, null);
            if ("file".equals(this.url.getProtocol())) {
                File file = new File(this.url.getFile().replace('/', File.separatorChar));
                this.feature.setURL("features/" + file.getParentFile().getName() + "/");
            } else {
                this.feature.setURL(Utils.makeAbsolute(Utils.getInstallURL(), this.url).toExternalForm());
            }
            Utils.debug("End process DefaultFeature tag: id:" + string + " ver:" + string2 + " url:" + this.feature.getURL());
        }
    }
}

