/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.workingcopies.IWorkingCopyListener;
import com.ibm.team.process.client.workingcopies.WorkingCopyChangeEvent;
import com.ibm.team.process.internal.client.workingcopies.IPropertyWorkingCopy;
import com.ibm.team.repository.common.IItemHandle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;

public abstract class PropertyWorkingCopy
implements IPropertyWorkingCopy {
    private boolean fIsDirty = false;
    private ListenerList fListeners = new ListenerList();

    protected PropertyWorkingCopy() {
    }

    public boolean isDirty() {
        if (!this.isDisposed()) {
            return this.fIsDirty;
        }
        return false;
    }

    public void setDirty(boolean isDirty) {
        this.setDirty(isDirty, false);
    }

    protected void setDirty(boolean isDirty, boolean fireEvent) {
        if (this.fIsDirty != isDirty) {
            boolean wasDirty = this.fIsDirty;
            this.fIsDirty = isDirty;
            if (wasDirty) {
                this.updateUnderlyingPropertyState();
            }
            if (fireEvent) {
                this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "dirtyState", wasDirty, isDirty));
            }
        }
    }

    protected void updateUnderlyingPropertyState() {
    }

    protected void fireWorkingCopyChanged(WorkingCopyChangeEvent event) {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IWorkingCopyListener listener = (IWorkingCopyListener)listeners[i];
            listener.workingCopyChanged(event);
            ++i;
        }
    }

    public void addWorkingCopyListener(IWorkingCopyListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeWorkingCopyListener(IWorkingCopyListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void dispose() {
        this.fListeners.clear();
    }

    protected static boolean havePropertyItemsChanged(List currentItems, List newItems) {
        currentItems = new ArrayList(currentItems);
        newItems = new ArrayList(newItems);
        Iterator e = newItems.iterator();
        block0: while (e.hasNext()) {
            IItemHandle newItem = (IItemHandle)e.next();
            Iterator x = currentItems.iterator();
            while (x.hasNext()) {
                IItemHandle currentItem = (IItemHandle)x.next();
                if (!newItem.sameItemId(currentItem)) continue;
                x.remove();
                e.remove();
                continue block0;
            }
        }
        return !currentItems.isEmpty() || !newItems.isEmpty();
    }
}

