/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.workingcopies.IProcessAttachmentsWorkingCopy;
import com.ibm.team.process.client.workingcopies.IProcessDefinitionWorkingCopy;
import com.ibm.team.process.client.workingcopies.IProcessStateModelHandle;
import com.ibm.team.process.common.IProcessContainer;
import com.ibm.team.process.common.IProcessDefinition;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.internal.client.workingcopies.ContentWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.FileURLWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.ProcessAttachmentsWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.ProcessItemWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.ProcessStateModelHandle;
import com.ibm.team.process.internal.client.workingcopies.StringWorkingCopy;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;

public class ProcessDefinitionWorkingCopy
extends ProcessItemWorkingCopy
implements IProcessDefinitionWorkingCopy {
    private StringWorkingCopy fProcessId;
    private StringWorkingCopy fProcessContentPath;
    private ContentWorkingCopy fProcessSpec;
    private ContentWorkingCopy fProcessState;
    private ProcessAttachmentsWorkingCopy fProcessAttachments;
    private ProcessStateModelHandle fStateModelHandle;

    public ProcessDefinitionWorkingCopy(IProcessDefinition definition) {
        super((IProcessItem)definition, null);
    }

    public IProcessDefinition getUnderlyingProcessDefinition() {
        return (IProcessDefinition)this.getUnderlyingProcessItem();
    }

    public void asyncInitialize(Collection propertyIds) {
        super.asyncInitialize(propertyIds);
        if (propertyIds == null) {
            this.getProcessSpecification();
            this.getProcessState();
            this.getProcessAttachments();
        } else {
            if (propertyIds.contains("processSpecification")) {
                this.getProcessSpecification();
            }
            if (propertyIds.contains("processState")) {
                this.getProcessState();
            }
            if (propertyIds.contains("processAttachments")) {
                this.getProcessAttachments();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument getProcessId() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fProcessId == null) {
            ProcessDefinitionWorkingCopy processDefinitionWorkingCopy = this;
            synchronized (processDefinitionWorkingCopy) {
                if (this.fProcessId == null) {
                    this.fProcessId = new StringWorkingCopy(this.getUnderlyingProcessDefinition().getProcessId());
                    this.addPropertyWorkingCopy(this.fProcessId);
                }
            }
        }
        return this.fProcessId == null ? null : this.fProcessId.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument getProcessContentPath() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fProcessContentPath == null) {
            ProcessDefinitionWorkingCopy processDefinitionWorkingCopy = this;
            synchronized (processDefinitionWorkingCopy) {
                if (this.fProcessContentPath == null) {
                    this.fProcessContentPath = new FileURLWorkingCopy(this.getUnderlyingProcessDefinition().getProcessContentPath());
                    this.addPropertyWorkingCopy(this.fProcessContentPath);
                }
            }
        }
        return this.fProcessContentPath == null ? null : this.fProcessContentPath.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument getProcessSpecification() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fProcessSpec == null) {
            ProcessDefinitionWorkingCopy processDefinitionWorkingCopy = this;
            synchronized (processDefinitionWorkingCopy) {
                if (this.fProcessSpec == null) {
                    ContentWorkingCopy processSpec = new ContentWorkingCopy(this.fCachedTeamRepository, "text/xml", "UTF8");
                    this.addPropertyWorkingCopy(processSpec);
                    IProcessDefinition processDefinition = this.getUnderlyingProcessDefinition();
                    IContent content = (IContent)processDefinition.getProcessData().get("com.ibm.team.internal.process.compiled.xml");
                    processSpec.asyncUpdate(content, 1, this.getUpdateContext(), null);
                    this.fProcessSpec = processSpec;
                }
            }
        }
        return this.fProcessSpec == null ? null : this.fProcessSpec.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument getProcessState() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fProcessState == null) {
            ProcessDefinitionWorkingCopy processDefinitionWorkingCopy = this;
            synchronized (processDefinitionWorkingCopy) {
                if (this.fProcessState == null) {
                    ContentWorkingCopy processState = new ContentWorkingCopy(this.fCachedTeamRepository, "text/xml", "UTF8");
                    this.addPropertyWorkingCopy(processState);
                    IProcessDefinition processDefinition = this.getUnderlyingProcessDefinition();
                    IContent content = (IContent)processDefinition.getProcessData().get("com.ibm.team.internal.process.state.xml");
                    processState.asyncUpdate(content, 1, this.getUpdateContext(), null);
                    this.fProcessState = processState;
                }
            }
        }
        return this.fProcessState == null ? null : this.fProcessState.getDocument();
    }

    public void resetProcessSpecification() {
        if (!this.isDisposed() && this.fProcessSpec != null && this.fProcessSpec.isDirty()) {
            IProcessDefinition processDefinition = this.getUnderlyingProcessDefinition();
            IContent content = (IContent)processDefinition.getProcessData().get("com.ibm.team.internal.process.compiled.xml");
            this.fProcessSpec.asyncUpdate(content, 1, this.getUpdateContext(), null);
            this.fProcessSpec.setDirty(false);
            this.updateDirtyState();
        }
    }

    public void resetProcessState() {
        if (!this.isDisposed() && this.fProcessState != null && this.fProcessState.isDirty()) {
            IProcessDefinition processDefinition = this.getUnderlyingProcessDefinition();
            IContent content = (IContent)processDefinition.getProcessData().get("com.ibm.team.internal.process.state.xml");
            this.fProcessState.asyncUpdate(content, 1, this.getUpdateContext(), null);
            this.fProcessState.setDirty(false);
            this.updateDirtyState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProcessAttachmentsWorkingCopy getProcessAttachments() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fProcessAttachments == null) {
            ProcessDefinitionWorkingCopy processDefinitionWorkingCopy = this;
            synchronized (processDefinitionWorkingCopy) {
                if (this.fProcessAttachments == null) {
                    ProcessAttachmentsWorkingCopy attachments = new ProcessAttachmentsWorkingCopy(this.fCachedTeamRepository);
                    this.addPropertyWorkingCopy(attachments);
                    attachments.asyncUpdate((IProcessContainer)this.getUnderlyingProcessDefinition(), 1, this.getUpdateContext(), null);
                    this.fProcessAttachments = attachments;
                }
            }
        }
        return this.fProcessAttachments;
    }

    protected boolean doSavePropertyWorkingCopies(IProcessItem mutableProcessItem, List itemsToSave, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean saveProcessDefinition = false;
        IProcessDefinition mutableProcessDefinition = (IProcessDefinition)mutableProcessItem;
        monitor.beginTask("", 1000);
        try {
            IContent content;
            Map definitionData;
            if (this.fProcessId != null && this.fProcessId.isDirty()) {
                mutableProcessDefinition.setProcessId(this.fProcessId.getDocument().get());
                saveProcessDefinition = true;
            }
            if (this.fProcessContentPath != null && this.fProcessContentPath.isDirty()) {
                mutableProcessDefinition.setProcessContentPath(this.fProcessContentPath.getDocument().get());
                saveProcessDefinition = true;
            }
            if (this.fProcessAttachments != null && this.fProcessAttachments.isDirty()) {
                if (this.fProcessAttachments.syncSave((IProcessContainer)mutableProcessDefinition, itemsToSave, (IProgressMonitor)new SubProgressMonitor(monitor, 600))) {
                    saveProcessDefinition = true;
                }
            } else {
                monitor.worked(600);
            }
            if (this.fProcessSpec != null && this.fProcessSpec.isDirty()) {
                definitionData = mutableProcessDefinition.getProcessData();
                content = this.fProcessSpec.syncSave((IProgressMonitor)new SubProgressMonitor(monitor, 200));
                if (content != null) {
                    definitionData.put("com.ibm.team.internal.process.compiled.xml", content);
                } else {
                    definitionData.remove("com.ibm.team.internal.process.compiled.xml");
                }
                saveProcessDefinition = true;
            } else {
                monitor.worked(200);
            }
            if (this.fProcessState != null && this.fProcessState.isDirty()) {
                definitionData = mutableProcessDefinition.getProcessData();
                content = this.fProcessState.syncSave((IProgressMonitor)new SubProgressMonitor(monitor, 200));
                if (content != null) {
                    definitionData.put("com.ibm.team.internal.process.state.xml", content);
                } else {
                    definitionData.remove("com.ibm.team.internal.process.state.xml");
                }
                saveProcessDefinition = true;
            } else {
                monitor.worked(200);
            }
        }
        finally {
            monitor.done();
        }
        return saveProcessDefinition;
    }

    protected void doReinitializeFromProcessItem(IProcessItem processItem, int flags) {
        IProcessDefinition processDefinition;
        IProcessDefinition definition;
        if (this.fProcessId != null) {
            definition = (IProcessDefinition)processItem;
            this.fProcessId.asyncUpdate(definition.getProcessId(), this.getUpdateContext());
        }
        if (this.fProcessContentPath != null) {
            definition = (IProcessDefinition)processItem;
            this.fProcessContentPath.asyncUpdate(definition.getProcessContentPath(), this.getUpdateContext());
        }
        if (this.fProcessAttachments != null) {
            definition = (IProcessDefinition)processItem;
            this.fProcessAttachments.asyncUpdate((IProcessContainer)definition, flags, this.getUpdateContext(), null);
        }
        if (this.fProcessSpec != null) {
            processDefinition = (IProcessDefinition)processItem;
            IContent spec = (IContent)processDefinition.getProcessData().get("com.ibm.team.internal.process.compiled.xml");
            this.fProcessSpec.asyncUpdate(spec, flags, this.getUpdateContext(), null);
        }
        if (this.fProcessState != null) {
            processDefinition = (IProcessDefinition)processItem;
            IContent state = (IContent)processDefinition.getProcessData().get("com.ibm.team.internal.process.state.xml");
            this.fProcessState.asyncUpdate(state, flags, this.getUpdateContext(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProcessStateModelHandle getProcessStateModel() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fStateModelHandle == null) {
            ProcessDefinitionWorkingCopy processDefinitionWorkingCopy = this;
            synchronized (processDefinitionWorkingCopy) {
                if (this.fStateModelHandle == null) {
                    this.fStateModelHandle = new ProcessStateModelHandle(this);
                }
            }
        }
        return this.fStateModelHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ProcessDefinitionWorkingCopy processDefinitionWorkingCopy = this;
        synchronized (processDefinitionWorkingCopy) {
            this.fStateModelHandle = null;
            super.dispose();
        }
    }
}

