/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.client.workingcopies.IIterationStructureWorkingCopy;
import com.ibm.team.process.client.workingcopies.IUpdateContext;
import com.ibm.team.process.client.workingcopies.WorkingCopyChangeEvent;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IIterationType;
import com.ibm.team.process.common.IIterationTypeHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.client.workingcopies.ExecUtil;
import com.ibm.team.process.internal.client.workingcopies.Messages;
import com.ibm.team.process.internal.client.workingcopies.PropertyWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.UpdateRequest;
import com.ibm.team.process.internal.common.DevelopmentLine;
import com.ibm.team.process.internal.common.IIterationStructureAccess;
import com.ibm.team.process.internal.common.InvalidAccessException;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.common.ItemHandleAwareHashSet;
import com.ibm.team.process.internal.common.Iteration;
import com.ibm.team.process.internal.common.IterationType;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class IterationStructureWorkingCopy
extends PropertyWorkingCopy
implements IIterationStructureWorkingCopy,
IIterationStructureAccess {
    private ITeamRepository fCachedTeamRepository;
    private IProjectAreaHandle fProjectArea;
    private ArrayList fIterationTypes = new ArrayList();
    private ArrayList fDevelopmentLines = new ArrayList();
    private IDevelopmentLineHandle fProjectDevelopmentLine;
    private LocalWorkingCopyManager fWorkingCopyManager = new LocalWorkingCopyManager();
    private IterationInformationCache fIterationInformationCache = new IterationInformationCache();

    public IterationStructureWorkingCopy(ITeamRepository teamRepository) {
        this.fCachedTeamRepository = teamRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        IterationStructureWorkingCopy iterationStructureWorkingCopy = this;
        synchronized (iterationStructureWorkingCopy) {
            this.fCachedTeamRepository = null;
            this.fProjectArea = null;
            this.fProjectDevelopmentLine = null;
            if (this.fIterationTypes != null) {
                this.fIterationTypes.clear();
                this.fIterationTypes = null;
            }
            if (this.fDevelopmentLines != null) {
                this.fDevelopmentLines.clear();
                this.fDevelopmentLines = null;
            }
            if (this.fWorkingCopyManager != null) {
                this.fWorkingCopyManager.clear();
                this.fWorkingCopyManager = null;
            }
            if (this.fIterationInformationCache != null) {
                this.fIterationInformationCache.clear();
                this.fIterationInformationCache = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        IterationStructureWorkingCopy iterationStructureWorkingCopy = this;
        synchronized (iterationStructureWorkingCopy) {
            return this.fCachedTeamRepository == null;
        }
    }

    public void asyncUpdate(final IProjectAreaHandle projectAreaHandle, int flags, IUpdateContext context, IProgressMonitor monitor) {
        if (this.isDisposed()) {
            return;
        }
        UpdateRequest request = new UpdateRequest(Messages.getString("IterationStructureWorkingCopy.0")){

            public IStatus execute(IUpdateContext context, IProgressMonitor monitor) {
                if (IterationStructureWorkingCopy.this.isDisposed()) {
                    return Status.OK_STATUS;
                }
                monitor.beginTask(this.getName(), 1000);
                try {
                    final ArrayList<IItem> iterationTypes = new ArrayList<IItem>();
                    final ArrayList<IItem> developmentLines = new ArrayList<IItem>();
                    IProjectArea projectArea = null;
                    boolean iterationsChangedOnLoad = false;
                    List itemTrap = IterationStructureWorkingCopy.this.fetchCompleteIterationStructure(projectAreaHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    Iterator e = itemTrap.iterator();
                    while (e.hasNext()) {
                        IItem item = (IItem)e.next();
                        if (item instanceof IIterationType) {
                            iterationTypes.add(item);
                            continue;
                        }
                        if (item instanceof IDevelopmentLine) {
                            developmentLines.add(item);
                            continue;
                        }
                        if (item instanceof IIteration) continue;
                        if (item instanceof IProjectArea) {
                            projectArea = (IProjectArea)item;
                            e.remove();
                            continue;
                        }
                        if (item != null) continue;
                        e.remove();
                        iterationsChangedOnLoad = true;
                    }
                    if (IterationStructureWorkingCopy.this.isDisposed()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    final IDevelopmentLineHandle projectDevelopmentLine = projectArea == null ? null : projectArea.getProjectDevelopmentLine();
                    final LocalWorkingCopyManager workingCopyManager = new LocalWorkingCopyManager(itemTrap);
                    final IterationInformationCache informationCache = IterationStructureWorkingCopy.this.computeIterationInformation(developmentLines, workingCopyManager);
                    final boolean markInitiallyDirty = iterationsChangedOnLoad;
                    Runnable runnable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            boolean isDisposed;
                            IterationStructureWorkingCopy iterationStructureWorkingCopy = IterationStructureWorkingCopy.this;
                            synchronized (iterationStructureWorkingCopy) {
                                isDisposed = IterationStructureWorkingCopy.this.isDisposed();
                                if (!isDisposed) {
                                    IterationStructureWorkingCopy.this.fProjectArea = projectAreaHandle;
                                    IterationStructureWorkingCopy.this.fIterationTypes = iterationTypes;
                                    IterationStructureWorkingCopy.this.fDevelopmentLines = developmentLines;
                                    IterationStructureWorkingCopy.this.fProjectDevelopmentLine = projectDevelopmentLine;
                                    IterationStructureWorkingCopy.this.fWorkingCopyManager = workingCopyManager;
                                    IterationStructureWorkingCopy.this.fIterationInformationCache = informationCache;
                                    IterationStructureWorkingCopy.this.setDirty(markInitiallyDirty, true);
                                }
                            }
                            if (!isDisposed) {
                                IterationStructureWorkingCopy.this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(IterationStructureWorkingCopy.this, "iterationStructure.change", null, null));
                            }
                        }
                    };
                    if (context != null) {
                        context.execute(runnable);
                    } else {
                        runnable.run();
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (TeamRepositoryException x) {
                    if (IterationStructureWorkingCopy.this.isDisposed()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    Status status = new Status(4, "com.ibm.team.process.client", 0, this.getName(), (Throwable)x);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        ExecUtil.asyncExec(request, context, monitor);
    }

    private List fetchCompleteIterationStructure(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessItemService processClientService = (IProcessItemService)this.fCachedTeamRepository.getClientLibrary(IProcessItemService.class);
        return processClientService.fetchCompleteIterationStructure(projectAreaHandle, monitor);
    }

    private IterationInformationCache computeIterationInformation(List developmentLines, LocalWorkingCopyManager workingCopyManager) {
        IterationInformationCache informationCache = new IterationInformationCache();
        for (IDevelopmentLine developmentLine : developmentLines) {
            this.computeCurrentIterations(developmentLine, workingCopyManager, informationCache);
            this.computeCompletedIterations(developmentLine, workingCopyManager, informationCache);
        }
        return informationCache;
    }

    private void computeCurrentIterations(IDevelopmentLine developmentLine, LocalWorkingCopyManager workingCopyManager, IterationInformationCache informationCache) {
        developmentLine = (IDevelopmentLine)this.findCurrentState((IItemHandle)developmentLine, workingCopyManager);
        IIterationHandle iterationHandle = developmentLine.getCurrentIteration();
        while (iterationHandle != null) {
            informationCache.markCurrent(iterationHandle);
            IIteration iteration = (IIteration)this.findCurrentState((IItemHandle)iterationHandle, workingCopyManager);
            iterationHandle = iteration.getParent();
        }
    }

    private void computeCompletedIterations(IDevelopmentLine developmentLine, LocalWorkingCopyManager workingCopyManager, IterationInformationCache informationCache) {
        this.markCompletedIterations(this.getIterations((IDevelopmentLineHandle)developmentLine, workingCopyManager), workingCopyManager, informationCache);
    }

    private void markCompletedIterations(IIteration[] iterations, LocalWorkingCopyManager workingCopyManager, IterationInformationCache informationCache) {
        int i = 0;
        while (i < iterations.length) {
            IIteration iteration = iterations[i];
            if (iteration != null && informationCache.isCurrent((IIterationHandle)iteration)) {
                this.markCompletedIterations(this.getChildIterations((IIterationHandle)iteration, workingCopyManager), workingCopyManager, informationCache);
                break;
            }
            this.markAllCompleted(iteration, workingCopyManager, informationCache);
            ++i;
        }
    }

    private void markAllCompleted(IIteration iteration, LocalWorkingCopyManager workingCopyManager, IterationInformationCache informationCache) {
        if (iteration != null) {
            informationCache.markCompleted((IIterationHandle)iteration);
            IIteration[] children = this.getChildIterations((IIterationHandle)iteration, workingCopyManager);
            int i = 0;
            while (i < children.length) {
                this.markAllCompleted(children[i], workingCopyManager, informationCache);
                ++i;
            }
        }
    }

    public IDevelopmentLine[] getDevelopmentLines() {
        IDevelopmentLine[] lines = new IDevelopmentLine[this.fDevelopmentLines.size()];
        int i = 0;
        while (i < lines.length) {
            IDevelopmentLine developmentLine = (IDevelopmentLine)this.fDevelopmentLines.get(i);
            lines[i] = (IDevelopmentLine)this.findCurrentState((IItemHandle)developmentLine, this.fWorkingCopyManager);
            ++i;
        }
        return lines;
    }

    public IIteration[] getIterations(IDevelopmentLineHandle developmentLineHandle) {
        return this.getIterations(developmentLineHandle, this.fWorkingCopyManager);
    }

    public IIteration[] getChildIterations(IIterationHandle iterationHandle) {
        return this.getChildIterations(iterationHandle, this.fWorkingCopyManager);
    }

    public IIteration getParentIteration(IIterationHandle iterationHandle) {
        IIteration iteration = (IIteration)this.findCurrentState((IItemHandle)iterationHandle, this.fWorkingCopyManager);
        IIterationHandle parentHandle = iteration.getParent();
        if (parentHandle == null) {
            return null;
        }
        return (IIteration)this.findCurrentState((IItemHandle)parentHandle, this.fWorkingCopyManager);
    }

    public IDevelopmentLine getDevelopmentLine(IIterationHandle iterationHandle) {
        IIteration iteration = (IIteration)this.findCurrentState((IItemHandle)iterationHandle, this.fWorkingCopyManager);
        IDevelopmentLineHandle developmentLineHandle = iteration.getDevelopmentLine();
        if (developmentLineHandle == null) {
            return null;
        }
        return (IDevelopmentLine)this.findCurrentState((IItemHandle)developmentLineHandle, this.fWorkingCopyManager);
    }

    public boolean isCurrentIteration(IIterationHandle iterationHandle) {
        return this.fIterationInformationCache.isCurrent(iterationHandle);
    }

    public boolean isCurrentLeafIteration(IIterationHandle iterationHandle) {
        IIteration iteration = (IIteration)this.findCurrentState((IItemHandle)iterationHandle, this.fWorkingCopyManager);
        IIterationHandle[] children = iteration.getChildren();
        if (children == null || children.length == 0) {
            return this.isCurrentIteration((IIterationHandle)iteration);
        }
        return false;
    }

    public boolean isLeafIteration(IIterationHandle iterationHandle, boolean ignoreArchivedChildren) {
        IIteration iteration = (IIteration)this.findCurrentState((IItemHandle)iterationHandle, this.fWorkingCopyManager);
        IIterationHandle[] children = iteration.getChildren();
        return children == null || children.length == 0 || ignoreArchivedChildren && this.isArchived(children);
    }

    private boolean isArchived(IIterationHandle[] children) {
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                IIteration iteration = this.getSharedMutableIteration(children[i]);
                if (!iteration.isArchived()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean isCompletedIteration(IIterationHandle iterationHandle) {
        return this.fIterationInformationCache.isCompleted(iterationHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDevelopmentLine getSharedMutableDevelopmentLine(IDevelopmentLineHandle developmentLineHandle) {
        IterationStructureWorkingCopy iterationStructureWorkingCopy = this;
        synchronized (iterationStructureWorkingCopy) {
            if (this.isDisposed()) {
                throw new InvalidAccessException();
            }
            return (IDevelopmentLine)this.fWorkingCopyManager.getWorkingCopy((IItemHandle)developmentLineHandle, true);
        }
    }

    public IDevelopmentLine createDevelopmentLine(String id, String name, Date startDate, Date endDate) {
        IDevelopmentLine developmentLine = this.internalCreateDevelopmentLine(id, name, startDate, endDate);
        this.commitChanges(new IProcessItem[]{developmentLine}, "iterationStructure.add", false);
        return developmentLine;
    }

    private IDevelopmentLine internalCreateDevelopmentLine(String id, String name, Date startDate, Date endDate) {
        IProcessItemService service = (IProcessItemService)this.fCachedTeamRepository.getClientLibrary(IProcessItemService.class);
        IDevelopmentLine developmentLine = (IDevelopmentLine)this.fWorkingCopyManager.add((IItem)service.createDevelopmentLine());
        developmentLine.setProjectArea(this.fProjectArea);
        developmentLine.setId(id);
        developmentLine.setName(name);
        developmentLine.setStartDate(startDate);
        developmentLine.setEndDate(endDate);
        this.fDevelopmentLines.add(developmentLine);
        return developmentLine;
    }

    public boolean isProjectDevelopmentLine(IDevelopmentLineHandle lineHandle) {
        return this.fProjectDevelopmentLine != null && this.fProjectDevelopmentLine.sameItemId((IItemHandle)lineHandle);
    }

    public IDevelopmentLine getProjectDevelopmentLine() {
        if (this.fProjectDevelopmentLine != null) {
            return (IDevelopmentLine)this.findCurrentState((IItemHandle)this.fProjectDevelopmentLine, this.fWorkingCopyManager);
        }
        return null;
    }

    public void setProjectDevelopmentLine(IDevelopmentLineHandle lineHandle) {
        if (!this.containsDevelopmentLine(lineHandle)) {
            throw new IllegalArgumentException();
        }
        this.fProjectDevelopmentLine = lineHandle;
        IDevelopmentLine developmentLine = (IDevelopmentLine)this.findCurrentState((IItemHandle)lineHandle, this.fWorkingCopyManager);
        developmentLine = this.getSharedMutableDevelopmentLine((IDevelopmentLineHandle)developmentLine);
        this.commitChanges(new IProcessItem[]{developmentLine}, "iterationStructure.update", false);
    }

    public void removeProjectDevelopmentLine() {
        if (this.fProjectDevelopmentLine != null) {
            IDevelopmentLine previous = this.getSharedMutableDevelopmentLine(this.fProjectDevelopmentLine);
            this.fProjectDevelopmentLine = null;
            this.commitChanges(new IProcessItem[]{previous}, "iterationStructure.update", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IIteration getSharedMutableIteration(IIterationHandle iterationHandle) {
        IterationStructureWorkingCopy iterationStructureWorkingCopy = this;
        synchronized (iterationStructureWorkingCopy) {
            if (this.isDisposed()) {
                throw new InvalidAccessException();
            }
            return (IIteration)this.fWorkingCopyManager.getWorkingCopy((IItemHandle)iterationHandle, true);
        }
    }

    public IIteration createIteration(IProcessItem parent, IIterationTypeHandle iterationTypeHandle, String newId, String newName, Date startDate, Date endDate, boolean hasDeliverable) {
        IIteration iteration = this.internalCreateIteration(parent);
        iteration.setIterationType(iterationTypeHandle);
        iteration.setId(newId);
        iteration.setName(newName);
        iteration.setStartDate(startDate);
        iteration.setEndDate(endDate);
        iteration.setHasDeliverable(hasDeliverable);
        this.commitChanges(new IProcessItem[]{iteration}, "iterationStructure.add", false);
        return iteration;
    }

    private IIteration internalCreateIteration(IProcessItem parent) {
        IIteration newIteration = this.createIteration();
        if (parent instanceof IDevelopmentLineHandle) {
            IDevelopmentLine developmentLine = this.getSharedMutableDevelopmentLine((IDevelopmentLineHandle)parent);
            developmentLine.addIteration((IIterationHandle)newIteration);
            newIteration.setDevelopmentLine((IDevelopmentLineHandle)developmentLine);
        } else if (parent instanceof IIteration) {
            IIteration parentIteration = this.getSharedMutableIteration((IIterationHandle)((IIteration)parent));
            parentIteration.addChild((IIterationHandle)newIteration);
            newIteration.setParent((IIterationHandle)parentIteration);
            newIteration.setDevelopmentLine((IDevelopmentLineHandle)this.getDevelopmentLine((IIterationHandle)parentIteration));
        }
        return newIteration;
    }

    private IIteration createIteration() {
        IProcessItemService service = (IProcessItemService)this.fCachedTeamRepository.getClientLibrary(IProcessItemService.class);
        return (IIteration)this.fWorkingCopyManager.add((IItem)service.createIteration());
    }

    private void commitChanges(IProcessItem[] workingCopies, String eventProperty, boolean flushIterationInformation) {
        if (this.fWorkingCopyManager.isValidWorkingCopies((IItem[])workingCopies)) {
            if (flushIterationInformation) {
                this.fIterationInformationCache = this.computeIterationInformation(this.fDevelopmentLines, this.fWorkingCopyManager);
            }
            this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, eventProperty, workingCopies, workingCopies));
            this.setDirty(true, true);
        }
    }

    private IIteration[] getIterations(IDevelopmentLineHandle developmentLineHandle, LocalWorkingCopyManager workingCopyManager) {
        IDevelopmentLine developmentLine = (IDevelopmentLine)this.findCurrentState((IItemHandle)developmentLineHandle, workingCopyManager);
        return this.findCurrentIterationStates(developmentLine.getIterations(), workingCopyManager);
    }

    private IIteration[] getChildIterations(IIterationHandle iterationHandle, LocalWorkingCopyManager workingCopyManager) {
        IIteration iteration = (IIteration)this.findCurrentState((IItemHandle)iterationHandle, workingCopyManager);
        return this.findCurrentIterationStates(iteration.getChildren(), workingCopyManager);
    }

    public IIteration getCurrentIteration(IDevelopmentLineHandle developmentLineHandle) {
        IDevelopmentLine developmentLine = (IDevelopmentLine)this.findCurrentState((IItemHandle)developmentLineHandle, this.fWorkingCopyManager);
        IIterationHandle currentIteration = developmentLine.getCurrentIteration();
        if (currentIteration != null) {
            return (IIteration)this.findCurrentState((IItemHandle)currentIteration, this.fWorkingCopyManager);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IItem findCurrentState(IItemHandle itemHandle, LocalWorkingCopyManager workingCopyManager) {
        IterationStructureWorkingCopy iterationStructureWorkingCopy = this;
        synchronized (iterationStructureWorkingCopy) {
            if (this.isDisposed()) {
                throw new InvalidAccessException();
            }
            IItem item = workingCopyManager.getWorkingCopy(itemHandle, false);
            if (item == null) {
                item = this.fCachedTeamRepository.itemManager().getSharedItemIfKnown(itemHandle);
                Assert.isNotNull((Object)item);
            }
            return item;
        }
    }

    private IIteration[] findCurrentIterationStates(IIterationHandle[] iterationHandles, LocalWorkingCopyManager workingCopyManager) {
        if (iterationHandles == null || iterationHandles.length == 0) {
            return new IIteration[0];
        }
        IIteration[] iterations = new IIteration[iterationHandles.length];
        int i = 0;
        while (i < iterationHandles.length) {
            iterations[i] = (IIteration)this.findCurrentState((IItemHandle)iterationHandles[i], workingCopyManager);
            ++i;
        }
        return iterations;
    }

    public boolean syncSave(IProjectArea mutableProcessArea, List processItemsToSaveCollector, IProgressMonitor monitor) {
        List workingCopies = this.fWorkingCopyManager.getWorkingCopies();
        this.sortWorkingCopies(workingCopies);
        processItemsToSaveCollector.addAll(workingCopies);
        mutableProcessArea.setDevelopmentLines((IDevelopmentLineHandle[])this.fDevelopmentLines.toArray(new IDevelopmentLine[this.fDevelopmentLines.size()]));
        mutableProcessArea.setProjectDevelopmentLine(this.fProjectDevelopmentLine);
        mutableProcessArea.setIterationTypes((IIterationTypeHandle[])this.fIterationTypes.toArray(new IIterationType[this.fIterationTypes.size()]));
        return true;
    }

    private void sortWorkingCopies(List workingCopies) {
        Collections.sort(workingCopies, new Comparator(){

            public int compare(Object left, Object right) {
                int leftWeight = 3;
                if (left instanceof IIteration) {
                    leftWeight = 2;
                } else if (left instanceof IDevelopmentLine) {
                    leftWeight = 1;
                }
                int rightWeight = 3;
                if (right instanceof IIteration) {
                    rightWeight = 2;
                } else if (right instanceof IDevelopmentLine) {
                    rightWeight = 1;
                }
                return leftWeight - rightWeight;
            }
        });
    }

    protected void updateUnderlyingPropertyState() {
        this.fWorkingCopyManager.abandonWorkingCopies();
    }

    public void archiveSubtrees(IProcessItem[] rootsToDelete) {
        if (rootsToDelete == null) {
            throw new IllegalArgumentException();
        }
        if (rootsToDelete.length > 0) {
            boolean wordChange = false;
            ArrayList<Object> workingCopies = new ArrayList<Object>();
            int i = 0;
            while (i < rootsToDelete.length) {
                if (rootsToDelete[i] instanceof IDevelopmentLine) {
                    IDevelopmentLine developmentLine = this.getSharedMutableDevelopmentLine((IDevelopmentLineHandle)((IDevelopmentLine)rootsToDelete[i]));
                    this.archiveIterations(this.getIterations((IDevelopmentLineHandle)developmentLine, this.fWorkingCopyManager));
                    boolean archived = this.archiveDevelopmentLine(developmentLine);
                    if (archived) {
                        workingCopies.add(developmentLine);
                    } else {
                        wordChange = true;
                    }
                } else if (rootsToDelete[i] instanceof IIteration) {
                    IIteration iteration = this.getSharedMutableIteration((IIterationHandle)((IIteration)rootsToDelete[i]));
                    IIteration parent = this.getParentIteration((IIterationHandle)iteration);
                    if (parent == null) {
                        parent = this.getDevelopmentLine((IIterationHandle)iteration);
                    }
                    this.archiveIterations(this.getChildIterations((IIterationHandle)iteration, this.fWorkingCopyManager));
                    boolean archived = this.archiveIteration(iteration);
                    if (archived) {
                        workingCopies.add(iteration);
                    } else {
                        workingCopies.add(parent);
                    }
                }
                ++i;
            }
            if (wordChange) {
                this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "iterationStructure.change", null, null));
                this.setDirty(true, true);
            } else {
                IProcessItem[] archived = workingCopies.toArray(new IProcessItem[workingCopies.size()]);
                this.commitChanges(archived, "iterationStructure.archive", false);
            }
        }
    }

    private boolean archiveDevelopmentLine(IDevelopmentLine developmentLine) {
        IIteration[] childIterations;
        ((DevelopmentLine)developmentLine).setArchived(true);
        if (developmentLine.isNewItem() && (childIterations = this.getIterations((IDevelopmentLineHandle)developmentLine)).length == 0) {
            Iterator e = this.fDevelopmentLines.iterator();
            while (e.hasNext()) {
                IDevelopmentLine line = (IDevelopmentLine)e.next();
                if (!developmentLine.sameItemId((IItemHandle)line)) continue;
                e.remove();
                this.fWorkingCopyManager.remove((IItemHandle)developmentLine);
                return false;
            }
        }
        return true;
    }

    private boolean archiveIteration(IIteration iteration) {
        IIteration[] childIterations;
        ((Iteration)iteration).setArchived(true);
        if (iteration.isNewItem() && (childIterations = this.getChildIterations((IIterationHandle)iteration)).length == 0) {
            IIteration parentIteration;
            IDevelopmentLine developmentLine = this.getDevelopmentLine((IIterationHandle)iteration);
            IIteration currentIteration = this.getCurrentIteration((IDevelopmentLineHandle)developmentLine);
            if (currentIteration != null && iteration.sameItemId((IItemHandle)currentIteration)) {
                this.removeCurrentIteration((IDevelopmentLineHandle)developmentLine, true);
            }
            if ((parentIteration = this.getParentIteration((IIterationHandle)iteration)) != null) {
                parentIteration = this.getSharedMutableIteration((IIterationHandle)parentIteration);
                parentIteration.removeChild((IIterationHandle)iteration);
                iteration.setParent(null);
                iteration.setDevelopmentLine(null);
            } else {
                developmentLine = this.getSharedMutableDevelopmentLine((IDevelopmentLineHandle)developmentLine);
                developmentLine.removeIteration((IIterationHandle)iteration);
                iteration.setDevelopmentLine(null);
            }
            this.fWorkingCopyManager.remove((IItemHandle)iteration);
            return false;
        }
        return true;
    }

    private void archiveIterations(IIteration[] iterations) {
        if (iterations != null && iterations.length > 0) {
            int i = 0;
            while (i < iterations.length) {
                this.archiveIterations(this.getChildIterations((IIterationHandle)iterations[i]));
                this.archiveIteration(this.getSharedMutableIteration((IIterationHandle)iterations[i]));
                ++i;
            }
        }
    }

    public void moveIterationSubtree(IIteration iteration, IProcessItem target, boolean isTargetPotentialSibling) {
        if (iteration == null || target == null) {
            throw new IllegalArgumentException();
        }
        ItemHandleAwareHashSet rootsToUpdate = new ItemHandleAwareHashSet();
        iteration = this.getSharedMutableIteration((IIterationHandle)iteration);
        IDevelopmentLine previousDevelopmentLine = this.getDevelopmentLine((IIterationHandle)iteration);
        IIteration previousParentIteration = this.getParentIteration((IIterationHandle)iteration);
        if (previousParentIteration != null) {
            previousParentIteration = this.getSharedMutableIteration((IIterationHandle)previousParentIteration);
            previousParentIteration.removeChild((IIterationHandle)iteration);
            iteration.setParent(null);
            rootsToUpdate.add((Object)previousParentIteration);
        } else {
            previousDevelopmentLine = this.getSharedMutableDevelopmentLine((IDevelopmentLineHandle)previousDevelopmentLine);
            previousDevelopmentLine.removeIteration((IIterationHandle)iteration);
            rootsToUpdate.add((Object)previousDevelopmentLine);
        }
        IIteration anchor = null;
        if (isTargetPotentialSibling && target instanceof IIteration) {
            anchor = (IIteration)target;
            IIteration parent = this.getParentIteration((IIterationHandle)((IIteration)target));
            target = parent == null ? this.getDevelopmentLine((IIterationHandle)((IIteration)target)) : parent;
        }
        IDevelopmentLine targetDevelopmentLine = null;
        if (target instanceof IIteration) {
            IIteration newParentIteration = (IIteration)target;
            newParentIteration = this.getSharedMutableIteration((IIterationHandle)newParentIteration);
            newParentIteration.insertChildAfter((IIterationHandle)iteration, (IIterationHandle)anchor);
            iteration.setParent((IIterationHandle)newParentIteration);
            targetDevelopmentLine = this.getDevelopmentLine((IIterationHandle)newParentIteration);
            rootsToUpdate.add((Object)newParentIteration);
        } else if (target instanceof IDevelopmentLine) {
            targetDevelopmentLine = (IDevelopmentLine)target;
            targetDevelopmentLine = this.getSharedMutableDevelopmentLine((IDevelopmentLineHandle)targetDevelopmentLine);
            targetDevelopmentLine.insertIterationAfter((IIterationHandle)iteration, (IIterationHandle)anchor);
            rootsToUpdate.add((Object)targetDevelopmentLine);
        }
        if (!targetDevelopmentLine.sameItemId((IItemHandle)previousDevelopmentLine)) {
            if (this.isCurrentIteration((IIterationHandle)iteration)) {
                IDevelopmentLine line = this.removeCurrentIteration((IDevelopmentLineHandle)previousDevelopmentLine, false);
                rootsToUpdate.add((Object)line);
            }
            iteration.setDevelopmentLine((IDevelopmentLineHandle)targetDevelopmentLine);
            this.setDevelopmentLine(this.getChildIterations((IIterationHandle)iteration), targetDevelopmentLine);
        }
        this.commitChanges(this.consolidateRoots(rootsToUpdate), "iterationStructure.move", true);
    }

    private IProcessItem[] consolidateRoots(ItemHandleAwareHashSet rootsToUpdate) {
        ArrayList minimalRoots = new ArrayList(rootsToUpdate);
        block0: for (IProcessItem processItem : rootsToUpdate) {
            if (!(processItem instanceof IIteration)) continue;
            IIteration iteration = (IIteration)processItem;
            IDevelopmentLine developmentLine = this.getDevelopmentLine((IIterationHandle)iteration);
            IIteration parent = iteration;
            while (parent != null) {
                for (IProcessItem potentialRoot : minimalRoots) {
                    if (potentialRoot.sameItemId((IItemHandle)developmentLine)) {
                        minimalRoots.remove(iteration);
                        continue block0;
                    }
                    if (parent == iteration || !potentialRoot.sameItemId((IItemHandle)parent)) continue;
                    minimalRoots.remove(iteration);
                    continue block0;
                }
                parent = this.getParentIteration((IIterationHandle)parent);
            }
        }
        return minimalRoots.toArray(new IProcessItem[minimalRoots.size()]);
    }

    private void setDevelopmentLine(IIteration[] iterations, IDevelopmentLine developmentLine) {
        if (iterations == null || iterations.length == 0) {
            return;
        }
        int i = 0;
        while (i < iterations.length) {
            IIteration iteration = this.getSharedMutableIteration((IIterationHandle)iterations[i]);
            iteration.setDevelopmentLine((IDevelopmentLineHandle)developmentLine);
            this.setDevelopmentLine(this.getChildIterations((IIterationHandle)iteration), developmentLine);
            ++i;
        }
    }

    public IDevelopmentLine duplicateDevelopmentLine(IDevelopmentLine origin, String id, String name, Date startDate, Date endDate) {
        if (origin != null && origin.isArchived()) {
            return null;
        }
        IDevelopmentLine duplicate = this.internalCreateDevelopmentLine(id, name, startDate, endDate);
        IIteration[] iterations = this.getIterations((IDevelopmentLineHandle)origin);
        int i = 0;
        while (i < iterations.length) {
            IIteration iteration = iterations[i];
            if (!iteration.isArchived()) {
                this.internalDuplicateIteration(iteration, (IProcessItem)duplicate);
            }
            ++i;
        }
        this.commitChanges(new IProcessItem[]{duplicate}, "iterationStructure.add", true);
        return duplicate;
    }

    public IIteration duplicateIteration(IIteration origin, String id, String name, Date startDate, Date endDate) {
        if (origin != null && origin.isArchived()) {
            return null;
        }
        IIteration parent = this.getParentIteration((IIterationHandle)origin);
        if (parent == null) {
            parent = this.getDevelopmentLine((IIterationHandle)origin);
        }
        IIteration duplicate = this.internalDuplicateIteration(origin, (IProcessItem)parent);
        duplicate.setId(id);
        duplicate.setName(name);
        duplicate.setStartDate(startDate);
        duplicate.setEndDate(endDate);
        this.commitChanges(new IProcessItem[]{duplicate}, "iterationStructure.add", true);
        return duplicate;
    }

    private IIteration internalDuplicateIteration(IIteration origin, IProcessItem parent) {
        IIteration copy = this.internalCreateIteration(parent);
        copy.setId(origin.getId());
        copy.setName(origin.getName());
        copy.setIterationType(origin.getIterationType());
        copy.setStartDate(origin.getStartDate());
        copy.setEndDate(origin.getEndDate());
        copy.setHasDeliverable(origin.hasDeliverable());
        IIteration[] children = this.getChildIterations((IIterationHandle)origin);
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                IIteration child = children[i];
                if (!child.isArchived()) {
                    this.internalDuplicateIteration(child, (IProcessItem)copy);
                }
                ++i;
            }
        }
        return copy;
    }

    public IIteration updateIterationProperties(IIterationHandle iterationHandle, IIterationTypeHandle iterationTypeHandle, String newId, String newName, Date startDate, Date endDate, boolean hasDeliverable) {
        IIteration workingCopy = this.getSharedMutableIteration(iterationHandle);
        workingCopy.setIterationType(iterationTypeHandle);
        workingCopy.setId(newId);
        workingCopy.setName(newName);
        workingCopy.setStartDate(startDate);
        workingCopy.setEndDate(endDate);
        workingCopy.setHasDeliverable(hasDeliverable);
        this.commitChanges(new IProcessItem[]{workingCopy}, "iterationStructure.update", false);
        return workingCopy;
    }

    public IDevelopmentLine updateDevelopmentLineProperties(IDevelopmentLineHandle developmentLineHandle, String newId, String newName, Date startDate, Date endDate) {
        IDevelopmentLine devLineWorkingCopy = this.getSharedMutableDevelopmentLine(developmentLineHandle);
        devLineWorkingCopy.setId(newId);
        devLineWorkingCopy.setName(newName);
        devLineWorkingCopy.setStartDate(startDate);
        devLineWorkingCopy.setEndDate(endDate);
        this.commitChanges(new IProcessItem[]{devLineWorkingCopy}, "iterationStructure.update", false);
        return devLineWorkingCopy;
    }

    public IDevelopmentLine setCurrentIteration(IIterationHandle iterationHandle, boolean allowArchivedChildren) {
        if (!this.isLeafIteration(iterationHandle, allowArchivedChildren)) {
            throw new IllegalArgumentException();
        }
        IDevelopmentLine developmentLine = this.getDevelopmentLine(iterationHandle);
        developmentLine = this.getSharedMutableDevelopmentLine((IDevelopmentLineHandle)developmentLine);
        developmentLine.setCurrentIteration(iterationHandle);
        this.commitChanges(new IProcessItem[]{developmentLine}, "iterationStructure.update", true);
        return developmentLine;
    }

    private IDevelopmentLine removeCurrentIteration(IDevelopmentLineHandle developmentLineHandle, boolean commitChanges) {
        IDevelopmentLine developmentLine = this.getSharedMutableDevelopmentLine(developmentLineHandle);
        developmentLine.setCurrentIteration(null);
        if (commitChanges) {
            this.commitChanges(new IProcessItem[]{developmentLine}, "iterationStructure.update", true);
        }
        return developmentLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDevelopmentLine(IDevelopmentLineHandle developmentLineHandle) {
        IterationStructureWorkingCopy iterationStructureWorkingCopy = this;
        synchronized (iterationStructureWorkingCopy) {
            if (this.isDisposed()) {
                throw new InvalidAccessException();
            }
            return this.fWorkingCopyManager.manages((IItemHandle)developmentLineHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsIteration(IIterationHandle iterationHandle) {
        IterationStructureWorkingCopy iterationStructureWorkingCopy = this;
        synchronized (iterationStructureWorkingCopy) {
            if (this.isDisposed()) {
                throw new InvalidAccessException();
            }
            return this.fWorkingCopyManager.manages((IItemHandle)iterationHandle);
        }
    }

    public int size() {
        return this.fWorkingCopyManager.getNumberOfManagedItems();
    }

    public IIterationType getIterationType(IIterationHandle iterationHandle) {
        IIteration iteration = (IIteration)this.findCurrentState((IItemHandle)iterationHandle, this.fWorkingCopyManager);
        IIterationTypeHandle iterationTypeHandle = iteration.getIterationType();
        if (iterationTypeHandle == null) {
            return null;
        }
        return (IIterationType)this.findCurrentState((IItemHandle)iterationTypeHandle, this.fWorkingCopyManager);
    }

    public IIterationType[] getIterationTypes() {
        IIterationType[] types = new IIterationType[this.fIterationTypes.size()];
        int i = 0;
        while (i < types.length) {
            IIterationType iterationType = (IIterationType)this.fIterationTypes.get(i);
            types[i] = (IIterationType)this.findCurrentState((IItemHandle)iterationType, this.fWorkingCopyManager);
            ++i;
        }
        return types;
    }

    public IIterationType createIterationType(String id, String name, String summary) {
        IIterationType iterationType = this.internalCreateIterationType(id, name, summary);
        this.commitChanges(new IProcessItem[]{iterationType}, "iterationStructure.add", false);
        return iterationType;
    }

    private IIterationType internalCreateIterationType(String id, String name, String summary) {
        IProcessItemService service = (IProcessItemService)this.fCachedTeamRepository.getClientLibrary(IProcessItemService.class);
        IIterationType iterationType = (IIterationType)this.fWorkingCopyManager.add((IItem)service.createIterationType());
        iterationType.setProjectArea(this.fProjectArea);
        iterationType.setId(id);
        iterationType.setName(name);
        iterationType.getDescription().setSummary(summary);
        this.fIterationTypes.add(iterationType);
        return iterationType;
    }

    public IIterationType updateIterationTypeProperties(IIterationTypeHandle iterationTypeHandle, String newId, String newName, String newSummary) {
        IIterationType workingCopy = this.getSharedMutableIterationType(iterationTypeHandle);
        workingCopy.setId(newId);
        workingCopy.setName(newName);
        workingCopy.getDescription().setSummary(newSummary);
        this.commitChanges(new IProcessItem[]{workingCopy}, "iterationStructure.update", false);
        return workingCopy;
    }

    public void archiveIterationType(IIterationTypeHandle iterationTypeHandle) {
        int size;
        if (iterationTypeHandle == null) {
            throw new IllegalArgumentException();
        }
        IIterationType iterationType = this.getSharedMutableIterationType(iterationTypeHandle);
        ((IterationType)iterationType).setArchived(true);
        ArrayList changedIterations = new ArrayList();
        if (iterationType.isNewItem()) {
            IDevelopmentLine[] developmentLines = this.getDevelopmentLines();
            int i = 0;
            while (i < developmentLines.length) {
                IDevelopmentLine developmentLine = developmentLines[i];
                this.archiveIterationType(iterationType, this.getIterations((IDevelopmentLineHandle)developmentLine, this.fWorkingCopyManager), changedIterations);
                ++i;
            }
            Iterator e = this.fIterationTypes.iterator();
            while (e.hasNext()) {
                IIterationType type = (IIterationType)e.next();
                if (!iterationType.sameItemId((IItemHandle)type)) continue;
                e.remove();
                this.fWorkingCopyManager.remove((IItemHandle)iterationType);
                break;
            }
        }
        if ((size = changedIterations.size()) > 0) {
            IProcessItem[] changed = changedIterations.toArray(new IProcessItem[size]);
            this.commitChanges(changed, "iterationStructure.change", false);
        }
        this.commitChanges(new IProcessItem[]{iterationType}, "iterationStructure.archive", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IIterationType getSharedMutableIterationType(IIterationTypeHandle iterationTypeHandle) {
        IterationStructureWorkingCopy iterationStructureWorkingCopy = this;
        synchronized (iterationStructureWorkingCopy) {
            if (this.isDisposed()) {
                throw new InvalidAccessException();
            }
            return (IIterationType)this.fWorkingCopyManager.getWorkingCopy((IItemHandle)iterationTypeHandle, true);
        }
    }

    private void archiveIterationType(IIterationType iterationType, IIteration[] iterations, List changedIterationsCollector) {
        if (iterations != null && iterations.length > 0) {
            int i = 0;
            while (i < iterations.length) {
                IIteration iteration = iterations[i];
                this.archiveIterationType(iterationType, this.getChildIterations((IIterationHandle)iteration), changedIterationsCollector);
                if (iterationType.sameItemId((IItemHandle)iteration.getIterationType())) {
                    IIteration workingCopy = this.getSharedMutableIteration((IIterationHandle)iteration);
                    workingCopy.setIterationType(null);
                    changedIterationsCollector.add(workingCopy);
                }
                ++i;
            }
        }
    }

    private static class IterationInformationCache {
        private ItemHandleAwareHashSet fCurrent = new ItemHandleAwareHashSet();
        private ItemHandleAwareHashSet fCompleted = new ItemHandleAwareHashSet();

        private IterationInformationCache() {
        }

        public void markCurrent(IIterationHandle iterationHandle) {
            this.fCurrent.add((Object)iterationHandle);
        }

        public void markCompleted(IIterationHandle iterationHandle) {
            this.fCompleted.add((Object)iterationHandle);
        }

        public boolean isCurrent(IIterationHandle iterationHandle) {
            return this.fCurrent.contains((Object)iterationHandle);
        }

        public boolean isCompleted(IIterationHandle iterationHandle) {
            return this.fCompleted.contains((Object)iterationHandle);
        }

        public void clear() {
            this.fCurrent.clear();
            this.fCompleted.clear();
        }
    }

    private class LocalWorkingCopyManager {
        private ItemHandleAwareHashMap fWorkingCopies = new ItemHandleAwareHashMap();
        private ItemHandleAwareHashSet fAddedItems = new ItemHandleAwareHashSet();

        public LocalWorkingCopyManager() {
        }

        public LocalWorkingCopyManager(List originals) {
            Iterator e = originals.iterator();
            while (e.hasNext()) {
                this.fWorkingCopies.put(e.next(), null);
            }
        }

        public boolean manages(IItemHandle itemHandle) {
            return this.fWorkingCopies.containsKey((Object)itemHandle);
        }

        public int getNumberOfManagedItems() {
            return this.fWorkingCopies.size();
        }

        public IItem add(IItem item) {
            if (this.manages((IItemHandle)item)) {
                throw new IllegalArgumentException();
            }
            IItem workingCopy = item.getWorkingCopy();
            this.fWorkingCopies.put((Object)item, (Object)workingCopy);
            this.fAddedItems.add((Object)item);
            return workingCopy;
        }

        public void remove(IItemHandle itemHandle) {
            if (!this.manages(itemHandle)) {
                throw new IllegalArgumentException();
            }
            this.fAddedItems.remove((Object)itemHandle);
            this.fWorkingCopies.remove((Object)itemHandle);
        }

        public IItem getWorkingCopy(IItemHandle itemHandle, boolean create) {
            if (!this.manages(itemHandle)) {
                throw new IllegalArgumentException();
            }
            IItem workingCopy = (IItem)this.fWorkingCopies.get((Object)itemHandle);
            if (workingCopy == null && create) {
                IItem item = IterationStructureWorkingCopy.this.fCachedTeamRepository.itemManager().getSharedItemIfKnown(itemHandle);
                Assert.isNotNull((Object)item);
                workingCopy = item.getWorkingCopy();
                this.fWorkingCopies.put((Object)itemHandle, (Object)workingCopy);
            }
            return workingCopy;
        }

        public boolean isValidWorkingCopy(IItem workingCopy) {
            return workingCopy != null && this.fWorkingCopies.containsValue((Object)workingCopy);
        }

        public boolean isValidWorkingCopies(IItem[] workingCopies) {
            if (workingCopies != null) {
                int i = 0;
                while (i < workingCopies.length) {
                    IItem item = workingCopies[i];
                    if (!this.isValidWorkingCopy(item)) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        public List getWorkingCopies() {
            ArrayList<IItem> workingCopies = new ArrayList<IItem>();
            for (IItem item : this.fWorkingCopies.values()) {
                if (item == null) continue;
                workingCopies.add(item);
            }
            return workingCopies;
        }

        public void abandonWorkingCopies() {
            IItemManager itemManager = IterationStructureWorkingCopy.this.fCachedTeamRepository.itemManager();
            ItemHandleAwareHashMap workingCopies = new ItemHandleAwareHashMap();
            for (IItem item : this.fWorkingCopies.keySet()) {
                if (this.fAddedItems.contains((Object)item)) {
                    IItem sharedItem = itemManager.getSharedItemIfKnown((IItemHandle)item);
                    if (sharedItem == null) continue;
                    workingCopies.put((Object)sharedItem, null);
                    continue;
                }
                workingCopies.put((Object)item, null);
            }
            this.fAddedItems.clear();
            this.fWorkingCopies = workingCopies;
        }

        public void clear() {
            this.fWorkingCopies.clear();
            this.fAddedItems.clear();
        }
    }
}

