/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client.workingcopies;

import com.ibm.team.process.client.workingcopies.IContributorListWorkingCopy;
import com.ibm.team.process.client.workingcopies.IUpdateContext;
import com.ibm.team.process.client.workingcopies.WorkingCopyChangeEvent;
import com.ibm.team.process.internal.client.workingcopies.ExecUtil;
import com.ibm.team.process.internal.client.workingcopies.Messages;
import com.ibm.team.process.internal.client.workingcopies.PropertyWorkingCopy;
import com.ibm.team.process.internal.client.workingcopies.UpdateRequest;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ContributorListWorkingCopy
extends PropertyWorkingCopy
implements IContributorListWorkingCopy {
    private final ITeamRepository fCachedTeamRepository;
    private List fWorkingCopy = new ArrayList();

    public ContributorListWorkingCopy(ITeamRepository teamRepository) {
        this.fCachedTeamRepository = teamRepository;
    }

    public List getContributors() {
        return this.fWorkingCopy;
    }

    public void dispose() {
        this.fWorkingCopy = null;
        super.dispose();
    }

    public synchronized boolean isDisposed() {
        return this.fWorkingCopy == null;
    }

    public synchronized void addContributors(IContributor[] contributors) {
        if (!this.isDisposed()) {
            ArrayList<IContributor> addedContributors = new ArrayList<IContributor>();
            int i = 0;
            while (i < contributors.length) {
                IContributor contributor = contributors[i];
                if (!this.hasContributor((IContributorHandle)contributor)) {
                    this.fWorkingCopy.add(contributor);
                    this.handleContributorAdded(contributor);
                    addedContributors.add(contributor);
                }
                ++i;
            }
            if (!addedContributors.isEmpty()) {
                this.setDirty(true, true);
                this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "contributorList.add", null, addedContributors.toArray()));
            }
        }
    }

    protected void handleContributorAdded(IContributor contributor) {
    }

    protected boolean hasContributor(IContributorHandle contributorHandle) {
        return this.resolveContributor(contributorHandle) != null;
    }

    private boolean hasContributor(List memberList, IContributorHandle contributorHandle) {
        return this.resolveContributor(memberList, contributorHandle) != null;
    }

    protected final IContributor resolveContributor(IContributorHandle contributorHandle) {
        return this.resolveContributor(this.fWorkingCopy, contributorHandle);
    }

    private final IContributor resolveContributor(List memberList, IContributorHandle contributorHandle) {
        for (IContributor member : memberList) {
            if (!member.sameItemId((IItemHandle)contributorHandle)) continue;
            return member;
        }
        return null;
    }

    public synchronized void removeContributors(IContributorHandle[] contributors) {
        if (!this.isDisposed()) {
            List<IContributorHandle> contributorsToRemove = Arrays.asList(contributors);
            ArrayList<IContributor> removedContributors = new ArrayList<IContributor>();
            Iterator e = this.fWorkingCopy.iterator();
            while (e.hasNext()) {
                IContributor contributor = (IContributor)e.next();
                if (!this.hasContributor(contributorsToRemove, (IContributorHandle)contributor)) continue;
                e.remove();
                this.handleContributorRemoved(contributor);
                removedContributors.add(contributor);
            }
            if (!removedContributors.isEmpty()) {
                this.setDirty(true, true);
                this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(this, "contributorList.delete", removedContributors.toArray(), null));
            }
        }
    }

    protected void handleContributorRemoved(IContributor contributor) {
    }

    public void asyncUpdate(final IContributorProvider provider, final int flags, IUpdateContext context, IProgressMonitor monitor) {
        if (this.isDisposed()) {
            return;
        }
        UpdateRequest request = new UpdateRequest(Messages.getString("ContributorListWorkingCopy.0")){

            public IStatus execute(IUpdateContext context, IProgressMonitor monitor) {
                if (ContributorListWorkingCopy.this.isDisposed()) {
                    return Status.OK_STATUS;
                }
                monitor.beginTask(this.getName(), 1000);
                try {
                    final ArrayList<IContributor> members = new ArrayList<IContributor>(ContributorListWorkingCopy.this.fWorkingCopy);
                    List[] changes = ContributorListWorkingCopy.this.computeChanges(members, provider.getContributorHandles());
                    boolean teamModifiedOnLoad = false;
                    boolean teamChanged = false;
                    if (changes[0] != null) {
                        IItemManager manager = ContributorListWorkingCopy.this.fCachedTeamRepository.itemManager();
                        List additions = manager.fetchCompleteItems(changes[0], flags, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
                        for (IContributor contributor : additions) {
                            if (contributor != null) {
                                members.add(contributor);
                                continue;
                            }
                            teamModifiedOnLoad = true;
                        }
                        teamChanged = true;
                    } else {
                        monitor.worked(500);
                    }
                    if (changes[1] != null) {
                        ContributorListWorkingCopy.this.removeAll(members, changes[1]);
                        teamChanged = true;
                    }
                    if (ContributorListWorkingCopy.this.isDisposed()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    ContributorListWorkingCopy.this.doUpdate(provider, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
                    final boolean markInitiallyDirty = teamModifiedOnLoad;
                    final boolean membersChanged = teamChanged;
                    Runnable runnable = new Runnable(){

                        public void run() {
                            if (!ContributorListWorkingCopy.this.isDisposed()) {
                                List oldMembers = null;
                                ArrayList newMembers = null;
                                if (membersChanged) {
                                    oldMembers = ContributorListWorkingCopy.this.fWorkingCopy;
                                    newMembers = new ArrayList(members);
                                    ContributorListWorkingCopy.this.fWorkingCopy = newMembers;
                                }
                                if (ContributorListWorkingCopy.this.handleContributorsUpdated(provider, membersChanged) || membersChanged) {
                                    ContributorListWorkingCopy.this.setDirty(markInitiallyDirty, true);
                                    ContributorListWorkingCopy.this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(ContributorListWorkingCopy.this, "contributorList.change", oldMembers, newMembers));
                                }
                            }
                        }
                    };
                    if (context != null) {
                        context.execute(runnable);
                    } else {
                        runnable.run();
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (TeamRepositoryException x) {
                    if (ContributorListWorkingCopy.this.isDisposed()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    Status status = new Status(4, "com.ibm.team.process.client", 0, this.getName(), (Throwable)x);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        ExecUtil.asyncExec(request, context, monitor);
    }

    protected void doUpdate(IContributorProvider provider, IProgressMonitor monitor) throws TeamRepositoryException {
    }

    protected boolean handleContributorsUpdated(IContributorProvider provider, boolean membersChanged) {
        return false;
    }

    public void syncSave(IContributorContainer container, IProgressMonitor monitor) throws TeamRepositoryException {
        List members = this.fWorkingCopy;
        if (members != null) {
            container.setContributors(members.toArray(new IContributorHandle[members.size()]));
        }
    }

    private List[] computeChanges(List oldContributors, List newContributors) {
        ArrayList additions = new ArrayList(newContributors);
        ArrayList removals = oldContributors == null ? new ArrayList() : new ArrayList(oldContributors);
        Iterator e1 = additions.iterator();
        block0: while (e1.hasNext()) {
            IContributorHandle potentialAddition = (IContributorHandle)e1.next();
            Iterator e2 = removals.iterator();
            while (e2.hasNext()) {
                IContributorHandle potentialRemoval = (IContributorHandle)e2.next();
                if (!potentialAddition.sameItemId((IItemHandle)potentialRemoval)) continue;
                e1.remove();
                e2.remove();
                continue block0;
            }
        }
        return new List[]{additions, removals};
    }

    private void removeAll(List contributors, List removals) {
        block0: for (IContributorHandle toRemove : removals) {
            Iterator e2 = contributors.iterator();
            while (e2.hasNext()) {
                IContributorHandle handle = (IContributorHandle)e2.next();
                if (!handle.sameItemId((IItemHandle)toRemove)) continue;
                e2.remove();
                continue block0;
            }
        }
    }

    public void handleContributorProviderChanged(IContributorProvider provider, IUpdateContext context, IProgressMonitor monitor) {
        this.asyncUpdate(provider, 0, context, monitor);
    }

    public void handleContributorChanged(final IContributor contributor, IUpdateContext context, IProgressMonitor monitor) {
        if (this.fWorkingCopy == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                List members = ContributorListWorkingCopy.this.fWorkingCopy;
                if (members != null) {
                    int i = 0;
                    while (i < members.size()) {
                        IContributor member = (IContributor)members.get(i);
                        if (member.sameItemId((IItemHandle)contributor)) {
                            ContributorListWorkingCopy.this.fireWorkingCopyChanged(new WorkingCopyChangeEvent(ContributorListWorkingCopy.this, "contributorList.contributor", contributor, contributor));
                            return;
                        }
                        ++i;
                    }
                }
            }
        };
        if (context != null) {
            context.execute(runnable);
        } else {
            runnable.run();
        }
    }

    public static interface IContributorContainer {
        public void setContributors(IContributorHandle[] var1);
    }

    public static interface IContributorProvider {
        public List getContributorHandles();
    }
}

