/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.client;

import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.ProcessClient;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineConfiguration;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIterationConfiguration;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ISimpleMap;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IOperationConfigurationInfo;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IParticipantReport;
import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.ProjectOperation;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.process.common.service.StaleConfigurationDataException;
import com.ibm.team.process.internal.client.ClientProcessContext;
import com.ibm.team.process.internal.client.ContentCache;
import com.ibm.team.process.internal.client.InternalProcessClient;
import com.ibm.team.process.internal.client.Messages;
import com.ibm.team.process.internal.client.ProcessClientService;
import com.ibm.team.process.internal.common.CurrentIterationInfo;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.common.advice.OperationReport;
import com.ibm.team.process.internal.common.advice.runtime.ILicenseChecker;
import com.ibm.team.process.internal.common.advice.runtime.OperationAdviceManager;
import com.ibm.team.process.internal.common.model.settings.OperationBehaviorConfiguration;
import com.ibm.team.process.internal.common.util.AbstractProcess;
import com.ibm.team.process.internal.common.util.ProcessModelCache;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ClientProcess
extends AbstractProcess
implements IClientProcess {
    private final ClientProcessContext fContext;
    private static final ProcessModelCache fgModelCache = new ProcessModelCache(100);

    public ClientProcess(IProjectArea projectArea, ClientProcessContext context) {
        super(projectArea, fgModelCache);
        this.fContext = context;
    }

    private ClientProcessContext getContext() {
        return this.fContext;
    }

    public IIterationConfiguration[] getIterationConfigurations(IDevelopmentLineConfiguration lineConfiguration, IProgressMonitor monitor) throws TeamRepositoryException {
        if (lineConfiguration != null) {
            return lineConfiguration.getIterations();
        }
        return new IIterationConfiguration[0];
    }

    public IOperationReport advise(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            return this.doAdvise(operation, 0, null, this.getProgressMonitor(monitor));
        }
        catch (TeamOperationCanceledException e) {
            throw new RuntimeException(e);
        }
    }

    public IOperationReport adviseAndExecute(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.doAdvise(operation, 1, null, this.getProgressMonitor(monitor));
    }

    public IOperationReport reAdviseAndExecute(AdvisableOperation operation, IOperationReport report, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.doAdvise(operation, 2, report, this.getProgressMonitor(monitor));
    }

    protected IOperationReport doAdvise(AdvisableOperation operation, int mode, IOperationReport oldReport, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1000);
        try {
            try {
                return super.doAdvise(operation, mode, oldReport, (IProgressMonitor)new SubProgressMonitor(monitor, 998));
            }
            catch (TeamOperationCanceledException e) {
                IOperationReport report = e.getReport();
                IOperationReport failedOperationReport = this.findFailedOperationReport((IProcessReport)report);
                if (failedOperationReport != null && failedOperationReport.getOperation() != null) {
                    IOperationConfigurationInfo configurationInfo = ((OperationReport)failedOperationReport).getOperationConfigurationInfo();
                    this.fContext.getProcessService().validateConfigurationInfo(configurationInfo, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                throw e;
            }
        }
        catch (StaleConfigurationDataException e) {
            return this.handleStaleConfigurationData(operation, e, mode, oldReport, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
    }

    private IOperationReport findFailedOperationReport(IProcessReport report) {
        block7: {
            block6: {
                if (!(report instanceof IParticipantReport)) break block6;
                IParticipantReport participantReport = (IParticipantReport)report;
                IReportInfo[] infos = participantReport.getInfos();
                int i = 0;
                while (i < infos.length) {
                    IReportInfo info = infos[i];
                    if (info.getSeverity() == 4) {
                        return participantReport.getOperationReport();
                    }
                    ++i;
                }
                break block7;
            }
            if (!(report instanceof IOperationReport)) break block7;
            IOperationReport operationReport = (IOperationReport)report;
            IReportInfo[] infos = operationReport.getInfos();
            int i = 0;
            while (i < infos.length) {
                IReportInfo info = infos[i];
                if (info.getSeverity() == 4) {
                    return operationReport;
                }
                ++i;
            }
            IProcessReport[] nestedReports = operationReport.getNestedReports();
            int i2 = 0;
            while (i2 < nestedReports.length) {
                IOperationReport failedReport = this.findFailedOperationReport(nestedReports[i2]);
                if (failedReport != null) {
                    return failedReport;
                }
                ++i2;
            }
        }
        return null;
    }

    protected OperationAdviceManager getOperationAdviceManager() {
        return (OperationAdviceManager)ProcessClient.getOperationAdviceManager();
    }

    protected CurrentIterationInfo[] getCurrentIterationInfos(IDevelopmentLine line, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fContext.getProcessService().getCurrentIterationInfos((IDevelopmentLineHandle)line, monitor);
    }

    protected String createStringFromContent(IContent content, IProgressMonitor monitor) throws TeamRepositoryException {
        ProcessClientService processService = this.getContext().getProcessService();
        if (processService instanceof ProcessClientService) {
            ProcessClientService client = processService;
            ContentCache cache = client.getContentCache();
            String value = cache.get(content);
            if (value != null) {
                return value;
            }
            value = this.retrieveContent(content, monitor);
            cache.put(content, value);
            return value;
        }
        return this.retrieveContent(content, monitor);
    }

    private String retrieveContent(IContent content, IProgressMonitor monitor) throws TeamRepositoryException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.getContentManager().retrieveContent(content, (OutputStream)stream, monitor);
        try {
            return new String(stream.toByteArray(), content.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    protected IContentManager getContentManager() {
        return this.getContext().getTeamRepository().contentManager();
    }

    protected IItemManager getItemManager() {
        return this.getContext().getTeamRepository().itemManager();
    }

    protected IItem fetchCompleteItem(IItemHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getItemManager().fetchCompleteItem(handle, 0, monitor);
    }

    protected IDevelopmentLine getDevelopmentLine(IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        return this.fContext.getProcessService().getDevelopmentLine(processArea, monitor);
    }

    protected IContributorHandle getContributor() {
        return this.getContext().getTeamRepository().loggedInContributor();
    }

    protected ILicenseChecker getLicenseChecker() {
        return new ILicenseChecker(){

            public void assertLicense(String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
            }
        };
    }

    public IOperationReport executeInitializer(ProjectOperation initializer, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            return super.executeInitializer(initializer, (IProgressMonitor)new SubProgressMonitor(monitor, 990));
        }
        catch (StaleConfigurationDataException e) {
            return this.handleStaleConfigurationData((AdvisableOperation)initializer, e, 1, null, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
    }

    private IOperationReport handleStaleConfigurationData(AdvisableOperation operation, StaleConfigurationDataException exception, int mode, IOperationReport oldReport, boolean isInitializer, IProgressMonitor monitor) throws TeamRepositoryException {
        Object data = exception.getData();
        if (data instanceof IProcessArea) {
            IProcessArea affectedArea = (IProcessArea)data;
            this.assertSameProjectArea(affectedArea);
            List areaHandles = this.computeTeamAreaPath(affectedArea);
            areaHandles.add(this.getProjectArea());
            List items = this.getItemManager().fetchCompleteItems(areaHandles, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            Object lastItem = items.get(items.size() - 1);
            if (lastItem == null) {
                throw new TeamRepositoryException(Messages.getString("ClientProcess.1"));
            }
            this.fProjectArea = (IProjectArea)lastItem;
            if (operation.canReRun()) {
                OperationAdviceManager manager = (OperationAdviceManager)ProcessClient.getOperationAdviceManager();
                OperationBehaviorConfiguration behavior = null;
                ItemHandleAwareHashMap permissions = new ItemHandleAwareHashMap();
                try {
                    if (isInitializer) {
                        behavior = this.getInitializationBehaviorConfiguration(operation.getOperationIdentifier(), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    } else {
                        permissions = this.getPermissionsMap(operation, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
                        behavior = this.getBehaviorConfiguration(operation, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
                    }
                }
                catch (TeamRepositoryException e) {
                    InternalProcessClient.log(e);
                }
                return manager.advise(operation, 1, (ISimpleMap)permissions, behavior, oldReport, (IProgressMonitor)new SubProgressMonitor(monitor, 950));
            }
        }
        throw exception;
    }

    private List computeTeamAreaPath(IProcessArea processArea) {
        ArrayList<ITeamAreaHandle> teamAreaHandles = new ArrayList<ITeamAreaHandle>();
        if (processArea instanceof ITeamArea) {
            ITeamAreaHierarchy hierarchy = this.fProjectArea.getTeamAreaHierarchy();
            ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)processArea;
            while (teamAreaHandle != null) {
                teamAreaHandles.add(teamAreaHandle);
                teamAreaHandle = hierarchy.getParent(teamAreaHandle);
            }
        }
        return teamAreaHandles;
    }
}

