/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.internal.WorkItemClient;
import com.ibm.team.workitem.client.internal.WorkItemSaveTransport;
import com.ibm.team.workitem.common.internal.rcp.dto.MultiSaveParameterDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.MultiSaveResultDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.SaveResultDTO;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkItemSaveRunnable
extends ProcessRunnable {
    private WorkItemSaveTransport fTransport;
    private MultiSaveParameterDTO fMultiSaveParameter;
    private MultiSaveResultDTO fSaveResult;

    public WorkItemSaveRunnable(WorkItemClient workItemClient, MultiSaveParameterDTO multiSaveParameter, WorkItemSaveTransport transport) {
        this.fTransport = transport;
        this.fMultiSaveParameter = multiSaveParameter;
    }

    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
        this.fSaveResult = this.fTransport.call(this.fMultiSaveParameter, monitor);
        List saveResults = this.fSaveResult.getSaveResults();
        for (SaveResultDTO saveResult : saveResults) {
            if (saveResult.getOperationReport() == null) continue;
            return ProcessCommon.cloneReport((IOperationReport)saveResult.getOperationReport());
        }
        return null;
    }

    public MultiSaveResultDTO getSaveResult() {
        return this.fSaveResult;
    }

    public void dispose() {
        this.fTransport = null;
        this.fMultiSaveParameter = null;
        this.fSaveResult = null;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == ((Object)((Object)this)).getClass();
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

