/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;

public class DateUtils {
    private static final SimpleDateFormat _ISO8601DateFormat;
    private static final SimpleDateFormat _RFC822DateFormat;
    private static final SimpleDateFormat _RFC3339DateFormat;
    private static final SimpleTimeZone _gmtTimeZone;
    private static final SimpleDateFormat _ISO8601DateFormatInternal;
    private static final SimpleDateFormat _RFC822DateFormatInternal;
    private static final SimpleDateFormat _RFC3339DateFormatInternal;
    private static final SimpleTimeZone _gmtTimeZoneInternal;

    static {
        _gmtTimeZone = new SimpleTimeZone(0, "GMT");
        _gmtTimeZoneInternal = new SimpleTimeZone(0, "GMT");
        _ISO8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        _ISO8601DateFormat.setTimeZone(_gmtTimeZoneInternal);
        _RFC822DateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        _RFC822DateFormat.setTimeZone(_gmtTimeZoneInternal);
        _RFC3339DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
        _RFC3339DateFormat.setTimeZone(_gmtTimeZoneInternal);
        _ISO8601DateFormatInternal = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        _ISO8601DateFormatInternal.setTimeZone(_gmtTimeZoneInternal);
        _RFC822DateFormatInternal = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        _RFC822DateFormatInternal.setTimeZone(_gmtTimeZoneInternal);
        _RFC3339DateFormatInternal = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
        _RFC3339DateFormatInternal.setTimeZone(_gmtTimeZoneInternal);
    }

    public static synchronized String formatTimeISO8601(Date date) {
        if (date == null) {
            throw (Throwable)new IllegalArgumentException("time must not be null");
        }
        return _ISO8601DateFormatInternal.format(date);
    }

    public static synchronized Timestamp parseTimeISO8601(String string) throws ParseException {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("time must not be null");
        }
        return new Timestamp(_ISO8601DateFormatInternal.parse(string).getTime());
    }

    public static synchronized String formatTimeRFC822(Date date) {
        if (date == null) {
            throw (Throwable)new IllegalArgumentException("time must not be null");
        }
        return _RFC822DateFormatInternal.format(date);
    }

    public static synchronized Timestamp parseTimeRFC822(String string) throws ParseException {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("time must not be null");
        }
        return new Timestamp(_RFC822DateFormatInternal.parse(string).getTime());
    }

    public static synchronized String formatTimeRFC3339(Date date) {
        if (date == null) {
            throw (Throwable)new IllegalArgumentException("time must not be null");
        }
        return _RFC3339DateFormatInternal.format(date);
    }

    public static synchronized Timestamp parseTimeRFC3339(String string) throws ParseException {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("time must not be null");
        }
        return new Timestamp(_RFC3339DateFormatInternal.parse(string).getTime());
    }

    public static SimpleDateFormat getISO8601DateFormat() {
        return _ISO8601DateFormat;
    }

    public static SimpleDateFormat getRFC822DateFormat() {
        return _RFC822DateFormat;
    }

    public static SimpleDateFormat getRFC3339DateFormat() {
        return _RFC3339DateFormat;
    }

    public static SimpleTimeZone getGMTTimeZone() {
        return _gmtTimeZone;
    }
}

